;; ķ
;;  FSE Collected Tricks: Real Time Clock                         
;;                          
;;  (1). GTR emulator spend a lot of time on many codes.          
;;       Memory access is just one of them.                       
;;  (2). CUP386 /7 is faster. What if we increase the loops?      
;;  (3). Please send me other emulators, if you have any.         
;;                                                                
;;  This trick may be included in next version of FSE.            
;;                                                                
;;  10th November 1997 by Zenix Yang E-Mail:zenix@ms10.hinet.net 
;; ͼ
.MODEL SMALL
.CODE
.386P

org 0314h     ;; <<--- 14th March is my birthday

start:
       mov  ax, cs
       mov  ds, ax
       mov  es, ax

     ;; -------------------
     ;;  Save Time at Init.
     ;; -------------------
       mov  ah, 02h
       INT  1Ah
       mov  word ptr cs:time1  , dx
       mov  word ptr cs:time1+2, cx

     ;; -------------------------------------------
     ;;   Simple Does-Nothing Loop
     ;;    >> Note: GTR spends a lot of time here
     ;; -------------------------------------------
       mov  dx, offset msg_logo
       mov  ah, 09h
       int  21h

       mov  cx, 1000h   ;; << --- Increase/Decrease this value if you want.
       cli
 null_1:
       push  cx
             PUSH  ds
             PUSH  es
                   xor  ax, ax
                   mov  es, ax
                   mov  ds, ax
                   mov  di, ax
                   mov  si, ax
                   mov  cx, 400h
                   rep  movsb
             pop  es
             pop  ds
       pop   cx
       loop null_1
       sti

     ;; -------------------------------------------
     ;;   Save Time after the Loop
     ;; -------------------------------------------
        mov  ah, 02h
        INT  1Ah

        mov   bx,  cx
        shl   ebx, 10h
        mov   bx,  dx

     ;; ---------------------
     ;;   Check the 2 times
     ;; ---------------------
       mov  dx, offset msg_ok
       sub  ebx, cs:time1
       cmp  ebx, 200h   ;; <<-- Increase/Decrease it, if you'd like to.
       jl   ok

       mov  dx, offset msg_err
    ok:
       mov  ah, 09h
       int  21h
       mov   ah, 4ch
       int  21h

     ;; ------------------------
     ;; DATA
     ;; ------------------------

time1    dd 0

msg_logo db 0ah, 0dh, ' FSE Collected tricks (GTR)   by Zenix Yang 1997-11-14   '
         db 0ah, 0dh, '     '
         db 0ah, 0dh, '    Run it under an emulator like GTR or Trace it by hand.  '
         db 0ah, 0dh, '    GTR cannot bypass the Do-Nothing loop in 2 seconds now. '
         db 0ah, 0dh, '    I believe GTR may overcome it soon                      '
         db 0ah, 0dh, '    Up-To-Date version of FSE is 0.4                        '
         db 0ah, 0dh, '    This is a test/tutorial file only.                      '
         db 0ah, 0dh, '                                                            '
         db 0ah, 0dh, '                                     zenix@ms10.hinet.net   '
         db 0ah, 0dh, '     ', 0ah, 0dh, '$'
msg_ok   db 0ah, 0dh, '   ....>> Time is OK.', 0ah, 0dh, '$'
msg_err  db 0ah, 0dh, '   ....>> Time is too long! (GTR emulator system?)'
         db 0ah, 0dh, '          Are you under GTR emulator system?'
         db 0ah, 0dh, '          Or are you tracing it by hand?', 0ah, 0dh, '$'

      .STACK
END    START
