;
;  name:    TRICK_I7.ASM
;  content: SoftIce does not give control to the real mode handler
;           if an INT 7 occurs. So remapping INT 7 to a decrypting
;           routine will cause a hangup if SoftICE is loaded because
;           the CPU runs into encrypted code...
;

.model tiny
.286
.code

  xor    ax, ax
  mov    ds, ax
  push   ds:[7*4]
  push   ds:[7*4+2]
  mov    word ptr ds:[7*4+2], cs
  mov    word ptr ds:[7*4], offset myint7
; ...  
  mov    dx, offset int7notexecuted
  int    7
; ...  
  xor    ax, ax
  mov    ds, ax
  pop    ds:[7*4+2]
  pop    ds:[7*4]
  push   cs
  pop    ds
  mov    ah, 9
  int    21h
  mov    ah, 4ch
  int    21h

  myint7:
  mov    dx, offset int7executed
  iret

int7executed    db "INT 7 was executed!",13,10,"$"
int7notexecuted db "INT 7 was not executed!",13,10,"$"

end
; SoftICE does also not give control to the real mode handler
; if an exception 6 or an execption 8 is generated by the cpu
; That does not affect int 6,8 called by software or int 8
; called by the clock, because the PIC is remapped

