;@GOTO TRANSLATE

.MODEL TINY
.586P

 INCLUDE BKPTS.EQU

.CODE
.STARTUP

JMP  Install


Status	       EQU BYTE PTR Stat
SystemType     EQU BYTE PTR SysType



;SETBKPT VOLEJ S BX:CX=LINADR DX=TYPE VRATI BX HANDLE
;REMBKPT VOLEJ S BX HANDLE
;VERBKPT VOLEJ S BX HANDLE

BkptService    DW  RGetVersion, RSetBreakPoint, RRemBreakPoint, RVerBreakPoint
MaxSrv	       =   ($-BkptService)/2
	       DW  RGetVersion, VSetBreakPoint, VRemBreakPoint, VVerBreakPoint
	       DW  RGetVersion, WSetBreakPoint, WRemBreakPoint, WVerBreakPoint

MaxService     =   MaxSrv + StartServ - 1

 BpINT:
    PUSHF
    CMP  EBP,SignumBkPti
    JNE  ContBkpt

    MOV  CS:Status,SignumErrori

    CMP  AH,StartServ
    JB	 ErrorBkpt
    CMP  AH,MaxService
    JA	 ErrorBkpt

    PUSH DS  CS
    POP      DS
    MOV  _AL,AL
    MOV  _BX,BX
    SMSW BX
    TEST BL,1
    MOV  SystemType,REAL
    JE	 Work

    ADD  AH,MaxSrv
    MOV  SystemType,VCPI
    PUSH AX
    MOV  AX,0DE00H
    INT  67H
    OR	 AH,AH
    POP  AX
    JE	 Work

    ADD  AH,MaxSrv
    MOV  SystemType,WIND
    PUSHA
    PUSH ES
    MOV  AX,1687H
    INT  2FH
    PUSH ES DI
    POP  GoDPMI
    OR	 AX,AX
    JNE  NextSys
    CMP  SI,Space4DPMI
    POP  ES
    POPA
    JBE  Work

   NextSys:
    POP  ES
    POPA

    MOV  SystemType,UNKNOWNTYPE
    SUB  AH,MaxSrv*2
    CMP  AH,GetVersion
    JNE  UnkSys

   Work:
    PUSH  EAX
    MOVZX EAX,_BX
    SHL   EAX,4
    ADD   AX,CX
    MOV   LinAdr,EAX
    ADC   WORD PTR LinAdr+2,0
    POP   EAX

    SUB  AH,StartServ
    MOVZX  BX,AH
    ADD  BX,BX
   GoON:
    CALL BkptService[BX]
   UnkSys:
    MOV  BX,_BX
    MOV  AL,_AL
    POP  DS
   ErrorBkpt:
    MOV  AH,SignumErrori
    Stat EQU $-1
    POPF
    IRET
   ContBkpt:
    POPF
    DB	0EAH
    OldBkpt DD ?

 MinorVer = 0
 MajorVer = 1

   RGetVersion:
    MOV  _BL,MinorVer
    MOV  _BH,MajorVer
    MOV   CL,0
    SysType EQU $-1
    MOV  Status,SignumSuccessi
    RET

   SetBkpt:
    PUSH EAX ECX EDX EBX EBP
    MOV  CX,DRXUsed
    SUB  AX,AX
   RSetNextDR:
    CMP  AX,4
    JAE  ErrSetBkpt
    INC  AX
    SHR  CL,1
    JC	 RSetNextDR
    DEC  AX
    BTS  DRXUsed,AX
    MOV  _BX,AX  ;HANDLE
    MOV  BX,1111B
    MOV  CL,AL
    SHL  CL,2
    SHL  BX,CL
    PUSH BX
    MOV  BX,11B
    MOV  CL,AL
    ADD  CL,AL
    SHL  BX,CL
    MOV  EBP,_DR7
    PUSH BX
    POP  EBX
    PUSH BX
    NOT  EBX
    AND  EBP,EBX
    CMP  DH,2
    JNE  TypeOK
    INC  DH
   TypeOK:
    DEC  DL
    SHL  DL,2
    OR	 DL,DH
    MOV  DH,0
    ADD  CL,AL
    ADD  CL,AL
    ADD  CL,16
    SHL  EDX,CL
    POP  DX
    OR	 DH,3
    OR	 EBP,EDX
    MOV  _DR7,EBP

    SHL  AL,2
    CBW
    ADD  AX,OFFSET _DRX
    MOV  SetDR,AX
    JMP  $+2
    MOV  EAX,LinAdr
    MOV  _DRX,EAX
    Memo1 EQU $-2
    SetDR EQU WORD PTR Memo1

    MOV  Status,SignumSuccessi
   ErrSetBkPt:
     POP EBP EBX EDX ECX EAX
     RET

   RemBkpt:
     PUSH AX CX
     MOV  AX,11B
     MOV  CL,_BL
     MOV  CH,0
     BTR  DRXUsed,CX
     ADD  CL,CL
     SHL  AX,CL
     NOT  AX
     AND  WORD PTR _DR7,AX
     POP  CX AX
     MOV  Status,SignumSuccessi
     RET

   VerBkpt:
     PUSH AX CX
     MOV  AL,1
     MOV  CL,_BL
     SHL  AL,CL
     TEST AL,BYTE PTR _DR6
     SETNE _AL
     NOT  AL
     AND  BYTE PTR _DR6,AL
     POP  CX AX
     MOV  Status,SignumSuccessi
     RET

   RGetDRX:
     CLD
     PUSH EAX DI ES DS
     POP  ES
     LEA  DI,_DRX
     MOV  EAX,DR0
     STOSD
     MOV  EAX,DR1
     STOSD
     MOV  EAX,DR2
     STOSD
     MOV  EAX,DR3
     STOSD
     ADD  DI,8
     MOV  EAX,DR6
     STOSD
     MOV  EAX,DR7
     STOSD
     POP  ES DI EAX
     RET

   RSetDRX:
     CLD
     PUSH  EAX SI
     LEA   SI,_DRX
     LODSD
     MOV   DR0,EAX
     LODSD
     MOV   DR1,EAX
     LODSD
     MOV   DR2,EAX
     LODSD
     MOV   DR3,EAX
     ADD   SI,8
     LODSD
     MOV   DR6,EAX
     LODSD
     MOV   DR7,EAX
     POP   SI  EAX
     RET


   VGetDRX:
     PUSH AX
     MOV  AX,0DE08H
     INT  67H
     OR   Status,AH
     POP  AX
     RET

   VSetDRX:
     PUSH AX
     MOV  AX,0DE09H
     INT  67H
     OR   Status,AH
     POP  AX
     RET

 RSetBreakPoint:
     CALL RGetDRX
     CALL SetBkpt
     CALL RSetDRX
     RET
 RRemBreakPoint:
     CALL RGetDRX
     CALL RemBkpt
     CALL RSetDRX
     RET
 RVerBreakPoint:
     CALL RGetDRX
     CALL VerBkpt
     CALL RSetDRX
     RET

 VSetBreakPoint:
     PUSH AX DI ES DS
     POP  ES
     LEA  DI,_DRX
     CALL VGetDRX
     CALL SetBkpt
     CALL VSetDRX
     POP  ES DI AX
     RET
 VRemBreakPoint:
     PUSH AX DI ES DS
     POP  ES
     LEA  DI,_DRX
     CALL VGetDRX
     CALL RemBkpt
     CALL VSetDRX
     POP  ES DI AX
     RET
 VVerBreakPoint:
     PUSH AX DI ES DS
     POP  ES
     LEA  DI,_DRX
     CALL VGetDRX
     CALL VerBkpt
     CALL VSetDRX
     POP  ES DI AX
     RET

 WSetBreakPoint:
     MOV  DService,0
     JMP  InitDPMI

 WRemBreakPoint:
     MOV  DService,1
     JMP  InitDPMI

 WVerBreakPoint:
     MOV  DService,2


 InitDPMI:
     PUSH  FS GS ES DS
     PUSHAD

     MOV   AH,62H
     INT   21H
     MOV   _PSP,BX
     MOV   AH,50H
     MOV   BX,CS
     INT   21H

     PUSH  0
     POP   FS
     PUSH  DWORD PTR FS:21H*4
     POP   Old21
     PUSH  CS OFFSET Temp21
     POP   DWORD PTR FS:21H*4

     MOV  _SS,SS
     MOV  _SP,SP

     MOV  AX,1234H
    Segment4DPMI EQU $-2
     MOV  ES,AX

     SUB  AX,AX
     CALL GoDPMI
     JC   DPMIFailed

     PUSH LinAdr
     POP  CX BX

     CMP  DService,0
     JE   _NoHandle
     MOV  BX,_BX
   _NoHandle:
     MOV  AX,0B00H
     DServ    EQU $-2
     DService EQU BYTE PTR DServ
     INT  31H
     JC   _Exit
     MOV  _AL,AL
     MOV  _BX,BX
     CMP  DService,2
     JNE  _NoUpdate
     MOV  AX,0B03H
     INT  31H
     JC   _Exit
    _NoUpdate:
     MOV  Status,SignumSuccessi
    _Exit:
     .EXIT

   Temp21:
     PUSHF
     CMP   AH,4CH
     JE    IsExit
     POPF
     DB    0EAH
     Old21 DD ?
    IsExit:
     LSS   SP, CS:MyStack

    DPMIFailed:
     MOV   BX,CS:_PSP
     MOV   AH,50H
     INT   21H

     POPAD
     POP   DS ES GS
     PUSH  0
     POP   FS
     PUSH  Old21
     POP   DWORD PTR FS:21H*4
     POP   FS
     RET

Install:
  LEA	AX,Place4DPMI+15
  MOV	BX,CS
  SHR	AX,4
  ADD	AX,BX
  MOV	WORD PTR Segment4DPMI,AX

  PUSH	0
  POP	FS
  PUSH	DWORD PTR FS:4*BkPtINT
  POP	OldBkpt
  PUSH	CS OFFSET BpINT
  POP	DWORD PTR FS:4*BkPtINT

  MOV	ES,DS:2CH
  MOV	AH,49H
  INT	21H

  MOV	AH,9
  LEA	DX,Message
  INT	21H

  LEA	DX,ENDMarker
  INT	27H


.DATA
  Message DB 13,10,"*EliCZ's BreakPoints '98*"
	  DB 13,10,"allows BreakPoints under RM, EMM, Windows, NT"
	  DB 13,10
	  DB 13,10,"BkPts resident.",36
  DRXUsed DW 0

  GoDPMI  DD ?
   MyStack LABEL DWORD
     _SP    DW ?
     _SS    DW ?
     _BX    LABEL WORD
     _BL    DB ?
     _BH    DB ?
     _AL    DB ?

  _PSP	  DW ?
  LinAdr  DD ?
  _DRX	  LABEL DWORD
    _DR0  DD ?
    _DR1  DD ?
    _DR2  DD ?
    _DR3  DD ?
    _DR4  DD ?
    _DR5  DD ?
    _DR6  DD ?
    _DR7  DD ?

  Space4DPMI EQU 2DH  ;IF PROBLEMS INCREASE

  Place4DPMI DB  Space4DPMI*16 DUP (?)


  ENDMarker LABEL

END

:TRANSLATE
   @echo off
   tasm  /m /q /z BKPTS.BAT
   tlink /3/t/x   BKPTS.OBJ
   del		  BKPTS.OBJ
