Program PXDTech1;
{***********************************************************}
{**                 TESTS THE TMXMS UNIT                  **}
{**  This program is just a simple demonstration of how   **}
{**  to store information in XMS and then move it back to **}
{**  conventional memory using the functions from TMXMS   **}
{***********************************************************}
uses
 crt,TMXMS;

type

 XMSBufferArrayT = Array[0..15000] of byte;
 XMSBufferT      = ^XMSBufferArrayT;


var
 status       : byte;
 i,j          : integer;
 check        : boolean;
 total_free,
 Largest_free : word;
 XMSHandle    : word;

 XMSBuffer       : XMSBufferT;
 XMSAddr         : Word;
 XMSBufferAddr   : longint;


 handlecount, nrHandles : byte;
 BlockSize : word;
 linearAdd : longint;



begin
 clrscr;

Writeln('      ****************************************************************');
Writeln('      *                                                              *');
Writeln('      *                PXDTECH #1 : TMXMS - A XMS unit!              *');
Writeln('      *                    by : Telemachos^Peroxide                  *');
Writeln('      *                                                              *');
Writeln('      ****************************************************************');
Writeln;
Writeln;
Writeln('      Hello fellow programmers! ');
Writeln;
Writeln('      Welcome to my new programming serie - the PXDTECH serie!');
Writeln;
Writeln('      Why a new serie you might ask? Why is this not just PXDTUT #9?');
Writeln('      Well - first of all : The PXDTECH serie will NOT replace the');
Writeln('      PXDTUT serie. The PXDTECH serie will be some sort of a bonus serie ');
Writeln('      dealing with stuff to small to be a PXDTUT - and it will not be as');
Writeln('      detailed as the PXDTUT serie. Most of the PXDTECH stuff will just');
Writeln('      be small units or sample programs demonstrating some stuff without');
Writeln('      the long textfiles supplied with the PXDTUT serie. Some sort of ');
Writeln('      documentation WILL be supplied though!');
Writeln;
Writeln('      This first PXDTECH deals with XMS memory - have fun!');
Writeln('      Hit any key to start.....');


readkey;
ClrScr;









 DisplayXMSInfo;                  {version number, HMA status and A20 status}

 GetMem(XMSBuffer,15000);
 XMSAddr := Seg(XMSBuffer^);
 XMSBufferAddr := LongInt(Ptr(XMSAddr,0));{set up the buffer to contain    }
                                          {the information we want to store}
                                          {in XMS                          }



 Writeln;
 status := QueryFreeXMS(total_free,largest_free);
 if (status <> $01) then ErrorMsg(status,'QueryFreeXMS');
 Writeln('XMS status : ');
 Writeln('Total free XMS memory (in Kb) : ',total_free);
 Writeln('Largest free XMS block (in Kb) : ',largest_free);
 {Get information on free XMS memory}


 Writeln('Trying to allocate a 600Kb XMS block....');
 status := AllocateXMS(600,XMSHandle);
 if status = $01 then Writeln('XMS memory sucessfully allocated!') else
 ErrorMsg(status,'AllocateXMS');
 {Allocate a fairly small XMS memory block of 600 Kb}


 Writeln('Trying to resize the XMS block to 15Kb....');
 status := ReAllocateXMS(XMSHandle,15);
 if status = $01 then Writeln('XMS block sucessfully resized to 15Kb!') else
 ErrorMsg(status,'ReAllocateXMS');
 {Resize the XMS block to 15Kb - but still with the same handle}



 j := 15;   {this is the number we test the XMS memory with!}
 Writeln;
 Writeln('Filling 15Kb testbuffer with value : ',j);
 For i := 0 to 15000 do mem[XMSAddr:i] := j;
 {now the buffer in conventional memory is filled with value 'j'}



 Writeln;
 Writeln('Storing test buffer in allocated XMS memory....');
 status  := MoveXMS(15000,0, XMSBufferAddr,XMSHandle,0);
 if status = $01 then Writeln('XMSMove sucessfully executed!') else
 ErrorMsg(status,'MoveXMS');
 {We have now moved the buffer to XMS memory}


 Writeln;
 Writeln('Clearing test buffer back to zero!');
 for i := 0 to 15000 do mem[XMSAddr:i] := 0;
 {OK - now the buffer in conventional memory is cleared with value 0}


 Writeln('Moving XMS back into testbuffer!');
 status := MoveXMS(15000,XMSHandle,0,0, XMSBufferAddr);
 if status = $01 then Writeln('XMSMove sucessfully executed!') else
 ErrorMsg(status,'MoveXMS');
 {Move the data stored in XMS back into the buffer in conventional memory}



  check := true;
  for i := 0 to 14999 do   {check the 15Kb retrieved from XMS!}
   if (mem[XMSAddr:i] <> j) then check := false;
 If check then Writeln('XMSBuffer match original!') else
               Writeln('Error - XMSBuffer NOT restored to original!');
 {Hopefully the values moved from XMS to conventional memory match the }
 {values we originally moved ;)                                        }



 Writeln;
 Writeln('Trying to deallocate the 15Kb XMS block with handle : ',XMSHandle);
 status := DeallocateXMS(XMSHandle);
 if status = $01 then Writeln('XMS memory sucessfully deallocated!') else
 ErrorMsg(status,'DeallocateXMS');

 {Remember to deallocate the XMS memory before closing program - otherwise }
 {the memory will be lost and cannot be used by other programs until the   }
 {computer has been reset!                                                 }

 readkey;
end.