LIBRARY TestPlugIn;

{ This is a skeleton file for creating a Plug-In for use with NeoBook 4.0.
  This plug-in contains no actions and must be edited before it can be used.
  Please refer to the "NeoBook Plug-In DOC.rtf" file for instructions. }

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls;

{$R TESTPLUG.RES}   { <--- Edit this file with a resource editor to change this plug-in's
                           icon which appears in NeoBook's Action list... }

{****************** NeoBook Interface Functions DO NOT MODIFY *****************}
{*}
{*}CONST { Action Command Parameter Types... }
{*}      ACTIONPARAM_NONE     = 0;
{*}      ACTIONPARAM_ALPHA    = 1;  { May contain alpha, numeric, punctuation, etc. }
{*}      ACTIONPARAM_ALPHASP  = 2;  { Contains aplha text that can be spell checked. }
{*}      ACTIONPARAM_NUMERIC  = 3;  { Must be numeric value 0..9 }
{*}      ACTIONPARAM_MIXED    = 4;  { May be either numeric or alpha. May contain math expression }
{*}      ACTIONPARAM_FILENAME = 5;  { Parameter is a file name }
{*}      ACTIONPARAM_VARIABLE = 6;  { Parameter is a variable name }
{*}
{*}      MaxActionParams      = 10; { Maximum number of parameters per action }
{*}
{*}TYPE TAddActionProc = PROCEDURE( IDNum      : INTEGER;
{*}                                 Name, Hint : PChar;
{*}                                 Params     : ARRAY OF BYTE;
{*}                                 NumParams  : BYTE );
{*}     TAddFileProc = PROCEDURE( FileName : PChar; AddFlag : BOOLEAN );
{*}     TVarGetProc = PROCEDURE( VarName : PChar; VAR Value : PChar );
{*}     TVarSetProc = PROCEDURE( VarName, Value : PChar );
{*}
{*}VAR nbGetVar    : TVarGetProc;
{*}    nbSetVar    : TVarSetProc;
{*}    nbAddFile   : TAddFileProc;
{*}    nbAddAction : TAddActionProc;
{*}    nbWinHandle : HWND;
{*}    SaveExit    : POINTER = NIL;
{*}
{*   Used to free memory allocated to PChars. You must use this if you create any
{*   PChars to send between NeoBook and your Plug-In DLL. Failure to use this
{*   procedure may result in memory allocation errors, memory leaks, crashes, etc... }
{*}PROCEDURE FreeStr( VAR S : PChar );
{*}BEGIN
{*}  IF S <> NIL THEN GlobalFree( HGLOBAL( S ) );
{*}  S := NIL;
{*}END;
{*}
{*   Used to modify PChar parameteres. You must use this if you modify any
{*   PChars sent between NeoBook and your Plug-In DLL. Failure to use this
{*   procedure may result in memory allocation errors, crashes, etc... }
{*}PROCEDURE SetStr( VAR Dest : PChar; CONST Source : STRING );
{*}BEGIN
{*}  IF Dest <> NIL THEN GlobalFree( HGLOBAL( Dest ) );
{*}  Dest := Pointer( GlobalAlloc( GMEM_FIXED, Length( Source )+1 ) );
{*}  StrCopy( Dest, PChar( Source ) );
{*}END;
{*}
{******************** End of NeoBook Interface Functions **********************}


{******************* Your Custom Plug-In Functions Go Here ********************}




{********** NeoBook Plug-In Functions that Must be Customized by You **********}

{ nbEditAction - called by NeoBook to edit/define on of the Plug-In's commands.
  Plug-In may display a dialog box with fields for user to fill in. Return
  TRUE if successful, FALSE if not.. }
FUNCTION nbEditAction( IDNum      : INTEGER;
                       VAR Params : ARRAY OF PChar ) : BOOLEAN; FAR;
BEGIN
  Result := FALSE;
  { Examine the Action string to determine which Plug-In command to execute... }
  CASE IDNum OF

  END;
END;


{ nbExecAction - called by NeoBook to execute one of the Plug-In's commands... }
FUNCTION nbExecAction( IDNum      : INTEGER;
                       VAR Params : ARRAY OF PChar ) : BOOLEAN; FAR;
BEGIN
  Result := FALSE;
  { Examine the Action string to determine which Plug-In command to execute... }
  CASE IDNum OF

  END;
END;


{ nbMessage - sent by NeoBook to inform plug-in of important NeoBook activities... }
PROCEDURE nbMessage( MsgCode, Reserved : INTEGER ); FAR;
BEGIN
  { Not all types of plug-ins will care about these messages,
    so they can be ignored if not needed. This procedure must be present even if
    none of the messages are used.

    Possible MsgCode values are:

      1 = Pub has entered run mode
      2 = Pub is about to exit run mode and return to design mode.
      3 = Pub window has been deactivated
      4 = Pub window has been activated
      5 = Pub window has been moved or sized
      6 = Pub is about to display another page

    Reserved value is not currently used
  }

  CASE MsgCode OF
    1 : ; { Don't care }
    2 : ; { Don't care }
    3 : ; { Don't care }
    4 : ; { Don't care }
    5 : ; { Don't care }
    6 : ; { Don't care }
  END;

END;


{ nbInitPlugIn - called by NeoBook to request information about the Plug-In... }
PROCEDURE nbInitPlugIn( WinHandle : HWND; VAR PlugInTitle, PlugInPublisher, PlugInHint : PChar ); FAR;
BEGIN
  { Save handle of Parent NeoBook App or compiled pub Window - may be required by some Windows functions }
  nbWinHandle := WinHandle;

  { Title of this Plug-In (appears as heading in NeoBook's action list) }
  SetStr( PlugInTitle, 'Sample Plug-In' );

  { Publisher of this Plug-In }
  SetStr( PlugInPublisher, 'John Doe' );

  { Description of this Plug-In }
  SetStr( PlugInHint, 'Use this plug-in to display a Windows message box' );
END;


{ nbRegisterPlugIn - called by NeoBook when it wants you to register your plug-in's actions... }
PROCEDURE nbRegisterPlugIn( AddActionProc, AddFileProc, VarGetFunc, VarSetFunc : POINTER ); FAR;
BEGIN

  {***************************** DO NOT MODIFY ********************************}
  {*} nbGetVar    := @TVarGetProc( VarGetFunc );
  {*} nbSetVar    := @TVarSetProc( VarSetFunc );
  {*} nbAddAction := @TAddActionProc( AddActionProc );
  {*} nbAddFile   := @TAddFileProc( AddFileProc );
  {****************************************************************************}

  { Call the AddAction procedure for each of Plug-In command.

    Parameters for the ndAddAction procedure:

    Item 1 = Action ID number - must use a unique identifier for each of your actions.
    Item 2 = Action Name
    Item 3 = Action Description
    Item 4 = Array describing each of the Action's parameters - choose from the following:

      ACTIONPARAM_NONE     = Use if action contains no parameters.
      ACTIONPARAM_ALPHA    = Parameter is a string. May contain alpha, numeric, punctuation, etc.
      ACTIONPARAM_ALPHASP  = Parameter is a string that can be spell checked.
      ACTIONPARAM_NUMERIC  = Parameter is a number.
      ACTIONPARAM_MIXED    = May be either numeric or alpha. May contain math expression
      ACTIONPARAM_FILENAME = Parameter is a file name
      ACTIONPARAM_VARIABLE = Parameter is a variable name

    Item 5 = Number of parameters required by this action
  }

  {******************* Enter your Plug-In's actions below *********************}





  { Next, if necessary, tell NeoBook what extra files are required for your plug-in.
    These are the files that NeoBook will collect when compiling publications that
    use this plug-in. If your plug-in uses any data files, drivers or special DLLs
    this is where you will tell NeoBook about it. It is NOT necessary to include
    the name of the plug-in itself since NeoBook will automatically assume that
    it is required.

    Parameters for the ndAddFile procedure:

    Item 1 = File name including correct drive and path
    Item 2 = TRUE to add the file, FALSE to remove the file

    For example:

    nbAddFile( 'c:\path\somefile.xyz', TRUE );
  }


END;


PROCEDURE Shutdown;
BEGIN
  { If this plug-in requires any special processing before being unloaded from
    memory, do that here. Leave blank if no special processing is needed. }


  { Restore old exit procedure procedure... }
  ExitProc := SaveExit;
END;


{***** Export the required functions for NeoBook interface. Do NOT modify *****}
{*}EXPORTS nbEditAction;
{*}EXPORTS nbExecAction;
{*}EXPORTS nbInitPlugIn;
{*}EXPORTS nbRegisterPlugIn;
{******************************************************************************}

BEGIN
  SaveExit := ExitProc;  // save exit procedure chain
  ExitProc := @Shutdown;  // install LibExit exit procedure
END.



