//  DateCA_BeanInfo.java : BeanInfo for business.awt.Date_CA

// To come: special editor to handle lowest and highest
// so user can enter properties as dates that are checked, rather than integers.

/**
  * @author Roedy Green of Canadian Mind Products
  * version 1 1977 December 10
  *           1977 December 11 - added Symantec Folder/Component lib
  */

package business.awt;
import java.beans.*;
import symantec.itools.beans.*;

/*
 *    BeanInfo for business.awt.Date_CA,
 *    This is an example of a minimalist BeanInfo class.
 *    By convention we just add BeanInfo to the name of the bean's class
 *    to get the name of the BeanInfo class,
 *    and store it in the same directory.
 *    THAT'S ALL THAT'S NEEDED TO GLUE THE BEANINFO TO THE BEAN.
 *    With Symantec Visual Cafe Database edition 2.0,
 *    these properties will only take effect
 *    once the component is removed then
 *    reinstalled in the component library.
 *    You install the bean, not the xxxBeanInfo class in the library.
 *    Further, you must delete and reinsert
 *    components of the bean type to have the new properties show up.
 *    A reparse will not suffice. Restarting Visual Cafe won't help.
 */
public class Date_CABeanInfo extends SimpleBeanInfo
    {
    /**
      * Standard boilerplate provides caller with additional bean information
      * on properties that our bean inherited,
      * e.g. setForeground, setBackground.
      * Any information our getPropertyDescriptors provides
      * will take precedence over this.
      */
    public BeanInfo[] getAdditionalBeanInfo()
        {
        try
            {
            BeanInfo[] bi = new BeanInfo[1];
            bi[0] = Introspector.getBeanInfo(beanClass.getSuperclass());
            return bi;
            }
        catch (IntrospectionException e)
            {
            throw new Error(e.toString());
            }
        } // end getAdditionalBeanInfo

    /**
      * returns an Image for use in the component library or toolbar
      * to represent this bean.
      * Icon images are in GIF format. 16x16 or 32x32.
      * *.gif files live in the same directory as this class.
      * Ideally you should support all 4 flavours,
      * but colour 16x16 would suffice, at least for Symantec.
      * To get icons, design your own with transparent backgrounds
      * using a program like JASC Paint Shop Pro.
      * In a pinch just a coloured square will do.
      * Steal some from Symantec's D:/VCP/bin/components.symbeans.jar
      * using WinZip and modify them.
      * Capture some off the screen with JASC's Paint Shop Pro capture.
      * Then crop and modify.
      */
    public java.awt.Image getIcon(int iconKind)
        {
        if (iconKind == BeanInfo.ICON_COLOR_16x16 ||
            iconKind == BeanInfo.ICON_MONO_16x16)
            {
            java.awt.Image img = loadImage("Date_CAC16.gif");
            return img;
            }
        if (iconKind == BeanInfo.ICON_COLOR_32x32 ||
            iconKind == BeanInfo.ICON_MONO_32x32)
            {
            java.awt.Image img = loadImage("Date_CAC32.gif");
            return img;
            }
        return null;
        } // end getIcon

    /**
      * returns an array of PropertyDescriptors which describe
      * the editable properties of this bean.
      * In addition to those specified here,
      * there will be the inherited properties, provided by
      * getAdditionalBeanInfo.
      * We are allowed to override BeanInfo of
      * inherited properties. Most commonly you hide an
      * inherited property so it won't be exposed to the editor.
      * We don't describe the type of each Property.
      * That is discovered by introspection of the
      * corresponding bean class file.
      */
    public PropertyDescriptor[] getPropertyDescriptors()
        {
        try
            {

            // The Date_CA bean has get/set methods
            // for the following properties:
            // (By convention all properties start with a capital letter.)
            // Aid(String) : inherited
            // Highest(int)
            // Label(String) : inherited
            // Lowest(int)
            // Mask(String ): inherited
            // MustEnter(boolean) : inherited
            // Prompt(String) : inherited
            // Text(String) : inherited
            // Value(int)

            // hide Aid Property, since it is automatically generated.
            // Property names are case sensitive,
            // and normally begin with a capital letter.
            PropertyDescriptor aid =
                new PropertyDescriptor("Aid", beanClass);
            aid.setHidden(true);

            // Highest, nothing special
            PropertyDescriptor highest =
                new PropertyDescriptor("Highest", beanClass);

            // Lowest, nothing special
            PropertyDescriptor lowest  =
                new PropertyDescriptor("Lowest",  beanClass);

            // Label, nothing special
            PropertyDescriptor label =
                new PropertyDescriptor("Label", beanClass);

            // hide Mask Property, since it must not be tampered with.
            PropertyDescriptor mask =
                new PropertyDescriptor("Mask", beanClass);
            mask.setHidden(true);

            // rename MustEnter property to Must Enter
            PropertyDescriptor mustEnter  =
                new PropertyDescriptor("MustEnter", beanClass);
            mustEnter.setDisplayName("Must Enter");

            // Prompt, nothing special
            PropertyDescriptor prompt  =
                new PropertyDescriptor("Prompt",  beanClass);

            // hide Text Property
            // Does not hide, why?? Symantec bug?? deep inheritance
            PropertyDescriptor text =
                new PropertyDescriptor("Text", beanClass);
            text.setHidden(true);

            // Value, nothing special
            PropertyDescriptor value =
                new PropertyDescriptor("Value", beanClass);

            // Collect together all the property descriptors
            // that we have just created into an array.
            // It does not matter what order we specify them, Symantec
            // always displays them alphabetically.
            PropertyDescriptor rv[] = {
                aid,    highest, label,
                lowest, mask,    mustEnter,
                prompt, text,    value};
            return rv;
            }
        catch (IntrospectionException e)
            {
            throw new Error(e.toString());
            }
        } // end getPropertyDescriptors

    /**
      * Symantec extensions to allow control over folder and toolbar placement and help.
      * Leave this out for other IDEs.
      */
    public java.beans.BeanDescriptor getBeanDescriptor()
        {
        SymantecBeanDescriptor bd = new SymantecBeanDescriptor(beanClass);
        bd.setFolder("CMP");
        bd.setToolbar("CMP");
        return bd;
        } // end getBeanDescriptor

    // specify the class of the bean are we describing
    // IF YOU GET THE WRONG BEAN CLASS HERE, THE SYMPTOMS WILL BE
    // "MISSING SETMETHOD" WHEN YOU GO TO TEST THE BEAN IN THE BEANBOX.
    // DOUBLE CHECK THE FOLLOWING LINE WHEN YOU CLONE THIS CODE!!!
    private final static Class beanClass = business.awt.Date_CA.class;

} // end Date_CABeanInfo
// -30-
