/*
 * Decompiled with CFR 0.152.
 */
package cmp.Quoter;

import cmp.Quoter.ClipboardPoker;
import cmp.Quoter.HTMLReservedChars;
import cmp.business.Misc;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class Quoter
extends Applet
implements ClipboardOwner {
    private static final String EmbeddedCopyright = "Copyright 1998 Roedy Green, Canadian Mind Products, http://mindprod.com";
    private static boolean asApplet = true;
    private static final Color black = Color.black;
    private static final Color blue = Color.blue;
    private static final Color darkGreen = new Color(0, 128, 0);
    private static final Color red = Color.red;
    private static final Color white = Color.white;
    Label titleLabel;
    TextArea rawTextArea;
    TextArea cookedTextArea;
    Choice encoding;
    Button clearButton;
    Button convertButton;
    Label instructions;
    private String[] translateTable = HTMLReservedChars.latin1;

    public Quoter() {
    }

    private Quoter(boolean bl) {
        asApplet = bl;
    }

    public void init() {
        this.setBackground(white);
        if (!Misc.isJavaVersionOK(1, 1, 0)) {
            System.out.println("You need Java 1.1.0 or later to run this Applet.");
            System.out.println("You are running under " + System.getProperty("java.version"));
            System.exit(1);
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.titleLabel = new Label("CMP HTML Quoter Amanuensis 1.1", 1);
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setForeground(red);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        ((GridBagLayout)this.getLayout()).setConstraints(this.titleLabel, gridBagConstraints);
        this.add(this.titleLabel);
        if (asApplet) {
            this.rawTextArea = new TextArea("", 3, 50, 3);
            this.rawTextArea.setEditable(true);
            this.rawTextArea.setFont(new Font("Dialog", 0, 15));
            this.rawTextArea.setForeground(black);
            ((Component)this.rawTextArea).setBackground(white);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 10.0;
            gridBagConstraints.ipadx = 10;
            gridBagConstraints.ipady = 10;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            ((GridBagLayout)this.getLayout()).setConstraints(this.rawTextArea, gridBagConstraints);
            this.add(this.rawTextArea);
            this.cookedTextArea = new TextArea("", 3, 50, 3);
            this.cookedTextArea.setEditable(false);
            this.cookedTextArea.setFont(new Font("Dialog", 0, 15));
            this.cookedTextArea.setForeground(black);
            ((Component)this.cookedTextArea).setBackground(white);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 10.0;
            gridBagConstraints.ipadx = 10;
            gridBagConstraints.ipady = 10;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            ((GridBagLayout)this.getLayout()).setConstraints(this.cookedTextArea, gridBagConstraints);
            this.add(this.cookedTextArea);
        }
        this.encoding = new Choice();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 30.0;
        gridBagConstraints.weighty = 5.0;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        ((GridBagLayout)this.getLayout()).setConstraints(this.encoding, gridBagConstraints);
        this.encoding.addItem("Latin1 Unicode");
        this.encoding.addItem("Windows");
        this.encoding.addItem("IBM PC OEM");
        this.encoding.select(0);
        this.add(this.encoding);
        if (asApplet) {
            this.clearButton = new Button("Clear");
            this.clearButton.setFont(new Font("Dialog", 1, 16));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 30.0;
            gridBagConstraints.weighty = 5.0;
            gridBagConstraints.ipadx = 20;
            gridBagConstraints.ipady = 10;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(5, 10, 5, 10);
            ((GridBagLayout)this.getLayout()).setConstraints(this.clearButton, gridBagConstraints);
            this.add(this.clearButton);
        }
        this.convertButton = new Button("Convert");
        this.convertButton.setFont(new Font("Dialog", 1, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 30.0;
        gridBagConstraints.weighty = 5.0;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        ((GridBagLayout)this.getLayout()).setConstraints(this.convertButton, gridBagConstraints);
        this.add(this.convertButton);
        this.instructions = new Label("", 1);
        if (asApplet) {
            this.instructions.setText("Paste raw text to upper; click Convert; then Copy cooked HTML from lower.");
        } else {
            this.instructions.setText("Copy raw text to the clipboard; click Convert; then Paste cooked HTML.");
        }
        this.instructions.setBackground(white);
        this.instructions.setForeground(darkGreen);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 20;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        ((GridBagLayout)this.getLayout()).setConstraints(this.instructions, gridBagConstraints);
        this.add(this.instructions);
        TheListener theListener = new TheListener();
        if (asApplet) {
            this.clearButton.addActionListener(theListener);
        }
        this.convertButton.addActionListener(theListener);
        this.encoding.addItemListener(theListener);
        this.validate();
        this.setVisible(true);
    }

    void convertButton_ActionPerformed(ActionEvent actionEvent) {
        if (asApplet) {
            String string = this.rawTextArea.getText();
            String string2 = HTMLReservedChars.toQuoted(string, this.translateTable);
            this.cookedTextArea.setText(string2);
            return;
        }
        String string = ClipboardPoker.getClip(this);
        String string3 = HTMLReservedChars.toQuoted(string, this.translateTable);
        ClipboardPoker.setClip(string3, this);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public static void main(String[] stringArray) {
        Quoter quoter = new Quoter(false);
        Frame frame = new Frame("HTML Quoter Amanuensis");
        ((Component)frame).setSize(440, 200);
        quoter.init();
        frame.add(quoter);
        frame.validate();
        ((Component)frame).setVisible(true);
        quoter.start();
        frame.addWindowListener(quoter.new 1());
    }

    static /* synthetic */ String[] access$0(Quoter quoter) {
        return quoter.translateTable;
    }

    static /* synthetic */ void access$1(Quoter quoter, String[] stringArray) {
        quoter.translateTable = stringArray;
    }

    class TheListener
    implements ActionListener,
    ItemListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == Quoter.this.convertButton) {
                Quoter.this.convertButton_ActionPerformed(actionEvent);
                return;
            }
            if (object == Quoter.this.clearButton) {
                Quoter.this.rawTextArea.setText(null);
                Quoter.this.cookedTextArea.setText(null);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == Quoter.this.encoding) {
                switch (Quoter.this.encoding.getSelectedIndex()) {
                    case 0: {
                        Quoter quoter = Quoter.this;
                        String[] stringArray = HTMLReservedChars.latin1;
                        quoter.translateTable = stringArray;
                        return;
                    }
                    case 1: {
                        Quoter quoter = Quoter.this;
                        String[] stringArray = HTMLReservedChars.win;
                        quoter.translateTable = stringArray;
                        return;
                    }
                    case 2: {
                        Quoter quoter = Quoter.this;
                        String[] stringArray = HTMLReservedChars.ibmoem;
                        quoter.translateTable = stringArray;
                        return;
                    }
                }
                Quoter quoter = Quoter.this;
                String[] stringArray = HTMLReservedChars.latin1;
                quoter.translateTable = stringArray;
                return;
            }
        }

        TheListener() {
            Quoter.this = Quoter.this;
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            Quoter.this.stop();
            Quoter.this.destroy();
            System.exit(0);
        }

        /* synthetic */ 1() {
        }
    }
}

