/*
 * Decompiled with CFR 0.152.
 */
package cmp.HeapSort;

import cmp.HeapSort.Comparator;

public class HeapSort {
    private static final String EmbeddedCopyright = "Copyright 1996-1998 Roedy Green, Canadian Mind Products, http://mindprod.com";
    private static final boolean debugging = false;
    private Comparator delegate;
    private Object[] offices;
    private int lastIndex = -1;
    private Object[] userArray;

    public static void sort(Object[] objectArray, Comparator comparator) {
        HeapSort heapSort = new HeapSort();
        heapSort.userArray = objectArray;
        heapSort.delegate = comparator;
        if (heapSort.isAlreadySorted()) {
            return;
        }
        heapSort.offices = new Object[objectArray.length];
        heapSort.lastIndex = -1;
        heapSort.assignOffices();
        heapSort.raidAllEmployeesBiggestFirst();
    }

    private boolean isAlreadySorted() {
        int n = 1;
        while (n < this.userArray.length) {
            if (this.delegate.compare(this.userArray[n], this.userArray[n - 1]) < 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void assignOffices() {
        int n = this.userArray.length - 1;
        while (n >= 0) {
            int n2 = ++this.lastIndex;
            this.offices[n2] = this.userArray[n];
            this.challenge(n2);
            --n;
        }
    }

    private void raidAllEmployeesBiggestFirst() {
        int n = this.offices.length - 1;
        while (n >= 0) {
            this.userArray[n] = this.offices[0];
            this.replaceVacancy(0);
            --n;
        }
    }

    private void challenge(int n) {
        Object object = this.offices[n];
        while (n > 0) {
            int n2 = (n - 1) / 2;
            Object object2 = this.offices[n2];
            if (this.delegate.compare(object2, object) >= 0) break;
            this.offices[n] = object2;
            n = n2;
        }
        this.offices[n] = object;
    }

    private void replaceVacancy(int n) {
        while (n < this.lastIndex) {
            int n2 = n * 2 + 1;
            if (n2 > this.lastIndex) {
                this.promoteJuniorToVacancy(n);
                break;
            }
            Object object = this.offices[n2];
            int n3 = n2 + 1;
            if (n3 > this.lastIndex) {
                this.offices[n] = object;
                n = n2;
                this.promoteJuniorToVacancy(n);
                break;
            }
            Object object2 = this.offices[n3];
            if (this.delegate.compare(object, object2) < 0) {
                this.offices[n] = object2;
                n = n3;
                continue;
            }
            this.offices[n] = object;
            n = n2;
        }
        --this.lastIndex;
    }

    private void promoteJuniorToVacancy(int n) {
        if (n < this.lastIndex) {
            this.offices[n] = this.offices[this.lastIndex];
            this.challenge(n);
        }
    }
}

