/*
 * Decompiled with CFR 0.152.
 */
package cmp.ISBN;

import java.awt.Toolkit;

class ISBNValidate {
    private static String leadJunk;
    private static String trailJunk;

    public static String tidy(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = ISBNValidate.strip(string);
        if (string2.length() != 10) {
            Toolkit.getDefaultToolkit().beep();
            return String.valueOf(leadJunk) + "[" + string2 + "]" + " is INVALID. Must be 10 digits! " + trailJunk;
        }
        if (!ISBNValidate.isPublisherValid(string2)) {
            Toolkit.getDefaultToolkit().beep();
            return String.valueOf(leadJunk) + "[" + string2 + "]" + " is INVALID. Bad publisher number! " + trailJunk;
        }
        if (!ISBNValidate.isValid(string2)) {
            Toolkit.getDefaultToolkit().beep();
            return String.valueOf(leadJunk) + "[" + string2 + "]" + " is INVALID. Check digit failure! " + trailJunk;
        }
        return String.valueOf(leadJunk) + ISBNValidate.insertDashes(string2) + trailJunk;
    }

    private static String strip(String string) {
        int n;
        leadJunk = "";
        int n2 = 0;
        while (n2 < string.length()) {
            n = string.charAt(n2);
            if ("0123456789".indexOf(n) >= 0) {
                leadJunk = string.substring(0, n2);
                string = string.substring(n2);
                break;
            }
            ++n2;
        }
        trailJunk = "";
        n = string.length() - 1;
        while (n >= 0) {
            char c = string.charAt(n);
            if ("0123456789Xx".indexOf(c) >= 0) {
                trailJunk = string.substring(n + 1);
                string = string.substring(0, n + 1);
                break;
            }
            --n;
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        int n3 = 0;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if ("0123456789".indexOf(c) >= 0) {
                stringBuffer.append(c);
            } else if ("Xx".indexOf(c) >= 0) {
                stringBuffer.append('X');
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static boolean isValid(String string) {
        int n = 0;
        int n2 = 1;
        while (n2 <= 10) {
            char c = string.charAt(10 - n2);
            int n3 = c != 'X' ? c - 48 : 10;
            n += n3 * n2;
            ++n2;
        }
        return n % 11 == 0;
    }

    public static String tidyBase(String string) {
        if (string.length() == 8) {
            string = String.valueOf('0') + string;
        }
        if (string.length() != 9) {
            return "[" + string + "]" + " is INVALID. Must be 9 digits! ";
        }
        int n = 0;
        if (!ISBNValidate.isPublisherValid(string)) {
            return "[" + string + "]" + " is INVALID. Bad pubisher number! ";
        }
        int n2 = 2;
        while (n2 <= 10) {
            char c = string.charAt(10 - n2);
            int n3 = c - 48;
            n += n3 * n2;
            ++n2;
        }
        switch (n %= 11) {
            case 0: {
                return ISBNValidate.tidy(String.valueOf(string) + '0');
            }
            case 1: {
                return ISBNValidate.tidy(String.valueOf(string) + 'X');
            }
        }
        return ISBNValidate.tidy(String.valueOf(string) + (char)(11 - n + 48));
    }

    public static String insertDashes(String string) {
        int n;
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string.substring(0, 9));
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
        int n3 = 0;
        int n4 = -1;
        int[] nArray = new int[]{20000000, 70000000, 85000000, 90000000, 95000000, 100000000, 155000000, 186980000, 199900000, 200000000, 800000000, 950000000, 996000000, 999000000, 1000000000};
        boolean bl = false;
        do {
            int n5 = 0;
            n = 0;
            while (n < nArray.length) {
                if (n2 < nArray[n]) {
                    n5 = n;
                    break;
                }
                ++n;
            }
            switch (n5) {
                case 0: {
                    n4 = n3 + 2;
                    bl = false;
                    break;
                }
                case 1: {
                    n4 = n3 + 3;
                    bl = false;
                    break;
                }
                case 2: {
                    n4 = n3 + 4;
                    bl = false;
                    break;
                }
                case 3: {
                    n4 = n3 + 5;
                    bl = false;
                    break;
                }
                case 4: {
                    n4 = n3 + 6;
                    bl = false;
                    break;
                }
                case 5: {
                    n4 = n3 + 7;
                    bl = false;
                    break;
                }
                case 6: {
                    n4 = 4;
                    bl = false;
                    break;
                }
                case 7: {
                    n4 = 5;
                    bl = false;
                    break;
                }
                case 8: {
                    n4 = 6;
                    bl = false;
                    break;
                }
                case 9: {
                    n4 = 7;
                    bl = false;
                    break;
                }
                case 10: {
                    n2 %= 100000000;
                    bl = true;
                    break;
                }
                case 11: {
                    n3 = 1;
                    n2 = n2 % 10000000 * 10;
                    bl = true;
                    break;
                }
                case 12: {
                    n3 = 2;
                    n2 = n2 % 1000000 * 100;
                    bl = true;
                    break;
                }
                case 13: {
                    n3 = 3;
                    n2 = n2 % 100000 * 1000;
                    bl = true;
                    break;
                }
                case 14: {
                    n3 = 4;
                    n2 = n2 % 10000 * 10000;
                    bl = true;
                }
            }
        } while (bl);
        StringBuffer stringBuffer = new StringBuffer(13);
        n = 0;
        while (n < 10) {
            char c = string.charAt(n);
            stringBuffer.append(c);
            if (n == n3 || n == n4 || n == 8) {
                stringBuffer.append('-');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean isPublisherValid(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string.substring(0, 9));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        int[] nArray = new int[]{800000000, 950000000, 996000000, 999000000, 1000000000};
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (n < nArray[n3]) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        switch (n2) {
            case 0: {
                return true;
            }
            case 1: {
                return n % 10000000 < 9500000;
            }
            case 2: {
                return n % 1000000 < 900000;
            }
            case 3: {
                return n % 100000 < 85000;
            }
            case 4: {
                return n % 10000 < 7000;
            }
        }
        return false;
    }

    ISBNValidate() {
    }
}

