/*
 * Decompiled with CFR 0.152.
 */
package cmp.ISBN;

import cmp.ISBN.ClipboardPoker;
import cmp.ISBN.ISBNValidate;
import cmp.business.Misc;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class ISBN
extends Applet
implements ClipboardOwner {
    private static final String EmbeddedCopyright = "Copyright 1998 Roedy Green, Canadian Mind Products, http://mindprod.com";
    private boolean asApplet = true;
    private static final Color black = Color.black;
    private static final Color blue = Color.blue;
    private static final Color darkGreen = new Color(0, 128, 0);
    private static final Color red = Color.red;
    private static final Color white = Color.white;
    Label titleLabel;
    TextArea rawTextArea;
    TextArea cookedTextArea;
    Button clearButton;
    Button tidyButton;
    Label instructions;
    private static final boolean debugging = false;

    public ISBN() {
    }

    private ISBN(boolean bl) {
        this.asApplet = bl;
    }

    public void init() {
        this.setVisible(false);
        this.setBackground(white);
        if (!Misc.isJavaVersionOK(1, 1, 0)) {
            System.out.println("You need Java 1.1.0 or later to run this Applet.");
            System.out.println("You are running under " + System.getProperty("java.version"));
            System.exit(1);
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.titleLabel = new Label("CMP ISBN Amanuensis 1.3", 1);
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setForeground(red);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        ((GridBagLayout)this.getLayout()).setConstraints(this.titleLabel, gridBagConstraints);
        this.add(this.titleLabel);
        if (this.asApplet) {
            this.rawTextArea = new TextArea("", 2, 25, 3);
            this.rawTextArea.setEditable(true);
            this.rawTextArea.setFont(new Font("Dialog", 0, 15));
            this.rawTextArea.setForeground(black);
            ((Component)this.rawTextArea).setBackground(white);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.weighty = 20.0;
            gridBagConstraints.ipadx = 10;
            gridBagConstraints.ipady = 20;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 10, 5, 5);
            ((GridBagLayout)this.getLayout()).setConstraints(this.rawTextArea, gridBagConstraints);
            this.add(this.rawTextArea);
            this.cookedTextArea = new TextArea("", 2, 25, 3);
            this.cookedTextArea.setEditable(false);
            this.cookedTextArea.setFont(new Font("Dialog", 0, 15));
            this.cookedTextArea.setForeground(black);
            ((Component)this.cookedTextArea).setBackground(white);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.weighty = 20.0;
            gridBagConstraints.ipadx = 10;
            gridBagConstraints.ipady = 20;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 5, 10);
            ((GridBagLayout)this.getLayout()).setConstraints(this.cookedTextArea, gridBagConstraints);
            this.add(this.cookedTextArea);
            this.clearButton = new Button("Clear");
            this.clearButton.setFont(new Font("Dialog", 1, 16));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.ipadx = 20;
            gridBagConstraints.ipady = 5;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            ((GridBagLayout)this.getLayout()).setConstraints(this.clearButton, gridBagConstraints);
            this.add(this.clearButton);
        }
        this.tidyButton = new Button("Tidy");
        this.tidyButton.setFont(new Font("Dialog", 1, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        ((GridBagLayout)this.getLayout()).setConstraints(this.tidyButton, gridBagConstraints);
        this.add(this.tidyButton);
        this.instructions = new Label("", 1);
        if (this.asApplet) {
            this.instructions.setText("Paste raw ISBN to left; click Tidy; then Copy tidied ISBN from right.");
        } else {
            this.instructions.setText("Copy raw ISBN to the clipboard; click Tidy; then Paste tidied ISBN.");
        }
        this.instructions.setBackground(white);
        this.instructions.setForeground(darkGreen);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        ((GridBagLayout)this.getLayout()).setConstraints(this.instructions, gridBagConstraints);
        this.add(this.instructions);
        TheListener theListener = new TheListener();
        if (this.asApplet) {
            this.clearButton.addActionListener(theListener);
        }
        this.tidyButton.addActionListener(theListener);
        this.validate();
        this.setVisible(true);
    }

    void tidyButton_ActionPerformed(ActionEvent actionEvent) {
        if (this.asApplet) {
            String string = this.rawTextArea.getText();
            String string2 = ISBNValidate.tidy(string);
            this.cookedTextArea.setText(string2);
            return;
        }
        String string = ClipboardPoker.getClip(this);
        String string3 = ISBNValidate.tidy(string);
        ClipboardPoker.setClip(string3, this);
    }

    void clearButton_ActionPerformed(ActionEvent actionEvent) {
        this.rawTextArea.setText(null);
        this.cookedTextArea.setText(null);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public static void main(String[] stringArray) {
        ISBN iSBN = new ISBN(false);
        Frame frame = new Frame("ISBN Amanuensis");
        ((Component)frame).setSize(440, 200);
        iSBN.init();
        frame.add(iSBN);
        frame.validate();
        ((Component)frame).setVisible(true);
        iSBN.start();
        frame.addWindowListener(iSBN.new 1());
    }

    class TheListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ISBN.this.tidyButton) {
                ISBN.this.tidyButton_ActionPerformed(actionEvent);
                return;
            }
            if (object == ISBN.this.clearButton) {
                ISBN.this.clearButton_ActionPerformed(actionEvent);
            }
        }

        TheListener() {
            ISBN.this = ISBN.this;
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ISBN.this.stop();
            ISBN.this.destroy();
            System.exit(0);
        }

        /* synthetic */ 1() {
        }
    }
}

