/*
 * Decompiled with CFR 0.152.
 */
package cmp.InWords;

import cmp.InWords.Test;
import cmp.InWords.ToWords;

public class Tagalog
implements ToWords {
    private static final String EmbeddedCopyright = "Copyright 1999 Roedy Green, Canadian Mind Products, http://mindprod.com";
    private static final String ZERO = "nol";
    private static final String MINUS = "minus";
    private static final String ALTONE = "san";
    private static final String[] digits = new String[]{"", "is\u00e1", "dalaw\u00e1", "tatl\u00f3", "\u00e1pat", "lim\u00e1", "\u00e1nim", "pit\u00f3", "wal\u00f3", "siy\u00e1m", "samp\u00fb"};
    private static final String[] TYS = new String[]{"", "samp\u00fb", "dalawamp\u00fb", "tatlump\u00fb", "apatnap\u00fb", "limamp\u00fb", "animnap\u00fb", "pitump\u00fb", "walump\u00fb", "siyamnap\u00fb"};
    private static final String ALTHUNDRED = "ra\u00e1n";
    private static final String[] groupName = new String[]{"", "da\u00e1n", "l\u00edbo", "milyon", "bilyon", "trilyon", "kwadrilyon", "kwintilyon"};
    private static final int[] divisor = new int[]{100, 10, 1000, 1000, 1000, 1000, 1000, 1000};

    public static String inWords(long l) {
        return Tagalog.inWordsCore(l, false);
    }

    public static String inWordsCore(long l, boolean bl) {
        boolean bl2;
        if (l == 0L) {
            return ZERO;
        }
        boolean bl3 = bl2 = l < 0L;
        if (bl2) {
            l = -l;
        }
        String string = "";
        int n = 0;
        while (l > 0L) {
            int n2 = (int)(l % (long)divisor[n]);
            l /= (long)divisor[n];
            if (n2 != 0) {
                boolean bl4;
                int n3;
                String string2;
                if (n2 < 20) {
                    string2 = Tagalog.lowName(n2);
                } else if (n2 < 100) {
                    int n4 = n2 % 10;
                    n3 = n2 / 10;
                    if (n4 == 0) {
                        string2 = TYS[n3];
                    } else {
                        string2 = Tagalog.appendAnd(TYS[n3]) + " " + Tagalog.lowName(n4);
                        bl = true;
                    }
                } else {
                    string2 = Tagalog.inWordsCore(n2, bl);
                }
                String string3 = groupName[n];
                n3 = string2.length() <= 0 ? 0 : 1;
                boolean bl5 = bl4 = string3.length() > 0;
                if (n == 1 && n2 % 10 == 4) {
                    string3 = ALTHUNDRED;
                }
                if (string3.length() > 0) {
                    string2 = Tagalog.makeMultiplicative(string2);
                }
                if (n == 1 && n2 == 1) {
                    string2 = ALTONE;
                    n3 = 0;
                }
                if (!bl && string.length() != 0) {
                    string3 = Tagalog.appendAnd(string3);
                    bl = true;
                }
                string = string2 + (n3 != 0 ? " " : "") + string3 + (bl4 ? " " : "") + string;
            }
            ++n;
        }
        string = string.trim();
        if (bl2) {
            string = MINUS + " " + string;
        }
        return string;
    }

    public String toWords(long l) {
        return Tagalog.inWords(l);
    }

    private static final String teens(int n) {
        String string;
        switch (n) {
            case 11: 
            case 14: 
            case 16: {
                string = "lab\u00edng-";
                break;
            }
            case 12: 
            case 13: 
            case 15: {
                string = "lab\u00edn";
                break;
            }
            case 17: {
                string = "labim";
                break;
            }
            case 18: {
                string = "labing";
                break;
            }
            case 19: {
                string = "labin";
                break;
            }
            default: {
                throw new IllegalArgumentException("teens parm not 11..19");
            }
        }
        return string + digits[n % 10];
    }

    private static final String lowName(int n) {
        String string = n < 11 ? digits[n] : Tagalog.teens(n);
        return string;
    }

    private static final String makeMultiplicative(String string) {
        String string2;
        switch (string.charAt(string.length() - 1)) {
            case 'm': 
            case 't': {
                string2 = " na";
                break;
            }
            default: {
                string2 = "ng";
                break;
            }
        }
        return string + string2;
    }

    private static final String appendAnd(String string) {
        switch (string.charAt(string.length() - 1)) {
            case '\u00fb': {
                return string.substring(0, string.length() - 1) + "\u00fa't";
            }
        }
        return string.substring(0, string.length() - 1) + "'t";
    }

    public static void main(String[] stringArray) {
        Test.test(new Tagalog());
    }
}

