/*
 * Decompiled with CFR 0.152.
 */
package cmp.InWords;

import cmp.InWords.DecimalDots;
import cmp.InWords.Test;
import cmp.InWords.ToWords;

public class Swedish
implements ToWords {
    private static final String EmbeddedCopyright = "Copyright 1999 Roedy Green, Canadian Mind Products, http://mindprod.com";
    private static final int NATURAL = 0;
    private static final int NEUTER = 1;
    private static final String ZERO = "noll";
    private static final String MINUS = "minus";
    private static final String PLURAL = "er";
    private static final String[] ONE = new String[]{"ett", "en"};
    private static final String[] naturalLowName = new String[]{"", "ett", "tv\u00e5", "tre", "fyra", "fem", "sex", "sju", "\u00e5tta", "nio", "tio", "elva", "tolv", "tretton", "fjorton", "femton", "sexton", "sjutton", "arton", "nitton"};
    private static final String[] tys = new String[]{"", "", "tjugo", "trettio", "fyrtio", "femtio", "sextio", "sjuttio", "\u00e5ttio", "nittio"};
    private static final String[] groupName = new String[]{"", "hundra", "tusen", "miljon", "miljard", "biljon", "biljard", "triljon"};
    private static final int[] divisor = new int[]{100, 10, 1000, 1000, 1000, 1000, 1000, 1000};

    public static String inWords(long l) {
        return Swedish.inWordsCore(l, 0);
    }

    public static String inWordsCore(long l, int n) {
        boolean bl;
        if (l == 0L) {
            return ZERO;
        }
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        String string = "";
        int n2 = 0;
        while (l > 0L) {
            int n3;
            int n4 = (int)(l % (long)divisor[n2]);
            l /= (long)divisor[n2];
            int n5 = n3 = n2 == 0 ? Swedish.groupGender(n) : Swedish.groupGender(n2);
            if (n4 != 0) {
                int n6;
                String string2;
                int n7;
                if (n4 == 1) {
                    switch (n2) {
                        case 1: 
                        case 2: {
                            n7 = l != 0L || n != 0 ? 0 : 1;
                            string2 = n7 != 0 ? "" : Swedish.lowName(n4, n3);
                            break;
                        }
                        default: {
                            string2 = Swedish.lowName(n4, n3);
                            break;
                        }
                    }
                } else if (n4 < 20) {
                    string2 = Swedish.lowName(n4, n3);
                } else if (n4 < 100) {
                    n7 = n4 % 10;
                    n6 = n4 / 10;
                    string2 = tys[n6];
                    if (n7 != 0) {
                        string2 = string2 + Swedish.lowName(n7, n3);
                    }
                } else {
                    string2 = Swedish.inWordsCore(n4, n2);
                }
                n7 = n4 <= 1 || n2 <= 2 ? 0 : 1;
                n6 = string.length() != 0 || n2 < 3 ? 0 : 1;
                string = string2 + (n6 != 0 ? " " : "") + groupName[n2] + (n7 != 0 ? PLURAL : "") + string;
            }
            ++n2;
        }
        string = string.trim();
        if (bl) {
            string = MINUS + " " + string;
        }
        return string;
    }

    public String toWords(long l) {
        return Swedish.inWords(l);
    }

    private static final String lowName(int n, int n2) {
        if (n == 1) {
            return ONE[n2];
        }
        return naturalLowName[n];
    }

    private static final int groupGender(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    public static void main(String[] stringArray) {
        Test.test(new Swedish(), new DecimalDots());
    }
}

