/*
 * Decompiled with CFR 0.152.
 */
package cmp.InWords;

import cmp.InWords.DecimalDots;
import cmp.InWords.Test;
import cmp.InWords.ToWords;

public class Polish
implements ToWords {
    private static final String EmbeddedCopyright = "Copyright 1999 Roedy Green, Canadian Mind Products, http://mindprod.com";
    private static final String ZERO = "zero";
    private static final String MINUS = "minus";
    private static final String[] lowName = new String[]{"", "jeden", "dwa", "trzy", "cztery", "pi\u0119\u0107", "sze\u015b\u0107", "siedem", "osiem", "dziewi\u0119\u0107", "dziesi\u0119\u0107", "jedena\u015bcie", "dwana\u015bcie", "trzyna\u015bcie", "czterna\u015bcie", "pi\u0119tna\u015bcie", "szesna\u015bcie", "siedemna\u015bcie", "osiemna\u015bcie", "dziewietna\u015bcie"};
    private static final String[] tys = new String[]{"", "", "dwadzie\u015bcia", "trzydzie\u015bci", "czterdzie\u015bci", "pi\u0119\u0107dziesi\u0105t", "sze\u015b\u0107dzies\u0105t", "siedemdziesi\u0105t", "ossiemdziesi\u0105t", "dziewi\u0119\u0107dziesi\u0105t"};
    private static final String[] hundredsGroupName = new String[]{"", "sto", "dwie\u015bcie", "trzysta", "czterysta", "pi\u0119\u0107set", "sze\u015b\u0107set", "siedemset", "osiemset", "dziewi\u0119\u0107set"};
    private static final String[] thousandsGroupName = new String[]{"", "tysi\u0105c", "tysi\u0105ce", "tysi\u0105ce", "tysi\u0105ce", "tysi\u0119cy", "tysi\u0119cy", "tysi\u0119cy", "tysi\u0119cy", "tysi\u0119cy"};
    private static final String[] groupName = new String[]{"", "", "tysi\u0105c", "milion", "miliard", "bilion", "biliard", "trilion"};
    private static final int[] divisor = new int[]{100, 10, 1000, 1000, 1000, 1000, 1000, 1000};

    public static String inWords(long l) {
        boolean bl;
        if (l == 0L) {
            return ZERO;
        }
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        String string = "";
        int n = 0;
        while (l > 0L) {
            int n2 = (int)(l % (long)divisor[n]);
            l /= (long)divisor[n];
            if (n2 != 0) {
                int n3;
                String string2;
                if (n2 == 1) {
                    switch (n) {
                        case 0: {
                            string2 = lowName[1];
                            break;
                        }
                        default: {
                            string2 = "";
                            break;
                        }
                    }
                } else if (n2 < 10) {
                    switch (n) {
                        case 1: {
                            string2 = "";
                            break;
                        }
                        default: {
                            string2 = lowName[n2];
                            break;
                        }
                    }
                } else if (n2 < 20) {
                    string2 = lowName[n2];
                } else if (n2 < 100) {
                    n3 = n2 % 10;
                    int n4 = n2 / 10;
                    string2 = tys[n4];
                    if (n3 != 0) {
                        string2 = string2 + " " + lowName[n3];
                    }
                } else {
                    string2 = Polish.inWords(n2);
                }
                n3 = string2.length() == 0 ? 0 : 1;
                string = string2 + (n3 != 0 ? " " : "") + Polish.getGroupName(n2, n) + " " + string;
            }
            ++n;
        }
        string = string.trim();
        if (bl) {
            string = MINUS + " " + string;
        }
        return string;
    }

    public String toWords(long l) {
        return Polish.inWords(l);
    }

    private static final String getGroupName(int n, int n2) {
        switch (n2) {
            case 0: {
                return "";
            }
            case 1: {
                return hundredsGroupName[n];
            }
            case 2: {
                if (10 <= n && n <= 19) {
                    n = 9;
                } else if (n >= 20 && (n %= 10) == 0) {
                    n = 9;
                }
                return thousandsGroupName[n];
            }
        }
        return groupName[n2];
    }

    public static void main(String[] stringArray) {
        Test.test(new Polish(), new DecimalDots());
    }
}

