/*
 * Decompiled with CFR 0.152.
 */
package cmp.InWords;

import cmp.InWords.DecimalDots;
import cmp.InWords.Test;
import cmp.InWords.ToWords;

public class Norwegian
implements ToWords {
    private static final String EmbeddedCopyright = "Copyright 1999 Roedy Green, Canadian Mind Products, http://mindprod.com";
    private static final String ZERO = "null";
    private static final String MINUS = "minus";
    private static final String AND = "og";
    private static final String PLURAL = "er";
    private static final String[] ONE = new String[]{"ett", "en"};
    private static final String[] lowName = new String[]{"", "en", "to", "tre", "fire", "fem", "seks", "sju", "\u00e5tte", "ni", "ti", "elleve", "tolv", "tretten", "fjorten", "femten", "seksten", "sytten", "atten", "nitten"};
    private static final String[] tys = new String[]{"", "", "tjue", "tretti", "f\u00f8rti", "femti", "seksti", "sytti", "\u00e5tti", "nitti"};
    private static final String[] groupName = new String[]{"", "hundre", "tusen", "million", "milliard", "billion", "billiard", "trillion"};
    private static final int[] divisor = new int[]{100, 10, 1000, 1000, 1000, 1000, 1000, 1000};

    public static String inWords(long l) {
        boolean bl;
        if (l == 0L) {
            return ZERO;
        }
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        String string = "";
        int n = 0;
        while (l > 0L) {
            int n2 = (int)(l % (long)divisor[n]);
            l /= (long)divisor[n];
            if (n2 != 0) {
                int n3;
                int n4;
                String string2;
                if (n2 == 1) {
                    string2 = n == 1 || n == 2 ? ONE[0] : ONE[1];
                } else if (n2 < 20) {
                    string2 = lowName[n2];
                } else if (n2 < 100) {
                    n4 = n2 % 10;
                    n3 = n2 / 10;
                    string2 = tys[n3];
                    if (n4 != 0) {
                        string2 = string2 + lowName[n4];
                    }
                } else {
                    string2 = Norwegian.inWords(n2);
                }
                n4 = n != 0 || l == 0L ? 0 : 1;
                n3 = n2 <= 1 || n <= 2 ? 0 : 1;
                string = (n4 != 0 ? "og " : "") + string2 + " " + groupName[n] + (n3 != 0 ? "er " : " ") + string;
            }
            ++n;
        }
        string = string.trim();
        if (bl) {
            string = MINUS + " " + string;
        }
        return string;
    }

    public String toWords(long l) {
        return Norwegian.inWords(l);
    }

    public static void main(String[] stringArray) {
        Test.test(new Norwegian(), new DecimalDots());
    }
}

