/*
 * Decompiled with CFR 0.152.
 */
package cmp.InWords;

import cmp.InWords.DecimalDots;
import cmp.InWords.Test;
import cmp.InWords.ToWords;

public class Icelandic
implements ToWords {
    private static final String EmbeddedCopyright = "Copyright 1999 Roedy Green, Canadian Mind Products, http://mindprod.com";
    private static final String ZERO = "n\u00fall";
    private static final String MINUS = "m\u00ednus";
    private static final String AND = "og";
    private static final int MASCULINE = 0;
    private static final int FEMININE = 1;
    private static final int NEUTER = 2;
    private static final String[] neuterLowName = new String[]{"", "eitt", "tv\u00f6", "\u00ferj\u00fa", "fj\u00f6gur"};
    private static final String[] masculineLowName = new String[]{"", "einn", "tveir", "\u00fer\u00edr", "fj\u00f3rir", "fimm", "sex", "sj\u00f6", "\u00e1tta", "n\u00edu", "t\u00edu", "ellefu", "t\u00f3lf", "\u00ferett\u00e1n", "fj\u00f3rt\u00e1n", "fimmt\u00e1n", "sext\u00e1n", "sautj\u00e1n", "\u00e1tj\u00e1n", "n\u00edtj\u00e1n"};
    private static final String[] feminineLowName = new String[]{"", "ein", "tv\u00e6r", "\u00ferj\u00e1r", "fj\u00f3rar"};
    private static final String[] tys = new String[]{"", "", "tuttugu", "\u00ferj\u00e1t\u00edu", "fj\u00f6rut\u00edu", "fimmt\u00edu", "sext\u00edu", "sj\u00f6t\u00edu", "\u00e1tta\u00edu", "n\u00edut\u00edu"};
    private static final String[] singularGroupName = new String[]{"", "hundra\u00f0", "\u00fe\u00fasund", "millj\u00f3n", "milljar\u00f0ur", "billj\u00f3n", "billjar\u00f0ur", "trillj\u00f3n"};
    private static final String[] pluralGroupName = new String[]{"", "hundru\u00f0", "\u00fe\u00fasund", "millj\u00f3nir", "milljar\u00f0ar", "billj\u00f3nir", "billjar\u00f0ar", "trillj\u00f3nir"};
    private static final int[] divisor = new int[]{100, 10, 1000, 1000, 1000, 1000, 1000, 1000};

    public static String inWords(long l) {
        return Icelandic.inWordsCore(l, 0, false);
    }

    private static final String inWordsCore(long l, int n, boolean bl) {
        boolean bl2;
        if (l == 0L) {
            return ZERO;
        }
        boolean bl3 = bl2 = l < 0L;
        if (bl2) {
            l = -l;
        }
        String string = "";
        int n2 = 0;
        while (l > 0L) {
            int n3;
            int n4 = (int)(l % (long)divisor[n2]);
            l /= (long)divisor[n2];
            int n5 = n3 = n2 == 0 ? Icelandic.groupGender(n) : Icelandic.groupGender(n2);
            if (n4 != 0) {
                int n6;
                int n7;
                String string2;
                if (n4 < 20) {
                    string2 = Icelandic.lowName(n4, n3);
                } else if (n4 < 100) {
                    n7 = n4 % 10;
                    n6 = n4 / 10;
                    string2 = tys[n6];
                    if (n7 != 0) {
                        string2 = string2 + " " + AND + " " + Icelandic.lowName(n7, n3);
                        bl = true;
                    }
                } else {
                    string2 = Icelandic.inWordsCore(n4, n2, bl);
                    if (string2.indexOf(AND + " ") >= 0) {
                        bl = true;
                    }
                }
                int n8 = n7 = bl || l == 0L || n4 == 0 ? 0 : 1;
                if (n7 != 0) {
                    bl = true;
                }
                n6 = n4 <= 1 ? 0 : 1;
                string = (n7 != 0 ? "og " : "") + string2 + " " + (n6 != 0 ? pluralGroupName[n2] : singularGroupName[n2]) + " " + string;
            }
            ++n2;
        }
        string = string.trim();
        if (bl2) {
            string = MINUS + " " + string;
        }
        return string;
    }

    public String toWords(long l) {
        return Icelandic.inWords(l);
    }

    private static final int groupGender(int n) {
        switch (n) {
            case 0: 
            case 4: 
            case 6: {
                return 0;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case 3: 
            case 5: 
            case 7: {
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    private static final String lowName(int n, int n2) {
        if (n <= 4) {
            switch (n2) {
                case 0: {
                    return masculineLowName[n];
                }
                case 1: {
                    return feminineLowName[n];
                }
                case 2: {
                    return neuterLowName[n];
                }
            }
            throw new IllegalArgumentException();
        }
        return masculineLowName[n];
    }

    public static void main(String[] stringArray) {
        Test.test(new Icelandic(), new DecimalDots());
    }
}

