/*
 * Decompiled with CFR 0.152.
 */
package cmp.InWords;

import cmp.InWords.DecimalDots;
import cmp.InWords.Test;
import cmp.InWords.ToWords;

public class German
implements ToWords {
    private static final String EmbeddedCopyright = "Copyright 1999 Roedy Green, Canadian Mind Products, http://mindprod.com";
    private static final String ZERO = "null";
    private static final String MINUS = "minus";
    private static final String AND = "und";
    private static final String[] ONE = new String[]{"eins", "ein", "eine"};
    private static final String[] lowName = new String[]{"", "ein", "zwei", "drei", "vier", "f\u00fcnf", "sechs", "sieben", "acht", "neun", "zehn", "elf", "zw\u00f6lf", "dreizehn", "vierzehn", "f\u00fcnfzehn", "sechzehn", "siebzehn", "achtzehn", "neunzehn", "zwanzig"};
    private static final String[] tys = new String[]{"", "zehn", "zwanzig", "drei\u00dfig", "vierzig", "f\u00fcnfzig", "sechzig", "siebzig", "achtzig", "neunzig"};
    private static final String[] singularGroupName = new String[]{"", "hundert", "tausend", "Million", "Milliarde", "Billion", "Billiarde", "Trillion", "Trilliarde"};
    private static final String[] pluralGroupName = new String[]{"", "hundert", "tausend", "Millionen", "Milliarden", "Billionen", "Billiarden", "Trillionen", "Trilliarden"};
    private static final int[] divisor = new int[]{100, 10, 1000, 1000, 1000, 1000, 1000, 1000};

    public static String inWords(long l) {
        boolean bl;
        if (l == 0L) {
            return ZERO;
        }
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        String string = "";
        int n = 0;
        while (l > 0L) {
            int n2 = (int)(l % (long)divisor[n]);
            l /= (long)divisor[n];
            if (n2 != 0) {
                int n3;
                int n4;
                String string2;
                if (n2 == 1) {
                    string2 = n == 0 ? ONE[0] : (n < 3 ? ONE[1] : ONE[2]);
                } else if (n2 < 20) {
                    string2 = lowName[n2];
                } else if (n2 < 100) {
                    n4 = n2 % 10;
                    n3 = n2 / 10;
                    string2 = tys[n3];
                    if (n4 > 0) {
                        string2 = lowName[n4] + AND + string2;
                    }
                } else {
                    string2 = German.inWords(n2);
                }
                n4 = n <= 2 ? 0 : 1;
                n3 = n <= 2 ? 0 : 1;
                boolean bl3 = n2 > 1;
                string = string2 + (n4 != 0 ? " " : "") + (bl3 ? pluralGroupName[n] : singularGroupName[n]) + (n3 != 0 ? " " : "") + string;
            }
            ++n;
        }
        string = string.trim();
        if (bl) {
            string = MINUS + " " + string;
        }
        return string;
    }

    public String toWords(long l) {
        return German.inWords(l);
    }

    public static void main(String[] stringArray) {
        Test.test(new German(), new DecimalDots());
    }
}

