/*
 * Decompiled with CFR 0.152.
 */
package cmp.InWords;

import cmp.InWords.DecimalDots;
import cmp.InWords.Test;
import cmp.InWords.ToWords;

public class French
implements ToWords {
    private static final String EmbeddedCopyright = "Copyright 1999 Roedy Green, Canadian Mind Products, http://mindprod.com";
    private static final String ZERO = "z\u00e9ro";
    private static final String MINUS = "moins";
    private static final String PLURAL = "s";
    private static final String AND = "et";
    private static final String[] lowName = new String[]{"", "un", "deux", "trois", "quatre", "cinq", "six", "sept", "huit", "neuf", "dix", "onze", "douze", "treize", "quatorze", "quinze", "seize", "dix-sept", "dix-huit", "dix-neuf", "vingt"};
    private static final String[] tys = new String[]{"", "", "vingt", "trente", "quarante", "cinquante", "soixante", "soixante-dix", "quatre vingt", "quatre-vingt-dix"};
    private static final String[] groupName = new String[]{"", "cent", "mille", "million", "milliard", "billion", "trillion"};
    private static final int[] divisor = new int[]{100, 10, 1000, 1000, 1000, 1000000, 1000000};

    public static String inWords(long l) {
        boolean bl;
        if (l == 0L) {
            return ZERO;
        }
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        String string = "";
        int n = 0;
        while (l > 0L) {
            int n2 = (int)(l % (long)divisor[n]);
            l /= (long)divisor[n];
            if (n2 != 0) {
                int n3;
                int n4;
                String string2;
                if (n2 == 1) {
                    string2 = n == 0 ? lowName[1] : "";
                } else if (n2 < 20) {
                    string2 = lowName[n2];
                } else if (n2 < 100) {
                    n4 = n2 % 10;
                    n3 = n2 / 10;
                    if (n3 == 7 | n3 == 9) {
                        --n3;
                        n4 += 10;
                    }
                    string2 = tys[n3];
                    switch (n4) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            if (n3 == 8) {
                                string2 = string2 + " " + lowName[1];
                                break;
                            }
                            string2 = string2 + " " + AND + " " + lowName[1];
                            break;
                        }
                        default: {
                            string2 = string2 + "-" + lowName[n4];
                            break;
                        }
                    }
                } else {
                    string2 = French.inWords(n2);
                }
                n4 = string2.length() == 0 ? 0 : 1;
                n3 = n2 <= 1 || n != 1 && n <= 2 ? 0 : 1;
                string = string2 + (n4 != 0 ? " " : "") + groupName[n] + (n3 != 0 ? PLURAL : "") + " " + string;
            }
            ++n;
        }
        string = string.trim();
        if (bl) {
            string = MINUS + " " + string;
        }
        return string;
    }

    public String toWords(long l) {
        return French.inWords(l);
    }

    public static void main(String[] stringArray) {
        Test.test(new French(), new DecimalDots());
    }
}

