/*
 * Decompiled with CFR 0.152.
 */
package cmp.InWords;

import cmp.InWords.Test;
import cmp.InWords.ToWords;

public class BritishEnglish
implements ToWords {
    private static final String EmbeddedCopyright = "Copyright 1999 Roedy Green, Canadian Mind Products, http://mindprod.com";
    private static final String ZERO = "zero";
    private static final String MINUS = "minus";
    private static final String AND = "and";
    private static final String[] lowName = new String[]{"", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
    private static final String[] tys = new String[]{"", "", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
    private static final String[] groupName = new String[]{"", "hundred", "thousand", "million", "billion", "trillion"};
    private static final int[] divisor = new int[]{100, 10, 1000, 1000000, 1000000, 1000000};

    public static String inWords(long l) {
        boolean bl;
        if (l == 0L) {
            return ZERO;
        }
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        String string = "";
        int n = 0;
        while (l > 0L) {
            int n2 = (int)(l % (long)divisor[n]);
            l /= (long)divisor[n];
            if (n2 != 0) {
                int n3;
                int n4;
                String string2;
                if (n2 < 20) {
                    string2 = lowName[n2];
                } else if (n2 < 100) {
                    n4 = n2 % 10;
                    n3 = n2 / 10;
                    string2 = tys[n3];
                    if (n4 != 0) {
                        string2 = string2 + "-" + lowName[n4];
                    }
                } else {
                    string2 = BritishEnglish.inWords(n2);
                }
                n4 = n != 0 || l == 0L ? 0 : 1;
                n3 = n <= 2 || string.length() == 0 || string.startsWith(AND) ? 0 : 1;
                string = (n4 != 0 ? "and " : "") + string2 + " " + groupName[n] + (n3 != 0 ? ", " : " ") + string;
            }
            ++n;
        }
        string = string.trim();
        if (bl) {
            string = MINUS + " " + string;
        }
        return string;
    }

    public String toWords(long l) {
        return BritishEnglish.inWords(l);
    }

    public static void main(String[] stringArray) {
        Test.test(new BritishEnglish());
    }
}

