/*
 * Decompiled with CFR 0.152.
 */
package cmp.InWords;

import cmp.InWords.AmericanEnglish;
import cmp.InWords.Test;
import cmp.InWords.ToWords;

public class AmericanOrdinals
implements ToWords {
    private static final String EmbeddedCopyright = "Copyright 1999 Roedy Green, Canadian Mind Products, http://mindprod.com";
    private static final String ZERO = "zeroth";
    private static final String MINUS = "minus";
    private static final String[] terminalLowName = new String[]{"", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "ninth", "tenth", "eleventh", "twelfth", "thirteenth", "fourteenth", "fifteenth", "sixteenth", "seventeenth", "eighteenth", "nineteenth"};
    private static final String[] combiningTys = new String[]{"", "", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
    private static final String[] terminalTys = new String[]{"", "", "twentieth", "thirtieth", "fortieth", "fiftieth", "sixtieth", "seventieth", "eightieth", "ninetieth"};
    private static final String[] combiningGroupName = new String[]{"", "hundred", "thousand", "million", "billion", "trillion", "quadrillion", "quintillion"};
    private static final String[] terminalGroupName = new String[]{"", "hundredth", "thousandth", "millionth", "billionth", "trillionth", "quadrillionth", "quintillionth"};
    private static final int[] divisor = new int[]{100, 10, 1000, 1000, 1000, 1000, 1000, 1000};

    public static String inWords(long l) {
        boolean bl;
        if (l == 0L) {
            return ZERO;
        }
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        String string = "";
        int n = 0;
        while (l > 0L) {
            int n2 = (int)(l % (long)divisor[n]);
            if (n == 1 && 1L <= (l /= (long)divisor[n]) && l <= 5L && n2 > 0) {
                n2 = (int)((long)n2 + l * 10L);
                l = 0L;
            }
            if (n2 != 0) {
                String string2;
                boolean bl3;
                boolean bl4 = n == 0;
                boolean bl5 = bl3 = string.length() == 0;
                if (bl4) {
                    if (n2 < 20) {
                        string2 = terminalLowName[n2];
                    } else if (n2 < 100) {
                        int n3 = n2 % 10;
                        int n4 = n2 / 10;
                        string2 = n3 == 0 ? terminalTys[n4] : combiningTys[n4] + "-" + terminalLowName[n3];
                    } else {
                        string2 = AmericanEnglish.inWords(n2);
                    }
                } else {
                    string2 = AmericanEnglish.inWords(n2);
                }
                string = string2 + " " + (bl3 ? terminalGroupName[n] : combiningGroupName[n]) + " " + string;
            }
            ++n;
        }
        string = string.trim();
        if (bl) {
            string = MINUS + " " + string;
        }
        return string;
    }

    public String toWords(long l) {
        return AmericanOrdinals.inWords(l);
    }

    public static void main(String[] stringArray) {
        Test.test(new AmericanOrdinals());
    }
}

