/*
 * Decompiled with CFR 0.152.
 */
package cmp.InWords;

import cmp.InWords.Test;
import cmp.InWords.ToWords;

public class AmericanEnglish
implements ToWords {
    private static final String EmbeddedCopyright = "Copyright 1999 Roedy Green, Canadian Mind Products, http://mindprod.com";
    private static final String ZERO = "zero";
    private static final String MINUS = "minus";
    private static final String[] lowName = new String[]{"", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
    private static final String[] tys = new String[]{"", "", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
    private static final String[] groupName = new String[]{"", "hundred", "thousand", "million", "billion", "trillion", "quadrillion", "quintillion"};
    private static final int[] divisor = new int[]{100, 10, 1000, 1000, 1000, 1000, 1000, 1000};

    public static String inWords(long l) {
        boolean bl;
        if (l == 0L) {
            return ZERO;
        }
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        String string = "";
        int n = 0;
        while (l > 0L) {
            int n2 = (int)(l % (long)divisor[n]);
            if (n == 1 && 1L <= (l /= (long)divisor[n]) && l <= 5L && n2 > 0) {
                n2 = (int)((long)n2 + l * 10L);
                l = 0L;
            }
            if (n2 != 0) {
                String string2;
                if (n2 < 20) {
                    string2 = lowName[n2];
                } else if (n2 < 100) {
                    int n3 = n2 % 10;
                    int n4 = n2 / 10;
                    string2 = tys[n4];
                    if (n3 != 0) {
                        string2 = string2 + "-" + lowName[n3];
                    }
                } else {
                    string2 = AmericanEnglish.inWords(n2);
                }
                string = string2 + " " + groupName[n] + " " + string;
            }
            ++n;
        }
        string = string.trim();
        if (bl) {
            string = MINUS + " " + string;
        }
        return string;
    }

    public String toWords(long l) {
        return AmericanEnglish.inWords(l);
    }

    public static void main(String[] stringArray) {
        Test.test(new AmericanEnglish());
    }
}

