/*
 * Decompiled with CFR 0.152.
 */
package cmp.Clock;

import cmp.Clock.MiniSNTP;
import cmp.Clock.PCSetClock;
import cmp.Clock.TimeInWords;
import cmp.business.Misc;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;

public class SetClock
extends Applet {
    private static final int PROBES = 4;
    private static final Color paleYellow = new Color(255, 255, 204);
    private static final Color darkkhaki = new Color(189, 183, 107);
    private static final Color darkGreen = new Color(0, 128, 0);
    private static final Color red = Color.red;
    private static final Color black = Color.black;
    private static final Color blue = Color.blue;
    private static final Color white = Color.white;
    private static final Font littleFont = new Font("Dialog", 0, 14);
    private static final Font medFont = new Font("Dialog", 1, 16);
    private static final Font bigFont = new Font("Dialog", 1, 18);
    static SimpleDateFormat flocal = new SimpleDateFormat("EEEE  yyyy/MM/dd  hh:mm:ss aa");
    static SimpleDateFormat fzone = new SimpleDateFormat("zz : zzzzzz");
    private final boolean inNetscape = true;
    Label accurateTimeLabel;
    TextField accurateTimeText;
    Label correctionLabel;
    TextField correctionText;
    Label instructionsText;
    Label pcTimeLabel;
    TextField pcTimeText;
    Button setClockButton;
    Label timeZoneLabel;
    TextField timeZoneName;
    private ClockUpdater clockUpdater;
    private GregorianCalendar accurateTime = new GregorianCalendar();
    private GregorianCalendar pcTime = new GregorianCalendar();
    private long correction;
    private Boolean recentFiddle = Boolean.FALSE;

    public void init() {
        this.setBackground(paleYellow);
        if (!Misc.isJavaVersionOK(1, 1, 0)) {
            System.out.println("You need Java 1.1.0 or later to run this Applet.");
            System.out.println("You are running under " + System.getProperty("java.version"));
            System.exit(1);
        }
        ((Component)this).setFont(medFont);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setVisible(false);
        this.setSize(676, 335);
        this.timeZoneLabel = new Label("Your Time Zone", 2);
        this.timeZoneLabel.setBounds(102, 159, 85, 24);
        this.timeZoneLabel.setForeground(darkGreen);
        this.timeZoneLabel.setFont(bigFont);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        ((GridBagLayout)this.getLayout()).setConstraints(this.timeZoneLabel, gridBagConstraints);
        this.add(this.timeZoneLabel);
        this.timeZoneName = new TextField();
        this.timeZoneName.setForeground(darkGreen);
        this.timeZoneName.setBounds(292, 159, 282, 24);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        ((GridBagLayout)this.getLayout()).setConstraints(this.timeZoneName, gridBagConstraints);
        this.add(this.timeZoneName);
        this.pcTimeLabel = new Label("Your PC's Clock", 2);
        this.pcTimeLabel.setBounds(102, 43, 160, 24);
        this.pcTimeLabel.setForeground(darkGreen);
        this.pcTimeLabel.setFont(bigFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        ((GridBagLayout)this.getLayout()).setConstraints(this.pcTimeLabel, gridBagConstraints);
        this.add(this.pcTimeLabel);
        this.pcTimeText = new TextField();
        this.pcTimeText.setForeground(darkGreen);
        this.pcTimeText.setBounds(102, 117, 160, 24);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        ((GridBagLayout)this.getLayout()).setConstraints(this.pcTimeText, gridBagConstraints);
        this.add(this.pcTimeText);
        this.correctionLabel = new Label("+ Correction", 2);
        this.correctionLabel.setBounds(292, 80, 85, 24);
        this.correctionLabel.setForeground(red);
        this.correctionLabel.setFont(bigFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        ((GridBagLayout)this.getLayout()).setConstraints(this.correctionLabel, gridBagConstraints);
        this.add(this.correctionLabel);
        this.correctionText = new TextField();
        this.correctionText.setForeground(red);
        this.correctionText.setBounds(292, 117, 85, 24);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        ((GridBagLayout)this.getLayout()).setConstraints(this.correctionText, gridBagConstraints);
        this.add(this.correctionText);
        this.accurateTimeLabel = new Label("= Accurate Clock", 2);
        this.accurateTimeLabel.setBounds(412, 40, 162, 30);
        this.accurateTimeLabel.setForeground(blue);
        this.accurateTimeLabel.setFont(bigFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        ((GridBagLayout)this.getLayout()).setConstraints(this.accurateTimeLabel, gridBagConstraints);
        this.add(this.accurateTimeLabel);
        this.accurateTimeText = new TextField();
        this.accurateTimeText.setForeground(blue);
        this.accurateTimeText.setBounds(412, 117, 162, 24);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        ((GridBagLayout)this.getLayout()).setConstraints(this.accurateTimeText, gridBagConstraints);
        this.add(this.accurateTimeText);
        this.setClockButton = new Button();
        this.setClockButton.setLabel("Set Clock");
        this.setClockButton.setBounds(289, 203, 97, 38);
        this.setClockButton.setBackground(darkkhaki);
        this.setClockButton.setForeground(blue);
        this.setClockButton.setFont(bigFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 10, 10, 20);
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        ((GridBagLayout)this.getLayout()).setConstraints(this.setClockButton, gridBagConstraints);
        this.add(this.setClockButton);
        this.instructionsText = new Label("To change your PC clock to the accurate date/time shown, click \"Set Clock\"", 1);
        this.instructionsText.setForeground(darkGreen);
        this.instructionsText.setFont(littleFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 0, 20, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.instructionsText, gridBagConstraints);
        this.add(this.instructionsText);
        SetClock setClock = this;
        if (setClock == null) {
            throw null;
        }
        TheListener theListener = setClock.new TheListener();
        this.setClockButton.addActionListener(theListener);
        this.calcTimesFromServer();
        this.refresh();
        this.validate();
        this.setVisible(true);
    }

    public void start() {
        if (this.clockUpdater == null) {
            SetClock setClock = this;
            if (setClock == null) {
                throw null;
            }
            this.clockUpdater = setClock.new ClockUpdater();
            this.clockUpdater.start();
        }
    }

    public void stop() {
        if (this.clockUpdater != null && this.clockUpdater.isAlive()) {
            this.clockUpdater.stop();
        }
        this.clockUpdater = null;
    }

    void displayPCTime() {
        flocal.setTimeZone(TimeZone.getDefault());
        String string = flocal.format(this.pcTime.getTime()).intern();
        if (!string.equals(this.pcTimeText.getText())) {
            ((TextComponent)this.pcTimeText).setText(string);
        }
    }

    void displayAccurateTime() {
        flocal.setTimeZone(TimeZone.getDefault());
        String string = flocal.format(this.accurateTime.getTime()).intern();
        if (!string.equals(this.accurateTimeText.getText())) {
            ((TextComponent)this.accurateTimeText).setText(string);
        }
    }

    void displayCorrection() {
        if (this.correction < 0L) {
            this.correctionLabel.setText("- Correction");
            ((TextComponent)this.correctionText).setText(TimeInWords.inWords(-this.correction));
        } else {
            this.correctionLabel.setText("+ Correction");
            ((TextComponent)this.correctionText).setText(TimeInWords.inWords(this.correction));
        }
    }

    void displayTimeZone() {
        fzone.setTimeZone(TimeZone.getDefault());
        long l = this.pcTime.get(15) + this.pcTime.get(16);
        int n = (int)(l / 60000L);
        ((TextComponent)this.timeZoneName).setText(fzone.format(this.pcTime.getTime()) + " (GMT" + this.hhmm(n) + ")");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void calcTimesFromServer() {
        try {
            PrivilegeManager.enablePrivilege((String)"UniversalConnect");
            PrivilegeManager.enablePrivilege((String)"UniversalListen");
            Boolean bl = this.recentFiddle;
            synchronized (bl) {
                this.recentFiddle = Boolean.TRUE;
                long l = 0L;
                int n = 0;
                while (true) {
                    if (n >= 4) {
                        this.correction = (l + 2L) / 4L;
                        this.calcTimesFromPC();
                        return;
                    }
                    l += MiniSNTP.correction();
                    ++n;
                }
            }
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            this.instructionsText.setText("Cannot continue without permission to access the remote web clock");
        }
    }

    void calcTimesFromPC() {
        this.pcTime = new GregorianCalendar();
        Date date = this.pcTime.getTime();
        date.setTime(date.getTime() + this.correction);
        this.accurateTime.setTime(date);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void synch() {
        System.out.println("here0");
        try {
            PrivilegeManager.enablePrivilege((String)"UniversalLinkAccess");
            PCSetClock pCSetClock = new PCSetClock();
            if (pCSetClock == null) {
                System.out.println("platform null");
            }
            if (this.recentFiddle == null) {
                System.out.println("recentFiddle null");
            }
            System.out.println("here1");
            Boolean bl = this.recentFiddle;
            synchronized (bl) {
                this.recentFiddle = Boolean.TRUE;
                System.out.println("here2");
                this.calcTimesFromPC();
                System.out.println("here3");
                pCSetClock.setClock(this.accurateTime.getTime());
                System.out.println("here4");
                this.correction = 0L;
                this.calcTimesFromPC();
                return;
            }
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            this.instructionsText.setText("Cannot continue without permission to use native code to set the system clock.");
        }
    }

    void refresh() {
        this.displayAccurateTime();
        this.displayPCTime();
        this.displayCorrection();
        this.correctionText.invalidate();
        this.displayTimeZone();
        this.timeZoneName.invalidate();
        if (this.correction == 0L) {
            this.setClockButton.setEnabled(false);
            this.instructionsText.setText("Your PC clock is now set accurately.");
        } else {
            this.setClockButton.setEnabled(true);
            this.instructionsText.setText("To change your PC clock to the accurate date/time shown, click \"Set Clock\"");
        }
        this.instructionsText.invalidate();
        this.validate();
        this.repaint();
    }

    String hhmm(int n) {
        boolean bl;
        if (n == 0) {
            return "+0";
        }
        boolean bl2 = bl = n < 0;
        if (bl) {
            n = -n;
        }
        char c = (char)(n % 10 + 48);
        char c2 = (char)((n /= 10) % 6 + 48);
        char c3 = (char)((n /= 6) % 10 + 48);
        char c4 = (char)((n /= 10) % 10 + 48);
        StringBuffer stringBuffer = new StringBuffer(5);
        stringBuffer.append(bl ? (char)'-' : '+');
        stringBuffer.append(c4);
        stringBuffer.append(c3);
        stringBuffer.append(':');
        stringBuffer.append(c2);
        stringBuffer.append(c);
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        SetClock setClock = new SetClock();
        Frame frame = new Frame("Set Clock");
        ((Component)frame).setSize(640, 360);
        setClock.init();
        frame.add(setClock);
        frame.validate();
        ((Component)frame).setVisible(true);
        setClock.start();
        frame.addWindowListener(new WindowAdapter(setClock){
            private final /* synthetic */ SetClock val$applet;

            public final void windowClosing(WindowEvent windowEvent) {
                this.val$applet.stop();
                this.val$applet.destroy();
                System.exit(0);
            }
            {
                this.val$applet = setClock;
                this.constructor$0();
            }

            public void constructor$0() {
            }
        });
    }

    /* synthetic */ GregorianCalendar access$0() {
        return this.pcTime;
    }

    /* synthetic */ Boolean access$1() {
        return this.recentFiddle;
    }

    /* synthetic */ void access$2(Boolean bl) {
        this.recentFiddle = bl;
    }

    class ClockUpdater
    extends Thread {
        public void run() {
            while (true) {
                SetClock.this.calcTimesFromPC();
                long l = SetClock.this.access$0().getTime().getTime();
                long l2 = SetClock.this.access$0().get(15) + SetClock.this.access$0().get(16);
                while (true) {
                    SetClock.this.displayPCTime();
                    SetClock.this.displayAccurateTime();
                    Boolean bl = SetClock.this.access$1();
                    synchronized (bl) {
                        long l3;
                        long l4;
                        block8: {
                            block9: {
                                block7: {
                                    SetClock.this.calcTimesFromPC();
                                    l4 = SetClock.this.access$0().getTime().getTime();
                                    l3 = SetClock.this.access$0().get(15) + SetClock.this.access$0().get(16);
                                    if (!SetClock.this.access$1().booleanValue()) break block7;
                                    SetClock.this.access$2(Boolean.FALSE);
                                    break block8;
                                }
                                if (l3 != l2 || l4 < l) break block9;
                                if (l4 <= l + 500L) break block8;
                            }
                            Object var6_4 = null;
                            break;
                        }
                        l = l4;
                        l2 = l3;
                    }
                }
                SetClock.this.calcTimesFromServer();
                SetClock.this.refresh();
            }
        }

        ClockUpdater() {
        }
    }

    class TheListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SetClock.this.setClockButton) {
                SetClock.this.synch();
                SetClock.this.refresh();
            }
        }

        TheListener() {
        }
    }
}

