/*
 * Decompiled with CFR 0.152.
 */
package cmp.Clock;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class MiniSNTP {
    private static boolean debugging = true;
    private static final int datagramLength = 48;
    static final int remotePort = 123;
    private static final long secsBetween1900and1970 = 2208988800L;
    InetAddress remoteIP;
    private DatagramSocket socket;
    private byte leapIndicator;
    private byte versionNumber;
    private byte mode;
    private byte stratum;
    private byte pollInterval;
    private byte precision;
    private int rootDelay;
    private int rootDispersion;
    private int referenceID;
    private long referenceTimestamp;
    private long originateTimestamp;
    private long receiveTimestamp;
    private long transmitTimestamp;
    private long destinationTimestamp;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long correction() {
        try {
            boolean bl;
            MiniSNTP miniSNTP = new MiniSNTP("ntp.belnet.be");
            miniSNTP.requestTimeFromServer();
            miniSNTP.receiveTimeFromServer();
            miniSNTP.close();
            long l = (miniSNTP.receiveTimestamp - miniSNTP.originateTimestamp + (miniSNTP.transmitTimestamp - miniSNTP.destinationTimestamp)) / 2L;
            if (l < 0L) {
                l = -l;
                bl = true;
            } else {
                bl = false;
            }
            long l2 = l >>> 32;
            int n = (int)l;
            int n2 = (int)((long)n * 1000L + 0x80000000L >>> 32);
            long l3 = l2 * 1000L + (long)n2;
            if (!bl) return l3;
            return -l3;
        }
        catch (IOException iOException) {
            return Long.MAX_VALUE;
        }
    }

    protected void close() {
        this.socket.close();
    }

    protected void receiveTimeFromServer() throws IOException {
        byte[] byArray = new byte[60];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        this.socket.receive(datagramPacket);
        this.destinationTimestamp = MiniSNTP.javaToSNTPTimestamp(System.currentTimeMillis());
        if (!datagramPacket.getAddress().equals(this.remoteIP) || datagramPacket.getPort() != 123) {
            throw new IOException("datagram received from unauthorised ip");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        byte by = dataInputStream.readByte();
        this.leapIndicator = (byte)(by >>> 6 & 3);
        this.versionNumber = (byte)(by >>> 3 & 7);
        this.mode = (byte)(by & 7);
        this.stratum = (byte)dataInputStream.readUnsignedByte();
        this.pollInterval = dataInputStream.readByte();
        this.precision = dataInputStream.readByte();
        this.rootDelay = dataInputStream.readInt();
        this.rootDispersion = dataInputStream.readInt();
        this.referenceID = dataInputStream.readInt();
        this.referenceTimestamp = dataInputStream.readLong();
        dataInputStream.skip(8L);
        this.receiveTimestamp = dataInputStream.readLong();
        this.transmitTimestamp = dataInputStream.readLong();
        dataInputStream.close();
    }

    protected void requestTimeFromServer() throws IOException {
        this.leapIndicator = 0;
        this.versionNumber = (byte)3;
        this.mode = (byte)3;
        this.stratum = 0;
        this.pollInterval = (byte)6;
        this.precision = (byte)-10;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(48);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        byte by = (byte)(this.leapIndicator << 6 | this.versionNumber << 3 | this.mode);
        dataOutputStream.writeByte(by);
        dataOutputStream.writeByte(this.stratum);
        dataOutputStream.writeByte(this.pollInterval);
        dataOutputStream.writeByte(this.precision);
        dataOutputStream.writeInt(this.rootDelay);
        dataOutputStream.writeInt(this.rootDispersion);
        dataOutputStream.writeInt(this.referenceID);
        dataOutputStream.writeLong(this.referenceTimestamp);
        this.originateTimestamp = MiniSNTP.javaToSNTPTimestamp(System.currentTimeMillis());
        dataOutputStream.writeLong(this.originateTimestamp);
        dataOutputStream.writeLong(this.receiveTimestamp);
        dataOutputStream.writeLong(this.transmitTimestamp);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        datagramPacket.setAddress(this.remoteIP);
        datagramPacket.setPort(123);
        this.socket.send(datagramPacket);
        dataOutputStream.close();
    }

    protected void dump() {
        if (debugging) {
            System.out.println("leap: " + this.leapIndicator);
            System.out.println("version: " + this.versionNumber);
            System.out.println("mode: " + this.mode);
            System.out.println("stratum: " + this.stratum);
            System.out.println("poll: " + this.pollInterval);
            System.out.println("precision: " + this.precision);
            System.out.println("delay: " + this.rootDelay);
            System.out.println("dispersion: " + this.rootDispersion);
            System.out.println("refID:" + this.referenceID);
            System.out.println("ref ts:      " + this.referenceTimestamp + " " + MiniSNTP.sntpToJavaTimestamp(this.referenceTimestamp));
            System.out.println("orig ts:     " + this.originateTimestamp + " " + MiniSNTP.sntpToJavaTimestamp(this.originateTimestamp));
            System.out.println("receive ts : " + this.receiveTimestamp + " " + MiniSNTP.sntpToJavaTimestamp(this.receiveTimestamp));
            System.out.println("transmit ts: " + this.transmitTimestamp + " " + MiniSNTP.sntpToJavaTimestamp(this.transmitTimestamp));
            System.out.println("dest ts:     " + this.destinationTimestamp + " " + MiniSNTP.sntpToJavaTimestamp(this.destinationTimestamp));
        }
    }

    protected static long javaToSNTPTimestamp(long l) {
        long l2 = l / 1000L + 2208988800L;
        int n = (int)(l % 1000L);
        int n2 = (int)(0x100000000L * (long)n / 1000L);
        return l2 << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    protected static long sntpToJavaTimestamp(long l) {
        long l2 = (l >>> 32) - 2208988800L;
        int n = (int)l;
        int n2 = (int)((long)n * 1000L + 0x80000000L >>> 32);
        return l2 * 1000L + (long)n2;
    }

    public static void main(String[] stringArray) {
        if (debugging) {
            System.out.println();
            System.out.println(MiniSNTP.correction());
            System.out.println();
        }
    }

    private MiniSNTP(String string) throws SocketException, UnknownHostException {
        this.remoteIP = InetAddress.getByName(string);
        this.socket = new DatagramSocket();
        this.socket.setSoTimeout(10000);
    }
}

