unit MainForm;

{
Revision history:

V0.1.0  1998 Nov 12  First experimental version
V0.1.2  1998 Nov 14  Add version info and ReadMe.txt, update components
                     Add level meter labels
                     Increase buffer size to reduce display rate
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, InputMixer, WaveCommon, AudioAnalyser, Displays, LED, MMSystem, Math,
  ExtCtrls, VersInfo;

type
  TFormMain = class(TForm)
    ButtonClose: TButton;
    BasicAudioAnalyser1: TBasicAudioAnalyser;
    ButtonRun: TButton;
    LevelMeter1: TLevelMeter;
    VectorScope1: TVectorScope;
    GroupBoxAGC: TGroupBox;
    RadioGroupAGCMaxGain: TRadioGroup;
    RadioGroupAGCDecay: TRadioGroup;
    VersionInfoResource1: TVersionInfoResource;
    Timer1: TTimer;
    LEDrun: TLED;
    procedure ButtonCloseClick(Sender: TObject);
    procedure ButtonRunClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BasicAudioAnalyser1Open(Sender: TObject);
    procedure BasicAudioAnalyser1Close(Sender: TObject);
    procedure BasicAudioAnalyser1Data(Header: PWaveHdr);
    procedure FormResize(Sender: TObject);
    procedure RadioGroupAGCMaxGainClick(Sender: TObject);
    procedure RadioGroupAGCDecayClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
    running: boolean;
    left_offset: integer;
    right_offset: integer;
    total_samples: integer;
  public
    { Public declarations }
  end;

var
  FormMain: TFormMain;

implementation

{$R *.DFM}
{$R LED.dcr}

procedure TFormMain.FormCreate(Sender: TObject);
begin
  running := False;
  left_offset := 0;
  right_offset := 0;
  total_samples := 0;
  Caption := 'VectorScope - V' +
             VersionInfoResource1.FileVersion.AsString + ' from gm8arv';
  Application.Title := Caption;
  LevelMeter1.ShowLabels;
end;


procedure TFormMain.ButtonCloseClick(Sender: TObject);
begin
  Close;
end;                                     


procedure TFormMain.ButtonRunClick(Sender: TObject);
begin
  if not running
  then
    begin
    BasicAudioAnalyser1.Enabled := True;
    running := True;
    end
  else
    begin
    running := False;
    BasicAudioAnalyser1.Enabled := False;
    end;
end;

procedure TFormMain.BasicAudioAnalyser1Open(Sender: TObject);
begin
  ButtonRun.Caption := '&Stop';
  LEDrun.Colour := clLime;
end;

procedure TFormMain.BasicAudioAnalyser1Close(Sender: TObject);
begin
  ButtonRun.Caption := '&Start';
  LEDrun.Colour := clGreen;
end;


procedure TFormMain.BasicAudioAnalyser1Data(Header: PWaveHdr);
// This routine computes an average offset and feeds it back to
// make the long-term mean offset zero.
var
  samples: integer;
  signal: PAudioSample;
  left, right: integer;
  sample: integer;
  smooth: integer;
begin
  // Extract the number of samples from the wave header
  samples := Header^.dwBytesRecorded div SizeOf (TStereoPair);
  Inc (total_samples, samples);
  // and point to the buffer in its actual format
  signal := PAudioSample (Header^.lpData);
  left := 0;
  right := 0;
  for sample := 0 to samples - 1 do
    begin
    left := left + signal^;
    Inc (signal);
    right := right + signal^;
    Inc (signal);
    end;
  left := left div samples;
  right := right div samples;
  if total_samples < 44100
  then smooth := 1
  else if total_samples < 441000
       then smooth := 4
       else smooth := 16;
  left_offset := left_offset + left div smooth;
  right_offset := right_offset + right div smooth;
  BasicAudioAnalyser1.LeftOffset := left_offset;
  BasicAudioAnalyser1.RightOffset := right_offset;
end;

procedure TFormMain.FormResize(Sender: TObject);
var
  _width, _height: integer;
  _left, _right: integer;
  radius: integer;
begin
  _right := ButtonRun.Left - 16;
  _left := VectorScope1.Left;
  _width := _right - _left;
  _height := (ClientHeight - 16) - VectorScope1.Top;
  radius := Min (_width , _height);
  with VectorScope1 do
    begin
    Height := radius;
    Width := radius;
    end;
  LevelMeter1.ShowLabels;
  LevelMeter1.Left := ButtonClose.Left + (ButtonClose.Width - LevelMeter1.Width) div 2;
end;

procedure TFormMain.RadioGroupAGCMaxGainClick(Sender: TObject);
var
  gain: integer;
begin
  case RadioGroupAGCMaxGain.ItemIndex of
    0: gain := 3;
    1: gain := 10;
    2: gain := 30;
    3: gain := 100;
    4: gain := 300;
    5: gain := 1000;
  else
    gain := 10;
  end;
  VectorScope1.AGCMaxGain := gain;
end;

procedure TFormMain.RadioGroupAGCDecayClick(Sender: TObject);
var
  decay: integer;
begin
  case RadioGroupAGCDecay.ItemIndex of
    0: decay := 50;
    1: decay := 10;
    2: decay := 2;
  else
    decay := 10;
  end;
  VectorScope1.AGCDecayPercent := decay;
end;

procedure TFormMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  BasicAudioAnalyser1.Enabled := False;
end;

procedure TFormMain.Timer1Timer(Sender: TObject);
begin
  Timer1.Enabled := False;
  ButtonRun.Click;
end;

end.

