{$IFDEF DPMI}
{$M 48000}
{$ENDIF}
{
  Copyright (c) 1998 Erland Van Olmen (erlandvo@hotmail.com)
  Protected Mode Ready
  WARNING: Protected Mode version only supports GUS!

  Bugfixes/changes/additions since version 1.0 (first public release):

      - Added custom control break handler, control break should exit
        the program properly now.
      - Channels 1 - 8 can now be muted by pressing '1' .. '8' respectively
      - Press 'i' to toggle Interpolation on SoundBlaster
      - Included "-D" command-line option (Shell to DOS) for the DPMI
        (protected Mode) version.
}
Uses
  Shitty1,  { for the MIDAS-alike SETUP system                               }
  Crt,      { for some screen output                                         }
  Dos,      { for Control-Break Handler                                      }
  Replay,   { get the MOD replay routines                                    }
  MODType1, { Information about the MODFormat                                }
  ModLoad,  { the MOD loader                                                 }
  GUS_DRV1, { Choose the GUS & SB drivers among the 36 drivers available ;-) }
  SB_DRV1;

Label ShutDown;

CONST
  NoteStrings: Array[0..60] of String[3] = ('',
     'C0','C#0','D0','D#0','E0','F0','F#0','G0','G#0','A0','A#0','B0',
     'C1','C#1','D1','D#1','E1','F1','F#1','G1','G#1','A1','A#1','B1',
     'C2','C#2','D2','D#2','E2','F2','F#2','G2','G#2','A2','A#2','B2',
     'C3','C#3','D3','D#3','E3','F3','F#3','G3','G#3','A3','A#3','B3',
     'C4','C#4','D4','D#4','E4','F4','F#4','G4','G#4','A4','A#4','B4');

{Error constants: -----------------------------------------------------------}
  NoArguments        = 0; { No command line options at all specified         }
  UnKnownOption      = 1; { Specified option does not exist                  }
  NoModule           = 2; { The module to be replayed is not specified       }
  WrongVolume        = 3; { The specified master volume has an invalid range }
  WrongVBoost        = 4; { The SB volume boost isn't specified as it should }
  WrongMixRate       = 5; { The specified mixrate has an invalid range       }
  WrongStartTrack    = 6; { The specified track to start at is invalid       }
  WrongFastDOverride = 7; { The soundcard/Base port specified does not exist }
  WrongGlobalPanning = 8; { The specified global panning has an invalid range}
  WrongNReduction    = 9; { The specified Noisereduction is invalid          }
  ToManyFilesToLoad  = 10;{ More than one .MOD file specified                }
  WrongAmplify       = 11;{ Wrong amplification specification                }
  NO_DPMI            = 12;{ This option only works in the Protected Mode ver.}

  OverrideDetection: Boolean = False;
  Amplifyspecified : Boolean = False;
  UseInterpolation : Boolean = True;
{$IFDEF DPMI}
  ShellMode        : Boolean = False;
{$ENDIF}
VAR
  Limit,
  Chn,
  GlobalPanning  : Byte;
  Wait           : Char;
  ModFileName    : String;
  OldBreakHandler: Procedure;

{}

Function DetectDevice: Boolean;
VAR
  Res1, Res2: Boolean;
BEGIN
  If GUS_DRV1.GUSDevice.SWDetected then PlayDevice:=GUS_DRV1.GUSDevice Else
  If SB_DRV1.SBDevice.SWDetected   then PlayDevice:=SB_DRV1.SBDevice   Else
  Begin
    PLAYDevice.ID:=NoDevice;
    PLAYDevice.SWDetected:=False;
  End;

  If OverrideDetection then
  Begin
    GiveDeviceInfo;
    If PLAYDevice.ID=NoDevice then Begin DetectDevice:=False; exit; End
    Else                           Begin DetectDevice:=True;  exit; End;
  End;

{Perform HardWare Detection: ------------------------------------------------
  Res1:=False; Res2:=False;
  Res1:=GUS_DRV1.HW_Detect;
  if Res1 then PLAYDevice:=GUSDevice;
  if Res2 then
  Else
   Begin
     Res2:=False;
     Res1:=SB_DRV1.HW_Detect;
     if Res1 then Res2:=SB_DRV1.HW_Check;
     if Res2 then PLAYDevice.ID:=SB100Device
     Else PLAYDevice.ID:=NODevice;
   End;
}
  PLAYDevice.SWDetected:=PLAYDevice.ID <> NoDevice;
  PLAYDevice.HWDetected:=PLAYDevice.SWDetected;
  DetectDevice:=PLAYDevice.SWDetected;
END;

{}
{}

Procedure ResetTMode;
BEGIN
  TextMode(CO80+Font8x8);
  TextColor(LightGray); TextBackGround(Black); Window(0, 0, 79, 49); ClrScr;
  GotoXY(0, 0);
END;

{}

Procedure SetExitScreen;
BEGIN
  ResetTMode;
  WriteLn('MOD Player v1.0 by BYTERAVER/TNT (The Next Temptation). (c) February 1998');
  WriteLn('Found bugs/want some more info? Read MPxx.DOC.');
  WriteLn('Have fun! Bye.');
  WriteLn;
  WriteLn('Feel free to contact me for any reason at erlandvo@hotmail.com.');
  WriteLn('I will be pleased to help you!');
END;

{}

Procedure WrongArgs(error: Byte);
BEGIN
  ResetTMode;
  WriteLn('');
  If Error = NoArguments then
    Begin
      WriteLn('Usage: MPxx  [OPTIONS]  <MUSICF.MOD>  [OPTIONS]');
      WriteLn('Where OPTIONS can be: ');
      WriteLn('');
      WriteLn('(*) -Mxx : Mixing Rate (in kHz). Valid values are: 8/9/10../42/43/44kHz.');
{      WriteLn('    -Txxx: Track to start at (in patterntable): 1..128');}
      WriteLn('    -Vxxx: Master Volume in % (Range: 1..100)');
      WriteLn('(*) -Fx  : Use filter. 1: SBPRO HW Filter, 2: Interpolation (default = none)');
      WriteLn('(*) -Axxx: Amplify. Min = 8 (divide by 2), Max = 127 (multiply by 8).');
      WriteLn('    -O   : Override SoundCard detection (default =  AutoDetect Device). ');
      WriteLn('    -B   : VBlank timing; use this for old MOD''s that play at the wrong speed.');
      WriteLn('(@) -Pxx : Set global panning. Same as in Cubic Player. Range: 0..15');
{      WriteLn('(@) -I   : Inverse Channels (inverse stereo).');}
{$IFDEF DPMI}
      WriteLn('    -D   : Shell to DOS. Only for the Protected Mode Version.');
{$ENDIF}
      WriteLn('');
      WriteLn('(*)  = Only affects SoundBlaster & compatible cards');
      WriteLn('(@)  = Only affects stereo soundcards');
      WriteLn('You MUST separate the options by a space & "-"');
      WriteLn;
      WriteLn('Feel free to contact me for any reason at erlandvo@hotmail.com.');
      WriteLn('I will be pleased to help you!');
    End
  Else
    Begin
      Case error of
        UnKnownOption     : WriteLn('One of the options you specified don''t exist.');
        NoModule          : WriteLn('You forgot to specify a .MOD File to load.');
        WrongVolume       : WriteLn('The master volume you specified couldn''t be interpreted or it''s range is'+
                                            '        invalid.');
        WrongVBoost       : WriteLn('You must use "mp xx.mod -Vxx -v100" for correct `volume boost''');
        WrongMixRate      : WriteLn('The mixrate you specified couldn''t be interpreted or it''s range is invalid.');
        WrongStartTrack   : begin
                              WriteLn('The track to start at you specified couldn''t be interpreted or it''s range is ');
                              WriteLn('invalid.');
                            end;
        WrongFastDOverride: WriteLn('The soundcard/BasePort you specified couldn''t be interpreted or it''s range is'+
                                            '   invalid.');
        WrongGlobalPanning: WriteLn('The global panning you specified couldn''t be interpreted or it''s range is'+
                                            '       invalid.');
        ToManyFilesToLoad : begin
                              WriteLn('It seems you are trying to load TWO MOD''s at once!');
                              WriteLn('Remember to put a ''/'' or ''-'' before each option!');
                            end;
        WrongAmplify      : WriteLn('The Amplify you specified couldn''t be interpreted or it''s range is invalid.');
        NO_DPMI           : WriteLn('You need the Protected Mode (DPMI) version of the player for this option 2 work.');
        else; WriteLn('Internal Error! Contact the author!');
      end;
    End;
  Halt;
END;

{}
{}

Procedure GetOptions;
VAR
   I, I2: Byte;
   Code, Mix, temp: Integer;
   Str2: String;
   Options: Array[1..32] of String;
   FileSpecified, GlobalVSpecified: Boolean;
BEGIN
  Filter:=Interpolative;
  FileSpecified:=False;
  GlobalVSpecified:=False;
  If (Paramcount<1) then WrongArgs(NoArguments);

  For I:=1 to Paramcount do
  BEGIN
    Options[I]:=ParamStr(I);
    If (Options[I][1]='/') or (Options[I][1]='-') then
    begin
      Case Upcase(Options[I][2]) Of
        '?', 'H': WrongArgs(NoArguments);
{        'I': InverseChannels:=True;}
        'O': OverrideDetection:=True;
        'B': Timing.VBlank:=True;
        'D':
{$IFDEF DPMI}
               ShellMode:=True;
{$ELSE}
               WrongArgs(NO_DPMI);
{$ENDIF}
        'F': Begin
               Case Options[I][3] of
                 '1': Begin Filter:=SBPROHW; UseInterpolation:=False; End;
                 '2': Filter:=Interpolative;
                 else; Begin Filter:=NoFilter; UseInterpolation:=False; End;
               End;
             End;
        'V': begin
               If not GlobalVSpecified then
                 Begin
                   GlobalVSpecified:=True;
                   Str2:='';
                   for I2:=1 to Length(Options[I])-2 do Str2:=Str2+Options[I][I2+2];
                   val(Str2, GlobalVolume, code);
                   If (GlobalVolume>100) or (GlobalVolume<1) or (code<>0) then WrongArgs(WrongVolume);
                 end
               Else
{secret}         Begin
                   Str2:='';
                   for I2:=1 to Length(Options[I])-2 do Str2:=Str2+Options[I][I2+2];
                   val(Str2, temp, code);
                   If (temp=100) then SBVolumeBoost:=True
                   Else WrongArgs(WrongVBoost);
                 end
             end;
{
        'T': begin
               Str2:='';
               for I2:=1 to Length(Options[I])-2 do Str2:=Str2+Options[I][I2+2];
               val(Str2, StartTrack, code);
               If (code<>0) or (StartTrack>128) or (StartTrack<1) then WrongArgs(WrongStartTrack);
               Dec(StartTrack);
             end;
}
        'A': begin
               Str2:='';
               for I2:=1 to Length(Options[I])-2 do Str2:=Str2+Options[I][I2+2];
               val(Str2, Amplify, code);
               If (code<>0) or (Amplify<8) or (Amplify>127) then WrongArgs(WrongAmplify);
               Amplifyspecified:=True;
             end;
        'M': begin
               Str2:='';
               for I2:=1 to Length(Options[I])-2 do Str2:=Str2+Options[I][I2+2];
               val(Str2, Mix, code);
               If (code<>0) or (Mix>44) or (Mix<8) then WrongArgs(WrongMixRate);

               Case Mix Of
                 12: MixRate:=11905;
                 14: MixRate:=13889;
                 16: MixRate:=15873;
                 18: MixRate:=17857;
                 22: MixRate:=21739;
                 24: MixRate:=23810;
                 26: MixRate:=25641;
                 28: MixRate:=27778;
                 32: MixRate:=32258;
                 36: MixRate:=35714;
                 40: MixRate:=40000;
                 44: MixRate:=45454;
                 else MixRate:=Word(Mix)*1000;
               end;
             end;
        'P': begin
               Str2:='';
               for I2:=1 to Length(Options[I])-2 do Str2:=Str2+Options[I][I2+2];
               val(str2, GlobalPanning, code);
               if (code<>0) or (GlobalPanning>15) then WrongArgs(WrongGlobalPanning);
               GlobalPanning:=GlobalPanning*$10;
             end;
        Else WrongArgs(UnKnownOption);
      end;
    End
    Else Begin
           If FileSpecified then WrongArgs(ToManyFilesToLoad); {file already specified?}
           ModFileName:=Options[I];
           FileSpecified:=True;
         End;
  END;
  If Not FileSpecified then WrongArgs(NoModule);
  If MixRate<=23000 then StereoReplay:=True;        {Temporary, For SB PRO...}
END;

{}

Function I2HStr(IntVal: LongInt; ChRet: Byte): String;
CONST
     HexStr: array[0..15] of Char = '0123456789ABCDEF';
VAR
   I: Byte;
   Dummy: String;
BEGIN
  For I:=0 to 7 do Dummy[ChRet-I]:=HexStr[(Byte(IntVal SHR (I SHL 2)) AND $0F)];
  Dummy[0]:=Chr(CHRet);
 I2HStr:=Dummy;
END;

{}

{$F+}
Procedure BreakHandler; Interrupt;
BEGIN
  ResetTMode;
  If Playing then With PlayDevice do Begin StopReplay; CloseCard; End;
  SetIntVec($1B, @OldBreakHandler);
  OldBreakHandler; {call old control break handler}
  Halt;
END;
{$F-}

{}
{}

VAR
  I           : Byte;
  SB_Detected,
  GUS_Detected: Boolean;
  Ans         : Char;

Begin
  GetIntVec($1B, @OldBreakHandler);   { Install Custom control-break Handler }
  SetIntVec($1B, @BreakHandler);

  TextColor(LightGray); TextBackGround(Black); TextMode(CO80+Font8x8); ClrScr;
  GetOptions;
  If not DetectDevice Then
  Begin
    TextColor(LightGray); TextBackGround(Black); TextMode(CO80+Font8x8); ClrScr;
    WriteLn('You need a GUS, SB or compatible soundcard to run this program.');
    Halt;
  End;
  TextColor(LightGray); TextBackGround(Black); TextMode(CO80+Font8x8); ClrScr;
  If (PLAYDevice.OpenCard(4)<>1) then
    Begin Writeln('Sound Card initialisation failure... Exiting!'); Halt; End;

  I:=LoadMod(ModFileName);
  If I<>NoError then Begin WriteLn(ErrStr(I)); Halt; End;

  If not Amplifyspecified then
    If      MODInfo.NrChannels>=16 then Amplify:=16+MODInfo.NrChannels*2
    Else If MODInfo.NrChannels>=4  then Amplify:=14+MODInfo.NrChannels*2
         Else                           Amplify:=16+MODInfo.NrChannels;
{  If Amplify>127 then Amplify:=127;}
  PLAYDevice.OpenCard(ModInfo.NrChannels);

  TextColor(LIGHTGRAY);
  Writeln('Song Title    : "', ModInfo.SongTitle, '"');
  Writeln('Mod File Name : "', ModInfo.ModFileName, '"');
  Writeln('Nr of channels: ' , ModInfo.NrChannels);
  Writeln('Nr of samples : ' , ModInfo.NrSamples );
  Writeln('Max Samples   : ' , ModInfo.MaxSamples);
  Writeln('Nr of patterns: ' , ModInfo.NrPatterns);
  Writeln('CustomRepeat  : ' , ModInfo.CustomRepeat);
  Writeln('Song Length   : ' , ModInfo.SongLength);
  Writeln('Loop Position : ' , ModInfo.RestartPosition);
  Writeln('Module Tag    : "', ModInfo.Tag, '"');
{ Do not uncomment; works only w/ GUS
  With PlayDevice do
  Begin
    VSetPanning(1, 128); VSetVolume(1, 64); VSetFrequency(1, 8363*2);
  End;
  For I:=1 to ModInfo.MaxSamples do
  If ModInfo.Samples[I].Length>2 then
    Begin
      Write  ('Smp ', I:2);
      Write  (': Len '   , ModInfo.Samples[I].Length      :5);
      Write  ('; RepOfs ', ModInfo.Samples[I].RepeatOffset:5);
      Write  ('; RepLen ', ModInfo.Samples[I].RepeatLength:5);
      Write  ('; Fn '    , ModInfo.Samples[I].FineTune    :2);
      WriteLn(' "'       , ModInfo.Samples[I].Name, '"');
      PlayDevice.VPlay(1, I, 0);
      ReadKey;
    End
  Else
    Begin
      PlayDevice.VSetMode(0, 3);
      WriteLn('Smp ', I:2, ' is not used', '"':36, ModInfo.Samples[I].Name, '"');
    End;
  With PlayDevice do
          Begin VSetPanning(1, 7); VSetVolume(1, 0); VSetFrequency(1, 0); End;
}
  With PlayDevice do
  Begin
    Writeln('Hit any key to start replay...'); ReadKey;
    StartReplay;
{$IFDEF DPMI}
    If ShellMode Then
    Begin
      ResetTMode; WriteLn('Type "exit", <ENTER> to get back to MP.'); WriteLn;
      Exec(GetEnv('COMSPEC'), '');
      If DosError = 0 Then goto ShutDown;
      WriteLn('Couldn''t shell to OS for some reason, sorry. DosError = ', DosError, '.');
    End;
{$ENDIF}
    Writeln('Playing: hit ESC to stop.');
    Wait:='?'; Globalpanning:=$40;
    If ModInfo.NrChannels<=8 then Limit:=ModInfo.NrChannels
    Else                          Limit:=8;
    Repeat
      If KeyPressed then
      Begin
        Wait:=UpCase(ReadKey);
        Case Wait of
          '1': Channels[1].Muted:=NOT Channels[1].Muted;
          '2': Channels[2].Muted:=NOT Channels[2].Muted;
          '3': Channels[3].Muted:=NOT Channels[3].Muted;
          '4': Channels[4].Muted:=NOT Channels[4].Muted;
          '5': Channels[5].Muted:=NOT Channels[5].Muted;
          '6': Channels[6].Muted:=NOT Channels[6].Muted;
          '7': Channels[7].Muted:=NOT Channels[7].Muted;
          '8': Channels[8].Muted:=NOT Channels[8].Muted;
          '/': If Globalpanning<255-15 then Inc(Globalpanning, 16)
               Else Globalpanning:=255;
          '*': If Globalpanning>15     then Dec(Globalpanning, 16)
               Else Globalpanning:=0;
          'I': Begin
                 UseInterpolation:=NOT UseInterpolation;
                 SetInterPolation(UseInterpolation);
               End;
        End;
        SetGlobalPanning(Globalpanning);
      End;

      If WaitState then
      Begin
        WaitState:=False;
        TextBackGround(Black); Writeln;
        If PatternInfo.line=0 then TextBackGround(Magenta) Else TextBackGround(Black);
        TextColor(LightRed); Write(I2HStr(PatternInfo.line , 2));
        TextColor(LightGray);
        Write(I2HStr(PatternInfo.Track, 2)+'/'); Write(I2HStr(ModInfo.SongLength-1, 2));
        For chn:=1 to Limit do
          With PatternInfo.ActLine[Chn] do
          Begin
            If Channels[Chn].Muted Then TextBackground(Red)
            Else If PatternInfo.line=0 then TextBackGround(Magenta)
                    Else TextBackGround(Black);
            TextColor(LightGray); Write('');
            If Note<>0 then Begin TextColor(White); Write(NoteStrings[Note]); End
            Else Write(''); TextColor(LightGray);

            If sample<>0 then Begin TextColor(LightBlue); Write(I2HStr(sample, 2)); End
            Else Write(''); TextColor(LightGray);

            If not ((effect=0) and (effectarg=0)) then
              Begin
                TextColor(Cyan);
                If effect>=$E0 then
                  Begin Write(I2HStr(effect, 2)); Write(I2HStr(effectArg, 1)); End
                Else
                  Begin Write(I2HStr(effect, 1)); Write(I2HStr(effectArg, 2)); End;
              End
            Else Write('');
          End;
      End;
    Until Wait=chr(27);
ShutDown:
    StopReplay;
    CloseCard;
  End;
  SetExitScreen;
  SetIntVec($1B, @OldBreakHandler); { Restore old break handler }
End.
