{
  Copyright (c) 1998 Erland Van Olmen (erlandvo@hotmail.com)
  Protected Mode Ready
}
Unit MODType1;

interface

{This constants are needed for the type definitions: ------------------------}
Const
  MaxWord  = $FFFF;
  MaxAlloc = MaxWord-$1F;

Type
{These type definitions are needed by the MOD loader & replay routines: -----}
  TSampleInfo = Record
    Name        : String[22];
    Length      : LongInt;
    RepeatOffset: LongInt;
    RepeatLength: LongInt;
    RepeatSample: Boolean;
    Used        : Boolean;
    Volume,
    FineTune,
    OldFineTune : Byte;
  end;

  TModInfo = Record
    NrChannels     : Byte;
    SongTitle      : String[20];
    ModFileName    : String;
    NrSamples      : Byte;
    NrPatterns     : Byte;
    MaxSamples     : Byte;   { 15 or 31 }
    CustomRepeat   : Boolean;
    SongLength     : Byte;
    RestartPosition: Byte;
    PatternTable   : Array[0..127] of Byte;
    Tag            : String[4];
    Samples        : Array[1..31] of TSampleInfo;
  end;

  TChannels = Record
{General channel info: ------------------------------------------------------}
    Muted,
    Replay         : Boolean;
    Period         : Word;
    Pan,
    Instr,
    Note,
    Vol            : Byte;
{Needed for the effect engine: ----------------------------------------------}
    Effect,
    EffectArg,
    LastEffect,
    LastEffectArg  : Byte;
    SmpOffset,
    ArpeggioPeriod : Word;
    ArpeggioCount,
    arp1,
    arp2           : Byte;
    DestPeriod     : Word;
    LastSlideRate  : Byte;
    Glissando      : Boolean;
    VibratoCount,
    VibratoWave,
    LastVibrato,
    TremoloCount,
    TremoloWave,
    LastTremolo,
    DelayCount     : Byte;
    DelayFlag      : Boolean;
    RetrigCount    : Byte;
    UpdateLine,                                 { Needed for the ptn loop FX }
    Looping       : Boolean;
    LoopStartLine,
    LoopCounter   : Byte;
  End;

{These types are needed for the Drivers: ------------------------------------}
  TOutputDevice = Record
    SWDetected: Boolean;    { If the device was actually detected            }
    HWDetected: Boolean;    { If the device was actually detected            }
    SubType   : Word;       { DSP version (for example)                      }
    ID        : Word;       { Just a number                                  }
    Name      : String[30]; { Name of the device (ex: 'SoundBlaster 1.0'     }
    MEnvStr   : String[20]; { Main      Environment variable of the device   }
    SEnvStr   : String[20]; { Secondary Environment variable of the device   }
    MPort     : Word;       { Main      I/O Port (^- not always available)   }
    SPort     : Word;       { Secondary I/O Port    (not always available)   }
    MIRQ      : Byte;       { Main      IRQ                                  }
    SIRQ      : Byte;       { Secondary IRQ         (not always available)   }
    MDMA      : Byte;       { Main      DMA Channel                          }
    SDMA      : Byte;       { Secondary DMA Channel (not always available)   }

{And this is the "code": first, some misc procedures }
{*} LoadMODSample: Function(var F: File; SampleNr: Byte)            : Word;
    HW_Detect    : Function                                         : Boolean;
{*} OpenCard     : Function(NrVoices: Byte)                         : Word;
{*} CloseCard    : Function                                         : Word;
{*} StartReplay  : Function                                         : Word;
{*} StopReplay   : Function                                         : Word;
{*} SetBPM       : Function                                         : Word;
{And now the replay-related procedures }
{*} VSetMode     : Function(Voice, Mode: Byte)                      : Word;
    VGetMode     : Function(Voice: Byte)                            : Byte;
{*} VPlay        : Function(Voice, Sample: Byte; Offset: Word)      : Word;
{*} VSetPanning  : Function(Voice, Panning: Byte)                   : Word;
{*} VSetVolume   : Function(Voice, Volume: Byte)                    : Word;
{*} VSetFrequency: Function(Voice: Byte; Frequency: LongInt)        : Word;
  end;
{ * -=> these functions return NoError if everything went fine. If an error
        occured, a non-zero value is returned.                               }

  TByteBuffer = Array[0..MaxAlloc-1] of Byte;
  PByteBuffer = ^TByteBuffer;

{And now the constants: -----------------------------------------------------}
Const
{ PeriodTable (Finetunes 0..$F (or 0..7, -8..-1)): --------------------------}
{ Notes:   C-0 .. B-0 ; eXtended octave
           C-1 .. B-1 ; standard octave
           C-2 .. B-2 ; standard octave
           C-3 .. B-3 ; standard octave
           C-4 .. B-4 ; eXtended octave                                      }
{ This table is taken from The ASM source code of Robert Adolfssons MODPlayer}
  PeriodTable: Array[0..15, 1..60] of Word = (
   (1712, 1616, 1524, 1440, 1356, 1280, 1208, 1140, 1076, 1016, 960 , 906,
    856 , 808 , 762 , 720 , 678 , 640 , 604 , 570 , 538 , 508 , 480 , 453,
    428 , 404 , 381 , 360 , 339 , 320 , 302 , 285 , 269 , 254 , 240 , 226,
    214 , 202 , 190 , 180 , 170 , 160 , 151 , 143 , 135 , 127 , 120 , 113,
    107 , 101 , 95  , 90  , 85  , 80  , 75  , 71  , 67  , 63  , 60  , 56 ),
   (1700, 1604, 1514, 1430, 1348, 1274, 1202, 1134, 1070, 1010, 954 , 900,
    850 , 802 , 757 , 715 , 674 , 637 , 601 , 567 , 535 , 505 , 477 , 450,
    425 , 401 , 379 , 357 , 337 , 318 , 300 , 284 , 268 , 253 , 239 , 225,
    213 , 201 , 189 , 179 , 169 , 159 , 150 , 142 , 134 , 126 , 119 , 113,
    106 , 100 , 94  , 89  , 84  , 79  , 75  , 71  , 67  , 63  , 59  , 56 ),
   (1688, 1592, 1504, 1418, 1340, 1264, 1194, 1126, 1064, 1004, 948 , 894,
    844 , 796 , 752 , 709 , 670 , 632 , 597 , 563 , 532 , 502 , 474 , 447,
    422 , 398 , 376 , 355 , 335 , 316 , 298 , 282 , 266 , 251 , 237 , 224,
    211 , 199 , 188 , 177 , 167 , 158 , 149 , 141 , 133 , 125 , 118 , 112,
    105 , 99  , 94  , 88  , 83  , 79  , 74  , 70  , 66  , 62  , 59  , 56 ),
   (1676, 1582, 1492, 1408, 1330, 1256, 1184, 1118, 1056, 996 , 940 , 888,
    838 , 791 , 746 , 704 , 665 , 628 , 592 , 559 , 528 , 498 , 470 , 444,
    419 , 395 , 373 , 352 , 332 , 314 , 296 , 280 , 264 , 249 , 235 , 222,
    209 , 198 , 187 , 176 , 166 , 157 , 148 , 140 , 132 , 125 , 118 , 111,
    104 , 99  , 93  , 88  , 83  , 78  , 74  , 70  , 66  , 62  , 59  , 55 ),
   (1664, 1570, 1482, 1398, 1320, 1246, 1176, 1110, 1048, 990 , 934 , 882,
    832 , 785 , 741 , 699 , 660 , 623 , 588 , 555 , 524 , 495 , 467 , 441,
    416 , 392 , 370 , 350 , 330 , 312 , 294 , 278 , 262 , 247 , 233 , 220,
    208 , 196 , 185 , 175 , 165 , 156 , 147 , 139 , 131 , 124 , 117 , 110,
    104 , 98  , 92  , 87  , 82  , 78  , 73  , 69  , 65  , 62  , 58  , 55 ),
   (1652, 1558, 1472, 1388, 1310, 1238, 1168, 1102, 1040, 982 , 926 , 874,
    826 , 779 , 736 , 694 , 655 , 619 , 584 , 551 , 520 , 491 , 463 , 437,
    413 , 390 , 368 , 347 , 328 , 309 , 292 , 276 , 260 , 245 , 232 , 219,
    206 , 195 , 184 , 174 , 164 , 155 , 146 , 138 , 130 , 123 , 116 , 109,
    103 , 97  , 92  , 87  , 82  , 77  , 73  , 69  , 65  , 61  , 58  , 54 ),
   (1640, 1548, 1460, 1378, 1302, 1228, 1160, 1094, 1032, 974 , 920 , 868,
    820 , 774 , 730 , 689 , 651 , 614 , 580 , 547 , 516 , 487 , 460 , 434,
    410 , 387 , 365 , 345 , 325 , 307 , 290 , 274 , 258 , 244 , 230 , 217,
    205 , 193 , 183 , 172 , 163 , 154 , 145 , 137 , 129 , 122 , 115 , 109,
    102 , 96  , 91  , 86  , 81  , 77  , 72  , 68  , 64  , 61  , 57  , 54 ),
   (1628, 1536, 1450, 1368, 1292, 1220, 1150, 1086, 1026, 968 , 914 , 862,
    814 , 768 , 725 , 684 , 646 , 610 , 575 , 543 , 513 , 484 , 457 , 431,
    407 , 384 , 363 , 342 , 323 , 305 , 288 , 272 , 256 , 242 , 228 , 216,
    204 , 192 , 181 , 171 , 161 , 152 , 144 , 136 , 128 , 121 , 114 , 108,
    102 , 96  , 90  , 85  , 80  , 76  , 72  , 68  , 64  , 60  , 57  , 54 ),
   (1814, 1712, 1616, 1524, 1440, 1356, 1280, 1208, 1140, 1076, 1016, 960,
    907 , 856 , 808 , 762 , 720 , 678 , 640 , 604 , 570 , 538 , 508 , 480,
    453 , 428 , 404 , 381 , 360 , 339 , 320 , 302 , 285 , 269 , 254 , 240,
    226 , 214 , 202 , 190 , 180 , 170 , 160 , 151 , 143 , 135 , 127 , 120,
    113 , 107 , 101 , 95  , 90  , 85  , 80  , 75  , 71  , 67  , 63  , 60 ),
   (1800, 1700, 1604, 1514, 1430, 1350, 1272, 1202, 1134, 1070, 1010, 954,
    900 , 850 , 802 , 757 , 715 , 675 , 636 , 601 , 567 , 535 , 505 , 477,
    450 , 425 , 401 , 379 , 357 , 337 , 318 , 300 , 284 , 268 , 253 , 238,
    225 , 212 , 200 , 189 , 179 , 169 , 159 , 150 , 142 , 134 , 126 , 119,
    112 , 106 , 100 , 94  , 89  , 84  , 79  , 75  , 71  , 67  , 63  , 59 ),
  (1788, 1688, 1592, 1504, 1418, 1340, 1264, 1194, 1126, 1064, 1004, 948,
    894 , 844 , 796 , 752 , 709 , 670 , 632 , 597 , 563 , 532 , 502 , 474,
    447 , 422 , 398 , 376 , 355 , 335 , 316 , 298 , 282 , 266 , 251 , 237,
    223 , 211 , 199 , 188 , 177 , 167 , 158 , 149 , 141 , 133 , 125 , 118,
    111 , 105 , 99  , 94  , 88  , 83  , 79  , 74  , 70  , 66  , 62  , 59 ),
   (1774, 1676, 1582, 1492, 1408, 1330, 1256, 1184, 1118, 1056, 996 , 940,
    887 , 838 , 791 , 746 , 704 , 665 , 628 , 592 , 559 , 528 , 498 , 470,
    444 , 419 , 395 , 373 , 352 , 332 , 314 , 296 , 280 , 264 , 249 , 235,
    222 , 209 , 198 , 187 , 176 , 166 , 157 , 148 , 140 , 132 , 125 , 118,
    111 , 104 , 99  , 93  , 88  , 83  , 78  , 74  , 70  , 66  , 62  , 59 ),
    (1762, 1664, 1570, 1482, 1398, 1320, 1246, 1176, 1110, 1048, 988 , 934,
    881 , 832 , 785 , 741 , 699 , 660 , 623 , 588 , 555 , 524 , 494 , 467,
    441 , 416 , 392 , 370 , 350 , 330 , 312 , 294 , 278 , 262 , 247 , 233,
    220 , 208 , 196 , 185 , 175 , 165 , 156 , 147 , 139 , 131 , 123 , 117,
    110 , 104 , 98  , 92  , 87  , 82  , 78  , 73  , 69  , 65  , 61  , 58 ),
   (1750, 1652, 1558, 1472, 1388, 1310, 1238, 1168, 1102, 1040, 982 , 926,
    875 , 826 , 779 , 736 , 694 , 655 , 619 , 584 , 551 , 520 , 491 , 463,
    437 , 413 , 390 , 368 , 347 , 328 , 309 , 292 , 276 , 260 , 245 , 232,
    219 , 206 , 195 , 184 , 174 , 164 , 155 , 146 , 138 , 130 , 123 , 116,
    109 , 103 , 97  , 92  , 87  , 82  , 77  , 73  , 69  , 65  , 61  , 58 ),
   (1736, 1640, 1548, 1460, 1378, 1302, 1228, 1160, 1094, 1032, 974 , 920,
    868 , 820 , 774 , 730 , 689 , 651 , 614 , 580 , 547 , 516 , 487 , 460,
    434 , 410 , 387 , 365 , 345 , 325 , 307 , 290 , 274 , 258 , 244 , 230,
    217 , 205 , 193 , 183 , 172 , 163 , 154 , 145 , 137 , 129 , 122 , 115,
    108 , 102 , 96  , 91  , 86  , 81  , 77  , 72  , 68  , 64  , 61  , 57 ),
   (1724, 1628, 1536, 1450, 1368, 1292, 1220, 1150, 1086, 1026, 968 , 914,
    862 , 814 , 768 , 725 , 684 , 646 , 610 , 575 , 543 , 513 , 484 , 457,
    431 , 407 , 384 , 363 , 342 , 323 , 305 , 288 , 272 , 256 , 242 , 228,
    216 , 203 , 192 , 181 , 171 , 161 , 152 , 144 , 136 , 128 , 121 , 114,
    108 , 101 , 96  , 90  , 85  , 80  , 76  , 72  , 68  , 64  , 60  , 57 ));

{Extended vs Standard octaves: ----------------------------------------------}
  NormalMaxPeriod   = 907;
  NormalMinPeriod   = 108;
  ExtendedMaxPeriod = 1814;
  ExtendedMinPeriod = 54;
  MaxPeriod  : Word = ExtendedMaxPeriod;
  MinPeriod  : Word = ExtendedMinPeriod;
  ExtendedOctaves: Boolean = True;          { Default = Use extended octaves }

{This table is used for the Vibrato & Tremolo FX: ---------------------------}
{ The table is taken from the GUSMOD unit by Mc.Kriss/Extravaganza. Thanks!
  VibratoTable: Array [0..2,0..63] of ShortInt = (
    ( 00, 06, 12, 19, 24, 30, 36, 41, 45, 49, 53, 56, 59, 61, 63, 64 ,
      64, 64, 63, 61, 59, 56, 53, 49, 45, 41, 36, 30, 24, 19, 12, 06 ,
      00,-06,-12,-19,-24,-30,-36,-41,-45,-49,-53,-56,-59,-61,-63,-64 ,
     -64,-64,-63,-61,-59,-56,-53,-49,-45,-41,-36,-30,-24,-19,-12,-06),
    (-63,-61,-59,-57,-55,-53,-51,-49,-47,-45,-43,-41,-39,-37,-35,-33 ,
     -31,-29,-27,-25,-23,-21,-19,-17,-15,-13,-11,-09,-07,-05,-03,-01 ,
      01, 03, 05, 07, 09, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31 ,
      33, 35, 37, 39, 41, 43, 45, 47, 49, 51, 53, 55, 57, 59, 61, 63),
    (-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64 ,
     -64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64 ,
      64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64 ,
      64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64)
  );
}
{Taken from CapaMOD:}
  VibratoTable: Array [0..2, 0..255] of Integer = (
   (0,6,13,19,25,31,38,44                   ,
    50,56,62,68,74,80,86,92                 ,
    98,104,109,115,121,126,132,137          ,
    142,147,152,157,162,167,172,177         ,
    181,185,190,194,198,202,206,209         ,
    213,216,220,223,226,229,231,234         ,
    237,239,241,243,245,247,248,250         ,
    251,252,253,254,255,255,256,256         ,
    256,256,256,255,255,254,253,252         ,
    251,250,248,247,245,243,241,239         ,
    237,234,231,229,226,223,220,216         ,
    213,209,206,202,198,194,190,185         ,
    181,177,172,167,162,157,152,147         ,
    142,137,132,126,121,115,109,104         ,
    98,92,86,80,74,68,62,56                 ,
    50,44,38,31,25,19,13,6                  ,
    0,-6,-13,-19,-25,-31,-38,-44            ,
    -50,-56,-62,-68,-74,-80,-86,-92         ,
    -98,-104,-109,-115,-121,-126,-132,-137  ,
    -142,-147,-152,-157,-162,-167,-172,-177 ,
    -181,-185,-190,-194,-198,-202,-206,-209 ,
    -213,-216,-220,-223,-226,-229,-231,-234 ,
    -237,-239,-241,-243,-245,-247,-248,-250 ,
    -251,-252,-253,-254,-255,-255,-256,-256 ,
    -256,-256,-256,-255,-255,-254,-253,-252 ,
    -251,-250,-248,-247,-245,-243,-241,-239 ,
    -237,-234,-231,-229,-226,-223,-220,-216 ,
    -213,-209,-206,-202,-198,-194,-190,-185 ,
    -181,-177,-172,-167,-162,-157,-152,-147 ,
    -142,-137,-132,-126,-121,-115,-109,-104 ,
    -98,-92,-86,-80,-74,-68,-62,-56         ,
    -50,-44,-38,-31,-25,-19,-13,-6         ),

   (256,254,252,250,248,246,244,242         ,
    240,238,236,234,232,230,228,226         ,
    224,222,220,218,216,214,212,210         ,
    208,206,204,202,200,198,196,194         ,
    192,190,188,186,184,182,180,178         ,
    176,174,172,170,168,166,164,162         ,
    160,158,156,154,152,150,148,146         ,
    144,142,140,138,136,134,132,130         ,
    128,126,124,122,120,118,116,114         ,
    112,110,108,106,104,102,100,98          ,
    96,94,92,90,88,86,84,82                 ,
    80,78,76,74,72,70,68,66                 ,
    64,62,60,58,56,54,52,50                 ,
    48,46,44,42,40,38,36,34                 ,
    32,30,28,26,24,22,20,18                 ,
    16,14,12,10,8,6,4,2                     ,
    0,-2,-4,-6,-8,-10,-12,-14               ,
    -16,-18,-20,-22,-24,-26,-28,-30         ,
    -32,-34,-36,-38,-40,-42,-44,-46         ,
    -48,-50,-52,-54,-56,-58,-60,-62         ,
    -64,-66,-68,-70,-72,-74,-76,-78         ,
    -80,-82,-84,-86,-88,-90,-92,-94         ,
    -96,-98,-100,-102,-104,-106,-108,-110   ,
    -112,-114,-116,-118,-120,-122,-124,-126 ,
    -128,-130,-132,-134,-136,-138,-140,-142 ,
    -144,-146,-148,-150,-152,-154,-156,-158 ,
    -160,-162,-164,-166,-168,-170,-172,-174 ,
    -176,-178,-180,-182,-184,-186,-188,-190 ,
    -192,-194,-196,-198,-200,-202,-204,-206 ,
    -208,-210,-212,-214,-216,-218,-220,-222 ,
    -224,-226,-228,-230,-232,-234,-236,-238 ,
    -240,-242,-244,-246,-248,-250,-252,-254),

   (256,256,256,256,256,256,256,256         ,
    256,256,256,256,256,256,256,256         ,
    256,256,256,256,256,256,256,256         ,
    256,256,256,256,256,256,256,256         ,
    256,256,256,256,256,256,256,256         ,
    256,256,256,256,256,256,256,256         ,
    256,256,256,256,256,256,256,256         ,
    256,256,256,256,256,256,256,256         ,
    256,256,256,256,256,256,256,256         ,
    256,256,256,256,256,256,256,256         ,
    256,256,256,256,256,256,256,256         ,
    256,256,256,256,256,256,256,256         ,
    256,256,256,256,256,256,256,256         ,
    256,256,256,256,256,256,256,256         ,
    256,256,256,256,256,256,256,256         ,
    256,256,256,256,256,256,256,256         ,
    -256,-256,-256,-256,-256,-256,-256,-256 ,
    -256,-256,-256,-256,-256,-256,-256,-256 ,
    -256,-256,-256,-256,-256,-256,-256,-256 ,
    -256,-256,-256,-256,-256,-256,-256,-256 ,
    -256,-256,-256,-256,-256,-256,-256,-256 ,
    -256,-256,-256,-256,-256,-256,-256,-256 ,
    -256,-256,-256,-256,-256,-256,-256,-256 ,
    -256,-256,-256,-256,-256,-256,-256,-256 ,
    -256,-256,-256,-256,-256,-256,-256,-256 ,
    -256,-256,-256,-256,-256,-256,-256,-256 ,
    -256,-256,-256,-256,-256,-256,-256,-256 ,
    -256,-256,-256,-256,-256,-256,-256,-256 ,
    -256,-256,-256,-256,-256,-256,-256,-256 ,
    -256,-256,-256,-256,-256,-256,-256,-256 ,
    -256,-256,-256,-256,-256,-256,-256,-256 ,
    -256,-256,-256,-256,-256,-256,-256,-256));

{Loader Errors: -------------------------------------------------------------}
{ (+128 to avoid "interference" w/ the errors returned by IOResult)          }
  NoError         = 0    ; { No error, everything goes fine                  }
  WrongExtension  = 1+128; { Extension was wrong                             }
  WrongFileName   = 2+128; { File does not exists                            }
  WrongFile       = 3+128; { File is not a real AMIGA Module                 }
  OutOfMemory     = 4+128; { Module contains too many data; out of Memory!   }
  OutOfGusMemory  = 5+128; { Samples are too big: out of GUS Memory!         }
  SampleLoadError = 6+128; { I/O Error whilst loading samples!               }
  AbortedByUser   = 7+128; { Error occured, and user decided to abort loading}
  PP20CorruptMod  = 8+128; { This MOD is a PP20 compressed Module            }
  ToHighPatternNr = 9+128; { Detected pattern nr > 127 in pattern seq. table }
  NoPatterns      =10+128; { No patterns to play                             }

{ Here come some Device-ID constants: ---------------------------------------}
  MaxDevices  = 7; { total nr of devices   }
  NODevice    = 0; { none                  }
  GUSDevice   = 1; { GRAVIS UltraSound     }
  SB100Device = 2; { SoundBlaster 1.0      }
  SB200Device = 3; { SoundBlaster 2.0      }
  SB201Device = 4; { SoundBlaster 2.01     }
  SBPRODevice = 5; { SoundBlaster PRO      }
  SB16Device  = 6; { SoundBlaster 16 (ASP) }

  DeviceNames: Array[0..MaxDevices-1] of String[30] = (
    'No Device',
    'GRAVIS UltraSound',
    'SoundBlaster 1.xx',
    'SoundBlaster 2.0',
    'SoundBlaster 2.1',
    'SoundBlaster PRO',
    'SoundBlaster 16'
  );

  GlobalVolume: Word = 70; {GlobalVolume In Percent}

  NOFilter      = 0;
  SBPROHW       = 1;
  Interpolative = 2;

{Flags for MAIN Program: ----------------------------------------------------}
  Loaded : Boolean = False;                { If Music is playing             }
  Playing: Boolean = False;                { If File was correctly loaded    }
  Filter : Byte    = NOFilter;

VAR
  PlayDevice : TOutputDevice;
  ModInfo    : TModInfo;
  Channels   : array[1..32]  Of TChannels;
  Patterns   : Array[0..127] Of PByteBuffer;
  FreqTable  : Array[ExtendedMinPeriod..ExtendedMaxPeriod] Of LongInt;
  WaitState  : Boolean;             { Set to true whenever a line was played }
  Timing     : Record
                 Count,
                 Speed,
                 PatternDelay: Word;    { for pattern delay effect }
                 Bpm         : Byte;
                 VBlank      : Boolean; { if true effect Fxx is always tempo }
               End;

{This makes some information available to the main program: -----------------}
  PatternInfo: Record
                 Line,
                 Track,
                 Pattern: Byte;
                 PatternData: PByteBuffer;
                 ActLine: Array[1..32] of Record
                                            Note,
                                            Sample,
                                            Effect,
                                            EffectArg: Byte;
                                          End;
               End;

Function ErrStr(Error: Word): String;

{}
{}

implementation

{}
{}

Function ErrStr(Error: Word): String;
BEGIN
  Case Error of
    NoError        : ErrStr:='No error detected.';
    WrongExtension : ErrStr:='The extension of the filespec is wrong. Loading Aborted By User.';
    WrongFileName  : ErrStr:='The specified file doesn''t exists.';
    WrongFile      : ErrStr:='The specified file is not a Real AMIGA Module.';
    OutOfMemory    : ErrStr:='The song is too big. Out of heap Memory.';
    OutOfGusMemory : ErrStr:='The samples are too big. Out of GUS Memory.';
    SampleLoadError: ErrStr:='I/O Error while loading samples! Corrupt MOD File!';
    AbortedByUser  : ErrStr:='Loading Aborted by User, Exiting. Bye Bye!';
    PP20CorruptMod : ErrStr:='This module is compressed with PowerPacker 2.0.';
    ToHighPatternNr: ErrStr:='The pattern sequence table contains a number higher than 127!';
    NoPatterns     : ErrStr:='There are no patterns (there is no partiture for replay)!';
    else; ErrStr:='*F-U-C-K* !!! UnKnown error! Contact me!!!';
  End;
END;

{}
{$F+}
Procedure EmptyProc;
BEGIN
  Writeln('Fatal Error: Empty function was called. Halting.');
  Halt;
END;
{$F-}
{}

BEGIN
{  Timing.PatternDelay:=0;}
  With PlayDevice do
  Begin
    SubType:=0;
    ID     :=MODType1.NoDevice;
    Name   :=DeviceNames[ID];
    MEnvStr:='';
    SEnvStr:='';
    MPort  :=0;
    SPort  :=0;
    MIRQ   :=0;
    SIRQ   :=0;
    MDMA   :=0;
    SDMA   :=0;
    HWDetected:=False;
    SWDetected:=True;
  End;

  Timing.VBlank:=False;
  Addr(PlayDevice.LoadMODSample):=Addr(EmptyProc);
  Addr(PlayDevice.HW_Detect    ):=Addr(EmptyProc);
  Addr(PlayDevice.OpenCard     ):=Addr(EmptyProc);
  Addr(PlayDevice.CloseCard    ):=Addr(EmptyProc);
  Addr(PlayDevice.StartReplay  ):=Addr(EmptyProc);
  Addr(PlayDevice.StopReplay   ):=Addr(EmptyProc);
  Addr(PlayDevice.SetBPM       ):=Addr(EmptyProc);
  Addr(PlayDevice.VSetMode     ):=Addr(EmptyProc);
  Addr(PlayDevice.VGetMode     ):=Addr(EmptyProc);
  Addr(PlayDevice.VPlay        ):=Addr(EmptyProc);
  Addr(PlayDevice.VSetPanning  ):=Addr(EmptyProc);
  Addr(PlayDevice.VSetVolume   ):=Addr(EmptyProc);
  Addr(PlayDevice.VSetFrequency):=Addr(EmptyProc);
END.

