/*
 *		winhlp.h
 *		timidity port for win32 'windows' mode
 *		based on timidity (Unix ) from Tuukka Toivonen and
 *		win32 console port from  Davide Moretti's 
 *		provided under GNU General Public License
 *	  contents : helper routine for graphics and window interface
 *    header file
 *    Nicolas Witczak mai 1996
 */

#ifndef __WIN95__
	#error this file is for windows95 version of timidity	
#endif /* __WIN95__ */ 


#ifndef WINHLP_H
	#define WINHLP_H

#include "win_inc.h"

#define szStringBuff 1024

int 
	SatToRange(int iValToSat,int iMin,int iMax);

int
	ClosestIntCelling(double dVal);

/*parse cmd line fill play list with midi files and return 
true if files to play */
BOOL
	ParseCmdLine(char* pszCmdLine,char*** ppszFileList,int* icbCount);


// windowsx.h like message cracker 
#define HANDLE_SMPCMD(hookId,fn)	\
	case hookId:					\
		fn();						\
		break

#define HANDLE_USERCMD(hookId,hwndCtl,codeNotify,fn)	\
	case hookId:					\
		fn(hwndCtl,codeNotify);	\
		break

void
	DisplayMessage(char* pszToDisplay);

/*
 * DlgFileOpen function
 *	input : pszFileName : a buffer to be filled with
 * a file name
 * input : sizeString
 * output : return success or failure
 * descr  : return a file name 
 */
BOOL
	DlgFileOpen(char* pszTitle,char* pszFileName,int sizeString);
void
	DlgMultiFileOpen(char*** ppszFileList,int* icbCount);
void
	FreeFileList(char** ppszFileList,int icbCount);

/*
 * CenterWindow function
 * descr  : center a window in the middle of the screen 
 * input : hwnd : the window handle to center
 * output : none
 */
void
	CenterWindow(HWND hwnd);
/*
 * SetExTitle function
 * descr  : append pszNewExt file name to title 
 */
void
	SetMidiTitle();


/*
 * Draw3dHLine , Draw3dVLine function
 * descr  : draw 3d style horlizontal and vertical 
 * lines using hDC device context and standart windows colors
 */

void
	Draw3dHLine(HDC hDC,int ixStart,int ixEnd,int iyPos);
void
	Draw3dVLine(HDC hDC,int iyStart,int iyEnd,int ixPos);

#ifndef max
	#define max(x,y)	\
		( ((x)>(y)) ? (x) : (y) ) 
#endif //max

/*
 *	 this overrides stdio 's fprintf 
 *	 windows doesn't know stdout nor stderr so we redirect 
 *  these output to our edit window
 *  otherwise we call the  'real' fprintf
 */  
int
	fprintf( FILE *stream, const char *format ,...);  

#endif // WINHLP_H
