unit ProgForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, Buttons;

type
  TFormProgram = class(TForm)
    EditFStart: TEdit;
    EditFEnd: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    EditTotalDuration: TEdit;
    MemoLevels: TMemo;
    Label4: TLabel;
    EditNSteps: TEdit;
    Label5: TLabel;
    BitBtnOK: TBitBtn;
    BitBtnCancel: TBitBtn;
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure BitBtnOKClick(Sender: TObject);
    procedure EditTotalDurationChange(Sender: TObject);
    procedure EditNStepsChange(Sender: TObject);
    procedure EditFStartChange(Sender: TObject);
    procedure EditFEndChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    TotalDuration: integer;
    FrequencySteps: integer;
    StartFrequency: integer;
    EndFrequency: integer;
    LevelList: string;
  end;

var
  FormProgram: TFormProgram;

implementation

{$R *.DFM}

procedure TFormProgram.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case Key of
    VK_F5: BitBtnOK.Click;
  end;
end;

procedure TFormProgram.FormShow(Sender: TObject);
var
  sl: TStringList;
begin
  EditTotalDuration.Text := IntToStr (TotalDuration);
  EditNSteps.Text := IntToStr (FrequencySteps);
  EditFStart.Text := IntToStr (StartFrequency);
  EditFEnd.Text := IntToStr (EndFrequency);
  sl := TStringList.Create;
  sl.CommaText := LevelList;;
  MemoLevels.Lines := sl;
  sl.Free;
end;

procedure TFormProgram.BitBtnOKClick(Sender: TObject);
begin
  Inherited Click;
end;

procedure TFormProgram.EditTotalDurationChange(Sender: TObject);
begin
  try
    TotalDuration := StrToInt (EditTotalDuration.Text);
  except
    ShowMessage ('Bad value for duration - must be an integer');
    EditTotalDuration.Text := IntToStr (TotalDuration);
  end;
end;

procedure TFormProgram.EditNStepsChange(Sender: TObject);
begin
  try
    FrequencySteps := StrToInt (EditNSteps.Text);
  except
    ShowMessage ('Bad value for number of steps - must be an integer');
    EditNSteps.Text := IntToStr (FrequencySteps);
  end;
end;

procedure TFormProgram.EditFStartChange(Sender: TObject);
begin
  try
    StartFrequency := StrToInt (EditFStart.Text);
  except
    ShowMessage ('Bad value for start frequency - must be an integer');
    EditFStart.Text := IntToStr (StartFrequency);
  end;
end;

procedure TFormProgram.EditFEndChange(Sender: TObject);
begin
  try
    EndFrequency := StrToInt (EditFEnd.Text);
  except
    ShowMessage ('Bad value for end frequency - must be an integer');
    EditFEnd.Text := IntToStr (EndFrequency);
  end;
end;

end.
