;----------------------------------------------------------------------------
;  RADC v1.1 - modified radtest.asm for C usage - (c)1997 Zephyr/Plasm/DNS
;----------------------------------------------------------------------------

;- WHY?
;Uploaded to hopefully easy the frustration of C programmers like me who
;want to play rads in their programs.
;This is for 16 bit C (borland, etc) - no protected mode! :)  (yet...)
;
;- UPDATES
;
;v1.1 - Added volume controls
;     - Added note triggers
;     - Added auto-detect for slow-timer tunes and TimerMode variable
;     - Added ability to fast-forward/re-wind
;     - Fixed adlib reset routine so there is less clicking
;
;v1.0 - first release
;
;
;- HOW?
;Compile this file with the following command line:
;tasm radc /ml/os/zn
;Then... link it to your program and use these defines:
;void extern far StartRad(unsigned char far *RadPointer);
;void extern far StopRad(void);
;void extern far SetMasterVolume(unsigned char VolPos);
;void extern far NextOrder(void);
;void extern far PrevOrder(void);
;Finally, just get the rad file in memory.  You can farmalloc it, include it,
;etc... but just get a far pointer to it and start it with StartRad.
;when finished.. call EndRad.  Easy! :)
;If you want some more info... the following variables have been made public:
;MasterVolume  - The master volume
;NoteTrigger   - Note triggers for eqs, visuals, etc..
;OrderSize     - The total the number of orders
;OrderPos      - The current order that is playing
;Line          - The current line playing
;and you can define these in you C program with:
;extern unsigned char MasterVolume;
;extern unsigned char NoteTrigger[9];
;extern unsigned char TimerMode;
;extern unsigned int OrderSize;
;extern unsigned int OrderPos;
;extern unsigned int Line;

;see radctest.c for an example of all this put together :)




.386P
.model large,c
jumps
locals
IPS		=	50

public StartRad
public StopRad
public SetMasterVolume
public PrevOrder
public NextOrder
public MasterVolume
public TimerMode
public NoteTrigger
public OrderSize
public OrderPos  
public Line

RadPlayer       segment public use16
                assume cs:RadPlayer, ds:RadPlayer

StartRad proc far, RadPointer:DWORD
                les si,RadPointer                
		call	InitPlayer
		call	SetInt
                ret
StartRad endp
StopRad proc far 
		call	ResetInt
                xor dl,dl
                call	EndPlayer
                ret
StopRad endp

SetMasterVolume proc far, VolPos:BYTE
                mov al,VolPos
                cmp al,64
                ja @@la
                mov byte ptr cs:MasterVolume,al
                call SetMasterVol
        @@la:   ret
SetMasterVolume endp

NextOrder proc far
        mov bx,cs:OrderPos
        mov ax,cs:OrderSize
        cmp bx,ax
        jb @@la
        ret
  @@la: call EndPlayer
        mov byte ptr cs:Line,0
        mov word ptr cs:PatternPos,0
        push ds
        mov  ds,cs:ModSeg    ; segment of module
        call NextPattern
        pop ds
        ret
NextOrder endp

PrevOrder proc far
        mov bx,cs:OrderPos
        cmp bx,0
        ja @@la
        ret
  @@la: dec bx
        call EndPlayer
        mov byte ptr cs:Line,0
        mov word ptr cs:PatternPos,0
        push ds
        mov  ds,cs:ModSeg    ; segment of module
        call PrevPattern
        pop ds
        ret
PrevOrder endp


SetInt:		push	ax es
                push ds si
		cli
		xor	ax,ax
		mov	es,ax
		mov	ax,es:[8*4]
                mov     word ptr cs:OldInt,ax
		mov	ax,es:2[8*4]
                mov     word ptr cs:OldInt+2,ax
		mov	word ptr es:[8*4], offset PlayerInt
		mov	es:2[8*4],cs
		mov	ax,IPS
                mov byte ptr cs:TimerMode,1
                mov ds,cs:ModSeg
                mov si,cs:ModOff
                mov bl,ds:[si+17]
                and bl,40h
                cmp bl,0
                jnz @@la
                call    SetTimer
                mov byte ptr cs:TimerMode,0
        @@la:   sti
                pop si ds
		pop	es ax
		ret

ResetInt:	push	ax es

		cli
		xor	ax,ax
		mov	es,ax
                mov     ax,word ptr cs:OldInt
		mov	es:[8*4],ax
                mov     ax,word ptr cs:OldInt+2
		mov	es:2[8*4],ax

		call	ResetTimer

		sti
		pop	es ax
		ret

PlayerInt:	push	ax

		call	PlayMusic

	; see if we have passed 18.2/s mark
        @@lx:   mov     ax,cs:TimerSteps           ; this no. of steps per int.
                add     cs:TimerCnt,ax
		jnc	@@ly			; don't call timer interrupt
		pop	ax
		jmp	cs:OldInt		; call old interrupt handlers

	; standard exit
	@@ly:	mov	al,20h
		out	20h,al
		pop	ax
		iret

SetTimer:	push	ax bx dx

		mov	bx,ax
		mov	ax,13532	; 1193180 mod 65536 (TASM craps out)
		mov	dx,18		; 1193180/65536 (TASM can't calculate this)
		div	bx
		mov	bx,ax

		mov	al,36h
		out	43h,al
		mov	al,bl
		out	40h,al
		mov	al,bh
		out	40h,al

                mov     cs:TimerSteps,bx   ; for keeping 18.2 timer correct
                mov     word ptr cs:TimerCnt,0      ; counter

		pop	dx bx ax
		ret

ResetTimer:	push	ax

		mov	al,36h
		out	43h,al
		xor	al,al
		out	40h,al
		out	40h,al

		pop	ax
		ret

; Tracker commands
cmPortamentoUp	=	1		; Portamento up
cmPortamentoDwn	=	2		; Portamento down
cmToneSlide	=	3		; Tone Slide: xx is speed of slide
cmToneVolSlide	=	5		; Tone slide of 00 + Vol. Slide
cmVolSlide	=	10		; Volume Slide: <50=down, >50=up
cmSetVol	=	12		; set volume
cmJumpToLine	=	13		; Jump to line in next track
cmSetSpeed	=	15		; set speed

FreqStart	=	156h		; low end of frequency in each octave
FreqEnd		=	2aeh		; high end of frequency in each octave
FreqRange	=	FreqEnd-FreqStart

InitPlayer:	pusha
		call	EndPlayer	; clear Adlib ready for tune

	; initialise certain Adlib registers that aren't changed
		mov	ax,0120h	; allow waveforms
		call	Adlib
		mov	ax,0800h
		call	Adlib
		mov	ah,0bdh		; no drums, etc.
		call	Adlib

	; check to see if it is a RAD file first
                cmp     word ptr es:[si],'AR'
		jnz	@@err
                cmp     word ptr es:[si+2],' D'
		jnz	@@err
                cmp     byte ptr es:[si+16],10h            ; correct version?
		jnz	@@err

		mov	cs:ModSeg,es		; keep the segment of module
                mov     cs:ModOff,si            ; and the offset...
	; read initial speed
                mov     al,es:[si+17]
		mov	ah,al
		and	al,1fh
		mov	cs:Speed,al

	; see if there's a description to skip
                add     si,18
		test	ah,80h			; description flag
		jz	@@lc			; no description

		xor	al,al
		jmp	@@le

	@@ld:	inc	si
	@@le:	cmp	es:[si],al		; look for null-termination
		jnz	@@ld
		inc	si			; move past null

	; create table of instrument pointers
	@@lc:	xor	bx,bx

	@@la:	mov	bl,es:[si]		; instrument no.
		inc	si
		add	bx,bx
		jz	@@lb			; no more instruments

		mov	cs:InstPtrs-2[bx],si	; record pointer to instrument
		add	si,11
		jmp	@@la

	; record offset of order list
	@@lb:	xor	ax,ax
		mov	al,es:[si]		; no. of orders in order-list
		mov	cs:OrderSize,ax
		inc	si
		mov	cs:OrderList,si
		xor	bx,bx
                mov     bl,byte ptr es:[si]     ; first pattern to play
		add	bx,bx
		add	si,ax			; move to end of list

	; record table of pattern offsets
		mov	cs:PatternList,si
		mov	ax,es:[si+bx]		; first pattern offset
                add     ax,cs:ModOff
        	mov	cs:PatternPos,ax	; pointer to first pattern

	; initial pointers
		xor	ax,ax
		mov	cs:OrderPos,ax		; start at position 0.
		mov	cs:SpeedCnt,al
		mov	cs:Line,al		; start at line 0

		clc
		jmp	@@lx			; successful initialisation

	@@err:	stc
	@@lx:	popa
		ret

EndPlayer:      push ax
                mov ax,02000h
        @@la:   call Adlib
                inc ah
                cmp ah,43h
                jb @@la
                mov al,3fh 
        @@lb:   call Adlib
                inc ah
                cmp ah,55h
                jb @@lb
                xor al,al
        @@lc:   call Adlib
                inc ah
                cmp ah,0F6h
                jb @@lc
                pop ax
                ret

PlayMusic:	pusha
		push	ds
		mov	ds,cs:ModSeg	; segment of module
		cmp	cs:SpeedCnt,0
		jz	@@la		; play a line of music
		dec	cs:SpeedCnt
		jmp	@@lx		; no new line, so just update effects

	; switch off any effects that are in operation
	@@la:	mov	si,8
		xor	al,al

	@@laa:	mov	cs:PortSlide[si],al	; reset any slides
		mov	cs:VolSlide[si],al	; reset any slides
		mov	cs:ToneSlide[si],al	; reset any slides
                mov     cs:NoteTrigger[si],al   ; reset notetriggers
                dec	si
		jns	@@laa

	; playing a new line, PatternPos should have been set-up already
		mov	si,cs:PatternPos
		or	si,si
		jz	@@lb		; rest of this pattern is blank

		mov	al,[si]		; line indicator
		and	al,7fh		; eliminate bit 7
		cmp	al,cs:Line	; is this current line?
		jnz	@@lb		; haven't reached it yet

		test	byte ptr [si],80h	; last line?
		jz	@@lc		; no, still more to check
		mov	cs:PatternPos,0	; mark rest of pattern as blank

	@@lc:	inc	si		; move to first channel
                
	; play channels
	@@lf:	mov	cl,[si]		; channel we are processing
		push	cx
		and	cl,7fh		; get rid of bit 7
		mov	ax,1[si]	; AL=octave/note, AH=inst/command
		add	si,3

		test	ah,15		; if there's a cmd, there'll be a param.
		jz	@@le		; no parameter byte
		mov	ch,[si]		; read parameter
		inc	si
                
        @@le:   
                call    PlayNote        ; play the note

		pop	cx
		jc	@@lg		; skip rest of line, AX has new line
		test	cl,80h		; last channel to play?
		jz	@@lf		; not yet

		mov	cs:PatternPos,si; keep position in crunched track

	; update pointers
	@@lb:	mov	al,cs:Speed	; needs to be set AFTER note playing
		dec	al
		mov	cs:SpeedCnt,al	;    for new speeds to take effect!

		inc	cs:Line
		cmp	cs:Line,64	; end of pattern?
		jb	@@lx		; nope

		mov	cs:Line,0	; top of next pattern
		call	NextPattern

	; now update effects (effect is acted upon straight away)
	@@lx:	call	UpdateNotes

		pop	ds
		popa
		ret
;
	; jump to line AX
	@@lg:	mov	bl,cs:Speed	; needs to be set AFTER note playing
		mov	cs:SpeedCnt,bl	;    for new speeds to take effect!

		mov	cs:Line,al

		; find start of next pattern
		call	NextPattern
		jz	@@lx		; there isn't any data in next pattern

		; find line that is greater or equal to the current line
	@@ll:	mov	cl,[si]		; line id.
		and	cl,7fh		; ignore bit 7
		cmp	cl,al
		jae	@@lh		; found line

		test	byte ptr [si],80h
		jz	@@li		; not last line
		xor	si,si
		jmp	@@lh		; ignore rest of pattern as it's last

		; skip to next line definition
	@@li:	inc	si
	@@lj:	mov	cl,[si]
		add	si,3
		test	byte ptr cs:[si-1],15	; is there a valid command?
		jz	@@lk
		inc	si		; skip parameter

	@@lk:	add	cl,cl
		jnc	@@lj		; wasn't last channel spec.
		jmp	@@ll		; check next line

	@@lh:	mov	cs:PatternPos,si
		jmp	@@lx

NextPattern:	mov	bx,cs:OrderPos
		inc	bx
		cmp	bx,cs:OrderSize
                jb      PrevPattern ;@@ld
		xor	bx,bx		; end of tune, move back to start
PrevPattern:
        @@ld:   mov     cs:OrderPos,bx
		mov	si,cs:OrderList
		mov	bl,[si+bx]	; no. of next pattern

		test	bl,80h
		jz	@@lda
		and	bl,7fh
		jmp	@@ld		; bit 7 = jump to new order

	@@lda:	mov	si,cs:PatternList
		add	bx,bx
                mov     si,[si+bx]      ; offset of next pattern
                add     si,cs:ModOff    ; plus the offset of the music
		mov	cs:PatternPos,si
		or	si,si
		ret

PlayNote:	mov	di,cx
		and	di,15
		mov	dh,ah
		and	dh,15		; command
                xor bx,bx
                mov bl,cl
;                mov byte ptr cs:NoteTrigger[bx],0
		or	al,al
		jz	@@lb		; no note playing, process command


                push ax
                mov     al,cs:Old43[bx] ; get reg43 value
                and     al,03fh         ; mask out non-vol bits
                xor     al,3fh          ; swap it around
                mov byte ptr cs:NoteTrigger[bx],al  ; set the trigger
                pop ax


	; check to see if we are actually performing a tone slide
		cmp	dh,cmToneSlide
		jnz	@@lt		; nope, play note

		; note/octave are used as parameters then (instrument ignored)
		mov	bx,ax
		and	bx,15		; note
		shr	al,4
		and	ax,7		; octave
		dec	bx		; we want 1..12
		cmp	bx,12
		jae	@@lx		; not a valid note (probably KEY-OFF)

		imul	ax,FreqRange	; scale octave
		add	bx,bx
		add	ax,cs:NoteFreq[bx]	; add frequency of this note
		sub	ax,FreqStart	; so range starts from zero
		mov	cs:ToneSlideFreqL[di],al	; destination frequency
		mov	cs:ToneSlideFreqH[di],ah

		; set tone slide speed
		mov	byte ptr cs:ToneSlide[di],1	; switch tone slide on
		or	ch,ch
		jz	@@lx		; use last speed setting
		mov	cs:ToneSlideSpeed[di],ch
		jmp	@@lx

	; KEY-OFF the previous note
	@@lt:	push	ax
		mov	al,cs:OldB0[di]	; old register value
		and	al, not 20h	; clear KEY-ON bit
		mov	cs:OldB0[di],al	; so slides after KEYOFF work correctly
		mov	ah,cl
		add	ah,0b0h
		call	Adlib
		pop	ax

	; load instrument (if any)
		mov	dl,ah
		add	al,al
		rcr	dl,1
		shr	dl,3		; instrument no.
		jz	@@la		; no instrument to load
		call	LoadInst

	; load note into channel
	@@la:	mov	bl,al
		and	bx,15*2		; note * 2
		cmp	bx,15*2
		jz	@@lb		; just a KEY-OFF so we're done
                call SetChanMasterVolume
		mov	bx,cs:NoteFreq-2[bx]	; frequency of note (BX-1)
		shr	al,3		; octave
		and	al,7*4
		or	al,20h		; KEY-ON
		or	al,bh		; Frequency high byte
		mov	ah,0b0h
		add	ah,cl
		mov	cs:OldB0[di],al	; record the register value
		push	ax

		sub	ah,10h
		mov	al,bl		; Frequency low byte
		mov	cs:OldA0[di],al
		call	Adlib

		pop	ax
		call	Adlib

	; process command (if any), DH has command, CH has parameter
	@@lb:	xor	bx,bx
		mov	bl,dh		; command
		add	bx,bx
		jmp	cs:Effects[bx]

	@@lx:	clc
	@@lxx:	ret
;
; Portamento up
@@PortUp:	mov	cs:PortSlide[di],ch
		jmp	@@lx
;
; Portamento down
@@PortDown:	neg	ch
		mov	cs:PortSlide[di],ch
		jmp	@@lx
;
; Tone slide to note (no note supplied)
@@ToneSlide:	or	ch,ch		; parameter has speed of tone slide
		jz	@@lja		; keep last tone slide speed
		mov	cs:ToneSlideSpeed[di],ch

	@@lja:	mov	byte ptr cs:ToneSlide[di],1	; tone slide on
		jmp	@@lx
;
; Volume slide & Volume + Tone Slide
@@ToneVolSlide:
@@VolSlide:	cmp	ch,50		; <50 = slide down, >50 = slide up
		jb	@@lga
		sub	ch,50
		neg	ch

	@@lga:	mov	cs:VolSlide[di],ch

		cmp	dh,cmToneVolSlide	; just plain volume slide
		jnz	@@lx
		mov	byte ptr cs:ToneSlide[di],1	; tone slide on
		jmp	@@lx
;
; Set volume
@@SetVolume:	call	SetVolume	; CH has volume, CL has channel
		jmp	@@lx
;
; jump to line in next pattern
@@JumpToLine:	cmp	ch,64
		jae	@@lx		; ignore as it is invalid
		xor	ax,ax
		mov	al,ch
		stc
		ret			; skip rest of channels
;
; Set speed
@@SetSpeed:	mov	cs:Speed,ch
		jmp	@@lx
;
Effects		dw	@@lx
		dw	@@PortUp
		dw	@@PortDown
		dw	@@ToneSlide
		dw	@@lx
		dw	@@ToneVolSlide
		dw	@@lx
		dw	@@lx
		dw	@@lx
		dw	@@lx
		dw	@@VolSlide
		dw	@@lx
		dw	@@SetVolume
		dw	@@JumpToLine
		dw	@@lx
		dw	@@SetSpeed

NoteFreq	dw	16bh,181h,198h,1b0h,1cah,1e5h	; 156h = C
		dw	202h,220h,241h,263h,287h,2aeh

UpdateNotes:	xor	bh,bh		; channel index
		xor	si,si

	; process portamentos
	@@la:	mov	bl,cs:PortSlide[si]
		or	bl,bl
		jz	@@lb		; no slide for this channel
		call	GetFreq
		mov	ch,bl
		sar	cx,8		; sign extend 8bit->16bit
		add	ax,cx
		call	SetFreq

	; process volume slides
	@@lb:	mov	ch,cs:VolSlide[si]
		mov	cl,cs:Old43[si]	; contains current volume
		and	cl,3fh
		xor	cl,3fh
		or	ch,ch
		jz	@@lc
		jns	@@lba

		; slide volume up
		sub	cl,ch
		cmp	cl,64
		jb	@@lbb
		mov	cl,63
		jmp	@@lbb

		; slide volume down
	@@lba:	sub	cl,ch
		jns	@@lbb
		xor	cl,cl

	@@lbb:	mov	ch,cl
		mov	cl,bh		; channel to set
		call	SetVolume

	; process tone slides
	@@lc:	cmp	cs:ToneSlide[si],0
		jz	@@lx		; no tone slide
		mov	bl,cs:ToneSlideSpeed[si]	; shouldn't get wiped uc

		; get current absolute frequency
		call	GetFreq

		; sign extend speed/direction
		mov	dh,bl
		sar	dx,8

		; get destination frequency
		mov	cl,cs:ToneSlideFreqL[si]
		mov	ch,cs:ToneSlideFreqH[si]
		cmp	ax,cx
		jz	@@le		; already at destination?!
		ja	@@ld		; tone slide down (source > dest)

		; doing a tone slide up
		add	ax,dx
		cmp	ax,cx
		jb	@@lg		; still under destination
		jmp	@@le		; reached destination

		; doing a tone slide down
	@@ld:	sub	ax,dx
		cmp	ax,cx
		ja	@@lg		; still over destination

		; reached destination so stop tone slide
	@@le:	mov	ax,cx		; clip it onto destination
		mov	cs:ToneSlide[si],0	; disables tone slide

		; write new frequency back to channel
	@@lg:	call	SetFreq

	@@lx:	inc	bh
		inc	si
		cmp	si,9
		jb	@@la
		ret

GetFreq:	mov	cl,cs:OldA0[si]
		mov	ch,cs:OldB0[si]
		and	ch,3		; mask to get high frequency
		sub	cx,FreqStart
		mov	al,cs:OldB0[si]
		shr	al,2
		and	ax,7		; mask to get octave
		mov	dx,FreqRange
		mul	dx
		add	ax,cx
		ret

SetFreq:	mov	cx,FreqRange
		xor	dx,dx
		div	cx		; extracts octave in AX and freq. in DX
		add	dx,FreqStart

		mov	ah,cs:OldB0[si]
		and	ah,11100000b	; keep old toggles
		shl	al,2		; move octave to correct bit position
		or	al,ah		; insert octave
		or	al,dh		; insert high frequency
		mov	ah,bh
		add	ah,0b0h
		mov	cs:OldB0[si],al
		call	Adlib

		sub	ah,10h
		mov	al,dl		; low frequency
		mov	cs:OldA0[si],al
		jmp	Adlib

LoadInst:	push	ax bx si

		mov	si,cx
		and	si,0ffh
		mov	ah,cs:ChannelOffs[si]	; Adlib register offsets

		xor	bx,bx
		mov	bl,dl
		dec	bx
		add	bx,bx
		mov	bx,cs:InstPtrs[bx]	; get instrument offset
		or	bx,bx
		jz	@@lx		; no instrument data ?!

		mov	al,2[bx]
		mov	cs:Old43[si],al	; old 43.. value

		mov	dl,4

	@@la:	mov	al,1[bx]
		call	Adlib		; load carrier
		add	ah,3
		mov	al,[bx]
		call	Adlib		; load modulator
		add	bx,2

		add	ah,20h-3
		dec	dl
		jnz	@@la

		add	ah,40h		; do E0 range now
		mov	al,2[bx]
		call	Adlib
		add	ah,3
		mov	al,1[bx]
		call	Adlib

		mov	ah,0c0h
		add	ah,cl
		mov	al,[bx]
		call	Adlib

	@@lx:	pop	si bx ax
		ret

ChannelOffs	db	20h,21h,22h,28h,29h,2ah,30h,31h,32h

SetVolume:	push	ax bx

		xor	bx,bx
		mov	bl,cl

	; ensure volume is within range
                mov al,byte ptr cs:MasterVolume
                mul ch
                shr ax,6 
                cmp ax,64    
                jb @@la
                mov al,63
                ;cmp     ch,64
                ;jb      @@la
                ;mov     ch,63

	; get old 43.. value
        @@la:   mov     ah,cs:Old43[bx]
                and     ah,0c0h         ; mask out volume bits
                xor     al,3fh
                or      al,ah           ; insert volume
		mov	cs:Old43[bx],al	; keep new 43.. value

	; write new volume into Adlib
		mov	ah,cs:ChannelOffs[bx]
		add	ah,23h
		call	Adlib

		pop	bx ax
		ret

Adlib:		push	ax dx

		mov	dx,cs:AdlibPort
		xchg	ah,al
		out	dx,al
		rept	6
		in	al,dx
		endm

		inc	dx
		mov	al,ah
		out	dx,al
		dec	dx
		mov	ah,22
	@@la:	in	al,dx
		dec	ah
		jnz	@@la

		pop	dx ax
		ret

SetChanMasterVolume:
                push bx cx
                xor bx,bx
                mov bl,cl
                mov ch,byte ptr cs:Old43[bx]
                and ch,3fh
                xor ch,3fh
                call SetVolume
                pop cx bx
                ret


SetMasterVol:
                mov cl,8
        @@la:   call SetChanMasterVolume
                dec cl
                jns @@la
                ret


; Variables
;
AdlibPort	dw	388h		; default Adlib base port

TimerMode       db      0               ; timer mode (0 - 50hz, 1 - 18.2hz)
                                        ; 50hz=normal  18.2hz=slowtimer
MasterVolume    db      64              ; master volume of music
InstPtrs	dw	31 dup (0)	; offsets of instrument data
Old43		db	9 dup (0)	; record of 43..   register values
OldA0		db	9 dup (0)	; record of A0..A8 register values
OldB0		db	9 dup (0)	; record of B0..B8 register values

ToneSlideSpeed	db	9 dup (1)	; speed of tone slide
ToneSlideFreqL	db	9 dup (?)	; destination frequency of tone slide
ToneSlideFreqH	db	9 dup (?)

ToneSlide	db	9 dup (?)	; tone slide flag
PortSlide	db	9 dup (?)	; portamento slide
VolSlide	db	9 dup (?)	; volume slide

NoteTrigger     db      9 dup (0)       ; note triggers (for eq)

ModSeg          dw      ?       ; segment of module
ModOff          dw      ?       ; offset of module
Speed		db	?	; speed (n/50Hz) of tune
SpeedCnt	db	?	; counter used for deriving speed

OrderSize	dw	?	; no. of entries in Order List
OrderList	dw	?	; offset in module of Order List
OrderPos	dw	?	; current playing position in Order List

PatternList	dw	?	; offset of pattern offset table in module
PatternPos	dw	?	; offset to current line in current pattern
Line		db	?	; current line being played (usually +1)

OldInt		dd	?
TimerCnt	dw	?
TimerSteps	dw	?

RadPlayer       ends

RadStack        segment para public use16 stack
		dw	100h dup (?)
RadStack        ends
end
