/*
  TorusSector

  (c) copyright Roman Komary Dez.1996

  POVRAY 3.0
*/


/*
  The TorusSector has the same starting position as a normal torus.
  (It will be lying in the x-z-plane.)

  Input Variables:
    torussector_major_radius
    torussector_minor_radius
    torussector_startangle        // 0 degrees is parallel the z-axe
    torussector_endangle          // the endangle cannot be larger than startangle+180 degrees and it must be greater than startangle as well

  Output Object:
    TorusSector
*/


#declare TorusSector = intersection
{
  torus
  {
    torussector_major_radius,
    torussector_minor_radius
  }
  plane
  {
    <-1,0,0>,0
    rotate <0,torussector_startangle,0>
  }
  plane
  {
    <1,0,0>,0
    rotate <0,torussector_endangle,0>
  }
  rotate <180,0,0>
}
