/*
  SinusArea

  (c) copyright Roman Komary July.1998

  POVRAY 3.0
*/


/*
  A SinusArea is a area of strips which will lie in the x-y-plane.
  In x-direction it will range from 0 to 1. In y-direction it will
  have a limit at y=0. The top-limit will be a cosinus funktion where
  at x=0 the cosinus function will start with y-value 1 and will and
  at x=1 with y-value of 'sinusarea_endheight'.
  The shearing value defines the movement of the cosinus curve in x-direction.
  0 means no shearing, -1 means 45 degrees in negative x-direction.
  The shearing value can be any value you want.

  Note: The area has no depth. This means it will be created only from triangles
  lying in the x-y-plane but without any extension into z-direction.

  Input Variables it needs:
    sinusarea_endheight           // must lie between 0 and 1
    sinusarea_shear
    sinusarea_cstrips
    sinusarea_relstipthickness    // relative thickness of a strip (0 = no stips visible, 1 = no spaces between strips)
    sinusarea_cstripparts         // of how many thin parts a single strip should be constructed so that it approximately has a round curve
    sinusarea_istart              // index (started from 0) of the first strip to draw; if negative -> all strips will be drawn
    sinusarea_iend                // index of the last strip to draw; if negative -> all strips will be drawn
    sinusarea_startangle
    sinusarea_endangle

  Output Object:
    SinusArea
*/


#if( sinusarea_istart<0 | sinusarea_iend<0 )
  #declare sinusarea_istart = 0
  #declare sinusarea_iend = sinusarea_cstrips-1
#end
#if( sinusarea_istart>=sinusarea_cstrips )
  #declare sinusarea_istart = sinusarea_cstrips-1
#end
#if( sinusarea_iend>=sinusarea_cstrips )
  #declare sinusarea_iend = sinusarea_cstrips-1
#end

#if( sinusarea_istart<=sinusarea_iend )
  #declare sinarea_istart = sinusarea_istart
  #declare sinarea_iend = sinusarea_iend
#else
  #declare sinarea_istart = 0
  #declare sinarea_iend = sinusarea_cstrips-1
#end

#declare sinarea_stripstep = 1/sinusarea_cstrips
#declare sinarea_stripthick = sinarea_stripstep*sinusarea_relstipthickness

#declare SinusArea = union
{
  #declare sinarea_i = sinarea_istart
  #while( sinarea_i<=sinarea_iend )
    #declare sinarea_strip_x = sinarea_stripstep*sinarea_i
    #declare sinarea_j = 0
    #while( sinarea_j<sinusarea_cstripparts )
      #declare sinarea_bottom_x0 = sinarea_strip_x+sinarea_j*sinarea_stripthick/sinusarea_cstripparts
      #declare sinarea_bottom_x1 = sinarea_strip_x+(sinarea_j+1)*sinarea_stripthick/sinusarea_cstripparts
      #declare sinarea_angle0 = sinarea_bottom_x0*(sinusarea_endangle-sinusarea_startangle)+sinusarea_startangle
      #declare sinarea_angle1 = sinarea_bottom_x1*(sinusarea_endangle-sinusarea_startangle)+sinusarea_startangle
      #declare sinarea_h0 = ( 0.5+0.5*cos(sinarea_angle0*pi/180) )*(1-sinusarea_endheight)+sinusarea_endheight
      #declare sinarea_h1 = ( 0.5+0.5*cos(sinarea_angle1*pi/180) )*(1-sinusarea_endheight)+sinusarea_endheight
      #declare sinarea_top_x0 = sinarea_bottom_x0+sinusarea_shear*sinarea_h0
      #declare sinarea_top_x1 = sinarea_bottom_x1+sinusarea_shear*sinarea_h1
      triangle
      {
        <sinarea_bottom_x1,0,0>,
        <sinarea_bottom_x0,0,0>,
        <sinarea_top_x0,sinarea_h0,0>
      }
      triangle
      {
        <sinarea_top_x0,sinarea_h0,0>,
        <sinarea_top_x1,sinarea_h1,0>,
        <sinarea_bottom_x1,0,0>
      }
      #declare sinarea_j = sinarea_j+1
    #end
    #declare sinarea_i = sinarea_i+1
  #end
}
