/*
  RoundCylinder

  (c) copyright Roman Komary Dez.1996

  POVRAY 3.0
*/


/*
  The RoundCylinder will lie in the z-axe.
  Its center will be the coordinates space's origin.

  Input Variables:
    roundcylinder_radius
    roundcylinder_height            // parallel z-axe
    roundcylinder_round_radius
    roundcylinder_scale_roundings   // default=1

  Output Object:
    RoundCylinder
*/


#declare RoundCylinder = merge
{
  // First the 2 roundings ( torus )
  torus
  {
    roundcylinder_radius-roundcylinder_round_radius,
    roundcylinder_round_radius*roundcylinder_scale_roundings
    rotate <90,0,0>
    translate <0,0,(roundcylinder_height/2-roundcylinder_round_radius)>
  }
  torus
  {
    roundcylinder_radius-roundcylinder_round_radius,
    roundcylinder_round_radius*roundcylinder_scale_roundings
    rotate <90,0,0>
    translate <0,0,-(roundcylinder_height/2-roundcylinder_round_radius)>
  }

  // 2 Cylinders
  cylinder
  {
    < 0,0,(roundcylinder_height/2-roundcylinder_round_radius) >,
    < 0,0,-(roundcylinder_height/2-roundcylinder_round_radius) >,
    roundcylinder_radius
  }
  cylinder
  {
    < 0,0,(roundcylinder_height/2) >,
    < 0,0,-(roundcylinder_height/2) >,
    roundcylinder_radius-roundcylinder_round_radius
  }
}
