/*
  RoundBox

  (c) copyright Roman Komary Dez.1996

  POVRAY 3.0
*/


/*
  The center of the box will be the origin of the coordinate space.

  Input Variables:
    roundbox_cx                 // parallel x-axe
    roundbox_cy                 // parallel y-axe
    roundbox_cz                 // parallel z-axe
    roundbox_round_radius
    roundbox_scale_corners      // default=1
    roundbox_scale_roundings    // scales the cylinders. default=1

  Output Object:
    RoundBox
*/


#declare RoundBox_4Cylinders = merge
{
  #if( roundbox_cx!=2*roundbox_round_radius )
  cylinder
  {
    < -(roundbox_cx/2-roundbox_round_radius),
      (roundbox_cy/2-roundbox_round_radius),
      0 >,
    < (roundbox_cx/2-roundbox_round_radius),
      (roundbox_cy/2-roundbox_round_radius),
      0 >,
    roundbox_round_radius*roundbox_scale_roundings
  }
  cylinder
  {
    < -(roundbox_cx/2-roundbox_round_radius),
      -(roundbox_cy/2-roundbox_round_radius),
      0 >,
    < (roundbox_cx/2-roundbox_round_radius),
      -(roundbox_cy/2-roundbox_round_radius),
      0 >,
    roundbox_round_radius*roundbox_scale_roundings
  }
  #end
  #if( roundbox_cy!=2*roundbox_round_radius )
  cylinder
  {
    < (roundbox_cx/2-roundbox_round_radius),
      (roundbox_cy/2-roundbox_round_radius),
      0 >,
    < (roundbox_cx/2-roundbox_round_radius),
      -(roundbox_cy/2-roundbox_round_radius),
      0 >,
    roundbox_round_radius*roundbox_scale_roundings
  }
  cylinder
  {
    < -(roundbox_cx/2-roundbox_round_radius),
      (roundbox_cy/2-roundbox_round_radius),
      0 >,
    < -(roundbox_cx/2-roundbox_round_radius),
      -(roundbox_cy/2-roundbox_round_radius),
      0 >,
    roundbox_round_radius*roundbox_scale_roundings
  }
  #end
}


#declare RoundBox = merge
{
  // First the 8 round corners
  #declare roundbox_i=0
  #while(roundbox_i<8)
    #switch(roundbox_i)
      #case (0)
        #declare roundbox_xf=1
        #declare roundbox_yf=1
        #declare roundbox_zf=1
        #break
      #case (1)
        #declare roundbox_xf=-1
        #declare roundbox_yf=1
        #declare roundbox_zf=1
        #break
      #case (2)
        #declare roundbox_xf=1
        #declare roundbox_yf=-1
        #declare roundbox_zf=1
        #break
      #case (3)
        #declare roundbox_xf=-1
        #declare roundbox_yf=-1
        #declare roundbox_zf=1
        #break
      #case (4)
        #declare roundbox_xf=1
        #declare roundbox_yf=1
        #declare roundbox_zf=-1
        #break
      #case (5)
        #declare roundbox_xf=-1
        #declare roundbox_yf=1
        #declare roundbox_zf=-1
        #break
      #case (6)
        #declare roundbox_xf=1
        #declare roundbox_yf=-1
        #declare roundbox_zf=-1
        #break
      #case (7)
        #declare roundbox_xf=-1
        #declare roundbox_yf=-1
        #declare roundbox_zf=-1
        #break
      #end
    sphere
    {
      < roundbox_xf*(roundbox_cx/2-roundbox_round_radius),
        roundbox_yf*(roundbox_cy/2-roundbox_round_radius),
        roundbox_zf*(roundbox_cz/2-roundbox_round_radius) >,
      roundbox_round_radius*roundbox_scale_corners
    }
    #declare roundbox_i=roundbox_i+1
  #end

  // Top 4 Cylinders
  object
  {
    RoundBox_4Cylinders
    translate <0,0,-(roundbox_cz/2-roundbox_round_radius)>
  }

  // Bottom 4 Cylinders
  object
  {
    RoundBox_4Cylinders
    translate <0,0,(roundbox_cz/2-roundbox_round_radius)>
  }

  // 4 Cylinders parallel to z-axe
  #declare roundbox_i=0
  #while(roundbox_i<4)
    #declare roundbox_xf=1
    #declare roundbox_yf=1
    #switch(roundbox_i)
      #case (0)
        #declare roundbox_xf=1
        #declare roundbox_yf=1
        #break
      #case (1)
        #declare roundbox_xf=-1
        #declare roundbox_yf=1
        #break
      #case (2)
        #declare roundbox_xf=1
        #declare roundbox_yf=-1
        #break
      #case (3)
        #declare roundbox_xf=-1
        #declare roundbox_yf=-1
        #break
      #end
    cylinder
    {
      < roundbox_xf*(roundbox_cx/2-roundbox_round_radius),
        roundbox_yf*(roundbox_cy/2-roundbox_round_radius),
        (roundbox_cz/2-roundbox_round_radius) >,
      < roundbox_xf*(roundbox_cx/2-roundbox_round_radius),
        roundbox_yf*(roundbox_cy/2-roundbox_round_radius),
        -(roundbox_cz/2-roundbox_round_radius) >,
      roundbox_round_radius*roundbox_scale_roundings
    }
    #declare roundbox_i=roundbox_i+1
  #end

  // 3 Boxes covering the 6 sides of the RoundBox
  box
  {
    < -(roundbox_cx/2),
      -(roundbox_cy/2-roundbox_round_radius),
      -(roundbox_cz/2-roundbox_round_radius) >,
    < (roundbox_cx/2),
      (roundbox_cy/2-roundbox_round_radius),
      (roundbox_cz/2-roundbox_round_radius) >
  }
  box
  {
    < -(roundbox_cx/2-roundbox_round_radius),
      -(roundbox_cy/2),
      -(roundbox_cz/2-roundbox_round_radius) >,
    < (roundbox_cx/2-roundbox_round_radius),
      (roundbox_cy/2),
      (roundbox_cz/2-roundbox_round_radius) >
  }
  box
  {
    < -(roundbox_cx/2-roundbox_round_radius),
      -(roundbox_cy/2-roundbox_round_radius),
      -(roundbox_cz/2) >,
    < (roundbox_cx/2-roundbox_round_radius),
      (roundbox_cy/2-roundbox_round_radius),
      (roundbox_cz/2) >
  }
}
