/*
  RoundTorusSector

  (c) copyright Roman Komary Dez.1996

  POVRAY 3.0
*/


/*
  The RoundTorusSector has the same starting position as a normal torus.
  (It will be lying in the x-z-plane.)

  Input Variables:
    torussector_major_radius
    torussector_minor_radius
    torussector_startangle        // 0 degrees is parallel the z-axe
    torussector_endangle          // the endangle cannot be larger than startangle+180 degrees
    roundtorussector_round_radius
    roundtorussector_scale_roundings  // default=1

  Output Object:
    RoundTorusSector
*/


#include "torussec.pov"


#declare RoundTorusSector = merge
{
  // First the torus sector
  object
  {
    TorusSector
  }

  merge
  {
    torus
    {
      torussector_minor_radius-roundtorussector_round_radius,
      roundtorussector_round_radius*roundtorussector_scale_roundings
    }
    cylinder
    {
      <0,roundtorussector_round_radius,0>,
      <0,-roundtorussector_round_radius,0>,
      torussector_minor_radius-roundtorussector_round_radius
    }
    rotate <0,0,90>
    translate <0,0,torussector_major_radius>
    rotate <0,torussector_startangle,0>
  }
  merge
  {
    torus
    {
      torussector_minor_radius-roundtorussector_round_radius,
      roundtorussector_round_radius*roundtorussector_scale_roundings
    }
    cylinder
    {
      <0,roundtorussector_round_radius,0>,
      <0,-roundtorussector_round_radius,0>,
      torussector_minor_radius-roundtorussector_round_radius
    }
    rotate <0,0,-90>
    translate <0,0,torussector_major_radius>
    rotate <0,torussector_endangle,0>
  }
}
