/*
  RoundRect

  (c) copyright Roman Komary Oct.1997

  POVRAY 3.0
*/


/*
  The RoundRect will lie in the x-y-plane.
  Its center will be the coordinates space's origin.

  Input Variables:
    roundrect_cx              // parallel x-axes
    roundrect_cy              // parallel y-axes
    roundrect_corner_radius
    roundrect_inner_radius

  Output Object:
    RoundRect
*/


#declare torussector_major_radius = roundrect_corner_radius
#declare torussector_minor_radius = roundrect_inner_radius
#declare torussector_startangle = 0
#declare torussector_endangle = torussector_startangle+90
#include "torussec.pov"

#declare RoundRect = merge
{
  cylinder
  {
    <-roundrect_cx/2,roundrect_cy/2-roundrect_corner_radius,0>,
    <-roundrect_cx/2,-roundrect_cy/2+roundrect_corner_radius,0>,
    roundrect_inner_radius
  }
  cylinder
  {
    <roundrect_cx/2,roundrect_cy/2-roundrect_corner_radius,0>,
    <roundrect_cx/2,-roundrect_cy/2+roundrect_corner_radius,0>,
    roundrect_inner_radius
  }
  cylinder
  {
    <-roundrect_cx/2+roundrect_corner_radius,roundrect_cy/2,0>,
    <roundrect_cx/2-roundrect_corner_radius,roundrect_cy/2,0>,
    roundrect_inner_radius
  }
  cylinder
  {
    <-roundrect_cx/2+roundrect_corner_radius,-roundrect_cy/2,0>,
    <roundrect_cx/2-roundrect_corner_radius,-roundrect_cy/2,0>,
    roundrect_inner_radius
  }
  object
  {
    TorusSector
    rotate <90,0,0>
    translate <roundrect_cx/2-roundrect_corner_radius,roundrect_cy/2-roundrect_corner_radius,0>
  }
  object
  {
    TorusSector
    rotate <90,0,-90>
    translate <roundrect_cx/2-roundrect_corner_radius,-roundrect_cy/2+roundrect_corner_radius,0>
  }
  object
  {
    TorusSector
    rotate <90,0,-180>
    translate <-roundrect_cx/2+roundrect_corner_radius,-roundrect_cy/2+roundrect_corner_radius,0>
  }
  object
  {
    TorusSector
    rotate <90,0,-270>
    translate <-roundrect_cx/2+roundrect_corner_radius,roundrect_cy/2-roundrect_corner_radius,0>
  }
}
