/*
  variable-size Magnet2-Vibrator (it is a speaker) of a Box

  (c) copyright Roman Komary July.1998

  POVRAY 3.0
*/


/*
  The Magnet2-Vibrator (it is a speaker) will lie in the x-z-plane.
  It's the outer fixing torus which lies exactly in the x-z-plane.

  IMPORTANT NOTE: If you do scale the Magnet2 you should scale only with the same
  amount in all 3 directions or otherwise the magnet will be deformed. This will result in
  incorrect light reflection for the EllipseConeSector (see the notes in "ellcone.pov").

  Input Varaibles:
    magnet2_outerxradius
    magnet2_outerzradius
    magnet2_innerxradius
    magnet2_innerzradius
    magnet2_outerfixingradius
    magnet2_height
    magnet2_sphere_nested_angle     // angle how far the sphere should be nested (0=not nested, 45=defaut)

  Output Objects:
    Magnet_Lights2                  // This is an object which contains several lamps.
                                    //  You should use this light constellation for
                                    //  a beautiful looking of the speaker.
                                    //  To use it, the speaker should be positioned
                                    //  in the coordinate space's origin and lying in
                                    //  the x-z-plane whereas the lights-object should
                                    //  also be positioned in the in the origin.
                                    //  (You can scale the lights-object if you want
                                    //  to generate a big speaker).
    Magnet2                         // This is the speaker object
*/


// -- Lights --


#declare Magnet_Lights2 = union
{

light_source {   // Light006
  <3.513, -6.746, 11.044>
  color rgb <0.943, 0.943, 0.943>
}

light_source {   // Light005
  <-11.858, -6.594, -0.051>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light004
  <10.457, -5.154, 1.541>
  color rgb <1.000, 1.000, 1.000>*0.4
}

light_source {   // Light003
  <-10.135, -5.761, 5.829>
  color rgb <0.614, 0.614, 0.614>
}

light_source {   // Light002
  <-1.244, -5.457, 11.591>
  color rgb <0.671, 0.671, 0.671>
}

light_source {   // Light001
  <-6.358, -4.442, 9.930>
  color rgb <1.000, 1.000, 1.000>
}

}


// -- Textures --


#include "magnet2.inc"


// -- Ojbects --


#ifdef( magnet2_outerxradius )
#if( magnet2_outerxradius>0 )

#declare Magnet2_Vibrator = union
{
  #declare magnet2_torusradius = 0.7*magnet2_outerfixingradius
  #declare magnet2_outerdist = 0.5*magnet2_outerfixingradius
  #declare magnet2_outerradofs = sqrt(pow(magnet2_outerfixingradius+magnet2_torusradius,2)-pow(magnet2_outerdist,2))
  object // Magnet2_OuterTorus
  {
    #declare ellipsetorussector_major_xradius = magnet2_outerxradius-magnet2_outerradofs
    #declare ellipsetorussector_major_zradius = magnet2_outerzradius-magnet2_outerradofs
    #declare ellipsetorussector_minor_radius = magnet2_torusradius
    #declare ellipsetorussector_startangle = 0
    #declare ellipsetorussector_endangle = 360
    #declare ellipsetorussector_cparts = 100
    #include "elltorus.pov"
    EllipseTorusSector
    translate y*magnet2_outerdist
    texture
    {
      TMagnet2_OuterTorus
    }
  }
  #declare magnet2_coneheight = magnet2_height-magnet2_outerdist
  #declare magnet2_conexradofs = magnet2_torusradius*magnet2_coneheight/sqrt(pow(ellipsetorussector_major_xradius-magnet2_innerxradius,2)+pow(magnet2_coneheight,2))
  #declare magnet2_conezradofs = magnet2_torusradius*magnet2_coneheight/sqrt(pow(ellipsetorussector_major_zradius-magnet2_innerzradius,2)+pow(magnet2_coneheight,2))
  object // Magnet2_Cone
  {
    #declare ellipseconesector_outerxradius = ellipsetorussector_major_xradius-magnet2_conexradofs
    #declare ellipseconesector_outerzradius = ellipsetorussector_major_zradius-magnet2_conezradofs
    #declare ellipseconesector_innerxradius = magnet2_innerxradius-max(magnet2_conexradofs,magnet2_conezradofs)
    #declare ellipseconesector_innerzradius = ellipseconesector_innerxradius
    #declare ellipseconesector_height = magnet2_coneheight
    #declare ellipseconesector_startangle = 0
    #declare ellipseconesector_endangle = 360
    #declare ellipseconesector_cparts = 100
    #declare ellipseconesector_open = 1
    #include "ellcone.pov"
    EllipseConeSector
    rotate <0,0,180>
    translate y*(magnet2_coneheight+magnet2_outerdist-sqrt(pow(magnet2_torusradius,2)-pow(max(magnet2_conexradofs,magnet2_conezradofs),2)))
  }
  #declare magnet2_innertorusypos = magnet2_outerdist+magnet2_coneheight
  object // Magnet2_InnerTorus
  {
    #declare ellipsetorussector_major_xradius = magnet2_innerxradius
    #declare ellipsetorussector_major_zradius = magnet2_innerzradius
    #declare ellipsetorussector_minor_radius = magnet2_torusradius
    #declare ellipsetorussector_startangle = 0
    #declare ellipsetorussector_endangle = 360
    #declare ellipsetorussector_cparts = 100
    #include "elltorus.pov"
    EllipseTorusSector
    translate y*magnet2_innertorusypos
    texture
    {
      TMagnet2_InnerTorus
    }
  }
  texture
  {
    TMagnet2_Cone
  }
}

#declare Magnet2 = union {
  object { Magnet2_Vibrator }
  object // Magnet2_OuterFixingTorus
  {
    #declare ellipsetorussector_major_xradius = magnet2_outerxradius
    #declare ellipsetorussector_major_zradius = magnet2_outerzradius
    #declare ellipsetorussector_minor_radius = magnet2_outerfixingradius
    #declare ellipsetorussector_startangle = 0
    #declare ellipsetorussector_endangle = 360
    #declare ellipsetorussector_cparts = 100
    #include "elltorus.pov"
    EllipseTorusSector
    texture
    {
      TMagnet2_Fixing
    }
  }
  #declare magnet2_innerradmean = (magnet2_innerxradius+magnet2_innerzradius)/2
  #declare magnet2_sphere_yofs = magnet2_innerradmean*tan(magnet2_sphere_nested_angle*pi/180)
  #declare magnet2_sphere_cos = cos(magnet2_sphere_nested_angle*pi/180)
  #declare magnet2_sphere_yrad = magnet2_innerradmean/magnet2_sphere_cos-magnet2_torusradius
  #declare magnet2_sphere_xradscale = magnet2_innerxradius/magnet2_innerradmean
  #declare magnet2_sphere_zradscale = magnet2_innerzradius/magnet2_innerradmean
  #declare magnet2_sphere_xrad = magnet2_sphere_yrad*magnet2_sphere_xradscale
  #declare magnet2_sphere_zrad = magnet2_sphere_yrad*magnet2_sphere_zradscale
  sphere // Magnet2_Sphere
  {
    <0,0,0>, 1
    texture
    {
      TMagnet2_Sphere
    }
    scale <magnet2_sphere_xrad,magnet2_sphere_yrad,magnet2_sphere_zrad>
    translate (magnet2_innertorusypos+magnet2_sphere_yofs)*y
  }
}

#end
#end
