/*
  Lamps from a ring

  (c) copyright Roman Komary July.1998

  POVRAY 3.0
*/


/*
  Lamps are torus sectors lying in the x-z-plane started at the positive z-point
*/


/*
  Input Variables it needs:
    lamps_radius            // radius of the lamp-ring
    lamps_thickness         // inner radius of a torus sector * 2
    lamps_count             // number of lamps to do (beginning at the top)
    lamps_spacing           // distances between lamps in percent (0 = no distance, 1 = no lamps)
    lamps_istart            //
    lamps_iend              // these 2 variables define, which is the starting and ending index to draw. If one is -1 -> all lamps will be drawn
    lamps_beginwithlamp     // 1 = on top a lamp will be drawn, 0 = on top a spacing will be drawn

  Output Object:
    Lamps
*/


#if( lamps_istart<0 | lamps_iend<0 )
  #declare lamps_istart = 0
  #declare lamps_iend = lamps_count-1
#end
#if( lamps_istart>=lamps_count )
  #declare lamps_istart = lamps_count-1
#end
#if( lamps_iend>=lamps_count )
  #declare lamps_iend = lamps_count-1
#end

#if( lamps_istart<=lamps_iend )
  #declare lamps1_istart = lamps_istart
  #declare lamps1_iend = lamps_iend
#else
  #declare lamps1_istart = 0
  #declare lamps1_iend = lamps_count-1
#end

#declare Lamps = union
{
  #declare lamps1_i = lamps1_istart
  #while( lamps1_i<=lamps1_iend )
    object
    {
      #declare torussector_major_radius = lamps_radius
      #declare torussector_minor_radius = lamps_thickness/2
      #declare torussector_startangle = -(180/lamps_count)*(1-lamps_spacing)
      #declare torussector_endangle = -torussector_startangle
      #include "torussec.pov"
      TorusSector
      rotate <0,360*lamps1_i/lamps_count,0>
    }
    #declare lamps1_i = lamps1_i+1
  #end
  #if( lamps_beginwithlamp=0 )
  rotate <0,180/lamps_count,0>
  #end
  rotate <0,180,0>
}
