/*
  EllipseTorusSector

  (c) copyright Roman Komary July.1998

  POVRAY 3.0
*/


/*
  The EllipseTorusSector has the same starting position as a normal torus.
  (It will be lying in the x-z-plane.)

  It will be constructed from normal torus sectors.

  Input Variables:
    ellipsetorussector_major_xradius
    ellipsetorussector_major_zradius
    ellipsetorussector_minor_radius
    ellipsetorussector_startangle
    ellipsetorussector_endangle
    ellipsetorussector_cparts           // number of parts

  Output Object:
    EllipseTorusSector
*/


// IMPORTANT: Do not change the staring point of angle 0 (it will start
// on negative x axes and rotate counter clock wise), because
// "ellamps1.pov" does need it that way.


#if( ellipsetorussector_endangle<ellipsetorussector_startangle )
  // exchange start- and endangle
  #declare elltorus_h = ellipsetorussector_startangle
  #declare ellipsetorussector_startangle = ellipsetorussector_endangle
  #declare ellipsetorussector_endangle = elltorus_h
#end
#declare elltorus_full_angle = mod( ellipsetorussector_endangle-ellipsetorussector_startangle, 360 )
#if( ellipsetorussector_endangle>ellipsetorussector_startangle &
     elltorus_full_angle=0 )
  #declare elltorus_full_angle = 360
  #declare ellipsetorussector_startangle = 0
#end
#declare ellipsetorussector_endangle = elltorus_full_angle+ellipsetorussector_startangle


#if( elltorus_full_angle>0 &
     ellipsetorussector_major_xradius>0 &
     ellipsetorussector_major_zradius>0 &
     ellipsetorussector_minor_radius>0 &
     ellipsetorussector_cparts>0 )
  #if( ( ellipsetorussector_major_xradius!=ellipsetorussector_major_zradius ) |
       ( elltorus_full_angle<360 ) )
    #declare EllipseTorusSector = merge
    {
      #declare elltorus_i = 0
      #while( elltorus_i<ellipsetorussector_cparts )

        #declare elltorus_A_angle = ellipsetorussector_startangle+elltorus_full_angle*elltorus_i/ellipsetorussector_cparts
        #declare elltorus_B_angle = ellipsetorussector_startangle+elltorus_full_angle*(elltorus_i+1)/ellipsetorussector_cparts
        // Note: The y-coords of the following points and vectors will be ignored (must be set to 0)
        #declare elltorus_A = vaxis_rotate(x,-y,elltorus_A_angle)
        #declare elltorus_A = <elltorus_A.x*ellipsetorussector_major_xradius,elltorus_A.y,elltorus_A.z*ellipsetorussector_major_zradius>
        #declare elltorus_B = vaxis_rotate(x,-y,elltorus_B_angle)
        #declare elltorus_B = <elltorus_B.x*ellipsetorussector_major_xradius,elltorus_B.y,elltorus_B.z*ellipsetorussector_major_zradius>

        #if( elltorus_full_angle<360 & elltorus_i=0 )
          #declare elltorus_O = elltorus_A
        #else
          #declare elltorus_O_angle = ellipsetorussector_startangle+elltorus_full_angle*(elltorus_i-1)/ellipsetorussector_cparts
          #declare elltorus_O = vaxis_rotate(x,-y,elltorus_O_angle)
          #declare elltorus_O = <elltorus_O.x*ellipsetorussector_major_xradius,elltorus_O.y,elltorus_O.z*ellipsetorussector_major_zradius>
        #end
        // Note: 'elltorus_O' is the point before 'elltorus_A'
        #if( elltorus_full_angle<360 & elltorus_i=ellipsetorussector_cparts-1 )
          #declare elltorus_P = elltorus_B
        #else
          #declare elltorus_P_angle = ellipsetorussector_startangle+elltorus_full_angle*(elltorus_i+2)/ellipsetorussector_cparts
          #declare elltorus_P = vaxis_rotate(x,-y,elltorus_P_angle)
          #declare elltorus_P = <elltorus_P.x*ellipsetorussector_major_xradius,elltorus_P.y,elltorus_P.z*ellipsetorussector_major_zradius>
        #end
        // Note: 'elltorus_P' is the point after 'elltorus_B'

        #declare elltorus_lambda_value = ( (elltorus_A.x-elltorus_P.x)*(elltorus_B.x-elltorus_A.x) - (elltorus_P.z-elltorus_A.z)*(elltorus_B.z-elltorus_A.z) )/( (elltorus_A.x-elltorus_P.x)*(elltorus_B.z-elltorus_O.z) - (elltorus_P.z-elltorus_A.z)*(elltorus_O.x-elltorus_B.x) )
        #declare elltorus_Z = < elltorus_A.x+elltorus_lambda_value*(elltorus_B.z-elltorus_O.z) ,0, elltorus_A.z+elltorus_lambda_value*(elltorus_O.x-elltorus_B.x) >
        // Note: 'elltorus_Z' is the center for the torus-sector

        #declare elltorus_AZ_vector = vnormalize(elltorus_A-elltorus_Z)
        #declare elltorus_AZ_angle = acos(elltorus_AZ_vector.x)*180/pi
        #if( elltorus_AZ_vector.z<0 )
          #declare elltorus_AZ_angle = 360-elltorus_AZ_angle
        #end
        #declare elltorus_BZ_vector = vnormalize(elltorus_B-elltorus_Z)
        #declare elltorus_BZ_angle = acos(elltorus_BZ_vector.x)*180/pi
        #if( elltorus_BZ_vector.z<0 )
          #declare elltorus_BZ_angle = 360-elltorus_BZ_angle
        #end
        #while( elltorus_BZ_angle<elltorus_AZ_angle )
          #declare elltorus_BZ_angle = elltorus_BZ_angle+360
        #end

        // Note: 'elltorus_angle_ofs' is used just to ensure that the torussectors really do
        // overlap at the points where they touch each other.
        #declare elltorus_angle_ofs = 0.0001*(elltorus_BZ_angle-elltorus_AZ_angle)

        object
        {
          #declare torussector_startangle = elltorus_AZ_angle+90-elltorus_angle_ofs
          #declare torussector_endangle = elltorus_BZ_angle+90+elltorus_angle_ofs
          #declare torussector_minor_radius = ellipsetorussector_minor_radius
          #declare torussector_major_radius = vlength( elltorus_A-elltorus_Z )
          #include "torussec.pov"
          TorusSector
          translate elltorus_Z
          bounded_by { sphere { (elltorus_A+elltorus_B)/2, vlength(elltorus_B-elltorus_A)+ellipsetorussector_minor_radius } }
        }

        #declare elltorus_i = elltorus_i+1
      #end
      bounded_by
      {
        #if( ellipsetorussector_major_xradius>ellipsetorussector_major_zradius )
          sphere { <0,0,0>, (ellipsetorussector_major_xradius+ellipsetorussector_minor_radius)*1.001 }
        #else
          sphere { <0,0,0>, (ellipsetorussector_major_zradius+ellipsetorussector_minor_radius)*1.001 }
        #end
      }
    }
  #else
    #declare EllipseTorusSector = torus
    {
      ellipsetorussector_major_xradius,
      ellipsetorussector_minor_radius
    }
  #end
#else
  #declare EllipseTorusSector = sphere
  {
    <0,0,0>, 0
  }
#end
