/*
  EllipseRing

  (c) copyright Roman Komary July.1998

  POVRAY 3.0
*/


/*
  The EllipseRing is an object like a (ell)cylinder with a hole where the hole has rounded
  borders. The front of the cylinder will lie in the x-z-plane and reach into the positive
  y-direction.

  The rounded borders will be created from a torus. Its major radius is 'ellipsering_outerholexradius'
  and 'ellipsering_outerholezradius' and its minor radius will be 'ellipsering_innerholexradius'
  and 'ellipsering_innerholezradius'. The 'ellipsering_depth' value defines how far the
  EllipseTorus should be stretched in y-direction.

  The 'ellipsering_outerxradius' and 'ellipsering_outerzradius' define the outer radius
  of the EllipseCylinder.

  Note: The following conditions should be met:
    ellipsering_innerholexradius < ellipsering_outerholexradius < ellipsering_outerxradius
    ellipsering_innerholezradius < ellipsering_outerholezradius < ellipsering_outerzradius

  Input Variables:
    ellipsering_innerholexradius
    ellipsering_innerholezradius
    ellipsering_outerholexradius
    ellipsering_outerholezradius
    ellipsering_outerxradius
    ellipsering_outerzradius
    ellipsering_depth               // how far to reach into the y-direction
    ellipsering_cparts

  Output Object:
    EllipseRing
*/


#declare EllipseRing = union
{
  intersection // inner torus for roundings
  {
    #declare ellring_minor_xrad = ellipsering_outerholexradius-ellipsering_innerholexradius
    #declare ellring_minor_zrad = ellipsering_outerholezradius-ellipsering_innerholezradius
    object
    {
      #declare ellipsetorussector_major_xradius = ellipsering_outerholexradius/ellring_minor_xrad
      #declare ellipsetorussector_major_zradius = ellipsering_outerholezradius/ellring_minor_zrad
      #declare ellipsetorussector_minor_radius = 1
      #declare ellipsetorussector_startangle = 0
      #declare ellipsetorussector_endangle = 360
      #declare ellipsetorussector_cparts = ellipsering_cparts
      #include "elltorus.pov"
      EllipseTorusSector
      translate <0,1,0>
      scale <ellring_minor_xrad,ellipsering_depth,ellring_minor_zrad>
    }
    cylinder
    {
      <0,-1,0>, <0,ellipsering_depth+1,0>, 1
      scale <ellipsering_outerholexradius,1,ellipsering_outerholezradius>
    }
    plane
    {
      y, ellipsering_depth
    }
  }
  difference // outer ring
  {
    cylinder
    {
      <0,0,0>, <0,ellipsering_depth,0>, 1
      scale <ellipsering_outerxradius,1,ellipsering_outerzradius>
    }
    cylinder
    {
      <0,-1,0>, <0,ellipsering_depth+1,0>, 1
      scale <ellipsering_outerholexradius,1,ellipsering_outerholezradius>
    }
  }
}
