/*
  EllipseConeSector

  (c) copyright Roman Komary July.1998

  POVRAY 3.0
*/


/*
  The EllipseConeSector's ellipse with the inner x and z radius will lie in the x-z-plane.
  Its ellipse with the outer x and z radius will lie in a plane parallel to the
  x-z-plane with y=ellipseconesector_height.

  It will be constructed from smooth triangles.

  IMPORTANT NOTE: Because the cone will be constructed from smooth triangles, you
  should *not* scale the EllipseConeSector (except if you scale with the same amount
  in all 3 directions), because this would deform the cone. The result would be
  incorrect light reflection because the normal vectors of the smooth triangles
  will be calculated based upon 'ellipseconesector_height'. After deformation,
  the normal vectors would be incorrect.
  So do scale only if you scale with the same amout in all 3 directions.

  Input Variables:
    ellipseconesector_outerxradius
    ellipseconesector_outerzradius
    ellipseconesector_innerxradius
    ellipseconesector_innerzradius
    ellipseconesector_height
    ellipseconesector_startangle
    ellipseconesector_endangle
    ellipseconesector_cparts
    ellipseconesector_open

  Output Ojbect:
    EllipseConeSector
*/


#if( ellipseconesector_endangle<ellipseconesector_startangle )
  // exchange start- and endangle
  #declare ellcone_h = ellipseconesector_startangle
  #declare ellipseconesector_startangle = ellipseconesector_endangle
  #declare ellipseconesector_endangle = ellcone_h
#end
#declare ellcone_full_angle = mod( ellipseconesector_endangle-ellipseconesector_startangle, 360 )
#if( ellipseconesector_endangle>ellipseconesector_startangle &
     ellcone_full_angle=0 )
  #declare ellcone_full_angle = 360
  #declare ellipseconesector_startangle = 0
#end
#declare ellipseconesector_endangle = ellcone_full_angle+ellipseconesector_startangle


#if( ellcone_full_angle>0 &
     ellipseconesector_outerxradius>0 &
     ellipseconesector_outerzradius>0 &
     ellipseconesector_innerxradius>0 &
     ellipseconesector_innerzradius>0 &
     ellipseconesector_cparts>0 )
  #if( ( ellipseconesector_outerxradius!=ellipseconesector_outerzradius ) |
       ( ellipseconesector_innerxradius!=ellipseconesector_innerzradius ) |
       ( ellcone_full_angle<360 ) )
    #declare EllipseConeSector = merge
    {
      #declare ellcone_i = 0
      #while( ellcone_i<ellipseconesector_cparts )

        #declare ellcone_A_angle = ellipseconesector_startangle+ellcone_full_angle*ellcone_i/ellipseconesector_cparts
        #declare ellcone_B_angle = ellipseconesector_startangle+ellcone_full_angle*(ellcone_i+1)/ellipseconesector_cparts
        #declare ellcone_A = vaxis_rotate(x,-y,ellcone_A_angle)
        #declare ellcone_Ao = <ellcone_A.x*ellipseconesector_outerxradius,ellipseconesector_height,ellcone_A.z*ellipseconesector_outerzradius>
        #declare ellcone_Ai = <ellcone_A.x*ellipseconesector_innerxradius,0,ellcone_A.z*ellipseconesector_innerzradius>
        #declare ellcone_B = vaxis_rotate(x,-y,ellcone_B_angle)
        #declare ellcone_Bo = <ellcone_B.x*ellipseconesector_outerxradius,ellipseconesector_height,ellcone_B.z*ellipseconesector_outerzradius>
        #declare ellcone_Bi = <ellcone_B.x*ellipseconesector_innerxradius,0,ellcone_B.z*ellipseconesector_innerzradius>

        #if( ellcone_full_angle<360 & ellcone_i=0 )
          #declare ellcone_Oo = ellcone_Ao
          #declare ellcone_Oi = ellcone_Ai
        #else
          #declare ellcone_O_angle = ellipseconesector_startangle+ellcone_full_angle*(ellcone_i-1)/ellipseconesector_cparts
          #declare ellcone_O = vaxis_rotate(x,-y,ellcone_O_angle)
          #declare ellcone_Oo = <ellcone_O.x*ellipseconesector_outerxradius,ellipseconesector_height,ellcone_O.z*ellipseconesector_outerzradius>
          #declare ellcone_Oi = <ellcone_O.x*ellipseconesector_innerxradius,0,ellcone_O.z*ellipseconesector_innerzradius>
        #end
        // Note: 'ellcone_Oo', 'ellcone_Oi' are the points before 'ellcone_Ao', 'ellcone_Ai'
        #if( ellcone_full_angle<360 & ellcone_i=ellipseconesector_cparts-1 )
          #declare ellcone_Po = ellcone_Bo
          #declare ellcone_Pi = ellcone_Bi
        #else
          #declare ellcone_P_angle = ellipseconesector_startangle+ellcone_full_angle*(ellcone_i+2)/ellipseconesector_cparts
          #declare ellcone_P = vaxis_rotate(x,-y,ellcone_P_angle)
          #declare ellcone_Po = <ellcone_P.x*ellipseconesector_outerxradius,ellipseconesector_height,ellcone_P.z*ellipseconesector_outerzradius>
          #declare ellcone_Pi = <ellcone_P.x*ellipseconesector_innerxradius,0,ellcone_P.z*ellipseconesector_innerzradius>
        #end
        // Note: 'ellcone_Po', 'ellcone_Pi' are the points after 'ellcone_Bo', 'ellcone_Bi'

        // Now calculate the normals of the points for the smooth triangle
        #declare ellcone_N_Ao = vcross(ellcone_Ai-ellcone_Ao,ellcone_Bo-ellcone_Oo)
        #declare ellcone_N_Bo = vcross(ellcone_Bi-ellcone_Bo,ellcone_Po-ellcone_Ao)
        #declare ellcone_N_Ai = vcross(ellcone_Ai-ellcone_Ao,ellcone_Bi-ellcone_Oi)
        #declare ellcone_N_Bi = vcross(ellcone_Bi-ellcone_Bo,ellcone_Pi-ellcone_Ai)

        smooth_triangle
        {
          ellcone_Ao, ellcone_N_Ao,
          ellcone_Bo, ellcone_N_Bo,
          ellcone_Ai, ellcone_N_Ai
        }
        smooth_triangle
        {
          ellcone_Bi, ellcone_N_Bi,
          ellcone_Ai, ellcone_N_Ai,
          ellcone_Bo, ellcone_N_Bo
        }
        #if( ellipseconesector_open=0 )
          triangle
          {
            <0,ellipseconesector_height,0>, ellcone_Ao, ellcone_Bo
          }
          triangle
          {
            <0,0,0>, ellcone_Ai, ellcone_Bi
          }
        #end

        #declare ellcone_i = ellcone_i+1
      #end
      bounded_by
      {
        box
        {
          <-ellipseconesector_outerxradius*1.001,-0.001,-ellipseconesector_outerzradius*1.001>,
          <ellipseconesector_outerxradius*1.001,1.001,ellipseconesector_outerzradius*1.001>
        }
      }
    }
  #else
    #declare EllipseConeSector = cone
    {
      <0,ellipseconesector_height,0>, ellipseconesector_outerxradius,
      <0,0,0>, ellipseconesector_innerxradius
      #if( ellipseconesector_open!=0 )
        open
      #end
    }
  #end
#else
  #declare EllipseConeSector = sphere
  {
    <0,0,0>, 0
  }
#end
