/*
  EllipseLamps

  (c) copyright Roman Komary July.1998

  POVRAY 3.0
*/


/*
  Lamps are torus sectors lying in the x-z-plane started at the positive z-point
*/


/*
  Input Variables it needs:
    ellipselamps_xradius
    ellipselamps_zradius
    ellipselamps_thickness         // inner radius of a torus sector * 2
    ellipselamps_count             // number of lamps to do (beginning at the top)
    ellipselamps_spacing           // distances between lamps in percent (0 = no distance, 1 = no lamps)
    ellipselamps_istart            //
    ellipselamps_iend              // these 2 variables define, which is the starting and ending index to draw. If one is -1 -> all lamps will be drawn
    ellipselamps_beginwithlamp     // 1 = on top a lamp will be drawn, 0 = on top a spacing will be drawn

  Output Object:
    EllipseLamps
*/


#if( ellipselamps_istart<0 | ellipselamps_iend<0 )
  #declare ellipselamps_istart = 0
  #declare ellipselamps_iend = ellipselamps_count-1
#end
#if( ellipselamps_istart>=ellipselamps_count )
  #declare ellipselamps_istart = ellipselamps_count-1
#end
#if( ellipselamps_iend>=ellipselamps_count )
  #declare ellipselamps_iend = ellipselamps_count-1
#end

#if( ellipselamps_istart<=ellipselamps_iend )
  #declare ellamps1_istart = ellipselamps_istart
  #declare ellamps1_iend = ellipselamps_iend
#else
  #declare ellamps1_istart = 0
  #declare ellamps1_iend = ellipselamps_count-1
#end

#declare EllipseLamps = union
{
  #declare ellamps1_i = ellamps1_istart
  #while( ellamps1_i<=ellamps1_iend )
    object
    {
      #declare ellipsetorussector_major_xradius = ellipselamps_xradius
      #declare ellipsetorussector_major_zradius = ellipselamps_zradius
      #declare ellipsetorussector_minor_radius = ellipselamps_thickness/2
      #declare ellipsetorussector_startangle = -(180/ellipselamps_count)*(1-ellipselamps_spacing)
      #declare ellipsetorussector_endangle = -ellipsetorussector_startangle
      #declare ellipsetorussector_cparts = int(200/ellipselamps_count)+2
      #declare angleamount = 360*ellamps1_i/ellipselamps_count
      #if( ellipselamps_beginwithlamp=0 )
        #declare angleamount = angleamount+180/ellipselamps_count
      #end
      #declare ellipsetorussector_startangle = -90-(angleamount+ellipsetorussector_startangle)
      #declare ellipsetorussector_endangle = -90-(angleamount+ellipsetorussector_endangle)
      #include "elltorus.pov"
      EllipseTorusSector
    }
    #declare ellamps1_i = ellamps1_i+1
  #end
  rotate <0,180,0>
}
