/*
  ConeSector

  (c) copyright Roman Komary July.1998

  POVRAY 3.0
*/


/*
  The ConeSector will be created with the circle with the inner radius lying in the
  x-z-plane. The circle with the outer radius will lie in a plane parallel to the
  x-z-plane with y=1.

  Input Varaibles:
    conesector_outerradius
    conesector_innerradius
    conesector_startangle       // 0 degrees is parallel the x-axe
    conesector_endangle         // the endangle cannot be larger than startangle+180 degrees and it must be greater than startangle as well
    conesector_open             // 1 = open, 0 = not open

  Output Object:
    ConeSector
*/


#declare ConeSector = intersection
{
  cone
  {
    <0,0,0>, conesector_innerradius,
    <0,1,0>, conesector_outerradius
    #if( conesector_open!=0 )
      open
    #end
  }
  plane
  {
    <0,0,-1>,0
    rotate <0,-conesector_startangle,0>
  }
  plane
  {
    <0,0,1>,0
    rotate <0,-conesector_endangle,0>
  }
}
