/*
  Boxes for PlugIn for ModPlug and WinAmp

  (c) copyright Roman Komary

  POVRAY 3.0
*/


#declare DRAW_AS_MASK = 1
// This will cause a white background and all objects are black.
// Note: For this, you should disable anti-alias rendering.

#declare DRAW_3WAY_BOX = 0
#declare DRAW_BIGWOOFER_BOX = 0
#declare DRAW_SLIDER_BOX = 0
#declare DRAW_SUBWOOFER_BOX = 0
#declare DRAW_LIGHTORGAN = 0
#declare DRAW_ORGAN = 1

#declare DRAW_3WAY_TWEETER = 1
#declare DRAW_3WAY_TWEETER_MAGNET = 1
#declare DRAW_3WAY_TWEETER_RING = 1
#declare DRAW_3WAY_TWEETER_LAMPS = 0
#declare DRAW_3WAY_MEDIUM = 1
#declare DRAW_3WAY_MEDIUM_MAGNET = 1
#declare DRAW_3WAY_MEDIUM_RING = 1
#declare DRAW_3WAY_MEDIUM_LAMPS = 0
#declare DRAW_3WAY_WOOFER = 1
#declare DRAW_3WAY_WOOFER_MAGNET = 1
#declare DRAW_3WAY_WOOFER_RING = 1
#declare DRAW_3WAY_WOOFER_LAMPS = 0
#declare DRAW_3WAY_HIGHPART = 1
#declare DRAW_3WAY_LOWPART = 1
#declare DRAW_3WAY_CASE = 1
#declare DRAW_3WAY_CASE_LEFT_LAMPS = 0
#declare DRAW_3WAY_CASE_RIGHT_LAMPS = 0
#declare ANIM_3WAY_CASE_LAMPS = 0
// Note: If you anim one of the case lamps, the .ini file should generate
// as many images as 'CASE_LAMPS_CSTRIPS'.

#declare DRAW_BIGWF_SPEAKER = 1
#declare DRAW_BIGWF_SPEAKER_MAGNET = 1
#declare DRAW_BIGWF_SPEAKER_RING = 1
#declare DRAW_BIGWF_SPEAKER_LAMPS = 0
#declare DRAW_BIGWF_PART = 0
#declare DRAW_BIGWF_CASE = 0

#declare DRAW_SUBWF_SPEAKER = 1
#declare DRAW_SUBWF_SPEAKER_MAGNET = 0
#declare DRAW_SUBWF_SPEAKER_RING = 1
#declare DRAW_SUBWF_PART = 1
#declare DRAW_SUBWF_CASE = 1

#declare DRAW_LTORG_CASE = 1

#declare DRAW_ORG_CASE = 1
#declare DRAW_ORG_LEFT = 1      // 0 = draw left organ, 1 = draw right organ
#declare DRAW_ORG_MASKS = 0
#declare DRAW_ORG_MAINCYL = 1
#declare DRAW_ORG_CONE = 1
#declare DRAW_ORG_CONE2 = 1
#declare DRAW_ORG_MAINCASE = 0

#declare ANIM_3WAY_SPK_LAMPS = 0
#declare ANIM_BIGWF_SPK_LAMPS = 0
// Note: If you anim the lamps of the speakers, the .ini file should generate
// as many images as 'TWEETERLAMPS_COUNT' (if tweeter to draw), etc.

#declare DRAW_SLIDER_CASE = 1

#declare DRAW_LAMPS_ON = 1

#declare DRAW_BLACK_BKGND = 0
#declare DRAW_DARK_RINGS = 0

#declare ANIM_MAGNET = 0
#declare MAX_MAGNET_FRAMES = 4

// ------------------------------------------
// ModPlug normal size:
// (for this, generate a 320*240 image)
#declare WORLD_SCALE = 0.85
#declare WORLD_ZOFS = 0
// ------------------------------------------
// WinAmp normal and double size:
// (for normal size, generate a 320*240 image, for double size generate a 640*480 image)
// Note: Set the WORLD_ZOFS to non-zero only if generating an image for the left or
// right side of the WinAmp window. Otherwise use the WORLD_ZOFS above (which is set to 0).
//  normal size:
//#declare WORLD_SCALE = 0.715
//#declare WORLD_ZOFS = 0.021
//  double size:
//#declare WORLD_SCALE = 0.718
//#declare WORLD_ZOFS = 0.01
// ------------------------------------------


// ------------------------------------------
// Define the aspect ration if you do not use a 4/3 aspect ratio
// (ie. for the SubWoofer ini file).
// For default ratio, mark out the declaration.
//#declare ASPECT_RATIO = 400/240
// ------------------------------------------


// ++++++++++++++++++++++++++++++++++++++++++


#if( ANIM_MAGNET!=0 )
  #declare EXPAND_SPEAKERS = 0.99*clock/(MAX_MAGNET_FRAMES-1)
  // 'EXPAND_SPEAKERS' :
  //  How much to scale the speakers. Should be between -1 and 1. 0 = normal size
  //  The 4 steps I chose were 0, 0.33, 0.66 and 0.99
#else
  #declare EXPAND_SPEAKERS = 0
#end

#declare ROTATE_SCENE = <0,0,0>
//#declare ROTATE_SCENE = <20,0,30>

// for all 3 Speakers of the 3Way-Box
#declare SPK3WAY_MAGNETNESTEDANGLE = 35
#declare SPK3WAY_RING_DEPTH = 0.075
#declare SPK3WAY_LAMPS_THICKSCALE = 0.1
#declare SPKBIGWF_MAGNETNESTEDANGLE = SPK3WAY_MAGNETNESTEDANGLE
#declare SPKBIGWF_RING_DEPTH = SPK3WAY_RING_DEPTH
#declare SPKBIGWF_LAMPS_THICKSCALE = SPK3WAY_LAMPS_THICKSCALE
#declare SPKSUBWF_MAGNETNESTEDANGLE = 35
#declare SPKSUBWF_RING_DEPTH = 0.075
// 3Way-Box Tweeter
#declare TWEETERMAGNET_OUTERRAD = 0.3
#declare TWEETERMAGNET_INNERRAD = TWEETERMAGNET_OUTERRAD*0.75
#declare TWEETERMAGNET_FIXINGRAD = TWEETERMAGNET_OUTERRAD*0.08
#declare TWEETERMAGNET_HEIGHT = TWEETERMAGNET_OUTERRAD*0.12
#declare TWEETERMAGNET_NESTEDSPHEREANGLE = SPK3WAY_MAGNETNESTEDANGLE
#declare TWEETERHOLE_INNERRAD = TWEETERMAGNET_OUTERRAD+TWEETERMAGNET_FIXINGRAD
#declare TWEETERHOLE_OUTERRAD = TWEETERHOLE_INNERRAD+0.1
#declare TWEETERRING_OUTERRAD = TWEETERHOLE_INNERRAD+0.25
#declare TWEETERRING_DEPTH = SPK3WAY_RING_DEPTH+1.0*TWEETERMAGNET_FIXINGRAD
#declare TWEETERHOLE_DEPTH = TWEETERRING_DEPTH+0.5
#declare TWEETERVIBRATOR_YOFS = TWEETERRING_DEPTH
//#declare TWEETERLAMPS_THICKNESS = 0.075
//#declare TWEETERLAMPS_RADIUS = TWEETERHOLE_OUTERRAD+TWEETERLAMPS_THICKNESS/2
#declare TWEETERLAMPS_THICKNESS = 0.11
#declare TWEETERLAMPS_RADIUS = TWEETERHOLE_OUTERRAD+TWEETERLAMPS_THICKNESS*0.4
#declare TWEETERLAMPS_COUNT = 12
#declare TWEETERLAMPS_SPACING = 0.25
#declare TWEETER_MAXEXPAND = 0.25
// 3Way-Box Medium
#declare MEDIUMMAGNET_OUTERRAD = 0.5
#declare MEDIUMMAGNET_INNERRAD = MEDIUMMAGNET_OUTERRAD*0.5
#declare MEDIUMMAGNET_FIXINGRAD = MEDIUMMAGNET_OUTERRAD*0.075
#declare MEDIUMMAGNET_HEIGHT = MEDIUMMAGNET_OUTERRAD*0.21
#declare MEDIUMMAGNET_NESTEDSPHEREANGLE = SPK3WAY_MAGNETNESTEDANGLE
#declare MEDIUMHOLE_INNERRAD = MEDIUMMAGNET_OUTERRAD+MEDIUMMAGNET_FIXINGRAD
#declare MEDIUMHOLE_OUTERRAD = MEDIUMHOLE_INNERRAD+0.1
#declare MEDIUMRING_OUTERRAD = MEDIUMHOLE_INNERRAD+0.26
#declare MEDIUMRING_DEPTH = SPK3WAY_RING_DEPTH+1.25*MEDIUMMAGNET_FIXINGRAD
#declare MEDIUMHOLE_DEPTH = MEDIUMRING_DEPTH+0.5
#declare MEDIUMVIBRATOR_YOFS = MEDIUMRING_DEPTH
//#declare MEDIUMLAMPS_THICKNESS = 0.075
//#declare MEDIUMLAMPS_RADIUS = MEDIUMHOLE_OUTERRAD+MEDIUMLAMPS_THICKNESS/2
#declare MEDIUMLAMPS_THICKNESS = 0.11
#declare MEDIUMLAMPS_RADIUS = MEDIUMHOLE_OUTERRAD+MEDIUMLAMPS_THICKNESS*0.4
#declare MEDIUMLAMPS_COUNT = 16
#declare MEDIUMLAMPS_SPACING = 0.2
#declare MEDIUM_MAXEXPAND = 0.2
// 3Way-Box Woofer
#declare WOOFERMAGNET_OUTERRAD = 1.25
#declare WOOFERMAGNET_INNERRAD = WOOFERMAGNET_OUTERRAD*0.47
#declare WOOFERMAGNET_FIXINGRAD = WOOFERMAGNET_OUTERRAD*0.075
#declare WOOFERMAGNET_HEIGHT = WOOFERMAGNET_OUTERRAD*0.26
#declare WOOFERMAGNET_NESTEDSPHEREANGLE = SPK3WAY_MAGNETNESTEDANGLE
#declare WOOFERHOLE_INNERRAD = WOOFERMAGNET_OUTERRAD+WOOFERMAGNET_FIXINGRAD
#declare WOOFERHOLE_OUTERRAD = WOOFERHOLE_INNERRAD+0.1
#declare WOOFERRING_OUTERRAD = WOOFERHOLE_INNERRAD+0.3
#declare WOOFERRING_DEPTH = SPK3WAY_RING_DEPTH+1.75*WOOFERMAGNET_FIXINGRAD
#declare WOOFERHOLE_DEPTH = WOOFERRING_DEPTH+0.5
#declare WOOFERVIBRATOR_YOFS = WOOFERRING_DEPTH
//#declare WOOFERLAMPS_THICKNESS = 0.09
//#declare WOOFERLAMPS_RADIUS = WOOFERHOLE_OUTERRAD+WOOFERLAMPS_THICKNESS/2
#declare WOOFERLAMPS_THICKNESS = 0.115
#declare WOOFERLAMPS_RADIUS = WOOFERHOLE_OUTERRAD+WOOFERLAMPS_THICKNESS*0.4
#declare WOOFERLAMPS_COUNT = 16
#declare WOOFERLAMPS_SPACING = 0.15
#declare WOOFER_MAXEXPAND = 0.15
// 3Way-Box High-Part (containing Tweeter and Medium)
#declare HIGHPART_TWEETER_MEDIUM_DISTOFS = -0.75*min( TWEETERRING_OUTERRAD-TWEETERHOLE_OUTERRAD, MEDIUMRING_OUTERRAD-MEDIUMHOLE_OUTERRAD )
#declare HIGHPART_TOP_DIST = 0.1
#declare HIGHPART_BOTTOM_DIST = 0.1
#declare HIGHPART_LEFTRIGHT_DIST = 0.2    // these 3 values are the distances to the speaker (its ring)
#declare HIGHPART_CYL_XRAD = 1.2
#declare HIGHPART_CYL_YRAD = 0.84
#declare HIGHPART_TWEETERCUTCONE_SCALE = < 2.4, 0.4, 1.14 >
#declare HIGHPART_MEDIUMCUTCONE_SCALE = < 4.3, 0.4, 1.1 >
#declare DRAW_HIGHPART_CUTCONES = 0
#declare HIGHPART_SCREW_RAD = 0.13
#declare HIGHPART_SCREW_XDIST = 0.12
#declare HIGHPART_SCREW_TOPDIST = 0.12
#declare HIGHPART_SCREW_BOTTOMDIST = 0.06
#declare HIGHPART_SPEAKER_NESTEDDEPTH = 0.1
// 3Way-Box Low-Part (containing Woofer)
#declare LOWPART_TOP_DIST = 0.15
#declare LOWPART_BOTTOM_DIST = 0.15
#declare LOWPART_LEFTRIGHT_DIST = 0.25    // these 3 values are the distances to the speaker (its ring)
#declare LOWPART_CYL_XRAD = 2.3
#declare LOWPART_CYL_YRAD = 1.7
#declare LOWPART_CUTCYL_XRAD = 4
#declare LOWPART_SCREW_RAD = 0.13
#declare LOWPART_SCREW_XDIST = 0.25
#declare LOWPART_SCREW_ZDIST = 0.32
#declare LOWPART_SPEAKER_NESTEDDEPTH = 0.3
#declare LOWPART_YMOVE = -0.02
// 3Way-Box Case
#declare CASE_TOP_DIST = 0.2
#declare CASE_BOTTOM_DIST = 0.3
#declare CASE_LEFTRIGHT_DIST = 0.3    // these 3 values are the distances from the part's borders to the case's borders
#declare CASE_FRONT_YOFS = 0.4
#declare CASE_DEPTH = 4
#declare CASE_CUTROUND_XDIST = CASE_LEFTRIGHT_DIST+0.4
#declare CASE_CUTROUND_XSCALE = 1.4
#declare CASE_HOLE_TOP_DIST = 0.85
#declare CASE_HOLE_BOTTOM_DIST = CASE_BOTTOM_DIST-0.1
#declare CASE_HOLE_LEFTRIGHT_DIST = CASE_LEFTRIGHT_DIST   // these 3 values are the distances of the hole's borders to the case's borders
#declare CASE_HOLE_DEPTH = 1
#declare CASE_HOLE_TEXTURE_DEPTH = 0.5  // the depth of the black object
#declare CASE_LAMPS_RELWIDTH = 0.6
#declare CASE_LAMPS_RELHEIGHT = 0.72
#declare CASE_LAMPS_RELZOFS = -0.06
#declare CASE_LAMPS_DEPTH = 0.2
#declare CASE_LAMPS_ENDHEIGHT = 0.3
#declare CASE_LAMPS_SHEAR = -0.07
//#declare CASE_LAMPS_CSTRIPS = 12
#declare CASE_LAMPS_CSTRIPS = 10
#declare CASE_LAMPS_RELSTRIPTHICKNESS = 0.7
// BigWoofer-Box Speaker
#declare BIGWFSPKMAGNET_OUTERXRAD = 1.125
#declare BIGWFSPKMAGNET_OUTERZRAD = 2
#declare BIGWFSPKMAGNET_INNERRAD = BIGWFSPKMAGNET_OUTERXRAD*0.55
#declare BIGWFSPKMAGNET_FIXINGRAD = BIGWFSPKMAGNET_OUTERXRAD*0.075
#declare BIGWFSPKMAGNET_HEIGHT = ((BIGWFSPKMAGNET_OUTERXRAD+BIGWFSPKMAGNET_OUTERZRAD)/2)*0.3
#declare BIGWFSPKMAGNET_NESTEDSPHEREANGLE = SPKBIGWF_MAGNETNESTEDANGLE
#declare BIGWFSPKHOLE_INNERXRAD = BIGWFSPKMAGNET_OUTERXRAD+BIGWFSPKMAGNET_FIXINGRAD
#declare BIGWFSPKHOLE_INNERZRAD = BIGWFSPKMAGNET_OUTERZRAD+BIGWFSPKMAGNET_FIXINGRAD
#declare BIGWFSPKHOLE_OUTERXRAD = BIGWFSPKHOLE_INNERXRAD+0.1
#declare BIGWFSPKHOLE_OUTERZRAD = BIGWFSPKHOLE_INNERZRAD+0.1
#declare BIGWFSPKRING_OUTERXRAD = BIGWFSPKHOLE_INNERXRAD+0.3
#declare BIGWFSPKRING_OUTERZRAD = BIGWFSPKHOLE_INNERZRAD+0.3
#declare BIGWFSPKRING_DEPTH = SPKBIGWF_RING_DEPTH+1.75*BIGWFSPKMAGNET_FIXINGRAD
#declare BIGWFSPKHOLE_DEPTH = BIGWFSPKRING_DEPTH+0.5
#declare BIGWFSPKVIBRATOR_YOFS = BIGWFSPKRING_DEPTH
//#declare BIGWFSPKLAMPS_THICKNESS = 0.09
#declare BIGWFSPKLAMPS_THICKNESS = 0.115
#declare BIGWFSPKLAMPS_XRADIUS = BIGWFSPKHOLE_OUTERXRAD+BIGWFSPKLAMPS_THICKNESS/2
#declare BIGWFSPKLAMPS_ZRADIUS = BIGWFSPKHOLE_OUTERZRAD+BIGWFSPKLAMPS_THICKNESS/2
#declare BIGWFSPKLAMPS_COUNT = 16
#declare BIGWFSPKLAMPS_SPACING = 0.15
#declare BIGWFSPK_MAXEXPAND = 0.12
// BigWoofer-Box Part (containing the Speaker)
#declare BIGWFPART_TOP_DIST = 0.15
#declare BIGWFPART_BOTTOM_DIST = 0.15
#declare BIGWFPART_LEFTRIGHT_DIST = 0.25    // these 3 values are the distances to the speaker (its ring)
#declare BIGWFPART_CYL_XRAD = 1.9
#declare BIGWFPART_CYL_YRAD = 1.4
#declare BIGWFPART_CUTCYL_XRAD = 4
#declare BIGWFPART_SCREW_RAD = 0.13
#declare BIGWFPART_SCREW_XDIST = 0.23
#declare BIGWFPART_SCREW_ZDIST = 0.34
#declare BIGWFPART_SPEAKER_NESTEDDEPTH = LOWPART_SPEAKER_NESTEDDEPTH
#declare BIGWFPART_YMOVE = LOWPART_YMOVE
// BigWoofer-Box Case
#declare BIGWFCASE_LEFTRIGHT_DIST = CASE_LEFTRIGHT_DIST   // this is the distances (left and right) from the part's borders to the case's borders
#declare BIGWFCASE_FRONT_YOFS = CASE_FRONT_YOFS
#declare BIGWFCASE_DEPTH = CASE_DEPTH
#declare BIGWFCASE_CUTROUND_XDIST = BIGWFCASE_LEFTRIGHT_DIST+0.4
#declare BIGWFCASE_CUTROUND_XSCALE = 1.5
#declare BIGWFCASE_HOLE_TOP_DISTOFS = 0.1
#declare BIGWFCASE_HOLE_BOTTOM_DISTOFS = BIGWFCASE_HOLE_TOP_DISTOFS
#declare BIGWFCASE_HOLE_LEFTRIGHT_DIST = BIGWFCASE_LEFTRIGHT_DIST   // this is the distances (left and right) of the hole's borders to the case's borders
#declare BIGWFCASE_HOLE_DEPTH = CASE_HOLE_DEPTH
#declare BIGWFCASE_HOLE_TEXTURE_DEPTH = CASE_HOLE_TEXTURE_DEPTH   // the depth of the black object
#declare BIGWFCASE_DENTCYL_RAD = 0.17
#declare BIGWFCASE_DENTCYL_THICKNESS = 0.07
#declare BIGWFCASE_DENTCYL_XDIST = 0.18
#declare BIGWFCASE_DENTCYL_ZDIST = 0.18
#declare BIGWFCASE_CDENTCYLS = 10
// Slider-Box Case
#declare SLIDERCASE_FRONT_YOFS = CASE_FRONT_YOFS
#declare SLIDERCASE_DEPTH = CASE_DEPTH
#declare SLIDERCASE_HOLE_LEFTRIGHT_DIST = 0.2
#declare SLIDERCASE_HOLE_TOP_DIST = 1
#declare SLIDERCASE_HOLE_BOTTOM_DIST = 0.4  // these 3 values are the distances of the hole's borders to the case's borders
#declare SLIDERCASE_HOLE_WIDTH = 1
#declare SLIDERCASE_HOLE_ROUNDRAD = 0.12
#declare SLIDERCASE_CUTROUND_XDIST = SLIDERCASE_HOLE_LEFTRIGHT_DIST+0.24
#declare SLIDERCASE_CUTCYL_XRAD = 0.08+(SLIDERCASE_HOLE_WIDTH+2*SLIDERCASE_HOLE_LEFTRIGHT_DIST)/2
#declare SLIDERCASE_CUTCYL_YRAD = 0.35
// SubWoofer
#declare SUBWF_SCALE_FACTOR = 1.5
// SubWoofer-Box Speaker
#declare SUBWFMAGNET_OUTERRAD = 1.25*SUBWF_SCALE_FACTOR
#declare SUBWFMAGNET_INNERRAD = SUBWFMAGNET_OUTERRAD*0.47
#declare SUBWFMAGNET_FIXINGRAD = SUBWFMAGNET_OUTERRAD*0.075
#declare SUBWFMAGNET_HEIGHT = SUBWFMAGNET_OUTERRAD*0.26
#declare SUBWFMAGNET_NESTEDSPHEREANGLE = SPKSUBWF_MAGNETNESTEDANGLE
#declare SUBWFHOLE_INNERRAD = SUBWFMAGNET_OUTERRAD+SUBWFMAGNET_FIXINGRAD
#declare SUBWFHOLE_OUTERRAD = SUBWFHOLE_INNERRAD+0.1
#declare SUBWFRING_OUTERRAD = SUBWFHOLE_INNERRAD+0.3
#declare SUBWFRING_DEPTH = SPKSUBWF_RING_DEPTH+1.75*SUBWFMAGNET_FIXINGRAD
#declare SUBWFHOLE_DEPTH = SUBWFRING_DEPTH+0.5
#declare SUBWFVIBRATOR_YOFS = SUBWFRING_DEPTH
#declare SUBWF_MAXEXPAND = 0.15
// SubWoofer-Box Part (containing the Speaker)
#declare SUBWFPART_LEFT_DIST = 0.15
#declare SUBWFPART_RIGHT_DIST = 0.15
#declare SUBWFPART_TOPBOTTOM_DIST = 0.25    // these 3 values are the distances to the speaker (its ring)
#declare SUBWFPART_CYL_ZRAD = 2.3*SUBWF_SCALE_FACTOR
#declare SUBWFPART_CYL_YRAD = 1.7*SUBWF_SCALE_FACTOR
#declare SUBWFPART_CUTCYL_ZRAD = 3.3*SUBWF_SCALE_FACTOR
#declare SUBWFPART_SCREW_RAD = 0.1*SUBWF_SCALE_FACTOR
#declare SUBWFPART_SCREW_XDIST = 0.32*SUBWF_SCALE_FACTOR
#declare SUBWFPART_SCREW_ZDIST = 0.2*SUBWF_SCALE_FACTOR
#declare SUBWFPARTHOLE_WIDTH = 0.6*SUBWF_SCALE_FACTOR
#declare SUBWFPARTHOLE_HEIGHT = 2*SUBWF_SCALE_FACTOR
#declare SUBWFPARTHOLE_ROUNDRAD = 0.2*SUBWF_SCALE_FACTOR
#declare SUBWFPARTHOLE_CYL_SCALE = 0.7
#declare SUBWFPARTHOLE_ZDIST = 0.3*SUBWF_SCALE_FACTOR
#declare SUBWFPARTHOLE_OUTERXDIST = 0.1*SUBWF_SCALE_FACTOR
#declare SUBWFPARTHOLE_INNERXDIST = 0.05*SUBWF_SCALE_FACTOR
#declare SUBWFPARTHOLE_INNERROUNDRAD = 0.2*SUBWF_SCALE_FACTOR
#declare SUBWFPART_SPEAKER_NESTEDDEPTH = 0.3*SUBWF_SCALE_FACTOR
#declare SUBWFPART_YMOVE = -0.02*SUBWF_SCALE_FACTOR
// SubWoofer-Box Case
#declare SUBWFCASE_LEFTRIGHT_DIST = 0.2
#declare SUBWFCASE_TOPBOTTOM_DIST = 0.3    // these 2 values are a distances from the part's borders to the case's borders
#declare SUBWFCASE_FRONT_YOFS = 0.4
#declare SUBWFCASE_DEPTH = 4
#declare SUBWFCASE_CUTROUND_ZDIST = (SUBWFCASE_TOPBOTTOM_DIST+0.4)*SUBWF_SCALE_FACTOR
#declare SUBWFCASE_CUTROUND_ZSCALE = 1.4
#declare SUBWFCASE_HOLE_TOPBOTTOM_DIST = SUBWFCASE_TOPBOTTOM_DIST   // this value is the distance of the hole's borders to the case's borders
#declare SUBWFCASE_HOLE_CUTCYL_SCALE = 1.14
#declare SUBWFCASE_HOLE_DEPTH = 1
#declare SUBWFCASES_XDIST = 0.3*SUBWF_SCALE_FACTOR
#declare SUBWFCASES_WIDTH = 3*SUBWF_SCALE_FACTOR
#declare SUBWFCASES_HEIGHT = 3*SUBWF_SCALE_FACTOR
#declare SUBWFCASES_HUGEHOLE_XDIST = 0.3
#declare SUBWFCASES_HUGEHOLE_ZDIST = 0.2
#declare SUBWFCASES_HUGEHOLE_ROUNDRAD = 0.16*SUBWF_SCALE_FACTOR
// LightOrgan
#declare LTORG_SCALE_FACTOR = 0.8
// LightOrgan Case
#declare LTORGCASE_RAD = 0.6*LTORG_SCALE_FACTOR
#declare LTORGCASE_WIDTH = 6*LTORG_SCALE_FACTOR
#declare LTORGCASERING_RAD = 0.2*LTORG_SCALE_FACTOR
#declare LTORGCASERING_BIGRAD = 0.3*LTORG_SCALE_FACTOR
#declare LTORGCASERING_COUNT = 11
#declare LTORGCASE_HOLE_LEFTRIGHT_DIST = 0.1*LTORG_SCALE_FACTOR
#declare LTORGCASE_HOLE_TOPBOTTOM_DIST = 0.13*LTORG_SCALE_FACTOR
#declare LTORGCASE_HOLE_DEPTH = 0.5   // 1 = full depth, 0 = no depth
// Organ
#declare ORG_SCALE_FACTOR = 1
// Organ Case
#declare ORGCASE_CYL_RAD = 2.1*ORG_SCALE_FACTOR
#declare ORGCASE_CYL_HEIGHT = 1.2*ORG_SCALE_FACTOR
#declare ORGCASE_CONE_OUTERRAD = 0.8*ORG_SCALE_FACTOR
#declare ORGCASE_CONE_INNERRAD = 0.46*ORG_SCALE_FACTOR
#declare ORGCASE_CONE_HEIGHT = 2.4*ORG_SCALE_FACTOR
#declare ORGCASE_CONE_ANGLE = -19
#declare ORGCASE_CONE2_ANGLE = ORGCASE_CONE_ANGLE-38
#declare ORGCASE_CONE_HOLE_BORDERDIST = 0.08*ORG_SCALE_FACTOR
#declare ORGCASE_BOX_WIDTHANGLE = 45
#declare ORGCASE_BOX_STARTANGLE = 2
#declare ORGCASE_BOX_RAD = 3.2*ORG_SCALE_FACTOR
#declare ORGCASE_BOX_HEIGHT = 1.375*ORG_SCALE_FACTOR
#declare ORGCASE_BOX_DEPTH = 0.3*ORG_SCALE_FACTOR
#declare ORGCASE_BOX_BORDERWIDTH = 0.2*ORG_SCALE_FACTOR
#declare ORGCASE_BOX_CHORZPARTS = 5
#declare ORGCASE_BOX_CVERTPARTS = 3
#declare ORGCASE_BOX_XPARTSCALE = 0.4     // must be in range 0.0 to 1.0
#declare ORGCASE_BOX_YPARTSCALE = 0.64    // must be in range 0.0 to 1.0
#declare ORGCASE_BOX_INNERPARTDEPTH = ORGCASE_BOX_DEPTH-0.05*ORG_SCALE_FACTOR
#declare ORGCASE_BOX_FIREDEPTH = ORGCASE_BOX_DEPTH*0.25
#declare ORGCASE_HEIGHT = 1.3*ORG_SCALE_FACTOR
#declare ORGCASE_WIDTH = 2.2*ORG_SCALE_FACTOR
#declare ORGCASE_DEPTH = 2*ORG_SCALE_FACTOR
#declare ORGCASE_XOFS = 0
#declare ORGCASE_YOFS = -2.7*ORG_SCALE_FACTOR
#declare ORG_CYL_ZRAD = 2.0*ORG_SCALE_FACTOR
#declare ORG_CYL_YRAD = 1.7*ORG_SCALE_FACTOR
#declare ORG_CUTROUND_ZDIST = 0.3*ORG_SCALE_FACTOR
#declare ORG_CUTROUND_ZSCALE = 1.4
#declare ORG_HOLE_LEFTDIST = 0.3*ORG_SCALE_FACTOR
#declare ORG_HOLE_RIGHTDIST = 0.3*ORG_SCALE_FACTOR
#declare ORG_HOLE_ZDIST = 0.1*ORG_SCALE_FACTOR
#declare ORG_HOLE_DEPTH = 0.4*ORG_SCALE_FACTOR
#declare ORG_HOLECUTCYL_RAD = 1.1*ORGCASE_HEIGHT/2
#declare ORG_SPHERE_RAD = ORGCASE_HEIGHT*0.7
#declare ORG_SPHERE_YRAD = ORG_SPHERE_RAD*0.5
#declare ORG_SPHERE_YOFS = -0.32*ORG_SCALE_FACTOR
#declare ORG_SPHERE_YCUT = 0.05*ORG_SCALE_FACTOR
#declare ORG_SPHERE_XMOVE = 0*ORG_SCALE_FACTOR


global_settings
{
  adc_bailout 0.003922
  #if( DRAW_AS_MASK=0 )
  ambient_light <1.0,1.0,1.0>
  #else
  ambient_light <0,0,0>
  #end
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity
  {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


/* ---- Textures ---- */


#declare TBlack = texture
{
  pigment
  {
    color rgb 0
  }
  finish
  {
    ambient 0
    diffuse 0
  }
}

#declare TWhite = texture
{
  pigment
  {
    color rgb 1
  }
  finish
  {
    ambient 1
    diffuse 0
  }
}

#declare TDkGray = texture
{
  pigment
  {
    color rgb 0.1
  }
  finish
  {
    ambient 1
    diffuse 0
  }
}

#declare TRing = texture
{
  #if( DRAW_DARK_RINGS=0 )
  pigment
  {
    color rgb <0.1,0.1,0.12>*0.4
  }
  finish
  {
    ambient 0.0
    diffuse 1
    brilliance 2.75
    //specular 0.2
    //roughness 0.02
    //specular 0.3
    //roughness 0.03
    specular 0.22
    roughness 0.024
    reflection 0.0
  }
  #else
  #if( DRAW_BLACK_BKGND=0 )
  TDkGray
  #else
  TBlack
  #end
  #end
}

#declare TTweeter_Ring = texture
{
  TRing
}

#declare TMedium_Ring = texture
{
  TRing
}

#declare TWoofer_Ring = texture
{
  TRing
}

#declare TBigWoofer_Ring = texture
{
  TRing
}

#declare TSubWf_Speaker_Ring = texture
{
  TRing
}

#declare TLamps_Off = texture
{
  pigment
  {
    color rgb <0.09,0.06,0.1>*1.2
  }
  finish
  {
    ambient 0.55
    diffuse 0.3
    brilliance 1
    reflection 0.0
  }
}

#declare TLamps = texture
{
  #if( DRAW_LAMPS_ON!=0 )
  /*
  pigment
  {
    color rgb <1,1,0>
  }
  finish
  {
    ambient 1
    diffuse 0
  }
  */
  TWhite
  #else
  TLamps_Off
  #end
}

#declare TAPart = texture
{
  pigment
  {
    //color rgb <0.1,0.1,0.1>*2
    //color rgb <0.1,0.1,0.1>*1
    //wood
    onion
    turbulence 1.2
    color_map
    {
      //[0.0    color rgb <0.1,0.1,0.1>*1]
      //[1.0    color rgb <0.1,0.1,0.1>*0.8]
      [0.0    color rgb 3.9*<0.1,0.1,0.1>*1]
      [1.0    color rgb 3.9*<0.1,0.1,0.1>*0.75]
    }
    triangle_wave
    scale 0.8
    rotate 20*y
    rotate -5*x
  }
  finish
  {
    ambient 0.0
    diffuse 1
    //brilliance 1.2
    //brilliance 1.5
    brilliance 2.9
    //specular 0.6
    //roughness 0.01
    specular 1
    //roughness 0.008
    roughness 0.003
    reflection 0.0
    metallic
  }
}

#declare THighPart = texture
{
  TAPart
}

#declare TLowPart = texture
{
  TAPart
}

#declare TBigWfPart = texture
{
  TAPart
}

#declare PSubWfPart = pigment
{
  onion
  turbulence 1.2
  color_map
  {
    [0.0    color rgb 0.8*<0.1,0.1,0.1>*1]
    [1.0    color rgb 0.8*<0.1,0.1,0.1>*0.75]
  }
  triangle_wave
  scale 0.8
  rotate 20*y
  rotate -5*x
  rotate -90*y
}

#declare TSubWfPart = texture
{
  pigment { PSubWfPart }
  finish
  {
    ambient 0.8
    diffuse 0.8
    brilliance 1
    //specular 10
    //roughness 0.0022
    specular 6
    roughness 0.002
    reflection 0.0
    metallic
  }
}

#declare TCase = texture
{
  TAPart
}

#declare TCase_OuterHole = texture
{
  TCase
}

#declare TCase_InnerHole = texture
{
  TBlack
}

#declare TBigWfCase = texture
{
  TAPart
}

#declare TBigWfCase_OuterHole = texture
{
  TBigWfCase
}

#declare TBigWfCase_InnerHole = texture
{
  TBlack
}

#declare TBigWfCase_DentCyls = texture
{
  TBlack
}

#declare TSubWfCase = texture
{
  pigment { PSubWfPart }
  finish
  {
    ambient 0.7
    diffuse 0.8
    brilliance 1
    //specular 10
    //roughness 0.0022
    specular 3
    roughness 0.006
    reflection 0.0
    metallic
  }
}

#declare TSubWfOuterCase = texture
{
  TSubWfCase
}

#declare PLtOrgCase = pigment
{
  onion
  turbulence 1.2
  color_map
  {
    [0.0    color rgb 2*<0.1,0.1,0.1>*1]
    [1.0    color rgb 2*<0.1,0.1,0.1>*0.75]
  }
  triangle_wave
  scale 0.8
  rotate 20*y
  rotate -5*x
  rotate -90*y
}

#declare TLtOrgCase = texture
{
  pigment { PLtOrgCase }
  finish
  {
    ambient 0.7
    diffuse 0.85
    brilliance 1
    specular 0.3
    roughness 0.006
    reflection 0.0
    metallic
  }
}

#declare TLtOrgCaseRings = texture
{
  pigment
  {
    color rgb 0.02
  }
  finish
  {
    ambient 0.2
    diffuse 1
    brilliance 1
    specular 0.1
    roughness 0.08
    reflection 0.0
  }
}

#declare TLtOrgCaseHole = texture
{
  TLtOrgCase
}

#declare TOrgBox = texture
{
  #if( DRAW_ORG_MASKS=0 )

  pigment
  {
    onion
    turbulence 1.2
    color_map
    {
      [0.0    color rgb 1.4*<0.1,0.1,0.1>*1]
      [1.0    color rgb 1.4*<0.1,0.1,0.1>*0.5]
    }
    triangle_wave
    scale 0.8
    rotate 20*y
    rotate -5*x
  }
  finish
  {
    ambient 0.9
    diffuse 0.9
    brilliance 1
    specular 0.22
    roughness 0.02
    reflection 0.0
  }

  #else

  TBlack

  #end
}

#declare TOrgBoxDark = texture
{
  #if( DRAW_ORG_MASKS=0 )

  pigment
  {
    onion
    turbulence 1.2
    color_map
    {
      [0.0    color rgb 0.4*<0.1,0.1,0.1>*1]
      [1.0    color rgb 0.4*<0.1,0.1,0.1>*0.5]
    }
    triangle_wave
    scale 0.8
    rotate 20*y
    rotate -5*x
  }
  finish
  {
    ambient 0.5
    diffuse 0.9
    brilliance 1
    specular 0.1
    roughness 0.008
    reflection 0.0
  }

  #else

  TWhite

  #end
}

#declare TOrgCone = texture
{
  #if( DRAW_ORG_MASKS=0 )

  pigment
  {
    onion
    turbulence 1.2
    color_map
    {
      [0.0    color rgb 1.6*<0.1,0.1,0.1>*1]
      [1.0    color rgb 1.6*<0.1,0.1,0.1>*0.5]
    }
    triangle_wave
    scale 0.65
    rotate 20*y
    rotate -5*x
  }
  finish
  {
    ambient 1
    diffuse 0.9
    brilliance 1
    //specular 0.05
    //roughness 0.4
    reflection 0.0
  }

  #else

  TWhite

  #end
}

#declare TOrgCase = texture
{
  #if( DRAW_ORG_MASKS=0 )

  TAPart

  #else

  TWhite

  #end
}

#declare TSliderCase = texture
{
  TAPart
}

#declare TSliderCase_Hole = texture
{
  TBlack
}

#declare TCase_Lamps = texture
{
  #if( DRAW_LAMPS_ON!=0 )
  /*
  pigment
  {
    gradient x
    color_map
    {
      [0.0    color rgb <0,1,0>]
      [0.4    color rgb <1,1,0>]
      [0.8    color rgb <1,0.1,0>]
      [1.0    color rgb <1,0.1,0>]
    }
  }
  finish
  {
    ambient 1
    diffuse 0
  }
  */
  TWhite
  #else
  //TLamps_Off
  /*
  pigment
  {
    gradient x
    color_map
    {
      [0.0    color rgb <0,1,0>]
      [0.4    color rgb <1,1,0>]
      [0.8    color rgb <1,0.1,0>]
      [1.0    color rgb <1,0.1,0>]
    }
  }
  finish
  {
    ambient 0.1
    diffuse 0.1
  }
  */
  TBlack
  #end
}


/* ---- Objects ---- */


camera
{
  location  <0,-10,0>
  sky       <0,0,1>  // Use right handed-system!
  up        <0,0,1>  // Where Z is up
  #ifdef( ASPECT_RATIO )
  right     <ASPECT_RATIO,0,0>
  #end
  look_at   <0,0,0>
}

background
{
  #if(( DRAW_AS_MASK=0 )&( DRAW_ORG_MASKS=0 ))
  #if( DRAW_BLACK_BKGND=0 )
  color rgb 0.1
  #else
  color rgb 0
  #end
  #else
  color rgb 1
  #end
}


// -- 3Way-Box --


#declare Tweeter = union
{
  union
  {
    #if( DRAW_3WAY_TWEETER_MAGNET!=0 )
    object
    {
      #declare magnet2_outerxradius = TWEETERMAGNET_OUTERRAD
      #declare magnet2_outerzradius = TWEETERMAGNET_OUTERRAD
      #declare magnet2_innerxradius = TWEETERMAGNET_INNERRAD
      #declare magnet2_innerzradius = TWEETERMAGNET_INNERRAD
      #declare magnet2_outerfixingradius = TWEETERMAGNET_FIXINGRAD
      #declare magnet2_height = TWEETERMAGNET_HEIGHT
      #declare magnet2_sphere_nested_angle = TWEETERMAGNET_NESTEDSPHEREANGLE
      #include "magnet2.pov"
      Magnet2
      translate TWEETERVIBRATOR_YOFS*y
    }
    #end
    #if( DRAW_3WAY_TWEETER_RING!=0 )
    object
    {
      #declare ellipsering_innerholexradius = TWEETERHOLE_INNERRAD
      #declare ellipsering_innerholezradius = TWEETERHOLE_INNERRAD
      #declare ellipsering_outerholexradius = TWEETERHOLE_OUTERRAD
      #declare ellipsering_outerholezradius = TWEETERHOLE_OUTERRAD
      #declare ellipsering_outerxradius = TWEETERRING_OUTERRAD
      #declare ellipsering_outerzradius = TWEETERRING_OUTERRAD
      #declare ellipsering_depth = TWEETERRING_DEPTH
      #declare ellipsering_cparts = 100
      #include "ellring.pov"
      EllipseRing
      texture { TTweeter_Ring }
    }
    cylinder
    {
      <0,TWEETERRING_DEPTH,0>, <0,TWEETERHOLE_DEPTH,0>, TWEETERHOLE_INNERRAD
      open
      texture { TBlack }
    }
    cylinder
    {
      <0,TWEETERHOLE_DEPTH*0.99,0>, <0,TWEETERHOLE_DEPTH,0>, TWEETERHOLE_INNERRAD
      texture { TBlack }
    }
    #end
    scale EXPAND_SPEAKERS*TWEETER_MAXEXPAND+1
  }
  #if( DRAW_3WAY_TWEETER_LAMPS!=0 )
  object
  {
    #declare lamps_radius = TWEETERLAMPS_RADIUS
    #declare lamps_thickness = TWEETERLAMPS_THICKNESS
    #declare lamps_count = TWEETERLAMPS_COUNT
    #declare lamps_spacing = TWEETERLAMPS_SPACING
    #if( ANIM_3WAY_SPK_LAMPS!=0 )
    #declare lamps_istart = clock
    #declare lamps_iend = clock
    #else
    #declare lamps_istart = -1
    #declare lamps_iend = -1
    #end
    #declare lamps_beginwithlamp = 0
    #include "lamps1.pov"
    Lamps
    texture { TLamps }
    scale <1,SPK3WAY_LAMPS_THICKSCALE,1>
  }
  #end
}


#declare Medium = union
{
  union
  {
    #if( DRAW_3WAY_MEDIUM_MAGNET!=0 )
    object
    {
      #declare magnet2_outerxradius = MEDIUMMAGNET_OUTERRAD
      #declare magnet2_outerzradius = MEDIUMMAGNET_OUTERRAD
      #declare magnet2_innerxradius = MEDIUMMAGNET_INNERRAD
      #declare magnet2_innerzradius = MEDIUMMAGNET_INNERRAD
      #declare magnet2_outerfixingradius = MEDIUMMAGNET_FIXINGRAD
      #declare magnet2_height = MEDIUMMAGNET_HEIGHT
      #declare magnet2_sphere_nested_angle = MEDIUMMAGNET_NESTEDSPHEREANGLE
      #include "magnet2.pov"
      Magnet2
      translate MEDIUMVIBRATOR_YOFS*y
    }
    #end
    #if( DRAW_3WAY_MEDIUM_RING!=0 )
    object
    {
      #declare ellipsering_innerholexradius = MEDIUMHOLE_INNERRAD
      #declare ellipsering_innerholezradius = MEDIUMHOLE_INNERRAD
      #declare ellipsering_outerholexradius = MEDIUMHOLE_OUTERRAD
      #declare ellipsering_outerholezradius = MEDIUMHOLE_OUTERRAD
      #declare ellipsering_outerxradius = MEDIUMRING_OUTERRAD
      #declare ellipsering_outerzradius = MEDIUMRING_OUTERRAD
      #declare ellipsering_depth = MEDIUMRING_DEPTH
      #declare ellipsering_cparts = 100
      #include "ellring.pov"
      EllipseRing
      texture { TMedium_Ring }
    }
    cylinder
    {
      <0,MEDIUMRING_DEPTH,0>, <0,MEDIUMHOLE_DEPTH,0>, MEDIUMHOLE_INNERRAD
      open
      texture { TBlack }
    }
    cylinder
    {
      <0,MEDIUMHOLE_DEPTH*0.99,0>, <0,MEDIUMHOLE_DEPTH,0>, MEDIUMHOLE_INNERRAD
      texture { TBlack }
    }
    #end
    scale EXPAND_SPEAKERS*MEDIUM_MAXEXPAND+1
  }
  #if( DRAW_3WAY_MEDIUM_LAMPS!=0 )
  object
  {
    #declare lamps_radius = MEDIUMLAMPS_RADIUS
    #declare lamps_thickness = MEDIUMLAMPS_THICKNESS
    #declare lamps_count = MEDIUMLAMPS_COUNT
    #declare lamps_spacing = MEDIUMLAMPS_SPACING
    #if( ANIM_3WAY_SPK_LAMPS!=0 )
    #declare lamps_istart = clock
    #declare lamps_iend = clock
    #else
    #declare lamps_istart = -1
    #declare lamps_iend = -1
    #end
    #declare lamps_beginwithlamp = 0
    #include "lamps1.pov"
    Lamps
    texture { TLamps }
    scale <1,SPK3WAY_LAMPS_THICKSCALE,1>
  }
  #end
}


#declare Woofer = union
{
  union
  {
    #if( DRAW_3WAY_WOOFER_MAGNET!=0 )
    object
    {
      #declare magnet2_outerxradius = WOOFERMAGNET_OUTERRAD
      #declare magnet2_outerzradius = WOOFERMAGNET_OUTERRAD
      #declare magnet2_innerxradius = WOOFERMAGNET_INNERRAD
      #declare magnet2_innerzradius = WOOFERMAGNET_INNERRAD
      #declare magnet2_outerfixingradius = WOOFERMAGNET_FIXINGRAD
      #declare magnet2_height = WOOFERMAGNET_HEIGHT
      #declare magnet2_sphere_nested_angle = WOOFERMAGNET_NESTEDSPHEREANGLE
      #include "magnet2.pov"
      Magnet2
      translate WOOFERVIBRATOR_YOFS*y
    }
    #end
    #if( DRAW_3WAY_WOOFER_RING!=0 )
    object
    {
      #declare ellipsering_innerholexradius = WOOFERHOLE_INNERRAD
      #declare ellipsering_innerholezradius = WOOFERHOLE_INNERRAD
      #declare ellipsering_outerholexradius = WOOFERHOLE_OUTERRAD
      #declare ellipsering_outerholezradius = WOOFERHOLE_OUTERRAD
      #declare ellipsering_outerxradius = WOOFERRING_OUTERRAD
      #declare ellipsering_outerzradius = WOOFERRING_OUTERRAD
      #declare ellipsering_depth = WOOFERRING_DEPTH
      #declare ellipsering_cparts = 100
      #include "ellring.pov"
      EllipseRing
      texture { TWoofer_Ring }
    }
    cylinder
    {
      <0,WOOFERRING_DEPTH,0>, <0,WOOFERHOLE_DEPTH,0>, WOOFERHOLE_INNERRAD
      open
      texture { TBlack }
    }
    cylinder
    {
      <0,WOOFERHOLE_DEPTH*0.99,0>, <0,WOOFERHOLE_DEPTH,0>, WOOFERHOLE_INNERRAD
      texture { TBlack }
    }
    #end
    scale EXPAND_SPEAKERS*WOOFER_MAXEXPAND+1
  }
  #if( DRAW_3WAY_WOOFER_LAMPS!=0 )
  object
  {
    #declare lamps_radius = WOOFERLAMPS_RADIUS
    #declare lamps_thickness = WOOFERLAMPS_THICKNESS
    #declare lamps_count = WOOFERLAMPS_COUNT
    #declare lamps_spacing = WOOFERLAMPS_SPACING
    #if( ANIM_3WAY_SPK_LAMPS!=0 )
    #declare lamps_istart = clock
    #declare lamps_iend = clock
    #else
    #declare lamps_istart = -1
    #declare lamps_iend = -1
    #end
    #declare lamps_beginwithlamp = 0
    #include "lamps1.pov"
    Lamps
    texture { TLamps }
    scale <1,SPK3WAY_LAMPS_THICKSCALE,1>
  }
  #end
}


#declare medium_center = <0,0,MEDIUMRING_OUTERRAD+HIGHPART_BOTTOM_DIST>
#declare tweeter_center = <0,0,medium_center.z+MEDIUMRING_OUTERRAD+HIGHPART_TWEETER_MEDIUM_DISTOFS+TWEETERRING_OUTERRAD>
#declare highpart_width = 2*MEDIUMRING_OUTERRAD+2*HIGHPART_LEFTRIGHT_DIST
#declare highpart_height = tweeter_center.z+TWEETERRING_OUTERRAD+HIGHPART_TOP_DIST

#declare woofer_center = <0,0,-WOOFERRING_OUTERRAD-LOWPART_TOP_DIST>
#declare lowpart_width = 2*WOOFERRING_OUTERRAD+2*LOWPART_LEFTRIGHT_DIST
#declare lowpart_height = -woofer_center.z+WOOFERRING_OUTERRAD+LOWPART_BOTTOM_DIST


#declare HighPart_3Way = union
{
  #if( DRAW_3WAY_HIGHPART!=0 )
  difference
  {
    cylinder
    {
      <0,1,-lowpart_height/2>, <0,1,highpart_height>, 1
      scale <HIGHPART_CYL_XRAD,HIGHPART_CYL_YRAD,1>
    }
    cylinder
    {
      <0,-1000,-1>, <0,1000,-1>, 1
      scale <LOWPART_CUTCYL_XRAD,1,lowpart_height/2>
    }
    cylinder
    {
      <0,-1000,0>, <0,1000,0>, TWEETERRING_OUTERRAD
      translate tweeter_center
    }
    cylinder
    {
      <0,-1000,0>, <0,1000,0>, MEDIUMRING_OUTERRAD
      translate medium_center
    }
    #if( DRAW_HIGHPART_CUTCONES!=0 )
    cone
    {
      <0,0,0>, TWEETERRING_OUTERRAD
      <0,TWEETERRING_OUTERRAD,0>, 0
      scale HIGHPART_TWEETERCUTCONE_SCALE
      translate tweeter_center
    }
    cone
    {
      <0,0,0>, MEDIUMRING_OUTERRAD
      <0,MEDIUMRING_OUTERRAD,0>, 0
      scale HIGHPART_MEDIUMCUTCONE_SCALE
      translate medium_center
    }
    #end
    plane
    {
      -x, -highpart_width/2
    }
    plane
    {
      x, -highpart_width/2
    }
    // now subract the screw holes
    #declare highpart_screw_xcenter = highpart_width/2-HIGHPART_SCREW_XDIST-HIGHPART_SCREW_RAD
    #declare highpart_screw_ztopcenter = highpart_height/2-HIGHPART_SCREW_TOPDIST-HIGHPART_SCREW_RAD
    #declare highpart_screw_zbottomcenter = -(highpart_height/2-HIGHPART_SCREW_BOTTOMDIST-HIGHPART_SCREW_RAD)
    cylinder
    {
      <highpart_screw_xcenter,-1000,highpart_screw_ztopcenter+highpart_height/2>,
      <highpart_screw_xcenter,HIGHPART_CYL_YRAD,highpart_screw_ztopcenter+highpart_height/2>,
      HIGHPART_SCREW_RAD
      texture { TBlack }
    }
    cylinder
    {
      <-highpart_screw_xcenter,-1000,highpart_screw_ztopcenter+highpart_height/2>,
      <-highpart_screw_xcenter,HIGHPART_CYL_YRAD,highpart_screw_ztopcenter+highpart_height/2>,
      HIGHPART_SCREW_RAD
      texture { TBlack }
    }
    cylinder
    {
      <highpart_screw_xcenter,-1000,highpart_screw_zbottomcenter+highpart_height/2>,
      <highpart_screw_xcenter,HIGHPART_CYL_YRAD,highpart_screw_zbottomcenter+highpart_height/2>,
      HIGHPART_SCREW_RAD
      texture { TBlack }
    }
    cylinder
    {
      <-highpart_screw_xcenter,-1000,highpart_screw_zbottomcenter+highpart_height/2>,
      <-highpart_screw_xcenter,HIGHPART_CYL_YRAD,highpart_screw_zbottomcenter+highpart_height/2>,
      HIGHPART_SCREW_RAD
      texture { TBlack }
    }
    texture { THighPart }
  }
  #end
  #if( DRAW_3WAY_TWEETER!=0 )
  object
  {
    Tweeter
    translate tweeter_center
    translate HIGHPART_SPEAKER_NESTEDDEPTH*y
  }
  #end
  #if( DRAW_3WAY_MEDIUM!=0 )
  object
  {
    Medium
    translate medium_center
    translate HIGHPART_SPEAKER_NESTEDDEPTH*y
  }
  #end
}


#declare LowPart_3Way = union
{
  #if( DRAW_3WAY_LOWPART!=0 )
  difference
  {
    intersection
    {
      cylinder
      {
        <0,1,0>, <0,1,-lowpart_height>, 1
        scale <LOWPART_CYL_XRAD,LOWPART_CYL_YRAD,1>
      }
      cylinder
      {
        <0,-1000,-1>, <0,1000,-1>, 1
        scale <LOWPART_CUTCYL_XRAD,1,lowpart_height/2>
      }
    }
    cylinder
    {
      <0,-1000,0>, <0,1000,0>, WOOFERRING_OUTERRAD
      translate woofer_center
    }
    plane
    {
      -x, -lowpart_width/2
    }
    plane
    {
      x, -lowpart_width/2
    }
    // now subract the screw holes
    #declare lowpart_screw_xcenter = lowpart_width/2-LOWPART_SCREW_XDIST-LOWPART_SCREW_RAD
    #declare lowpart_screw_zcenter = lowpart_height/2-LOWPART_SCREW_ZDIST-LOWPART_SCREW_RAD
    cylinder
    {
      <lowpart_screw_xcenter,-1000,lowpart_screw_zcenter-lowpart_height/2>,
      <lowpart_screw_xcenter,LOWPART_CYL_YRAD,lowpart_screw_zcenter-lowpart_height/2>,
      LOWPART_SCREW_RAD
      texture { TBlack }
    }
    cylinder
    {
      <-lowpart_screw_xcenter,-1000,lowpart_screw_zcenter-lowpart_height/2>,
      <-lowpart_screw_xcenter,LOWPART_CYL_YRAD,lowpart_screw_zcenter-lowpart_height/2>,
      LOWPART_SCREW_RAD
      texture { TBlack }
    }
    cylinder
    {
      <lowpart_screw_xcenter,-1000,-lowpart_screw_zcenter-lowpart_height/2>,
      <lowpart_screw_xcenter,LOWPART_CYL_YRAD,-lowpart_screw_zcenter-lowpart_height/2>,
      LOWPART_SCREW_RAD
      texture { TBlack }
    }
    cylinder
    {
      <-lowpart_screw_xcenter,-1000,-lowpart_screw_zcenter-lowpart_height/2>,
      <-lowpart_screw_xcenter,LOWPART_CYL_YRAD,-lowpart_screw_zcenter-lowpart_height/2>,
      LOWPART_SCREW_RAD
      texture { TBlack }
    }
    texture { TLowPart }
  }
  #end
  #if( DRAW_3WAY_WOOFER!=0 )
  object
  {
    Woofer
    translate woofer_center
    translate LOWPART_SPEAKER_NESTEDDEPTH*y
  }
  #end
  translate LOWPART_YMOVE*y
}


#declare case_width = lowpart_width+2*CASE_LEFTRIGHT_DIST
#declare case_height = CASE_BOTTOM_DIST+lowpart_height+highpart_height+CASE_TOP_DIST
#declare case_hole_cutter_width = case_width-2*CASE_HOLE_LEFTRIGHT_DIST
#declare case_hole_cutter_height = lowpart_height+2*(CASE_BOTTOM_DIST-CASE_HOLE_BOTTOM_DIST)

#if( DRAW_3WAY_CASE!=0 )
#declare Case_3Way_Hole_Cutter = merge
{
  difference
  {
    cylinder
    {
      <0,-1000,0>, <0,CASE_HOLE_TEXTURE_DEPTH*1.0001,0>, 1
      scale <LOWPART_CUTCYL_XRAD*case_hole_cutter_height/lowpart_height,1,case_hole_cutter_height/2>
    }
    plane
    {
      -x, -case_hole_cutter_width/2
    }
    plane
    {
      x, -case_hole_cutter_width/2
    }
    texture { TCase_OuterHole }
  }
  difference
  {
    cylinder
    {
      <0,CASE_HOLE_TEXTURE_DEPTH,0>, <0,CASE_HOLE_DEPTH,0>, 1
      scale <LOWPART_CUTCYL_XRAD*case_hole_cutter_height/lowpart_height,1,case_hole_cutter_height/2>
    }
    plane
    {
      -x, -case_hole_cutter_width/2
    }
    plane
    {
      x, -case_hole_cutter_width/2
    }
    texture { TCase_InnerHole }
  }
}
#end

#declare case_base_zcoord = -lowpart_height-CASE_BOTTOM_DIST
#declare case_top_zcoord = case_base_zcoord+case_height
#declare case_hole_top_zcoord = case_top_zcoord-CASE_HOLE_TOP_DIST

#declare case_lamps_width = (case_hole_cutter_width-highpart_width)/2
#declare case_lamps_height = case_hole_top_zcoord

#declare Case_3Way_Lamps = object
{
  object
  {
    #declare sinusarea_endheight = CASE_LAMPS_ENDHEIGHT
    #declare sinusarea_shear = CASE_LAMPS_SHEAR
    #declare sinusarea_cstrips = CASE_LAMPS_CSTRIPS
    #declare sinusarea_relstipthickness = CASE_LAMPS_RELSTRIPTHICKNESS
    #declare sinusarea_cstripparts = 8
    #if( ANIM_3WAY_CASE_LAMPS!=0 )
    #declare sinusarea_istart = clock
    #declare sinusarea_iend = clock
    #else
    #declare sinusarea_istart = -1
    #declare sinusarea_iend = -1
    #end
    #declare sinusarea_startangle = 0
    #declare sinusarea_endangle = 180
    #include "sinarea.pov"
    SinusArea
    texture
    {
      TCase_Lamps
      scale <(1+abs(CASE_LAMPS_SHEAR)),1,1>
      #if( CASE_LAMPS_SHEAR<0 )
        translate CASE_LAMPS_SHEAR*x
      #end
    }
    translate <-0.5,-0.5,0>
    rotate 90*x
    rotate -90*y
    scale <CASE_LAMPS_RELWIDTH,1,CASE_LAMPS_RELHEIGHT>
    translate <-0.5,0,0.5+CASE_LAMPS_RELZOFS>
    scale <case_lamps_width,1,case_lamps_height>
  }
}

#declare Case_3Way = union
{
  #if( DRAW_3WAY_CASE!=0 )
  difference
  {
    intersection
    {
      #declare case_front_ymove = CASE_FRONT_YOFS-LOWPART_YMOVE
      box
      {
        <-case_width/2,0,0>,
        <case_width/2,CASE_DEPTH,case_height>
        translate <0,case_front_ymove,case_base_zcoord>
      }
      // now subtract the slopes at the left and right of the box
      merge
      {
        #declare scaled_lowpart_cyl_xrad = LOWPART_CYL_XRAD*CASE_CUTROUND_XSCALE
        #declare case_front_cylcenter_dist = abs(LOWPART_CYL_YRAD-case_front_ymove)
        #declare case_cyl_scale__x = (case_width-2*CASE_CUTROUND_XDIST)/(2*scaled_lowpart_cyl_xrad)
        #declare case_cyl_scale__y = case_front_cylcenter_dist/LOWPART_CYL_YRAD
        #declare case_cyl_scale = sqrt( pow(case_cyl_scale__x,2)+pow(case_cyl_scale__y,2) )
        cylinder
        {
          <0,0,-1000>, <0,0,1000>, 1
          scale <scaled_lowpart_cyl_xrad,LOWPART_CYL_YRAD,1> * case_cyl_scale
        }
        plane
        {
          -y, 0
        }
        translate LOWPART_CYL_YRAD*y
      }
      translate LOWPART_YMOVE*y
    }
    // now make black holes for the 3 speakers
    cylinder
    {
      <0,CASE_FRONT_YOFS+CASE_HOLE_DEPTH,0>, <0,-1000,0>, TWEETERRING_OUTERRAD
      texture { TBlack }
      translate tweeter_center
    }
    cylinder
    {
      <0,CASE_FRONT_YOFS+CASE_HOLE_DEPTH,0>, <0,-1000,0>, MEDIUMRING_OUTERRAD
      texture { TBlack }
      translate medium_center
    }
    cylinder
    {
      <0,CASE_FRONT_YOFS+CASE_HOLE_DEPTH,0>, <0,-1000,0>, WOOFERRING_OUTERRAD
      texture { TBlack }
      translate woofer_center
    }
    // now cut out the main hole
    merge
    {
      object
      {
        Case_3Way_Hole_Cutter
        translate (-lowpart_height/2)*z
      }
      object
      {
        Case_3Way_Hole_Cutter
        translate (-case_hole_cutter_height/2+case_hole_top_zcoord)*z
      }
      /*
      box
      {
        <-case_hole_cutter_width/2,-1000,-lowpart_height/2>,
        <case_hole_cutter_width/2,CASE_HOLE_DEPTH,-case_hole_cutter_height/2+case_hole_top_zcoord>
      }
      */
      translate CASE_FRONT_YOFS*y
    }
    texture { TCase }
  }
  #end
  #if( DRAW_3WAY_CASE_LEFT_LAMPS!=0 )
  object
  {
    Case_3Way_Lamps
    translate <-highpart_width/2,CASE_LAMPS_DEPTH+CASE_FRONT_YOFS,0>
  }
  #end
  #if( DRAW_3WAY_CASE_RIGHT_LAMPS!=0 )
  object
  {
    Case_3Way_Lamps
    rotate 180*z
    translate <highpart_width/2,CASE_LAMPS_DEPTH+CASE_FRONT_YOFS,0>
  }
  #end
}


#declare Box_3Way = union
{
  #if( DRAW_3WAY_BOX!=0 )
  object
  {
    HighPart_3Way
  }
  object
  {
    LowPart_3Way
  }
  object
  {
    Case_3Way
  }
  translate (-case_base_zcoord-case_height/2)*z
  #end
}


// -- BigWoofer-Box --


#declare BigWf_Speaker = union
{
  union
  {
    #if( DRAW_BIGWF_SPEAKER_MAGNET!=0 )
    object
    {
      #declare magnet2_outerxradius = BIGWFSPKMAGNET_OUTERXRAD
      #declare magnet2_outerzradius = BIGWFSPKMAGNET_OUTERZRAD
      #declare magnet2_innerxradius = BIGWFSPKMAGNET_INNERRAD
      #declare magnet2_innerzradius = BIGWFSPKMAGNET_INNERRAD
      #declare magnet2_outerfixingradius = BIGWFSPKMAGNET_FIXINGRAD
      #declare magnet2_height = BIGWFSPKMAGNET_HEIGHT
      #declare magnet2_sphere_nested_angle = BIGWFSPKMAGNET_NESTEDSPHEREANGLE
      #include "magnet2.pov"
      Magnet2
      translate BIGWFSPKVIBRATOR_YOFS*y
    }
    #end
    #if( DRAW_BIGWF_SPEAKER_RING!=0 )
    object
    {
      #declare ellipsering_innerholexradius = BIGWFSPKHOLE_INNERXRAD
      #declare ellipsering_innerholezradius = BIGWFSPKHOLE_INNERZRAD
      #declare ellipsering_outerholexradius = BIGWFSPKHOLE_OUTERXRAD
      #declare ellipsering_outerholezradius = BIGWFSPKHOLE_OUTERZRAD
      #declare ellipsering_outerxradius = BIGWFSPKRING_OUTERXRAD
      #declare ellipsering_outerzradius = BIGWFSPKRING_OUTERZRAD
      #declare ellipsering_depth = BIGWFSPKRING_DEPTH
      #declare ellipsering_cparts = 100
      #include "ellring.pov"
      EllipseRing
      texture { TBigWoofer_Ring }
    }
    cylinder
    {
      <0,BIGWFSPKRING_DEPTH,0>, <0,BIGWFSPKHOLE_DEPTH,0>, 1
      open
      scale <BIGWFSPKHOLE_INNERXRAD,1,BIGWFSPKHOLE_INNERZRAD>
      texture { TBlack }
    }
    cylinder
    {
      <0,BIGWFSPKHOLE_DEPTH*0.99,0>, <0,BIGWFSPKHOLE_DEPTH,0>, 1
      scale <BIGWFSPKHOLE_INNERXRAD,1,BIGWFSPKHOLE_INNERZRAD>
      texture { TBlack }
    }
    #end
    scale EXPAND_SPEAKERS*BIGWFSPK_MAXEXPAND+1
    /*
    #declare xexpand = EXPAND_SPEAKERS*BIGWFSPK_MAXEXPAND+1
    #declare yexpand = xexpand
    #declare zexpand = ((xexpand-1)*BIGWFSPKHOLE_OUTERXRAD+BIGWFSPKHOLE_OUTERZRAD)/BIGWFSPKHOLE_OUTERZRAD
    scale <xexpand,yexpand,zexpand>
    // Note: This will deform the BigWoofer a bit, but this not very much
    //  difference to the light effects for the ellipse-cone of the magnet.
    // Note: The deformation *does* look bad. It seems as if the magnet
    //  is being stretched. -> Normal scaling done again.
    */
  }
  #if( DRAW_BIGWF_SPEAKER_LAMPS!=0 )
  object
  {
    #declare ellipselamps_xradius = BIGWFSPKLAMPS_XRADIUS
    #declare ellipselamps_zradius = BIGWFSPKLAMPS_ZRADIUS
    #declare ellipselamps_thickness = BIGWFSPKLAMPS_THICKNESS
    #declare ellipselamps_count = BIGWFSPKLAMPS_COUNT
    #declare ellipselamps_spacing = BIGWFSPKLAMPS_SPACING
    #if( ANIM_BIGWF_SPK_LAMPS!=0 )
    #declare ellipselamps_istart = clock
    #declare ellipselamps_iend = clock
    #else
    #declare ellipselamps_istart = -1
    #declare ellipselamps_iend = -1
    #end
    #declare ellipselamps_beginwithlamp = 0
    #include "ellamps1.pov"
    EllipseLamps
    texture { TLamps }
    scale <1,SPKBIGWF_LAMPS_THICKSCALE,1>
  }
  #end
}


#declare bigwfpart_width = 2*BIGWFSPKRING_OUTERXRAD+2*BIGWFPART_LEFTRIGHT_DIST
#declare bigwfpart_height = BIGWFPART_TOP_DIST+2*BIGWFSPKRING_OUTERZRAD+BIGWFPART_BOTTOM_DIST

#declare BigWf_Part = union
{
  #if( DRAW_BIGWF_PART!=0 )
  difference
  {
    intersection
    {
      cylinder
      {
        <0,1,bigwfpart_height/2>, <0,1,-bigwfpart_height/2>, 1
        scale <BIGWFPART_CYL_XRAD,BIGWFPART_CYL_YRAD,1>
      }
      cylinder
      {
        <0,-1000,0>, <0,1000,0>, 1
        scale <BIGWFPART_CUTCYL_XRAD,1,bigwfpart_height/2>
      }
    }
    cylinder
    {
      <0,-1000,0>, <0,1000,0>, 1
      scale <BIGWFSPKRING_OUTERXRAD,1,BIGWFSPKRING_OUTERZRAD>
    }
    plane
    {
      -x, -bigwfpart_width/2
    }
    plane
    {
      x, -bigwfpart_width/2
    }
    // now subract the screw holes
    #declare bigwfpart_screw_xcenter = bigwfpart_width/2-BIGWFPART_SCREW_XDIST-BIGWFPART_SCREW_RAD
    #declare bigwfpart_screw_zcenter = bigwfpart_height/2-BIGWFPART_SCREW_ZDIST-BIGWFPART_SCREW_RAD
    cylinder
    {
      <bigwfpart_screw_xcenter,-1000,bigwfpart_screw_zcenter>,
      <bigwfpart_screw_xcenter,BIGWFPART_CYL_YRAD,bigwfpart_screw_zcenter>,
      BIGWFPART_SCREW_RAD
      texture { TBlack }
    }
    cylinder
    {
      <-bigwfpart_screw_xcenter,-1000,bigwfpart_screw_zcenter>,
      <-bigwfpart_screw_xcenter,BIGWFPART_CYL_YRAD,bigwfpart_screw_zcenter>,
      BIGWFPART_SCREW_RAD
      texture { TBlack }
    }
    cylinder
    {
      <bigwfpart_screw_xcenter,-1000,-bigwfpart_screw_zcenter>,
      <bigwfpart_screw_xcenter,BIGWFPART_CYL_YRAD,-bigwfpart_screw_zcenter>,
      BIGWFPART_SCREW_RAD
      texture { TBlack }
    }
    cylinder
    {
      <-bigwfpart_screw_xcenter,-1000,-bigwfpart_screw_zcenter>,
      <-bigwfpart_screw_xcenter,BIGWFPART_CYL_YRAD,-bigwfpart_screw_zcenter>,
      BIGWFPART_SCREW_RAD
      texture { TBlack }
    }
    texture { TBigWfPart }
  }
  #end
  #if( DRAW_BIGWF_SPEAKER!=0 )
  object
  {
    BigWf_Speaker
    translate BIGWFPART_SPEAKER_NESTEDDEPTH*y
  }
  #end
  translate BIGWFPART_YMOVE*y
}


#declare bigwfcase_width = bigwfpart_width+2*BIGWFCASE_LEFTRIGHT_DIST
#declare bigwfcase_height = case_height
#declare BIGWFCASE_TOP_DIST = (bigwfcase_height-bigwfpart_height)/2
#declare BIGWFCASE_BOTTOM_DIST = BIGWFCASE_TOP_DIST
#declare BIGWFCASE_HOLE_TOP_DIST = BIGWFCASE_TOP_DIST-BIGWFCASE_HOLE_TOP_DISTOFS
#declare BIGWFCASE_HOLE_BOTTOM_DIST = BIGWFCASE_BOTTOM_DIST-BIGWFCASE_HOLE_BOTTOM_DISTOFS
#declare bigwfcase_hole_cutter_width = bigwfcase_width-2*BIGWFCASE_HOLE_LEFTRIGHT_DIST
#declare bigwfcase_hole_cutter_height = bigwfpart_height+2*(BIGWFCASE_BOTTOM_DIST-BIGWFCASE_HOLE_BOTTOM_DIST)

#declare Case_BigWf_Hole_Cutter = merge
{
  difference
  {
    cylinder
    {
      <0,-1000,0>, <0,BIGWFCASE_HOLE_TEXTURE_DEPTH*1.0001,0>, 1
      scale <BIGWFPART_CUTCYL_XRAD*bigwfcase_hole_cutter_height/bigwfpart_height,1,bigwfcase_hole_cutter_height/2>
    }
    plane
    {
      -x, -bigwfcase_hole_cutter_width/2
    }
    plane
    {
      x, -bigwfcase_hole_cutter_width/2
    }
    texture { TBigWfCase_OuterHole }
  }
  difference
  {
    cylinder
    {
      <0,BIGWFCASE_HOLE_TEXTURE_DEPTH,0>, <0,BIGWFCASE_HOLE_DEPTH,0>, 1
      scale <BIGWFPART_CUTCYL_XRAD*bigwfcase_hole_cutter_height/bigwfpart_height,1,bigwfcase_hole_cutter_height/2>
    }
    plane
    {
      -x, -bigwfcase_hole_cutter_width/2
    }
    plane
    {
      x, -bigwfcase_hole_cutter_width/2
    }
    texture { TBigWfCase_InnerHole }
  }
}

#declare bigwfcase_base_zcoord = -bigwfpart_height/2-BIGWFCASE_BOTTOM_DIST
#declare bigwfcase_top_zcoord = bigwfcase_base_zcoord+bigwfcase_height
#declare bigwfcase_hole_top_zcoord = bigwfcase_top_zcoord-BIGWFCASE_HOLE_TOP_DIST

#declare Case_BigWf = union
{
  #if( DRAW_BIGWF_CASE!=0 )
  difference
  {
    intersection
    {
      #declare bigwfcase_front_ymove = BIGWFCASE_FRONT_YOFS-BIGWFPART_YMOVE
      box
      {
        <-bigwfcase_width/2,0,0>,
        <bigwfcase_width/2,BIGWFCASE_DEPTH,bigwfcase_height>
        translate <0,bigwfcase_front_ymove,bigwfcase_base_zcoord>
      }
      // now subtract the slopes at the left and right of the box
      merge
      {
        #declare scaled_bigwfpart_cyl_xrad = BIGWFPART_CYL_XRAD*BIGWFCASE_CUTROUND_XSCALE
        #declare bigwfcase_front_cylcenter_dist = abs(BIGWFPART_CYL_YRAD-bigwfcase_front_ymove)
        #declare bigwfcase_cyl_scale__x = (bigwfcase_width-2*BIGWFCASE_CUTROUND_XDIST)/(2*scaled_bigwfpart_cyl_xrad)
        #declare bigwfcase_cyl_scale__y = bigwfcase_front_cylcenter_dist/BIGWFPART_CYL_YRAD
        #declare bigwfcase_cyl_scale = sqrt( pow(bigwfcase_cyl_scale__x,2)+pow(bigwfcase_cyl_scale__y,2) )
        cylinder
        {
          <0,0,-1000>, <0,0,1000>, 1
          scale <scaled_bigwfpart_cyl_xrad,BIGWFPART_CYL_YRAD,1> * bigwfcase_cyl_scale
        }
        plane
        {
          -y, 0
        }
        translate BIGWFPART_CYL_YRAD*y
      }
      translate BIGWFPART_YMOVE*y
    }
    // now make a black hole for the speaker
    cylinder
    {
      <0,BIGWFCASE_FRONT_YOFS+BIGWFCASE_HOLE_DEPTH,0>, <0,-1000,0>, 1
      scale <BIGWFSPKRING_OUTERXRAD,1,BIGWFSPKRING_OUTERZRAD>
      texture { TBlack }
    }
    // now cut out the main hole
    object
    {
      object
      {
        Case_BigWf_Hole_Cutter
      }
      translate BIGWFCASE_FRONT_YOFS*y
    }
    // now cut out the dent-cylinders
    merge
    {
      #declare bigwfcase_dentcyl_ydist = sqrt(pow(BIGWFCASE_DENTCYL_RAD,2)-pow(BIGWFCASE_DENTCYL_THICKNESS/2,2))
      #declare bigwfcase_dentcyl_top_ztop = bigwfcase_top_zcoord-BIGWFCASE_DENTCYL_ZDIST
      #declare bigwfcase_dentcyl_top_zbottom = bigwfcase_top_zcoord-BIGWFCASE_TOP_DIST+BIGWFCASE_DENTCYL_ZDIST
      #declare bigwfcase_dentcyl_bottom_ztop = bigwfcase_base_zcoord+BIGWFCASE_BOTTOM_DIST-BIGWFCASE_DENTCYL_ZDIST
      #declare bigwfcase_dentcyl_bottom_zbottom = bigwfcase_base_zcoord+BIGWFCASE_DENTCYL_ZDIST
      #declare bigwfcase_dentcyls_width = (BIGWFCASE_CDENTCYLS-1)*BIGWFCASE_DENTCYL_XDIST
      #declare i = 0
      #while( i<BIGWFCASE_CDENTCYLS )
        #declare bigwfcase_dentcyl_x = -bigwfcase_dentcyls_width/2+i*BIGWFCASE_DENTCYL_XDIST
        merge
        {
          cylinder
          {
            <bigwfcase_dentcyl_x,0,bigwfcase_dentcyl_top_ztop>,
            <bigwfcase_dentcyl_x,0,bigwfcase_dentcyl_top_zbottom>,
            BIGWFCASE_DENTCYL_RAD
          }
          sphere
          {
            <bigwfcase_dentcyl_x,0,bigwfcase_dentcyl_top_ztop>,
            BIGWFCASE_DENTCYL_RAD
          }
          sphere
          {
            <bigwfcase_dentcyl_x,0,bigwfcase_dentcyl_top_zbottom>,
            BIGWFCASE_DENTCYL_RAD
          }
        }
        merge
        {
          cylinder
          {
            <bigwfcase_dentcyl_x,0,bigwfcase_dentcyl_bottom_ztop>,
            <bigwfcase_dentcyl_x,0,bigwfcase_dentcyl_bottom_zbottom>,
            BIGWFCASE_DENTCYL_RAD
          }
          sphere
          {
            <bigwfcase_dentcyl_x,0,bigwfcase_dentcyl_bottom_ztop>,
            BIGWFCASE_DENTCYL_RAD
          }
          sphere
          {
            <bigwfcase_dentcyl_x,0,bigwfcase_dentcyl_bottom_zbottom>,
            BIGWFCASE_DENTCYL_RAD
          }
        }
        #declare i = i+1
      #end
      texture { TBigWfCase_DentCyls }
      translate (-bigwfcase_dentcyl_ydist+bigwfcase_front_ymove+BIGWFPART_YMOVE)*y
    }
    texture { TBigWfCase }
  }
  #end
}


#declare Box_BigWoofer = union
{
  #if( DRAW_BIGWOOFER_BOX!=0 )
  object
  {
    BigWf_Part
  }
  object
  {
    Case_BigWf
  }
  #end
}


// -- Slider-Box --


#declare slidercase_width = SLIDERCASE_HOLE_WIDTH+2*SLIDERCASE_HOLE_LEFTRIGHT_DIST
#declare slidercase_height = case_height
#declare slidercase_hole_height = slidercase_height-SLIDERCASE_HOLE_TOP_DIST-SLIDERCASE_HOLE_BOTTOM_DIST

#declare slidercase_base_zcoord = -slidercase_height/2
#declare slidercase_top_zcoord = slidercase_base_zcoord+slidercase_height

#declare Case_Slider = union
{
  #if( DRAW_SLIDER_CASE!=0 )
  difference
  {
    intersection
    {
      #declare slidercase_front_ymove = SLIDERCASE_FRONT_YOFS
      box
      {
        <-slidercase_width/2,0,0>,
        <slidercase_width/2,SLIDERCASE_DEPTH,slidercase_height>
        translate <0,0,slidercase_base_zcoord>
      }
      // now subtract the slopes at the left and right of the box
      merge
      {
        #declare normalized_slidercase_width = slidercase_width/SLIDERCASE_CUTCYL_XRAD
        #declare normalized_slidercase_cutround_xdist = SLIDERCASE_CUTROUND_XDIST/SLIDERCASE_CUTCYL_XRAD
        #declare normalized_slidercase_cylcenter_y = sqrt( pow(1,2)-pow(normalized_slidercase_width/2-normalized_slidercase_cutround_xdist,2) )
        #declare normalized_slidercase_cyl_ymove = -(1-normalized_slidercase_cylcenter_y)
        cylinder
        {
          <0,1,-1000>, <0,1,1000>, 1
        }
        plane
        {
          -y, -1
        }
        translate normalized_slidercase_cyl_ymove*y
        scale <SLIDERCASE_CUTCYL_XRAD,SLIDERCASE_CUTCYL_YRAD,1>
        #declare slidercase_cylcenter_y = normalized_slidercase_cylcenter_y*SLIDERCASE_CUTCYL_YRAD
      }
      translate <0,slidercase_front_ymove,0>
    }
    // now cut out the main hole
    object
    {
      #declare slidercase_hole_depth = slidercase_cylcenter_y
      #if( slidercase_hole_depth>SLIDERCASE_DEPTH*0.99 )
        #declare slidercase_hole_depth = SLIDERCASE_DEPTH*0.99
      #end
      /*
      box
      {
        <-slidercase_width/2+SLIDERCASE_HOLE_LEFTRIGHT_DIST,-1000,SLIDERCASE_HOLE_BOTTOM_DIST>,
        <slidercase_width/2-SLIDERCASE_HOLE_LEFTRIGHT_DIST,slidercase_hole_depth,slidercase_height-SLIDERCASE_HOLE_TOP_DIST>
      }
      */
      object
      {
        #declare roundbox_cx = slidercase_width-2*SLIDERCASE_HOLE_LEFTRIGHT_DIST
        #declare roundbox_cy = 1000
        #declare roundbox_cz = slidercase_height-SLIDERCASE_HOLE_TOP_DIST-SLIDERCASE_HOLE_BOTTOM_DIST
        #declare roundbox_round_radius = SLIDERCASE_HOLE_ROUNDRAD
        #declare roundbox_scale_corners = 1
        #declare roundbox_scale_roundings = 1
        #include "roundbox.pov"
        RoundBox
        translate <0,-roundbox_cy/2+slidercase_hole_depth,roundbox_cz/2+SLIDERCASE_HOLE_BOTTOM_DIST>
      }
      translate <0,slidercase_front_ymove,slidercase_base_zcoord>
      texture { TSliderCase_Hole }
    }
    texture { TSliderCase }
  }
  #end
}


#declare Box_Slider = union
{
  #if( DRAW_SLIDER_BOX!=0 )
  object
  {
    Case_Slider
  }
  #end
}


// -- SubWoofer-Box --


#declare SubWf_Speaker = union
{
  union
  {
    #if( DRAW_SUBWF_SPEAKER_MAGNET!=0 )
    object
    {
      #declare magnet2_outerxradius = SUBWFMAGNET_OUTERRAD
      #declare magnet2_outerzradius = SUBWFMAGNET_OUTERRAD
      #declare magnet2_innerxradius = SUBWFMAGNET_INNERRAD
      #declare magnet2_innerzradius = SUBWFMAGNET_INNERRAD
      #declare magnet2_outerfixingradius = SUBWFMAGNET_FIXINGRAD
      #declare magnet2_height = SUBWFMAGNET_HEIGHT
      #declare magnet2_sphere_nested_angle = SUBWFMAGNET_NESTEDSPHEREANGLE
      #include "magnet2.pov"
      Magnet2
      translate SUBWFVIBRATOR_YOFS*y
    }
    #end
    #if( DRAW_SUBWF_SPEAKER_RING!=0 )
    object
    {
      #declare ellipsering_innerholexradius = SUBWFHOLE_INNERRAD
      #declare ellipsering_innerholezradius = SUBWFHOLE_INNERRAD
      #declare ellipsering_outerholexradius = SUBWFHOLE_OUTERRAD
      #declare ellipsering_outerholezradius = SUBWFHOLE_OUTERRAD
      #declare ellipsering_outerxradius = SUBWFRING_OUTERRAD
      #declare ellipsering_outerzradius = SUBWFRING_OUTERRAD
      #declare ellipsering_depth = SUBWFRING_DEPTH
      #declare ellipsering_cparts = 100
      #include "ellring.pov"
      EllipseRing
      texture { TSubWf_Speaker_Ring }
    }
    cylinder
    {
      <0,SUBWFRING_DEPTH,0>, <0,SUBWFHOLE_DEPTH,0>, SUBWFHOLE_INNERRAD
      open
      texture { TBlack }
    }
    cylinder
    {
      <0,SUBWFHOLE_DEPTH*0.99,0>, <0,SUBWFHOLE_DEPTH,0>, SUBWFHOLE_INNERRAD
      texture { TBlack }
    }
    #end
    scale EXPAND_SPEAKERS*SUBWF_MAXEXPAND+1
  }
}


#declare subwfpart_width = SUBWFPART_LEFT_DIST+2*SUBWFRING_OUTERRAD+SUBWFPART_RIGHT_DIST
#declare subwfpart_height = 2*(SUBWFRING_OUTERRAD+SUBWFPART_TOPBOTTOM_DIST)
#declare subwfpart_fullwidth = subwfpart_width+2*SUBWFPARTHOLE_WIDTH


#declare SubWf_Part = union
{
  #if( DRAW_SUBWF_PART!=0 )
  difference
  {
    intersection
    {
      cylinder
      {
        <-subwfpart_width/2,1,0>, <subwfpart_width/2,1,0>, 1
        scale <1,SUBWFPART_CYL_YRAD,SUBWFPART_CYL_ZRAD>
      }
      cylinder
      {
        <0,-1000,0>, <0,1000,0>, 1
        scale <subwfpart_width/2,1,SUBWFPART_CUTCYL_ZRAD>
      }
    }
    cylinder
    {
      <0,-1000,0>, <0,1000,0>, SUBWFRING_OUTERRAD
    }
    plane
    {
      -z, -subwfpart_height/2
    }
    plane
    {
      z, -subwfpart_height/2
    }
    // now subract the screw holes
    #declare subwfpart_screw_xcenter = subwfpart_width/2-SUBWFPART_SCREW_XDIST-SUBWFPART_SCREW_RAD
    #declare subwfpart_screw_zcenter = subwfpart_height/2-SUBWFPART_SCREW_ZDIST-SUBWFPART_SCREW_RAD
    cylinder
    {
      <subwfpart_screw_xcenter,-1000,subwfpart_screw_zcenter>,
      <subwfpart_screw_xcenter,SUBWFPART_CYL_YRAD,subwfpart_screw_zcenter>,
      SUBWFPART_SCREW_RAD
      texture { TBlack }
    }
    cylinder
    {
      <-subwfpart_screw_xcenter,-1000,subwfpart_screw_zcenter>,
      <-subwfpart_screw_xcenter,SUBWFPART_CYL_YRAD,subwfpart_screw_zcenter>,
      SUBWFPART_SCREW_RAD
      texture { TBlack }
    }
    cylinder
    {
      <subwfpart_screw_xcenter,-1000,-subwfpart_screw_zcenter>,
      <subwfpart_screw_xcenter,SUBWFPART_CYL_YRAD,-subwfpart_screw_zcenter>,
      SUBWFPART_SCREW_RAD
      texture { TBlack }
    }
    cylinder
    {
      <-subwfpart_screw_xcenter,-1000,-subwfpart_screw_zcenter>,
      <-subwfpart_screw_xcenter,SUBWFPART_CYL_YRAD,-subwfpart_screw_zcenter>,
      SUBWFPART_SCREW_RAD
      texture { TBlack }
    }
    texture { TSubWfPart }
  }
  // now add the subwoofer-holes on the left and right side
  difference
  {
    intersection
    {
      cylinder
      {
        <-1000,1,0>, <1000,1,0>, 1
        scale <1,SUBWFPART_CYL_YRAD,SUBWFPART_CYL_ZRAD>
        scale SUBWFPARTHOLE_CYL_SCALE
      }
      object
      {
        #declare roundbox_cx = subwfpart_fullwidth
        #declare roundbox_cy = 1000
        #declare roundbox_cz = SUBWFPARTHOLE_HEIGHT
        #declare roundbox_round_radius = SUBWFPARTHOLE_ROUNDRAD
        #declare roundbox_scale_corners = 1
        #declare roundbox_scale_roundings = 1
        #include "roundbox.pov"
        RoundBox
      }
    }
    cylinder
    {
      <0,-1000,0>, <0,1000,0>, 1
      scale <subwfpart_width/2,1,SUBWFPART_CUTCYL_ZRAD>
    }
    #declare roundbox_cx = SUBWFPARTHOLE_WIDTH-SUBWFPARTHOLE_OUTERXDIST-SUBWFPARTHOLE_INNERXDIST
    #declare roundbox_cy = 1000
    #declare roundbox_cz = SUBWFPARTHOLE_HEIGHT-2*SUBWFPARTHOLE_ZDIST
    #declare roundbox_round_radius = SUBWFPARTHOLE_INNERROUNDRAD
    #declare roundbox_scale_corners = 1
    #declare roundbox_scale_roundings = 1
    #include "roundbox.pov"
    object
    {
      RoundBox
      translate -(-roundbox_cx/2+subwfpart_fullwidth/2-SUBWFPARTHOLE_OUTERXDIST)*x
      texture { TBlack }
    }
    object
    {
      RoundBox
      translate (-roundbox_cx/2+subwfpart_fullwidth/2-SUBWFPARTHOLE_OUTERXDIST)*x
      texture { TBlack }
    }
    texture { TSubWfPart }
  }
  #end
  #if( DRAW_SUBWF_SPEAKER!=0 )
  object
  {
    SubWf_Speaker
    translate SUBWFPART_SPEAKER_NESTEDDEPTH*y
  }
  #end
  translate SUBWFPART_YMOVE*y
}


#declare subwfcase_width = subwfpart_fullwidth+2*SUBWFCASE_LEFTRIGHT_DIST
#declare subwfcase_height = subwfpart_height+2*SUBWFCASE_TOPBOTTOM_DIST
#declare subwfcase_hole_cutter_height = subwfcase_height-2*SUBWFCASE_HOLE_TOPBOTTOM_DIST

#declare Case_SubWf = union
{
  #if( DRAW_SUBWF_CASE!=0 )
  difference
  {
    intersection
    {
      #declare subwfcase_front_ymove = SUBWFCASE_FRONT_YOFS-SUBWFPART_YMOVE
      box
      {
        <-subwfcase_width/2,0,-subwfcase_height/2>,
        <subwfcase_width/2,SUBWFCASE_DEPTH,subwfcase_height/2>
        translate <0,subwfcase_front_ymove,0>
      }
      // now subtract the slopes at the top and bottom of the box
      merge
      {
        #declare scaled_subwfpart_cyl_zrad = SUBWFPART_CYL_ZRAD*SUBWFCASE_CUTROUND_ZSCALE
        #declare subwfcase_front_cylcenter_dist = abs(SUBWFPART_CYL_YRAD-subwfcase_front_ymove)
        #declare subwfcase_cyl_scale__z = (subwfcase_height-2*SUBWFCASE_CUTROUND_ZDIST)/(2*scaled_subwfpart_cyl_zrad)
        #declare subwfcase_cyl_scale__y = subwfcase_front_cylcenter_dist/SUBWFPART_CYL_YRAD
        #declare subwfcase_cyl_scale = sqrt( pow(subwfcase_cyl_scale__z,2)+pow(subwfcase_cyl_scale__y,2) )
        cylinder
        {
          <-1000,0,0>, <1000,0,0>, 1
          scale <1,SUBWFPART_CYL_YRAD,scaled_subwfpart_cyl_zrad> * subwfcase_cyl_scale
        }
        plane
        {
          -y, 0
        }
        translate SUBWFPART_CYL_YRAD*y
      }
      translate SUBWFPART_YMOVE*y
    }
    // now make black hole for the speaker
    cylinder
    {
      <0,SUBWFCASE_FRONT_YOFS+SUBWFCASE_HOLE_DEPTH,0>, <0,-1000,0>, SUBWFRING_OUTERRAD
      texture { TBlack }
    }
    // now cut out the main hole(s)
    merge
    {
      intersection
      {
        cylinder
        {
          <0,-1000,0>, <0,0,0>, 1
          scale <subwfpart_width/2,1,SUBWFPART_CUTCYL_ZRAD> * SUBWFCASE_HOLE_CUTCYL_SCALE
        }
        plane
        {
          z, subwfcase_hole_cutter_height/2
        }
        plane
        {
          -z, subwfcase_hole_cutter_height/2
        }
      }
      #declare roundbox_cx = SUBWFPARTHOLE_WIDTH-SUBWFPARTHOLE_OUTERXDIST-SUBWFPARTHOLE_INNERXDIST
      #declare roundbox_cy = 1000
      #declare roundbox_cz = SUBWFPARTHOLE_HEIGHT-2*SUBWFPARTHOLE_ZDIST
      #declare roundbox_round_radius = SUBWFPARTHOLE_INNERROUNDRAD
      #declare roundbox_scale_corners = 1
      #declare roundbox_scale_roundings = 1
      #include "roundbox.pov"
      object
      {
        RoundBox
        translate -(-roundbox_cx/2+subwfpart_fullwidth/2-SUBWFPARTHOLE_OUTERXDIST)*x
      }
      object
      {
        RoundBox
        translate (-roundbox_cx/2+subwfpart_fullwidth/2-SUBWFPARTHOLE_OUTERXDIST)*x
      }
      texture { TBlack }
      translate (SUBWFCASE_FRONT_YOFS+SUBWFCASE_HOLE_DEPTH)*y
    }
    texture { TSubWfCase }
  }
  #declare SubWF_OuterCase = difference
  {
    intersection
    {
      box
      {
        <-SUBWFCASES_WIDTH/2,0,-SUBWFCASES_HEIGHT/2>,
        <SUBWFCASES_WIDTH/2,SUBWFCASE_DEPTH,SUBWFCASES_HEIGHT/2>
        translate <0,subwfcase_front_ymove,0>
      }
      // now subtract the slopes at the top and bottom of the box
      merge
      {
        #declare subwfcase_cyl_scale__z2 = (SUBWFCASES_HEIGHT-2*SUBWFCASE_CUTROUND_ZDIST)/(2*scaled_subwfpart_cyl_zrad)
        #declare subwfcase_cyl_scale2 = sqrt( pow(subwfcase_cyl_scale__z2,2)+pow(subwfcase_cyl_scale__y,2) )
        cylinder
        {
          <-1000,0,0>, <1000,0,0>, 1
          scale <1,SUBWFPART_CYL_YRAD,scaled_subwfpart_cyl_zrad> * subwfcase_cyl_scale2
        }
        plane
        {
          -y, 0
        }
        translate SUBWFPART_CYL_YRAD*y
      }
      translate SUBWFPART_YMOVE*y
    }
    // now cut out the main hole(s)
    object
    {
      #declare roundbox_cx = SUBWFCASES_WIDTH-2*SUBWFCASES_HUGEHOLE_XDIST
      #declare roundbox_cy = 1000
      #declare roundbox_cz = SUBWFCASES_HEIGHT-2*SUBWFCASES_HUGEHOLE_ZDIST
      #declare roundbox_round_radius = SUBWFCASES_HUGEHOLE_ROUNDRAD
      #declare roundbox_scale_corners = 1
      #declare roundbox_scale_roundings = 1
      #include "roundbox.pov"
      RoundBox
      translate (-roundbox_cy/2+SUBWFCASE_DEPTH/2+SUBWFCASE_FRONT_YOFS)*y
      texture { TBlack }
    }
    texture { TSubWfOuterCase }
  }
  object
  {
    SubWF_OuterCase
    //translate ((subwfcase_height-SUBWFCASES_HEIGHT)/2)*z
    translate -(SUBWFCASES_WIDTH/2+SUBWFCASES_XDIST+subwfcase_width/2)*x
  }
  object
  {
    SubWF_OuterCase
    //translate ((subwfcase_height-SUBWFCASES_HEIGHT)/2)*z
    translate (SUBWFCASES_WIDTH/2+SUBWFCASES_XDIST+subwfcase_width/2)*x
  }
  #end
}


#declare Box_SubWoofer = union
{
  #if( DRAW_SUBWOOFER_BOX!=0 )
  object
  {
    SubWf_Part
  }
  object
  {
    Case_SubWf
  }
  #end
}


// -- Lightorgan --


#declare Case_LtOrg = union
{
  #if( DRAW_LTORG_CASE!=0 )
  difference
  {
    merge
    {
      cylinder
      {
        <-LTORGCASE_WIDTH/2,0,0>,
        <LTORGCASE_WIDTH/2,0,0>,
        LTORGCASE_RAD
        texture { TLtOrgCase }
      }
      merge
      {
        #declare i=1
        #while( i<LTORGCASERING_COUNT-1 )
          torus
          {
            LTORGCASE_RAD, LTORGCASERING_RAD
            rotate 90*z
            translate (-LTORGCASE_WIDTH/2+LTORGCASE_WIDTH*i/(LTORGCASERING_COUNT-1))*x
          }
          #declare i=i+1
        #end
        torus
        {
          LTORGCASE_RAD, LTORGCASERING_BIGRAD
          rotate 90*z
          translate (-LTORGCASE_WIDTH/2)*x
        }
        torus
        {
          LTORGCASE_RAD, LTORGCASERING_BIGRAD
          rotate 90*z
          translate (LTORGCASE_WIDTH/2)*x
        }
        texture { TLtOrgCaseRings }
      }
    }
    box
    {
      <-LTORGCASE_WIDTH/2+LTORGCASE_HOLE_LEFTRIGHT_DIST,-1000,-(LTORGCASE_RAD-LTORGCASE_HOLE_TOPBOTTOM_DIST)>,
      <LTORGCASE_WIDTH/2-LTORGCASE_HOLE_LEFTRIGHT_DIST,-LTORGCASE_RAD*(1-LTORGCASE_HOLE_DEPTH),(LTORGCASE_RAD-LTORGCASE_HOLE_TOPBOTTOM_DIST)>
      texture { TLtOrgCaseHole }
    }
  }
  #end
}


#declare LightOrgan = union
{
  #if( DRAW_LIGHTORGAN!=0 )
  object
  {
    Case_LtOrg
  }
  #end
}


// -- Organ --


#declare org_hole_leftdist = ORG_HOLE_RIGHTDIST
#declare org_hole_rightdist = ORG_HOLE_LEFTDIST
#declare org_side = 1
#if( DRAW_ORG_LEFT!=0 )
  #declare org_side = -1
  #declare org_hole_leftdist = ORG_HOLE_LEFTDIST
  #declare org_hole_rightdist = ORG_HOLE_RIGHTDIST
#end
#declare orgcase_cone_innerrad = ORGCASE_CONE_INNERRAD
#if( orgcase_cone_innerrad<0 )
  #declare orgcase_cone_innerrad = 0
#end
#declare orgcase_cone_height = ORGCASE_CONE_HEIGHT
#declare orgcase_cone_angle = org_side*ORGCASE_CONE_ANGLE
#declare orgcase_cone2_angle = org_side*ORGCASE_CONE2_ANGLE
#declare orgcase_box_startangle = org_side*(ORGCASE_BOX_STARTANGLE+ORGCASE_BOX_WIDTHANGLE/2)
#declare orgcase_xmove = org_side*(-ORGCASE_WIDTH/2-ORGCASE_XOFS)

#declare Case_Org = union
{
  #if( DRAW_ORG_CASE!=0 )
  #if( DRAW_ORG_MAINCYL!=0 )
  object
  {
    intersection
    {
      cylinder
      {
        <0,0,0>,
        <0,0,ORGCASE_CYL_HEIGHT>,
        ORGCASE_CYL_RAD
      }
      texture { TOrgCone }
    }
  }
  #end
  union
  {
    #if( DRAW_ORG_CONE!=0 )
    difference
    {
      cone
      {
        <0,-orgcase_cone_height,0>, ORGCASE_CONE_OUTERRAD,
        <0,0,0>, orgcase_cone_innerrad
      }
      cylinder
      {
        <0,-1000,0>, <0,-orgcase_cone_height+0.01,0>, ORGCASE_CONE_OUTERRAD-ORGCASE_CONE_HOLE_BORDERDIST
        texture { TBlack }
      }
      rotate orgcase_cone_angle*z
      translate ORGCASE_CONE_OUTERRAD*z
      texture { TOrgCone }
    }
    #end
    #if( DRAW_ORG_CONE2!=0 )
    difference
    {
      cone
      {
        <0,-orgcase_cone_height,0>, ORGCASE_CONE_OUTERRAD,
        <0,0,0>, orgcase_cone_innerrad
      }
      cylinder
      {
        <0,-1000,0>, <0,-orgcase_cone_height+0.01,0>, ORGCASE_CONE_OUTERRAD-ORGCASE_CONE_HOLE_BORDERDIST
        texture { TBlack }
      }
      rotate orgcase_cone2_angle*z
      translate ORGCASE_CONE_OUTERRAD*z
      texture { TOrgCone }
    }
    #end
  }
  union
  {
    #declare org_cornerpart_angle = (ORGCASE_BOX_BORDERWIDTH/ORGCASE_BOX_RAD)*180/pi
    #declare org_cornerpart_height = ORGCASE_BOX_BORDERWIDTH
    #declare Org_Part_Cyl = cylinder
    {
      <0,0,0>, <0,0,ORGCASE_BOX_HEIGHT>, ORGCASE_BOX_RAD
      texture { TOrgBoxDark }
    }
    #declare Org_InnerPart_Cyl = cylinder
    {
      <0,0,0>, <0,0,ORGCASE_BOX_HEIGHT>, ORGCASE_BOX_RAD-ORGCASE_BOX_INNERPARTDEPTH
      texture { TOrgBoxDark }
    }
    // first the 4 corner parts
    intersection
    {
      object
      {
        Org_Part_Cyl
      }
      plane
      {
        x, 0
        rotate (-ORGCASE_BOX_WIDTHANGLE/2+org_cornerpart_angle)*z
      }
      plane
      {
        -x, 0
        rotate (-ORGCASE_BOX_WIDTHANGLE/2)*z
      }
      plane
      {
        z, org_cornerpart_height
      }
      texture { TOrgBoxDark }
    }
    intersection
    {
      object
      {
        Org_Part_Cyl
      }
      plane
      {
        x, 0
        rotate (ORGCASE_BOX_WIDTHANGLE/2)*z
      }
      plane
      {
        -x, 0
        rotate (ORGCASE_BOX_WIDTHANGLE/2-org_cornerpart_angle)*z
      }
      plane
      {
        z, org_cornerpart_height
      }
      texture { TOrgBoxDark }
    }
    intersection
    {
      object
      {
        Org_Part_Cyl
      }
      plane
      {
        x, 0
        rotate (-ORGCASE_BOX_WIDTHANGLE/2+org_cornerpart_angle)*z
      }
      plane
      {
        -x, 0
        rotate (-ORGCASE_BOX_WIDTHANGLE/2)*z
      }
      plane
      {
        -z, -(ORGCASE_BOX_HEIGHT-org_cornerpart_height)
      }
      texture { TOrgBoxDark }
    }
    intersection
    {
      object
      {
        Org_Part_Cyl
      }
      plane
      {
        x, 0
        rotate (ORGCASE_BOX_WIDTHANGLE/2)*z
      }
      plane
      {
        -x, 0
        rotate (ORGCASE_BOX_WIDTHANGLE/2-org_cornerpart_angle)*z
      }
      plane
      {
        -z, -(ORGCASE_BOX_HEIGHT-org_cornerpart_height)
      }
      texture { TOrgBoxDark }
    }
    // now the horizontal, vertical and inner parts
    #declare cx = ORGCASE_BOX_CHORZPARTS
    #declare cy = ORGCASE_BOX_CVERTPARTS
    #declare cx_part = ORGCASE_BOX_XPARTSCALE   // 0.0 to 1.0
    #declare cy_part = ORGCASE_BOX_YPARTSCALE   // 0.0 to 1.0
    #declare fullangle = ORGCASE_BOX_WIDTHANGLE-2*org_cornerpart_angle
    #declare anglestep = fullangle/(cx+1-cx_part)
    #declare partangle = anglestep*cx_part
    #declare spaceangle = anglestep*(1-cx_part)
    #declare startangle = -ORGCASE_BOX_WIDTHANGLE/2+org_cornerpart_angle+spaceangle
    #declare fullheight = ORGCASE_BOX_HEIGHT-2*org_cornerpart_height
    #declare heightstep = fullheight/(cy+1-cy_part)
    #declare partheight = heightstep*cy_part
    #declare spaceheight = heightstep*(1-cy_part)
    #declare startheight = org_cornerpart_height+spaceheight
    // first the horz top parts
    #declare xx = 0
    #while( xx<cx )
      #declare angle_now = startangle+xx*anglestep
      intersection
      {
        object
        {
          Org_Part_Cyl
        }
        plane
        {
          x, 0
          rotate (angle_now+partangle)*z
        }
        plane
        {
          -x, 0
          rotate (angle_now)*z
        }
        plane
        {
          -z, -(ORGCASE_BOX_HEIGHT-org_cornerpart_height)
        }
        texture { TOrgBoxDark }
      }
      #declare xx = xx+1
    #end
    // now vertical and inner parts
    #declare yy = 0
    #while( yy<cy )
      // first the left vert parts
      #declare height_now = startheight+yy*heightstep
      intersection
      {
        object
        {
          Org_Part_Cyl
        }
        plane
        {
          x, 0
          rotate (-ORGCASE_BOX_WIDTHANGLE/2+org_cornerpart_angle)*z
        }
        plane
        {
          -x, 0
          rotate (-ORGCASE_BOX_WIDTHANGLE/2)*z
        }
        plane
        {
          -z, -height_now
        }
        plane
        {
          z, height_now+partheight
        }
        texture { TOrgBoxDark }
      }
      // now the inner parts
      #declare xx = 0
      #while( xx<cx )
        #declare angle_now = startangle+xx*anglestep
        intersection
        {
          object
          {
            Org_InnerPart_Cyl
          }
          plane
          {
            x, 0
            rotate (angle_now+partangle)*z
          }
          plane
          {
            -x, 0
            rotate (angle_now)*z
          }
          plane
          {
            -z, -height_now
          }
          plane
          {
            z, height_now+partheight
          }
          texture { TOrgBoxDark }
        }
        #declare xx = xx+1
      #end
      // now the right vert parts
      #declare height_now = startheight+yy*heightstep
      intersection
      {
        object
        {
          Org_Part_Cyl
        }
        plane
        {
          x, 0
          rotate (ORGCASE_BOX_WIDTHANGLE/2)*z
        }
        plane
        {
          -x, 0
          rotate (ORGCASE_BOX_WIDTHANGLE/2-org_cornerpart_angle)*z
        }
        plane
        {
          -z, -height_now
        }
        plane
        {
          z, height_now+partheight
        }
        texture { TOrgBoxDark }
      }
      #declare yy = yy+1
    #end
    // now the horz bottom parts
    #declare xx = 0
    #while( xx<cx )
      #declare angle_now = startangle+xx*anglestep
      intersection
      {
        object
        {
          Org_Part_Cyl
        }
        plane
        {
          x, 0
          rotate (angle_now+partangle)*z
        }
        plane
        {
          -x, 0
          rotate (angle_now)*z
        }
        plane
        {
          z, org_cornerpart_height
        }
        texture { TOrgBoxDark }
      }
      #declare xx = xx+1
    #end
    // now the main cylinder sector
    intersection
    {
      cylinder
      {
        #if( DRAW_ORG_MASKS=0 )
        <0,0,org_cornerpart_height/2>, <0,0,ORGCASE_BOX_HEIGHT-org_cornerpart_height/2>, ORGCASE_BOX_RAD-ORGCASE_BOX_DEPTH
        #else
        <0,0,0>, <0,0,ORGCASE_BOX_HEIGHT>, ORGCASE_BOX_RAD-ORGCASE_BOX_FIREDEPTH
        #end
      }
      plane
      {
        x, 0
        rotate (ORGCASE_BOX_WIDTHANGLE/2-org_cornerpart_angle/2)*z
      }
      plane
      {
        -x, 0
        rotate -(ORGCASE_BOX_WIDTHANGLE/2-org_cornerpart_angle/2)*z
      }
      texture { TOrgBox }
    }
    rotate orgcase_box_startangle*z
  }
  #if( DRAW_ORG_MAINCASE!=0 )
  difference
  {
    intersection
    {
      box
      {
        <-ORGCASE_WIDTH/2,0,-ORGCASE_HEIGHT/2>,
        <ORGCASE_WIDTH/2,ORGCASE_DEPTH,ORGCASE_HEIGHT/2>
      }
      // now subtract the slopes at the top and bottom of the box
      merge
      {
        #declare scaled_org_cyl_zrad = ORG_CYL_ZRAD*ORG_CUTROUND_ZSCALE
        #declare org_front_cylcenter_dist = abs(ORG_CYL_YRAD)
        #declare org_cyl_scale__z = (ORGCASE_HEIGHT-2*ORG_CUTROUND_ZDIST)/(2*scaled_org_cyl_zrad)
        #declare org_cyl_scale__y = org_front_cylcenter_dist/ORG_CYL_YRAD
        #declare org_cyl_scale = sqrt( pow(org_cyl_scale__z,2)+pow(org_cyl_scale__y,2) )
        cylinder
        {
          <-1000,0,0>, <1000,0,0>, 1
          scale <1,ORG_CYL_YRAD,scaled_org_cyl_zrad> * org_cyl_scale
        }
        plane
        {
          -y, 0
        }
        translate ORG_CYL_YRAD*y
      }
      texture { TOrgCase }
    }
    difference
    {
      intersection
      {
        box
        {
          <-ORGCASE_WIDTH/2+org_hole_leftdist,-1000,-ORGCASE_HEIGHT/2+ORG_HOLE_ZDIST>,
          <ORGCASE_WIDTH/2-org_hole_rightdist,ORG_HOLE_DEPTH,ORGCASE_HEIGHT/2-ORG_HOLE_ZDIST>
        }
        /*
        cylinder
        {
          <0,-1000,0>, <0,1000,0>, (ORGCASE_WIDTH-org_hole_rightdist-org_hole_leftdist)/2
          translate ((org_hole_leftdist-org_hole_rightdist)/2)*x
        }
        */
      }
      /*
      cylinder
      {
        <0,-1000,0>, <0,1000,0>, ORG_HOLECUTCYL_RAD
        translate <-org_side*ORG_SPHERE_XMOVE,0,0>
      }
      */
      texture { TBlack }
    }
    /*
    intersection
    {
      sphere
      {
        <0,0,0>, ORG_SPHERE_RAD
        scale <1,ORG_SPHERE_YRAD/ORG_SPHERE_RAD,1>
        translate ORG_SPHERE_YOFS*y
        texture { TOrgCase }
        //texture { TBlack }
      }
      plane
      {
        y, ORG_SPHERE_YCUT
        texture { TBlack }
      }
      translate <-org_side*ORG_SPHERE_XMOVE,0,0>
    }
    */
    translate (ORGCASE_HEIGHT/2)*z
    translate <orgcase_xmove,ORGCASE_YOFS,0>
  }
  /*
  object
  {
    intersection
    {
      sphere
      {
        <0,0,0>, ORG_SPHERE_RAD
        scale <1,ORG_SPHERE_YRAD/ORG_SPHERE_RAD,1>
        translate -ORG_SPHERE_YOFS*y
        texture { TOrgCase }
      }
      plane
      {
        -y, ORG_SPHERE_YCUT
        texture { TBlack }
      }
      translate <-org_side*ORG_SPHERE_XMOVE,0,0>
    }
    translate (ORGCASE_HEIGHT/2)*z
    translate <orgcase_xmove,ORGCASE_YOFS,0>
  }
  */
  #end
  #end
}


#declare Organ = union
{
  #if( DRAW_ORGAN!=0 )
  object
  {
    Case_Org
    translate -0.01*z
  }
  #end
}


// --------


union
{
  object
  {
    Box_3Way
  }

  object
  {
    Box_BigWoofer
  }

  object
  {
    Box_Slider
  }

  object
  {
    Box_SubWoofer
  }

  object
  {
    LightOrgan
  }

  object
  {
    Organ
  }

  #if( DRAW_AS_MASK=0 )
  object
  {
    #declare magnet2_outerxradius = 0
    #declare magnet2_outerzradius = 0
    #declare magnet2_innerxradius = 0
    #declare magnet2_innerzradius = 0
    #declare magnet2_outerfixingradius = 0
    #declare magnet2_height = 0
    #declare magnet2_sphere_nested_angle = 0
    #include "magnet2.pov"
    Magnet_Lights2
    scale 100
  }
  #end

  scale WORLD_SCALE
  translate WORLD_ZOFS*z
  rotate ROTATE_SCENE
}
