;[]---------------------------------------------------------------------[]
;| RTC - Real Time Clock handler by Kenneth Foo aka TechnoMaestro/RDG.   |
;| 11th March 1995.                                                      |
;[]---------------------------------------------------------------------[]
;DATA 
	OrigINT70       dd 0
	UserRoutine     dd 0
	UpRate          dw 0
	Counts          dw 1
	CountVal        dw 1
;
;Initialize Real Time Clock
;I:     byte UpdateValue, SEG:OFF of int routine (Ends with IRET).
;O:     Carry Set = Error.
;Note:  These update values corresponds to the following frequencies.
;       Value           Frequency
;       0               2     Hz
;       1               4     Hz
;       2               8     Hz
;       3               16    Hz
;       4               32    Hz
;       5               64    Hz
;       6               128   Hz
;       7               256   Hz
;       8               512   Hz
;       9               1024  Hz
;       10              2048  Hz
;       11              4096  Hz
;       12              8192  Hz
;       13              16384 Hz
;       14              32768 Hz
;       15              65536 Hz
;
;       The frequency formula = 2^(x+1)  (^ means to the power of)
;       where x is in range of 0 to 15 (4-bit value).
;
;       ****************************************************
;       ** IF YOU'RE NOT VERY SURE, JUST SET IT TO 1024hz **
;       ** USING HIGH UPDATE RATES SLOW DOWN THE SYSTEM!! **
;       ****************************************************
;
;       The far routine should return with a RETF instruction.
;
;       By default, the call rate = update rate.
;
RTCinit PROC USES ax bx cx dx es ds, UpdateValue:BYTE, Routine:DWORD

	;=====Test presence of RTC and make sure it's functional.
	mov     al,0Eh
	out     070h,al
	jmp     $+2
	in      al,071h
	test    al,10000000b
	jnz     @@Error

	mov     ax,word ptr Routine[0]          ;Set user routine address
	mov     word ptr cs:UserRoutine[0],ax
	mov     ax,word ptr Routine[2]
	mov     word ptr cs:UserRoutine[2],ax

	mov     cl,UpdateValue                  ;Record update rate
	mov     ax,10b
	shl     ax,cl
	mov     cs:UpRate    ,ax

	mov     ax,03570h                       ;Save int
	int     21h
	mov     word ptr cs:OrigINT70[0],bx
	mov     word ptr cs:OrigINT70[2],es

	;=====Initialize RTC
	cli
	;=====Hook up interrupt handler
	;xor     ax,ax
	;mov     ds,ax
	;mov     ax,[ds:070h*4][0]
	;mov     word ptr cs:OrigINT70[0],ax     ;Save original handler
	;mov     ax,[ds:070h*4][2]
	;mov     word ptr cs:OrigINT70[2],ax
	;mov     ax,offset RTChandler            ;Set new handler
	;mov     [ds:070h*4][0],ax
	;mov     ax,cs
	;mov     [ds:070h*4][2],ax
	push    cs
	pop     ds
	mov     dx,offset RTChandler
	mov     ax,02570h
	int     21h

	mov     al,0bh                  ;Disable periodic interrupt
	out     070h,al
;        in      al,071h
;        and     al,10111111b
;mov     ah,al
;mov     al,0bh
;out     070h,al
;mov     al,ah

	mov     al,00000010b

	out     071h,al

	mov     al,0ah                  ;Set rate
	out     070h,al
	mov     al,UpdateValue
	neg     al
	add     al,15
	or      al,00100000b            ;32khz timer
;mov     al,025h
	out     071h,al

	mov     al,0bh                  ;Enable periodic interrurpt
	out     070h,al
;        in      al,071h
;        or      al,01000000b            ;Enable periodic int
;mov     ah,al
;mov     al,0bh
;out     070h,al
;mov     al,ah

	mov     al,01000010b

	out     071h,al

	in      al,021h                         ;Enable IRQ 2
	and     al,11111011b
	out     021h,al
	in      al,0a1h                         ;Enable IRQ 8
	and     al,11111110b
	out     0a1h,al
	mov     al,020h                         ;Send EOI
	out     020h,al
	out     0a0h,al

	sti
	clc
	ret
	@@Error:
	stc
	ret
	db 'RealTimeClock handler by TechnoMaestro. 1995.'
	ENDP

;
;Deinitialize RTC
;
RTCdeinit PROC USES ax dx ds
	cli
	mov     al,0bh                          ;Disable RTC interrupt.
	out     070h,al
	;in      al,071h
	;and     al,NOT 01000000b
	mov     al,00000010b
	out     071h,al
	;xor     ax,ax
	;mov     ds,ax
	;mov     ax,word ptr cs:OrigINT70[0]
	;mov     [ds:070h*4][0],ax
	;mov     ax,word ptr cs:OrigINT70[2]
	;mov     [ds:070h*4][2],ax

	lds     dx,cs:OrigINT70                 ;Unhook
	mov     ax,02570h
	int     21h

	sti
	ret
	ENDP

;
;Set routine call rate
;I:     word RateInHertz
;Note:  Call rate is best when it is much smaller than the RTC update
;       rate (2,4,8,16,...65536 Hz thingy at RTCinit)!!
;
;       Maximum call rate is the update rate.
;
RTCsetRate PROC USES eax ebx edx, CallRate:WORD
	cli
	;xor     dx,dx                           ;Get update rate in DX
	;mov     ax,cs:UpRate
	;sub     ax,1
	;adc     dx,0
	;inc     ax
	;div     CallRate
	;mov     cs:Counts,ax
	;mov     cs:CountVal,1

	mov     ax,CallRate                     ;Fixed point
	shl     eax,16
	xor     edx,edx
	movzx   ebx,cs:UpRate
	div     ebx
	mov     cs:Counts,ax
	mov     cs:CountVal,0

	sti
	ret
	ENDP

;
;INTERRUPT HANDLER
;
RTChandler PROC FAR
	push    ax
	;dec     cs:CountVal
	;jnz     short @@NotTimeToCall
	;mov     ax,cs:Counts
	;mov     cs:CountVal,ax

	mov     al,0ch                  ;Enable RTC interrupt
	out     070h,al
	in      al,071h

	mov     ax,cs:CountVal
	add     ax,cs:Counts
	cmp     ax,cs:CountVal          ;If new count =< old count == overflow!
	mov     cs:CountVal,ax
	ja      short @@NotTimeToCall

;        ;Enable INT 8h to function...
;        mov     al,020h
;        out     020h,al
;        in      al,021h
;        and     al,not 1b
;        out     21h,al
;        sti

	pushf
	call    dword ptr cs:UserRoutine
	@@NotTimeToCall:

	mov     al,020h                         ;EOI
	out     020h,al                         ;This is required (dunno why)
	out     0A0h,al
	pop     ax
	iret
	ENDP

