;'MI.USERFLAG' ???
;TRKeffectData2 EQU <TRKeffectData>
;TRKeffectData2 always holds the previous effect (whatever effect) parameter.
;[]------------------------------------------------------------------------[]
;| AUDIO MANAGER III by Kenneth Foo aka TechnoMaestro 1994.                 |
;[]------------------------------------------------------------------------[]
;  [AMM] MUSIC INTERPRETER
VolumeBarSpeed = 2

IF _AMMONLY_ EQ 0
INCLUDE MOD.INC
IF _TP_ EQ 0
INCLUDE S3M.INC
ENDIF
ENDIF

IF _TP_ EQ 0
INCLUDE AMM.INC
ENDIF

;
;NOTES
; AMM is really just a variant of S3M format. It however, does not use
; compressed notes (will be implemented in the future, for memory and file).
; It can handle what the S3M does...and maybe some more...
;
; MI will also handle some of the S3M bugs. Read the S3M.INC file for the
; notes there on S3Ms 'bugs'.
;
;POSSIBLE BUGS
;  I still don't feel comfortable with the pattern delay/loop routines.
;   I'm not sure it'll cause problems...but what the heck...it worked here...
;  Also, I might not have the correct waveforms for tremolo/vibrato.
;  Scream Tracker bug: Efx param 00 for those which support is as use previous
;   value will use the previous value of ANY effect! So, using a set speed to
;   6 and then using a volume slide with param 00 will yield a result of
;   having volume slide down by speed 6! This is really stupid if you ask
;   me. Anyway...FastTracker 2 doesn't have this bug.
;
;
;
;EQUATES
;
;MACROS
CLIPPERIOD MACRO
	local   uses3mlimit,upperokS3M,lowerokS3M,NotS3Mbug,upperok,lowerok
	push    ebx ecx
	mov     ebx,07FFFh                      ;;ST3 upper limit
	mov     ecx,64                          ;;ST3 lower limit
	test    Music.MUSinfo,1b
	jz      short UseS3Mlimit
	mov     ebx,1712*4 ;856*4               ;;MOD upper limit
	mov     ecx,56*4 ;113*4                 ;;MOD lower limit
	UseS3Mlimit:
	;;******************************************************************
	;;S3M BUG - DOESN'T TEST FOR NEGATIVE VALUES. ASSUMES NEGATIVE
	;;VALUES (8000h - FFFFh as too big and it clips to the upper PERIOD
	;;limit). Effect is present in PANIC demo.
	;;******************************************************************
	test    Music.MUSinfo,100b              ;;S3M BUG.
	jz      short NotS3Mbug
	cmp     ax,bx
	jbe     short UpperOKS3M
	mov     ax,bx
	UpperOKS3M:
	cmp     ax,cx
	jge     short LowerOKS3M
	mov     ax,cx
	LowerOKS3M:
	jmp     short LowerOK
      NotS3Mbug:                                ;;Else, use AMM non-bugged.
	cmp     eax,ebx
	jle     short UpperOK
	mov     eax,ebx
	UpperOK:
	cmp     eax,ecx
	jge     short LowerOK
	mov     eax,ecx
	LowerOK:
	pop     ecx ebx
	ENDM
;
;GLOBAL DATA IN DATA SEGMENT
;
.DSEG
.DSEG_ENDS
;
;DATA IN CODE SEGMENT
;
.CSEG   AM
AM_MI_INFO DB 'AUDIO MANAGER 3.0: MUSIC INTERPRETER by Kenneth Foo'

	;STRUCTURE DECLARATION
	DD_ALIGN
	Music   MusicX  <>
	DD_ALIGN
	MI      MIX     <>

	;POINTERS TO...
	DD_ALIGN
	MI_SampleMemHandle      dd 0            ;SDI memory handle for
						;music.
	MI_TrackPatterns        dd MI@MaxPatterns dup(0)        ;Patterns
	MI_Samples              dw MI@MaxSamples+1 dup(0)       ;Sample struc
	MI_SampleInfos          db (MI@MaxSamples+1)*(SIZE SmpX) dup(0)

	;STORAGE
	MI_OrigUpdateRoutine    dd _AMidle
	MI_OrigUpdateRate       dw 20
	MI_TrackNumber          dw 0
	MI_OrigqNumEMSblocks    dw 0
	MI_SavedMemFlag         db 0
	MI_MappingContext       db MEM@mapLength dup(0)
	MI_Buffer               db 512 dup(0)

	;SYSTEM
	;MUSIC IMPLEMENTATION
	DD_ALIGN
	;AM_FinePortaSteps       dw 1
	;AM_NormalPortaSteps     dw 4

	MI_FineTuneFrequency    DW      7895    ;Fine tune frequencies for
				DW      7941    ;C-2. 8=Normal 8363 hertz.
				DW      7985
				DW      8046
				DW      8107
				DW      8169
				DW      8232
				DW      8280
				DW      8363
				DW      8413
				DW      8463
				DW      8529
				DW      8581
				DW      8651
				DW      8723
				DW      8757
			   ;  C      C#       D      D#       E       F
	MI_PeriodTable  DW 1712*16,1616*16,1524*16,1440*16,1356*16,1280*16
			DW 1208*16,1140*16,1076*16,1016*16,0960*16,0907*16
			   ; F#       G      G#       A      A#       B

	; volume fade tables for Retrig Note:
			;To add to volume
	MI_RetrigDelta  DB 0,-1,-2,-4,-8,-16,0,0,0,1,2,4,8,16,0,0
	MI_RetrigMul    DB 16,16,16,16,16,16,10,8,16,16,16,16,16,16,24,32
			;Volume multiplier (16x larger)

	MI_WaveForms    LABEL WORD
	SineWave \
		dw        0, 24, 49, 74, 97,120,141,161         ;2nd half cycle (ADD -- lower tone)
		dw      180,197,212,224,235,244,250,253
		dw      255,253,250,244,235,224,212,197
		dw      180,161,141,120, 97, 74, 49, 24
		dw        -0, -24, -49, -74, -97,-120,-141,-161 ;1st half cycle (ADD -- higher tone)
		dw      -180,-197,-212,-224,-235,-244,-250,-253
		dw      -255,-253,-250,-244,-235,-224,-212,-197
		dw      -180,-161,-141,-120, -97, -74, -49, -24
	RampDownWave \
		dw      -255,-246,-238,-230,-222,-214,-206,-198
		dw      -190,-182,-174,-165,-157,-149,-141,-133
		dw      -125,-117,-109,-101,-093,-085,-076,-068
		dw      -060,-052,-044,-036,-028,-020,-012,-004
		dw       005, 013, 021, 029, 037, 045, 053, 061
		dw       069, 077, 085, 094, 102, 110, 118, 126
		dw       134, 142, 150, 158, 166, 175, 183, 191
		dw       199, 207, 215, 223, 231, 239, 247, 255
	SquareWave \
		dw      255,255,255,255,255,255,255,255
		dw      255,255,255,255,255,255,255,255
		dw      255,255,255,255,255,255,255,255
		dw      255,255,255,255,255,255,255,255
		dw      000,000,000,000,000,000,000,000
		dw      000,000,000,000,000,000,000,000
		dw      000,000,000,000,000,000,000,000
		dw      000,000,000,000,000,000,000,000
	;This is my idea of the random wave (note: it's sub-random)
	RandomWave \
		dw      -100,030,020,-240,040,100,200,-010
		dw      -050,143,123,255,-000,128,-032,005
		dw      063,-038,102,255,128,000,-222,111
		dw      -044,077,-011,200,102,204,-220,000
		dw      100,030,020,240,-040,100,-200,-010
		dw      050,143,123,-255,000,128,-032,-005
		dw      -063,038,-102,-255,128,-000,222,111
		dw      044,-077,011,-200,102,204,220,000
.CSEG_ENDS AM


;
;CODE
;
.CSEG   AM

; MUSIC STUFF 
; MUSIC STUFF 
; MUSIC STUFF 
;
;_AMmusicInit                                                             
;NOTE: This routine will not interfere with normal sound handling, as it  
;      only modifies the music system part.                               
;
_AMmusicInit PROC USES BX CX SI DI ES DS
	setDS
	;SETUP POINTERS TO SAMPLE STRUCTURES
	mov     di,offset MI_SampleInfos
	xor     bx,bx                   ;Start from sample number 0
	mov     cx,MI@MaxSamples+1      ;But out music system will use only
	@@WriteSamplePointers:          ;from sample number 1...
	mov     MI_Samples[bx],di
	mov     byte ptr [cs:SmpX.SMPmarker][di+0],'A'
	mov     byte ptr [cs:SmpX.SMPmarker][di+1],'M'
	mov     byte ptr [cs:SmpX.SMPmarker][di+2],'S'
	mov     byte ptr [cs:SmpX.SMPmarker][di+3],01Ah
	mov     [cs:SmpX.SMPmidC][di],8363
	mov     [cs:SmpX.SMPlength][di],0
	mov     [cs:SmpX.SMPloopB][di],0
	mov     [cs:SmpX.SMPloopP][di],0
	;mov     [cs:SmpX.SMPinfo][di],10b
	;mov     MI.MIflag,0             ;DO NOT CLEAR FLAG! SET BY USER!Clear flag

	mov     MI_SampleMemHandle,0
	push    cx
	mov     si,di                   ;Clear name
	mov     cx,(SIZE SmpX.SMPname)
	@@ClearName:
	mov     [cs:SmpX.SMPname][si],0
	inc     si
	loop    @@ClearName
	mov     si,di                   ;Clear file name
	mov     cx,(SIZE SmpX.SMPfileName)
	@@ClearFileName:
	mov     [cs:SmpX.SMPfileName][si],0
	inc     si
	loop    @@ClearFileName
	pop     cx
	add     di,SIZE SmpX
	add     bx,2
	loop    @@WriteSamplePointers

	mov     Music.MUSmarker,'MMA'
	clc
	ret
	ENDP
;
;_AMmusicDeinit                                                           
;
_AMmusicDeinit PROC
	clc
	ret
	ENDP
;
;_AMmusicUnload                                                           
;
_AMmusicUnload PROC USES BX CX DI DS
	setDS
	;CHECK AM SYSTEM, IF INITIALIZED.
	mov     ErrorCode,ERR_NotPossible
	test    AM.AM_Status,1b
	jz      @@Error
	;CHECK IF A MODULE IS ALREADY UNLOADED
	test    AM.AM_Status,1000000000000b
	mov     ErrorCode,ERR_NotPossible
	jz      @@Error
	;CLEAR PATTERN MEMORY
	mov     ErrorCode,ERR_CannotManageMemory
	mov     bx,2                            ;Start from track 1
	mov     cx,Music.MUSnumberTracks
	@@ClearPatterns:
	mov     di,AM_TrackTable[bx]
	mov     eax,[cs:TrackX.TRKmemHandle][di]
	or      eax,eax
	jz      short @@Empty
	push    eax
	call    _MEMqDealloc
	jc      @@Error
	@@Empty:
	mov     [cs:TrackX.TRKmemHandle][di],0  ;CLEAR
	inc     bx
	inc     bx
	loop    @@ClearPatterns
	;CLEAR SAMPLE MEMORY
	push    MI_SampleMemHandle
	call    _AMdeallocMem
	jc      @@Error2

	;SET FLAGS
	and     AM.AM_Status,NOT 1000000000000b ;Music unloaded

	quit
	ENDP
;
;_AMmusicPlay                                                             
;I: StartSequenceNumber:W                                                 
;
_AMmusicPlay PROC USES BX CX DX SI DS, StartSequence:WORD
	setDS
	test    AM.AM_Status,1000000000000b        ;LOADED?
	mov     ErrorCode,ERR_NotPossible
	jz      @@Error
	;SET TRACKS TO POINT TO AN EMPTY SAMPLE STRUCTURE...
	mov     ax,cs
	shl     eax,16
	mov     ax,MI_Samples[0]                ;Sample0=empty!
	mov     bx,2
	mov     cx,Music.MUSnumberTracks
	@@SetPoint0:
	mov     si,AM_TrackTable[bx]
	mov     [cs:TrackX.TRKsampleStrucAddress][si],eax
	inc     bx
	inc     bx
	loop    @@SetPoint0
	;INIT AND ENABLE TRACKS
	mov     bx,1
	mov     cx,Music.MUSnumberTracks
	@@InitTracks:
	push    bx
	call    _AMinitTrack
	inc     bx
	loop    @@InitTracks
	;SET INIT PANNING POSITIONS AND MASTER VOLUME & CLEAR EFX
	mov     bx,2                                    ;Start TRK1
	mov     cx,Music.MUSnumberTracks
	@@SetInitPanPos:
	mov     si,AM_TrackTable[bx]
	mov     [cs:TrackX.TRKeffectNumber][si],0
	mov     [cs:TrackX.TRKeffectData][si],0
	mov     [cs:TrackX.TRKeffectData2][si],0
	shr     bx,1
	;dec     bx
	mov     al,Music.MUSinitPan[bx]
	;inc     bx
	  push    bx
	shl     bx,1
	  xor     ah,ah
	  push    ax
	  call    _AMsetPanPos
	inc     bx
	inc     bx
	loop    @@SetInitPanPos
	;SET MASTER VOLUME AND AMPLIFICATION
	push    Music.MUSmasterVolume
	call    _AMmusicMasterVolume
	push    Music.MUSamplification
	call    _AMamplification
	;SET INIT TEMPO/SPEED & HOOKS TO SDI TIMED-UPDATING ROUTINE
	mov     ax,AM_UpdateRate
	mov     MI_OrigUpdateRate,ax
	mov     eax,AM_UpdateRoutine
	mov     MI_OrigUpdateRoutine,eax

	mov     bx,2 ;Simply put ... track 1; Just to set up Track structure
	mov     si,AM_TrackTable[bx]    ;pointer.
	mov     al,Music.MUSinitTempo                   ;Set TEMPO
	xor     ah,ah
	mov     [cs:TrackX.TRKeffectData][si],ax
	mov     [cs:TrackX.TRKeffectData2][si],ax
	call    _MIefx_SetTempo
	mov     al,Music.MUSinitSpeed                   ;Set SPEED
	xor     ah,ah
	mov     [cs:TrackX.TRKeffectData][si],ax
	mov     [cs:TrackX.TRKeffectData2][si],ax
	call    _MIefx_SetSpeed
	mov     [cs:TrackX.TRKeffectNumber][si],0       ;Clear EFX
	mov     [cs:TrackX.TRKeffectData][si],0
	mov     [cs:TrackX.TRKeffectData2][si],0

	;SET TICK COUNT, CURRENT/NEXTROW, CURRENT/NEXTSEQUENCE
	mov     ax,MI.MIspeed
	mov     MI.MItickCount,1        ;Make it called the first time!ax
	mov     ax,StartSequence
	cmp     ax,Music.MUSsongLength
	jbe     short @@StartSeqOK
	xor     ax,ax                   ;Bad start sequence...
	@@StartSeqOK:
	mov     MI.MIcurrentSequence,ax
	mov     MI.MInextSequence,ax
	mov     MI.MIcurrentRow,0
	mov     MI.MInextRow,0
	mov     MI.MItargetSequence,65535
	mov     MI.MItargetRow,65535
	mov     MI.MIpatternLoopSequence,0
	mov     MI.MIpatternLoopStart,0
	mov     MI.MIpatternLoopEnd,0
	mov     MI.MIpatternLoopCount,0
	mov     MI.MIpatternDelayCount,0
	mov     MI.MIeventData,0
	and     AM.AM_status,NOT (1 SHL 15)

	or      AM.AM_Status,10000000000000b       ;SET PLAYING MUSIC
	and     AM.AM_Status,NOT 100000000000000b  ;CLEAR MUSIC-RESTART BIT
	quit
	ENDP

;
;_AMmusicStop                                                             
;
_AMmusicStop PROC USES BX CX DS
	setDS
	test    AM.AM_Status,10000000000000b       ;PLAYING?
	mov     ErrorCode,ERR_NotPossible
	jz      short @@Error
	;RESTORE UPDATE RATE AND ROUTINE
	push    MI_OrigUpdateRate
	push    MI_OrigUpdateRoutine
	call    _AMsetUpdate
	;DISABLE AND DEINIT TRACKS
	mov     bx,1
	mov     cx,Music.MUSnumberTracks
	@@InitTracks:
	push    bx
	call    _AMdeinitTrack
	inc     bx
	loop    @@InitTracks
	and     AM.AM_Status,NOT 10000000000000b   ;SET STOPPED MUSIC
	quit
	ENDP

;
;_AMmusicMasterVolume                                                     
;I:  Volume:W (0-256)                                                     
;
_AMmusicMasterVolume PROC USES BX CX SI DS, Volume:WORD
	setDS
	;CLIP VOLUME AND SET VARIABLES
	mov     ax,Volume
	cmp     ax,256
	jbe     short @@VolOK
	mov     ax,256
	@@VolOK:
	mov     Volume,ax
	mov     MI.MImasterVolume,ax
	;SET INDIVIDUAL TRACK MASTER VOLUMES...
	mov     bx,2                                    ;Start TRK1
	mov     cx,Music.MUSnumberTracks
	@@SetMaster:
	mov     si,AM_TrackTable[bx]
	shr     bx,1
	push    bx
	shl     bx,1
	push    Volume
	call    _AMsetMasterVolume
	inc     bx
	inc     bx
	loop    @@SetMaster
	clc
	ret
	ENDP

;
;_AMmusicGetInfo                                                          
;O:  DX:AX=SEG:OFF of module data struc (MusicX.xxxx)                     
;
_AMmusicGetInfo PROC
	;mov     dx,seg Music
	mov     dx,cs
	mov     ax,offset Music
	ret
	ENDP
;
;_AMmusicGetState                                                         
;O:  DX:AX=SEG:OFF of music state data struc (MIX.xxxx)                   
;
_AMmusicGetState PROC
	;mov     dx,seg MI
	mov     dx,cs
	mov     ax,offset MI
	ret
	ENDP
;
;_AMmusicGetSampleInfo                                                    
;I:  SmpNumber:W                                                          
;O:  DX:AX=SEG:OFF of SmpX struc                                          
;
_AMmusicGetSampleInfo PROC,SmpNum:WORD
	mov     ax,(SIZE SmpX)
	mul     SmpNum
	;mov     dx,seg MI_SampleInfos
	mov     dx,cs
	add     ax,offset MI_SampleInfos
	ret
	ENDP
;
;_AMmusicSetSystem                                                        
;I:  SystemType:W (0=PAL 1=NTSC)                                          
;    By default, MI uses NTSC systems.                                    
;
_AMmusicSetSystem PROC USES BX CX SI, SysType:WORD
	mov     ax,SysType
	mov     MI.MIsystemType,al
	mov     MI.MIdivider,14186947 ;Value=NTSCval/8363*8287   This val--> 14187578  is an extension from MODFIL10.DOC ;PAL? I'm not really sure about this!
	or      ax,ax
	jz      short @@PAL
	mov     MI.MIdivider,14317056   ;NTSC
	@@PAL:

	;=====Update all channels to that certain period...
	mov     cx,Music.MUSnumberTracks
	@@UpdatePeriods:
	mov     bx,cx
	dec     bx
	shl     bx,1
	mov     si,AM_TrackTable[bx]
	movzx   eax,[cs:TrackX.TRKperiod][si]
	call    _MIsetPeriod
	loop    @@UpdatePeriods
	ret
	ENDP
; MUSIC REPLAYER 
; MUSIC REPLAYER 
; MUSIC REPLAYER 
;
;_MIgetPeriod                                                             
;I: AL=Note, CS:SI=Track structure                                        
;O: EAX=Period, TrackX's MidC is set.                                     
;N: Sets SDI frequency.                                                   
;
CODE_ALIGN
_MIgetPeriod PROC NEAR
	;========================================;
	;Period = (Period[NOTE] SHR Octave)x 8363;
	;         -------------------------------;
	;                     MidC               ;
	;========================================;
	;              14317056(NTSC)            ;
	;Frequency = ----------------------------;
	;             Fine-tunedPeriod           ;
	;                                        ;
	;Where MI.MIdivider = 14317056           ;
	;========================================;
	push    ebx cx edx
	mov     cl,al
	xor     ebx,ebx
	mov     al,cl
	shr     cl,4
	and     al,0Fh
	xor     ah,ah
	mov     bx,ax
	shl     bx,1
	mov     bx,MI_PeriodTable[bx]
	shr     bx,cl
	mov     ax,8363
	mul     bx
	xchg    ax,dx
	shl     eax,16
	mov     ax,dx
	xor     edx,edx
	div     [cs:TrackX.TRKsampleMidC][si]
	pop     edx cx ebx
	ret
	ENDP
;
;_MIsetPeriod                                                             
;I: EAX=Period, CS:SI=Track structure                                     
;O: EAX=Clipped period                                                    
;N: Clips period. Sets period in track structure, and sets SDI frequency. 
;
CODE_ALIGN
_MIsetPeriod PROC NEAR
	push    ebx ecx edx
	mov     ebx,07FFFh               ;ST3 upper limit
	mov     ecx,64                   ;ST3 lower limit
	test    Music.MUSinfo,1b
	jz      short @@UseS3Mlimit
	mov     ebx,1712*4 ;856*4                ;MOD upper limit
	mov     ecx,56*4 ;113*4                ;MOD lower limit
	@@UseS3Mlimit:
	;******************************************************************
	;S3M BUG - DOESN'T TEST FOR NEGATIVE VALUES. ASSUMES NEGATIVE
	;VALUES (8000h - FFFFh as too big and it clips to the upper PERIOD
	;limit). Effect is present in PANIC demo.
	;******************************************************************
	test    Music.MUSinfo,100b              ;S3M BUG.
	jz      short @@NotS3Mbug
	cmp     ax,bx
	jbe     short @@UpperOKS3M
	mov     ax,bx
	@@UpperOKS3M:
	cmp     ax,cx
	jge     short @@LowerOKS3M
	mov     ax,cx
	@@LowerOKS3M:
	jmp     short @@SetFrequency
      @@NotS3Mbug:                              ;Else, use AMM non-bugged.
	cmp     eax,ebx
	jle     short @@UpperOK
	mov     eax,ebx
	@@UpperOK:
	cmp     eax,ecx
	jge     short @@LowerOK
	mov     eax,ecx
	@@LowerOK:
@@SetFrequency:
	push    ax
	movzx   ebx,ax
	xor     edx,edx
	mov     eax,MI.MIdivider
	div     ebx
	push    MI_TrackNumber
	push    eax
	call    _AMsetFrequency
	pop     ax
	pop     edx ecx ebx
	ret
	ENDP
;
;_MIupdate                                                                
;N: Called periodically to update effects/fetch notes.                    
;
CODE_ALIGN
_MIupdate PROC FAR USES EBX CX EDX SI DI ES FS DS
	setDS
	dec     MI.MItickCount
	jnz     short @@DoEFX
	call    _MIgetNote
	mov     ax,MI.MIspeed
	mov     MI.MItickCount,ax
	jmp     short @@Done
	@@DoEFX:
	mov     MI_TrackNumber,1
	mov     bx,2
	mov     cx,Music.MUSnumberTracks
	@@DoTracks:
	mov     si,AM_TrackTable[bx]
	;DECREMENT VOLUME BAR
	sub     [cs:TrackX.TRKvolumeBar][si],VolumeBarSpeed ;2
	jnc     short @@VolBarOK
	mov     [cs:TrackX.TRKvolumeBar][si],0
	@@VolBarOK:
	;CALL EFFECT HANDLER
	mov     di,[cs:TrackX.TRKeffectNumber][si]
	shl     di,1
	call    MI_DoEffect[di]         ;Upon input, CS:SI=Track structure
	inc     bx
	inc     bx
	inc     MI_TrackNumber
	dec     cx
	jnz     short @@DoTracks
	@@Done:
	ret
	ENDP

;
;_MIgetNote                                                               
;N: Get note for each tracks                                              
;
CODE_ALIGN
_MIgetNote PROC NEAR
	LOCAL   TMPtrackOffset:DWORD,TMPstrucAddress:DWORD,TMPnote:BYTE,\
		TMPrereadFlag:BYTE,TMPtriggerFlag:BYTE

	;SAVE MAPPING CONTEXT
	mov     MI_SavedMemFlag,0
	test    AM.AM_Status,1000b
	jnz     short @@AlreadySaverd

	call    _MEMgetInfo
	mov     es,dx
	mov     di,ax
	mov     ax,[es:di][MEMx.MEM_qNumEMSblocks]
	mov     MI_OrigqNumEMSblocks,ax
	mov     [es:di][MEMx.MEM_qNumEMSblocks],2

	push    seg MI_MappingContext
	push    offset MI_MappingContext
	call    _MEMsaveStatus
	or      AM.AM_Status,1000b         ;Set MEMORY MAP SAVED
	mov     MI_SavedMemFlag,1
	@@AlreadySaverd:

     ;* When a patterndelay and a pattern break are on the same row, the delay
     ;  comes before the break.
     ;
     ;* When a patternloop and a pattern break are on the same row, the loop
     ;  comes before the break.

	cmp     MI.MInextRow,0
	jne     short @@NotNewPatternYet
	;xor     ax,ax                           ;Row 0 = start of loop upon
	mov     MI.MIpatternLoopStart,0 ;ax
	@@NotNewPatternYet:                     ;entering a new pattern.

	;GET CURRENT ROW AND POINTER TO NOTE
	;===PATTERN LOOP EXECUTION UNIT===
	cmp     MI.MIpatternLoopCount,0
	je      short @@NoPatternLoop
	mov     ax,MI.MIcurrentRow      ;(Previous row finished?) ;nextRow
	cmp     ax,MI.MIpatternLoopEnd
	jb      short @@NoPatternLoop
	mov     ax,MI.MIpatternLoopSequence ;Restore the sequence number.
	mov     MI.MInextSequence,ax        ;(If EFX was at row 63, nextSequence
	mov     ax,MI.MIpatternLoopStart    ;will already point to NEXT seq!)
	mov     MI.MInextRow,ax
	@@NoPatternLoop:

@@GetPattern:
	cmp     MI.MItargetSequence,65535       ;===OVERRIDING SEQUENCE VAL
	je      short @@NoOverridingSequence
	mov     ax,MI.MItargetSequence
	mov     MI.MInextSequence,ax
	mov     MI.MItargetSequence,65535
	mov     MI.MIpatternLoopCount,0         ;Cancel pattern loop
	@@NoOverridingSequence:
	cmp     MI.MItargetRow,65535            ;===OVERRIDING ROW VAL
	je      short @@NoOverridingRow
	mov     ax,MI.MItargetRow
	mov     MI.MInextRow,ax
	mov     MI.MItargetRow,65535
	mov     MI.MIpatternLoopCount,0         ;Cancel pattern loop
	@@NoOverridingRow:

	mov     bx,MI.MInextSequence
	mov     MI.MIcurrentSequence,bx
	shl     bx,1
	mov     ax,Music.MUSsequence[bx]
	mov     TMPrereadFlag,0
	cmp     ax,65534                ;65534=Skip!
	jb      short @@ValidPattern
	mov     TMPrereadFlag,1
	ja      short @@RestartSong     ;65535=Restart (end of song)
	jmp     @@IncSequence
	@@ValidPattern:
	mov     MI.MIcurrentPattern,ax
	mov     bx,5*64
	mul     bx
	mov     bx,MI.MInextRow
	mov     MI.MIcurrentRow,bx
	shl     bx,2
	add     bx,MI.MIcurrentRow
	add     ax,bx
	adc     dx,0
	mov     word ptr TMPtrackOffset[0],ax
	mov     word ptr TMPtrackOffset[2],dx

	;---ADVANCE ROW FOR NEXT NOTE.
	;===PATTERN DELAY EXECUTION UNIT (REPEAT ROW, UPDATE EFX ONLY)===
	cmp     MI.MIpatternDelayCount,1 ;0
	jbe     short @@NoDelay
	dec     MI.MInextRow
	;dec     MI.MIpatternDelayCount
	;mov     TMPpatDelayFlag,1
	@@NoDelay:

	inc     MI.MInextRow
	cmp     MI.MInextRow,64
	jb      short @@SamePattern
@@IncSequence:
	mov     MI.MInextRow,0
	mov     ax,MI.MIcurrentSequence                 ;??????nextSequence
	inc     ax
	mov     MI.MInextSequence,ax
	cmp     ax,Music.MUSsongPlayLength;Music.MUSsongLength
	jb      short @@SamePattern
@@RestartSong:
	;-----SONG RESTART
	;==DETERMINE IF RESTART IS ENABLED...
	or      AM.AM_Status,1 SHL 14   ;Set restart flag
	;test    MI.MIflag,1
	;jz      short @@NoDisableLooping
	;pushad         ;CRASHES!!
	;push    es
	;call    _AMmusicStop
	;pop     es
	;popad
	;jmp     @@QuitSong
	@@NoDisableLooping:
	mov     MI.MInextRow,0
	;mov     MI.MInextSequence,0
	;--- version 1.2 addition ---------------
	;A better way is to scan in reverse the sequence list,
	;until we found a 65535 marker or start of sequence...
	mov     bx,MI.MIcurrentSequence
	xor     ax,ax                   ;AX=Next sequence to go to...
	shl     bx,1
	@@PrevSeq:
	cmp     bx,0
	je      short @@EndSearchPrevSeq
	mov     ax,bx   ;Shitty coding here. Haven't touch asm for quite some time!
	sub     bx,2
	cmp     Music.MUSsequence[bx],65535
	jne     short @@PrevSeq
	@@EndSearchPrevSeq:
	shr     ax,1
	mov     MI.MInextSequence,ax
	;----------------------------------------

	@@SamePattern:
	cmp     TMPrereadFlag,1                 ;Skipped/Restart pattern marker.
	je      @@GetPattern              ;Must reread...


;cmp     MI.MIcurrentRow,12
;jb      short @@HAHAHA
;mov     ax,MI.MItempo
;mov     bx,MI.MIspeed
;@@HAHAHA:

	;READ NOTES FOR EACH TRACK
	mov     MI_TrackNumber,1
	mov     cx,Music.MUSnumberTracks
      @@DoTracks:
      push      cx
	mov     bx,MI_TrackNumber
	shl     bx,1
	mov     si,AM_TrackTable[bx]
	push    [cs:TrackX.TRKmemHandle][si]
	push    TMPtrackOffset
	call    _MEMqGetAddress
	;jc      @@Error                        ;Can't handle error
	mov     es,dx
	mov     di,ax                           ;ES:DI=Note address
						;CS:SI=Track structure
						;FS:BX=Smp structure
	;DECREMENT VOLUME BAR
	sub     [cs:TrackX.TRKvolumeBar][si],VolumeBarSpeed ;2
	jnc     short @@VolBarOK
	mov     [cs:TrackX.TRKvolumeBar][si],0
	@@VolBarOK:

;cmp     MI_TrackNumber,4
;jne     shorT @@Noo
;nop
;@@Noo:

	;SET SAMPLE STRUCTURE ADDRESS
	mov     eax,[cs:TrackX.TRKsampleStrucAddress][si]
	mov     bl,[es:NoteX.NOTEsampleNumber][di]
	cmp     bl,255                          ;Use previous instrument?
	je      short @@NoNewSampleStruc
	xor     bh,bh
	shl     bx,1
	mov     ax,cs
	shl     eax,16
	mov     ax,MI_Samples[bx]
	@@NoNewSampleStruc:
	mov     TMPstrucAddress,eax
	;mov     [cs:TrackX.TRKsampleStrucAddress][si],eax ;DON'T SET YET!
	;SET SAMPLE PARAMETERS
	;===========================================================;
	;EXCEPTIONS!!                                               ;
	;-----------------------------------------------------------;
	;DO NOT UPDATE NOTE/VOLUME/(OR ANY SOUND PARAMETERS) DURING ;
	;                                                           ;
	;1) Slide to note (note is part of a parameter)             ;
	;   If sample number present, set sample volume.            ;
	;2) Delay note                                              ;
	;===========================================================;
	;Note present = Trigger sample (but if no sample number, no vol restore)
	;Sample change = Trigger sample
	;Sample present = Set volume

	;Get sample number intro the TrackX structure...
	xor     bh,bh
	mov     bl,[es:NoteX.NOTEeffectData][di]
	mov     [cs:TrackX.TRKeffectData][si],bx
	mov     bl,[es:NoteX.NOTEeffect][di]
	cmp     bx,01Fh ;PIG! 23h                         ;Effect number clip
	jbe     short @@ValidEfx
	xor     bx,bx
	@@ValidEfx:
	mov     [cs:TrackX.TRKeffectNumber][si],bx      ;Clip EFX 255 (No efx)

	mov     TMPtriggerFlag,0
	;===SLIDE TO NOTE. IF SAMPLE NUMBER PRESENT, STILL MUST RESTORE VOL!===
	cmp     [es:NoteX.NOTEeffect][di],MI@EFXslideToNote
	jne     short @@NotSlideToNote

;BUG FOUND IN KELVIN FOO'S FIRST CHIP TUNE...
;APPARENTLY, IF THERE IS A SLIDE TO NOTE, WITHOUT A PREVIOUS NOTE,
;THEN THERE'S NO SOUND!
	;If previously there's no note, and we're doing a slide to note,
	;cancel the effect....because there shouldn't be any sound...
	test    Music.MUSinfo,100b              ;S3M BUG.
	jz      short @@NotS3Mbug_STNP
	;======Scream Tracker bug...
	cmp     [cs:TrackX.TRKnote][si],255     ;Previous note present...
	je      short @@NotSlideToNote ;Do normal processing if not...@@STN_PrevPresent
	jmp     short @@STNP

	;======MOD implementation...
	@@NotS3Mbug_STNP:
	cmp     [cs:TrackX.TRKnote][si],255     ;Previous note present...
	jne     short @@STNP
	mov     [cs:TrackX.TRKeffectNumber][si],MI@EFXnoEffect
	jmp     @@DoNothing
	@@STNP:

	;***IF SAMPLE NUMBER <> PREVIOUS SAMPLE NUMBER, SAMPLE MUST BE
	;***TRIGGERED...
	cmp     [cs:TrackX.TRKsampleNumber][si],255 ;No previous!
	je      short @@NotSlideToNote
	mov     al,[es:NoteX.NOTEsampleNumber][di] ;Different samples/no prev
	cmp     al,255
	je      short @@UsePrevSTNsample
	cmp     [cs:TrackX.TRKsampleNumber][si],al
	jne     short @@NotSlideToNote
	@@UsePrevSTNsample:

	;mov     al,[es:NoteX.NOTEsampleNumber][di] ;Different samples/no prev
	;cmp     [cs:TrackX.TRKsampleNumber][si],al ;means use current as
	;jne     short @@NotSlideToNote          ;source and target...
	;
	;;jm p     short @@NotSlideToNote          ;
	;;@@STN_PrevPresent:
	;
	;cmp     [cs:TrackX.TRKsampleNumber][si],255 ;Previous smp present...
	;je      short @@NotSlideToNote          ;No previous sound. Do it!


	mov     ah,255
	cmp     [es:NoteX.NOTEsampleNumber][di],ah
	jne     @@RestoreSampleVolume
	jmp     @@CheckVolume
	@@NotSlideToNote:
	;===DELAY NOTE - DO ABSOLUTELY NOTHING!===
	mov     ah,255
	cmp     [es:NoteX.NOTEeffect][di],MI@EFXdelayNote
	je      @@DoNothing             ;NoNoteAndNoVolumeRestore
	;===PATTERN DELAY -- WHILE ACTIVE, NO RETRIGGER, NO VOLUME.
	cmp     MI.MIpatternDelayCount,0
	jne     @@DoNothing
	;GET NOTE AND SAMPLE NUMBER
	mov     al,[es:NoteX.NOTEnote][di]
	mov     TMPnote,al
	mov     al,[es:NoteX.NOTEsampleNumber][di]
	;Note present = Trigger sample
	cmp     TMPnote,255
	jne     short @@TriggerSample
	;Sample present = Set volume
	mov     ah,255
	cmp     al,255
	je      @@CheckVolume                   ;NoNewSample
	;Sample change = Trigger sample
	cmp     al,[cs:TrackX.TRKsampleNumber][si]
	je      short @@RestoreSampleVolume     ;NoSampleTrigger
@@TriggerSample:
	;SET SAMPLE NUMBER
	cmp     al,255
	je      short @@NoNewSample2
	mov     [cs:TrackX.TRKsampleNumber][si],al
	@@NoNewSample2:
	;SET SAMPLE STRUCTURE ADDRESS
	mov     eax,TMPstrucAddress
	mov     [cs:TrackX.TRKsampleStrucAddress][si],eax
	;STOP SOUND
	push    MI_TrackNumber
	call    _AMkeyOff
	;---KEY OFF? (VAL 254)
	cmp     TMPnote,254             ;JE OR JAE? PIGS DOGS!
	je      @@DoNothing     ;NoSampleTrigger
	;SET OFFSET
	push    MI_TrackNumber
	push    dword ptr 0
	call    _AMsetOffset
	;GET NOTE PERIOD
	lfs     bx,TMPstrucAddress              ;Set MIDC
	mov     eax,[fs:SmpX.SMPmidC][bx]
	mov     [cs:TrackX.TRKsampleMidC][si],eax
	mov     al,TMPnote                      ;===IF NO NEW NOTE, USE
	cmp     al,255                          ;===PREVIOUS
	je      short @@BlankNote
	mov     [cs:TrackX.TRKnote][si],al
	call    _MIgetPeriod
	mov     [cs:TrackX.TRKperiod][si],ax

	;=============================================;
	;EXCEPTION!                                   ;
	;=============================================;
	mov     [cs:TrackX.TRKeffectSlideToNoteTarget][si],ax

	IF _TP_ EQ 1
	shr     ax,2                            ;TPSBMOD IS 4X SMALLER
	mov     [cs:TrackX.TRKperiodTPSBMOD][si],ax
	ENDIF
	@@BlankNote:
      cmp       [cs:TrackX.TRKnote][si],255     ;Really no current/prev
      je        short @@NoNote                  ;note!
      cmp       [cs:TrackX.TRKsampleNumber][si],255;Really no current/prev
      je        short @@NoNote                  ;samplenote! So, don't start
	;SET SAMPLE                        ;sample!
	push    MI_TrackNumber
	push    TMPstrucAddress
	call    _AMsetSample    ;playSample
	mov     TMPtriggerFlag,1                ;Trigger sample (key on)
      @@NoNote:
;        mov     al,[cs:TrackX.TRKvolume][si]
;        cmp     al,[cs:TrackX.TRKvolumeBar][si]
;        jbe     short @@NoVolBarChgTrigger
;        mov     [cs:TrackX.TRKvolumeBar][si],al
;        @@NoVolBarChgTrigger:
@@RestoreSampleVolume:
	;GET SAMPLE VOLUME IN AH
	mov     ah,[es:NoteX.NOTEsampleNumber][di]      ;If no sample number
	cmp     ah,255                                  ;then no vol restore.
	je      short @@CheckVolume
	lfs     bx,TMPstrucAddress
	mov     ah,[fs:SmpX.SMPvolume][bx]
	;When exection arrives here, AH=Sample's default volume or 255.
	;**FALL THROUGH**
@@CheckVolume:
	;CHECK VOLUME OVERRIDE AND SET VOLUME
	mov     al,[es:NoteX.NOTEvolume][di]
	cmp     al,255
	jne     short @@FoundVolume
	cmp     ah,255
	je      short @@NoVolume
	mov     al,ah
	;**FALL THROUGH**
	@@FoundVolume:
	cmp     al,64                           ;Volume clip
	jbe     short @@ValidVolume
	mov     al,64
	@@ValidVolume:
	xor     ah,ah
	push    MI_TrackNumber
	push    ax
	call    _AMsetVolume
	mov     al,[cs:TrackX.TRKsampleVolume][si]      ;Store volume for
	mov     [cs:TrackX.TRKvolume][si],al            ;MUSIC INTERPRETER.
	;mov     al,[cs:TrackX.TRKsampleVolume][si]
	cmp     al,[cs:TrackX.TRKvolumeBar][si]
	jbe     short @@NoVolBarChg
	mov     [cs:TrackX.TRKvolumeBar][si],al
	@@NoVolBarChg:
	@@NoVolume:
@@NoNewSample:
@@DoNothing:
	;SET NOTE FREQUENCY EVERYTIME WE FETCH A NEW NOTE.
	;THIS ENSURES VIBRATO IS CORRECT.
	;HOWEVER, TREMOLO DOESN'T HAVE THIS EFFECT. AMIGA BUG IF U ASK ME.
	;(PERIOD RETURNS TO NORMAL IF VIBRATO STOPS)
	movzx   eax,[cs:TrackX.TRKperiod][si]
	call    _MIsetPeriod
	mov     [cs:TrackX.TRKperiod][si],ax

	;TRIGGER SAMPLE? (TRIGGER AFTER SETTING SAMPLE PARAMS,ETC)
	cmp     TMPtriggerFlag,0
	je      short @@NoTrigger
	push    MI_TrackNumber
	call    _AMkeyOn
	@@NoTrigger:

	;CHECK EFFECT AND EFFECT DATA
	;xor     bh,bh
	;mov     bl,[es:NoteX.NOTEeffectData][di]
	;mov     [cs:TrackX.TRKeffectData][si],bx
	;mov     bl,[es:NoteX.NOTEeffect][di]
	;cmp     bx,01Fh ;PIG! 23h                         ;Effect number clip
	;jbe     short @@ValidEfx
	;xor     bx,bx
	;@@ValidEfx:
	;mov     [cs:TrackX.TRKeffectNumber][si],bx      ;Clip EFX 255 (No efx)

	mov     bx,[cs:TrackX.TRKeffectNumber][si]     ;Get EFX number...

;SCREAM TRACKER BUG
or      bx,bx
jz      short @@UsePreviousEfx          ;No effect...so, must've been efx 0FFh
mov     ax,[cs:TrackX.TRKeffectData][si]
test    Music.MUSinfo,100b              ;If MOD, effectData2 always has the
jz      short @@NotS3Mup                ;value of effectData.
or      al,al                           ;If S3M, effectData2 only has effectData
jz      short @@UsePreviousEfx          ;value if effectData <> 0.
;==For some effects...
@@NotS3Mup:
mov     [cs:TrackX.TRKeffectData2][si],ax
@@UsePreviousEfx:
;SCREAM TRACKER BUG

	;===PATTERN LOOP EXECUTION UNIT.
	;===IF IT'S THE END-OF-LOOP MARKER ENCOUNTERED AND LOOP IS CURRENTLY
	;===ACTIVE, WE IGNORE IT AND JUST DECREMENT COUNT.
	cmp     bl,MI@EFXpatternLoop
	jne     short @@DoEFX
	cmp     [es:NoteX.NOTEeffectData][di],0
	je      short @@DoEFX
	cmp     MI.MIpatternLoopCount,0
	je      short @@DoEFX
;pop     cx
;cmp     cx,1
;push    cx
;jne     short @@DoEFX
	dec     MI.MIpatternLoopCount   ;Do this on last row

	;----------MI 1.2 addition------------
	jnz     short @@SkipEFX ;StilMore
	;mov     ax,MI.MIcurrentRow

	mov     ax,MI.MIpatternLoopEnd
	cmp     ax,63
	jae     short @@PLE_KO
	inc     ax
	@@PLE_KO:
	;mov     MI.MInextRow,ax

	;cmp     ax,63
	;jae     short @@SkipEFX             ;just a 'patch' .. not 100% certain of function...
	;inc     ax
	;cmp     ax,64
	;jb      short @@StartOfLoopOK
	;mov     ax,63
	;@@StartOfLoopOK:
	;and     ax,111111b                  ;Bah!! Ignore bad MODs!! ;-) (Lazy me)
	;mov     ax,MI.MInextRow
	mov     MI.MIpatternLoopStart,ax    ;New update, which seems that
										;start = where there is no loop!!!
										;aka row 0, or past end of loop row.
	;@@StilMore:
	;----------MI 1.2 addition------------

	jmp     short @@SkipEFX
	@@DoEFX:


	;;===If pattern break, do it only if pattern loop is done...
	;cmp     bl,MI@EFXpatternBreak
	;jne     short @@NotPB
	;cmp     MI.MIpatternLoopCount,1
	;jne     short @@SkipEFX
	;@@NotPB:
	;I don't really bother about this bug anymore...



;********************************
;SB0 on track 1, SBx on other tracks...what will happen?
;POSSIBLE BUG WHEN TRYING TO USE BOTH PATTERN DELAY WITH PATTERN LOOP ON SAME
;ROW!
;********************************

	;===PATTERN DELAY EXECUTION UNIT.
	;===IF COUNT IS NON-ZERO, DON'T UPDATE EFFECTS.

       ;cmp     bl,MI@EFXpatternDelay
       ;jne     short @@DoEFX2
;pigs
;==========
	;cmp     bl,MI@EFXpatternDelay
	;jne     short @@DoEFX2

	cmp     bl,MI@EFXpatternDelay           ;If no pat delay, do EFX
	jne     short @@DoEFX2
	cmp     MI.MIpatternDelayCount,0        ;If pat delay, check count.
	ja      short @@SkipEFX                 ;If count expired, can do again.

;        cmp     MI.MIpatternDelayCount,0
;        je      short @@DoEFX2
;pop     cx
;cmp     cx,1
;push    cx
;jne     short @@SkipEFX ;DoEFX2
;        dec     MI.MIpatternDelayCount  ;Do this on last row
;        jmp     short @@SkipEFX
	@@DoEFX2:
;==========

	@@MustDoEFX:
	shl     bx,1
	call    MI_StartEffect[bx]      ;Upon input, CS:SI=Track structure
	@@SkipEFX:

	;;=====CHECK IF SONG END MARKER SET (In disabled looping, patternbreak might do it!)
	;test    AM.AM_Status,10000000000000b       ;STOPPED?
      pop     cx
	;jz      short @@QuitSong
      inc     MI_TrackNumber
      dec     cx
      jnz     @@DoTracks

@@QuitSong:
	sub     MI.MIpatternDelayCount,1        ;Decrement pattern delay count
	adc     MI.MIpatternDelayCount,0

	;RESTORE MAPPING CONTEXT
	cmp     MI_SavedMemFlag,1
	jne     short @@NotSaved

	call    _MEMgetInfo
	mov     es,dx
	mov     di,ax
	mov     ax,MI_OrigqNumEMSblocks
	mov     [es:di][MEMx.MEM_qNumEMSblocks],ax

	push    seg MI_MappingContext
	push    offset MI_MappingContext
	call    _MEMrestoreStatus
	and     AM.AM_Status,NOT 1000b     ;Set MEMORY MAP NOT SAVED
	@@NotSaved:
	ret
	ENDP

; EFFECT HANDLER 
; EFFECT HANDLER 
; EFFECT HANDLER 
DD_ALIGN
MI_StartEffect  dw _MIefx_Nothing
		dw _MIefx_SetSpeed
		dw _MIefx_SetTempo
		dw _MIefx_SetMasterVolume
		dw _MIefx_PatternJump
		dw _MIefx_PatternBreak
		dw _MIefx_VolumeSlide
		dw _MIefx_SlideUp
		dw _MIefx_SlideDown
		dw _MIefx_SlideToNote
		dw _MIefx_Vibrato
		dw _MIefx_Tremolo
		dw _MIefx_Arpeggio
		dw _MIefx_Vibrato_VolumeSlide
		dw _MIefx_SlideToNote_VolumeSlide
		dw _MIefx_SetSampleOffset
		dw _MIefx_Retrigger
		dw _MIefx_SetPan
		dw _MIefx_CutNote
		dw _MIefx_DelayNote
		dw _MIefx_Tremor
		dw _MIefx_PatternLoop
		dw _MIefx_PatternDelay
		dw _MIefx_SetVibratoWaveform
		dw _MIefx_SetTremolowaveform
		dw _MIefx_SetGlissando
		dw _MIefx_SetFineTune
		dw _MIefx_Nothing               ;--
		dw _MIefx_Nothing
		dw _MIefx_Nothing
		dw _MIefx_Event ;Nothing
		dw _MIefx_FineVibrato
DD_ALIGN
MI_DoEffect     dw _MIefxU_Nothing
		dw _MIefxU_Nothing
		dw _MIefxU_Nothing
		dw _MIefxU_Nothing
		dw _MIefxU_Nothing
		dw _MIefxU_Nothing
		dw _MIefxU_VolumeSlide
		dw _MIefxU_SlideUp
		dw _MIefxU_SlideDown
		dw _MIefxU_SlideToNote
		dw _MIefxU_Vibrato
		dw _MIefxU_Tremolo
		dw _MIefxU_Arpeggio
		dw _MIefxU_Vibrato_VolumeSlide
		dw _MIefxU_SlideToNote_VolumeSlide
		dw _MIefxU_Nothing
		dw _MIefxU_Retrigger
		dw _MIefxU_Nothing
		dw _MIefxU_CutNote
		dw _MIefxU_DelayNote
		dw _MIefxU_Tremor
		dw _MIefxU_Nothing
		dw _MIefxU_Nothing
		dw _MIefxU_Nothing
		dw _MIefxU_Nothing
		dw _MIefxU_Nothing
		dw _MIefxU_Nothing
		dw _MIefx_Nothing               ;--
		dw _MIefx_Nothing
		dw _MIefx_Nothing
		dw _MIefx_Nothing
		dw _MIefxU_FineVibrato

;
;START EFFECT ROUTINES
;UPON CALL:
;ES:DI          = Note structure address
;CS:SI          = Track structure
;MI_TrackNumber = Track number (0-?)
;
CODE_ALIGN
_MIefx_Nothing PROC NEAR
	ret
	ENDP
_MIefxU_Nothing PROC NEAR
	ret
	ENDP
_MIefx_SetTempo PROC NEAR
	push    dx
	mov     ax,[cs:TrackX.TRKeffectData2][si]
	or      ax,ax
	jz      short @@Previous
	mov     MI.MItempo,ax
	shl     ax,1
	mov     dl,5
	div     dl
	xor     ah,ah
	push    ax
	push    cs
	push    offset _MIupdate
	call    _AMsetUpdate
	@@Previous:
	pop     dx
	ret
	ENDP
_MIefx_SetSpeed PROC NEAR
	mov     ax,[cs:TrackX.TRKeffectData2][si]
	or      ax,ax
	jz      short @@Previous
	mov     MI.MIspeed,ax
	@@Previous:
	ret
	ENDP
_MIefx_SetMasterVolume PROC NEAR
	mov     ax,[cs:TrackX.TRKeffectData][si];Must convert master volume
	shl     ax,2                            ;0-64 to 0-256.
	push    ax
	call    _AMmusicMasterVolume
	ret
	ENDP
_MIefx_PatternJump PROC NEAR
	mov     ax,[cs:TrackX.TRKeffectData][si]

	test    MI.MIflag,1                     ;If disabled looping, disable
	jz      short @@NoDisableLoop           ;all jumps backward...
	cmp     ax,MI.MInextSequence ;currentSequence
	jae     short @@NoDisableLoop
	;mov     ax,0e07h
	;int     010h
	ret
	@@NoDisableLoop:

	mov     MI.MItargetSequence,ax
	;******************************************
	;* TARGET ROW NOT MODIFIED IF ALREADY SET *
	;******************************************
	cmp     MI.MItargetRow,65535
	jne     short @@AlreadySet
	mov     MI.MItargetRow,0
	@@AlreadySet:
	ret
	ENDP
_MIefx_PatternBreak PROC NEAR
	mov     ax,[cs:TrackX.TRKeffectData][si]
	mov     MI.MItargetRow,ax ;MI.MInextRow,ax
	;******************************************************
	;* TARGET SEQUENCE NUMBER NOT MODIFIED IF ALREADY SET *
	;******************************************************
	cmp     MI.MItargetSequence,65535
	jne     short @@AlreadySet
	mov     ax,MI.MIcurrentSequence
	inc     ax
	cmp     ax,Music.MUSsongPlayLength;Music.MUSsongLength
	jb      short @@NotRestart

	or      AM.AM_status,1 SHL 14   ;Just set restart flag
	;test    MI.MIflag,1             ;If disabled looping
	;jz      short @@NoDisableLoop
	;pushad         ;Crashes!
	;push    es
	;call    _AMmusicStop
	;pop     es
	;popad
	;ret
	;@@NoDisableLoop:

	xor     ax,ax
	@@NotRestart:
	mov     MI.MItargetSequence,ax
	@@AlreadySet:
	ret
	ENDP
_MIefx_VolumeSlide PROC NEAR
	;BUT FOR MODS, SLIDE SPEED 0 = NO CHANGE...
	mov     al,byte ptr [cs:TrackX.TRKeffectData2][si]
	or      al,al
	jz      short @@Previous
	;@@NotS3Mbug:
	mov     [cs:TrackX.TRKeffectSlideData][si],al
	@@Previous:
	mov     al,[cs:TrackX.TRKeffectSlideData][si]
	test    al,11110000b
	jz      short @@VS
	test    al,00001111b
	jz      short @@VS
	;Now, it should be fine slides...oh well...
	mov     ah,al
	and     ah,0Fh          ;SLIDE UP HAS MORE PRIORITY...
	cmp     ah,0Fh          ;So, check fine slide up first.
	je      short @@FVSU
     @@FVSD:
	and     al,0Fh
	neg     al
	add     al,[cs:TrackX.TRKvolume][si]
	jns     short @@NoNeg
	xor     al,al
	@@NoNeg:
	mov     [cs:TrackX.TRKvolume][si],al
	xor     ah,ah
	push    MI_TrackNumber
	push    ax
	call    _AMsetVolume
	ret
     @@FVSU:
	shr     al,4
	add     al,[cs:TrackX.TRKvolume][si]
	cmp     al,64
	jbe     short @@VolOK
	mov     al,64
	@@VolOK:
	mov     [cs:TrackX.TRKvolume][si],al
	xor     ah,ah
	push    MI_TrackNumber
	push    ax
	call    _AMsetVolume
	ret
     @@VS:
	test    Music.MUSinfo,100000b           ;S3M BUG. FAST VOL SLIDE.
	jz      short @@MOD
	jmp     _MIefxU_VolumeSlide
	@@MOD:
	ret
	ENDP
_MIefx_SlideUp PROC NEAR
	;OPTIMIZABLE
	mov     al,byte ptr [cs:TrackX.TRKeffectData2][si]
	or      al,al
	jz      short @@Previous
	;@@NotS3Mbug:
	mov     [cs:TrackX.TRKeffectSlideData][si],al
	@@Previous:
	mov     al,[cs:TrackX.TRKeffectSlideData][si]
	mov     ah,al
	shr     ah,4
	cmp     ah,0Eh
	je      short @@EFSU
	ja      short @@FSU
      @@SU:     ;===SLIDE UP===
	ret
      @@FSU:    ;===FINE SLIDE UP===
	push    ebx
	xor     ah,ah
	and     al,0Fh
	shl     ax,2                            ;x4!
	neg     ax
	movsx   eax,ax
	movzx   ebx,[cs:TrackX.TRKperiod][si]
	add     eax,ebx
	call    _MIsetPeriod
	mov     [cs:TrackX.TRKperiod][si],ax
	pop     ebx
	ret
      @@EFSU:   ;===EXTRA FINE SLIDE UP===
	push    ebx
	xor     ah,ah
	and     al,0Fh
	neg     ax
	movsx   eax,ax
	movzx   ebx,[cs:TrackX.TRKperiod][si]
	add     eax,ebx
	call    _MIsetPeriod
	mov     [cs:TrackX.TRKperiod][si],ax
	pop     ebx

	;;DUNNO?: S3M has a slightly-faster slide?
	;test    Music.MUSinfo,100b
	;jz      short @@MOD
	;jmp     _MIefxU_SlideToNote
	;@@MOD:
	ret
	ENDP
_MIefx_SlideDown PROC NEAR
	;OPTIMIZABLE
	mov     al,byte ptr [cs:TrackX.TRKeffectData2][si]
	or      al,al
	jz      short @@Previous
	;@@NotS3Mbug:
	mov     [cs:TrackX.TRKeffectSlideData][si],al
	@@Previous:
	mov     al,[cs:TrackX.TRKeffectSlideData][si]
	mov     ah,al
	shr     ah,4
	cmp     ah,0Eh
	je      short @@EFSD
	ja      short @@FSD
      @@SD:     ;===SLIDE DOWN===
	ret
      @@FSD:    ;===FINE SLIDE DOWN===
	push    ebx
	xor     ah,ah
	and     al,0Fh
	shl     ax,2                            ;x4!
	movsx   eax,ax
	movzx   ebx,[cs:TrackX.TRKperiod][si]
	add     eax,ebx
	call    _MIsetPeriod
	mov     [cs:TrackX.TRKperiod][si],ax
	pop     ebx
	ret
      @@EFSD:   ;===EXTRA FINE SLIDE DOWN===
	push    ebx
	xor     ah,ah
	and     al,0Fh
	movsx   eax,ax
	movzx   ebx,[cs:TrackX.TRKperiod][si]
	add     eax,ebx
	call    _MIsetPeriod
	mov     [cs:TrackX.TRKperiod][si],ax
	pop     ebx

	;;DUNNO?: S3M has a slightly-faster slide?
	;test    Music.MUSinfo,100b
	;jz      short @@MOD
	;jmp     _MIefxU_SlideToNote
	;@@MOD:
	ret
	ENDP
_MIefx_SlideToNote PROC NEAR
	;---Get speed and target period
	mov     ax,[cs:TrackX.TRKeffectData][si]        ;Not Data2!!
							;Bug found in SkyJet3.s3m
							;by Kelvin Foo!
	shl     ax,2                            ;x4!
	jz      short @@OldSpeed                ;0=Continue previous speed
	mov     [cs:TrackX.TRKeffectSlideToNoteSpeed][si],ax
	@@OldSpeed:
	mov     al,[es:NoteX.NOTEnote][di]      ;No note=Old target
	cmp     al,255
	je      short @@OldPeriod
	call    _MIgetPeriod
	mov     [cs:TrackX.TRKeffectSlideToNoteTarget][si],ax
	;DETERMINE DIRECTION
	mov     [cs:TrackX.TRKeffectSlideToNoteDir][si],1 ;1=Inc
	cmp     [cs:TrackX.TRKperiod][si],ax
	jbe     short @@IncrementPeriod
	mov     [cs:TrackX.TRKeffectSlideToNoteDir][si],0 ;0=Dec
	@@IncrementPeriod:
	@@OldPeriod:

	;DUNNO?: S3M has a slightly-faster slide?
	;test    Music.MUSinfo,100b
	;jz      short @@MOD
	;;===If previously there isn't any note, use target note as current
	;;note - S3M bug??
	;cmp     [cs:TrackX.TRKperiod][si],0
	;jne     short @@NotEmptyPrevious
	;cmp     [cs:TrackX.TRKnote][si],255
	;jne     short @@NotEmptyPrevious
	;mov     ax,[cs:TrackX.TRKeffectSlideToNoteTarget][si]
	;mov     [cs:TrackX.TRKperiod][si],ax
	;mov     al,[es:NoteX.NOTEnote][di]
	;mov     [cs:TrackX.TRKnote][si],al
	;@@NotEmptyPrevious:
	;jmp     _MIefxU_SlideToNote
	;@@MOD:

	ret
	ENDP
_MIefx_Vibrato PROC NEAR
	;0y      Retains speed. Sets depth to y.
	;xy x=speed y=depth
	mov     ax,[cs:TrackX.TRKeffectData][si]        ;Data2? Changed!
	or      ax,ax
	jz      short @@UsePrevious
	mov     ah,al
	and     al,0Fh
	;jz      short @@OldDepth               ;NO SUCH THING! BUGFIX!
	mov     [cs:TrackX.TRKeffectVibratoDepth][si],al
	@@OldDepth:
	shr     ah,4
	jz      short @@OldSpeed
	mov     [cs:TrackX.TRKeffectVibratoSpeed][si],ah
	@@OldSpeed:
      @@UsePrevious:
	test    [cs:TrackX.TRKeffectVibratoWave][si],100b
	jnz     short @@NoNote  ;Bit 2. 1=No retrigger. 0=Retrigger
	mov     al,[es:NoteX.NOTEnote][di]              ;Reset count if
	cmp     al,255                                  ;new note present.
	je      short @@NoNote
	mov     [cs:TrackX.TRKeffectVibratoCount][si],0
	@@NoNote:

	;===PREPARE TO UPDATE PERIOD...
	call    _MIefxU_Vibrato
	mov     al,[cs:TrackX.TRKeffectVibratoSpeed][si]
	sub     [cs:TrackX.TRKeffectVibratoCount][si],al
	and     [cs:TrackX.TRKeffectVibratoCount][si],111111b
	ret
	ENDP
_MIefx_Tremolo PROC NEAR
	;xy x=speed y=depth
	mov     ax,[cs:TrackX.TRKeffectData2][si]
	or      ax,ax
	jz      short @@UsePrevious
	mov     ah,al
	and     al,0Fh
	jz      short @@OldDepth
	mov     [cs:TrackX.TRKeffectTremoloDepth][si],al
	@@OldDepth:
	shr     ah,4
	jz      short @@OldSpeed
	mov     [cs:TrackX.TRKeffectTremoloSpeed][si],ah
	@@OldSpeed:
      @@UsePrevious:
	test    [cs:TrackX.TRKeffectTremoloWave][si],100b
	jnz     short @@NoNote  ;Bit 2. 1=No retrigger. 0=Retrigger
	cmp     [es:NoteX.NOTEnote][di],255             ;Reset count if
	je      short @@NoNote                          ;new note present.
	mov     [cs:TrackX.TRKeffectTremoloCount][si],0
	@@NoNote:
	ret
	ENDP
_MIefx_Arpeggio PROC NEAR
	;STILL HAS SOME BUGS. TRY ANARCHY..THE SECOND 'BUMP' SOUNDS WEIRD.
	push    bx
	cmp     [es:NoteX.NOTEnote][di],255             ;Reset count if
	je      short @@NoNote                          ;new note present.
	mov     [cs:TrackX.TRKeffectArpeggioCount][si],0
	@@NoNote:
	cmp     [cs:TrackX.TRKnote][si],255             ;No current notes=
	je      short @@NoArpeggio                      ;no arpeggio
	;===Get number semitones===
	mov     bx,[cs:TrackX.TRKeffectData][si]
	or      bl,bl
	jz      short @@UsePrevious
	mov     bh,bl
	shr     bh,4
	and     bl,0Fh                                  ;BH=2nd BL=3rd
	;===Get 1st note===
	mov     al,[cs:TrackX.TRKnote][si]
	mov     [cs:TrackX.TRKeffectArpeggioNotes][si][0],al ;1st
	mov     ah,al
	and     ah,0F0h
	and     al,00Fh                                 ;AH=Octave*16 AL=Note
	;===Get 2nd note===
	push    ax
	add     bh,al
	@@Check2nd:
	cmp     bh,12
	jb      short @@Ok2nd
	sub     bh,12
	add     ah,010h ;Next octave
	jmp     short @@Check2nd                        ;Might still be too much
	@@Ok2nd:
	add     bh,ah
	mov     [cs:TrackX.TRKeffectArpeggioNotes][si][1],bh ;2nd
	pop     ax
	;===Get 3rd note===
	add     bl,al
	@@Check3rd:
	cmp     bl,12
	jb      short @@Ok3rd
	sub     bl,12
	add     ah,010h ;Next octave
	jmp     short @@Check3rd                        ;Might still be too much
	@@Ok3rd:
	add     bl,ah
	mov     [cs:TrackX.TRKeffectArpeggioNotes][si][2],bl ;3rd
	;===UPDATE NOTE...
	@@UsePrevious:
	call    _MIefxU_Arpeggio
	@@NoArpeggio:
	pop     bx
	ret
	ENDP
_MIefx_Vibrato_VolumeSlide PROC NEAR
	;===UPDATE VIBRATO===
	call    _MIefxU_Vibrato
	mov     al,[cs:TrackX.TRKeffectVibratoSpeed][si]
	sub     [cs:TrackX.TRKeffectVibratoCount][si],al
	and     [cs:TrackX.TRKeffectVibratoCount][si],111111b
	jmp     _MIefx_VolumeSlide
	ENDP
_MIefx_SlideToNote_VolumeSlide PROC NEAR
	;!!!! pig call    _MIefx_SlideToNote
	;We do not call slide to note because we're not INITIALIZING
	;slide to note...but merely CONTINUING ...which is done during
	;the other ticks!
	jmp     _MIefx_VolumeSlide
	ENDP
_MIefx_SetSampleOffset PROC NEAR
	xor     eax,eax
	mov     ah,byte ptr [cs:TrackX.TRKeffectData][si]
	push    MI_TrackNumber
	push    eax
	call    _AMsetOffset
	ret
	ENDP
_MIefx_Retrigger PROC NEAR
	mov     ax,[cs:TrackX.TRKeffectData2][si]
	or      al,al
	jz      short @@Previous
	mov     ah,al
	and     al,0Fh
	mov     [cs:TrackX.TRKeffectRetriggerTicks][si],al
	mov     [cs:TrackX.TRKeffectRetriggerCount][si],al
	shr     ah,4
	mov     [cs:TrackX.TRKeffectRetriggerVolFade][si],ah
	@@Previous:
	ret
	ENDP
_MIefx_SetPan PROC NEAR
	push    MI_TrackNumber
	push    [cs:TrackX.TRKeffectData][si]
	call    _AMsetPanPos
	ret
	ENDP
_MIefx_CutNote PROC NEAR
	mov     ax,[cs:TrackX.TRKeffectData][si]
	mov     [cs:TrackX.TRKeffectCutNoteCount][si],al
	ret
	ENDP
_MIefx_DelayNote PROC NEAR
	push    bx
	mov     al,byte ptr [cs:TrackX.TRKeffectData][si]
	mov     [cs:TrackX.TRKeffectDelayNoteCount][si],al
	;===GET THE NEEDED INFO===
	;GET NOTE
	mov     al,[es:NoteX.NOTEnote][di]
	cmp     al,255
	jne     short @@NotePresent
	mov     al,[cs:TrackX.TRKnote][si]
	@@NotePresent:
	mov     [cs:TrackX.TRKeffectDelayNoteNote][si],al
	;GET SAMPLE NUMBER
	mov     bl,[es:NoteX.NOTEsampleNumber][di]
	cmp     bl,255
	jne     short @@SmpNumPresent
	mov     bl,[cs:TrackX.TRKsampleNumber][si]
	@@SmpNumPresent:
	mov     [cs:TrackX.TRKeffectDelayNoteSampleNumber][si],bl
	;GET VOLUME NUMBER
	mov     al,[es:NoteX.NOTEvolume][di]
	cmp     bl,255
	jne     short @@VolumePresent
	xor     bh,bh
	shl     bx,1
	mov     bx,MI_Samples[bx]
	mov     al,[es:NoteX.NOTEvolume][si]
	@@VolumePresent:
	mov     [cs:TrackX.TRKeffectDelayNoteVolume][si],al
	pop     bx
	ret
	ENDP
_MIefx_Tremor PROC NEAR
	mov     al,byte ptr [cs:TrackX.TRKeffectData2][si]
	mov     ah,al
	and     al,0Fh
	shr     ah,4
	inc     al                                      ;S3M BUG
	inc     ah                                      ;S3M BUG
	mov     [cs:TrackX.TRKeffectTremorOnTicks][si],ah
	mov     [cs:TrackX.TRKeffectTremorOffTicks][si],al
	mov     [cs:TrackX.TRKeffectTremorCount][si],ah
	cmp     [es:NoteX.NOTEnote][di],255             ;Reset if
	je      short @@NoNote                          ;new note present.
	mov     [cs:TrackX.TRKeffectTremorFlag][si],1   ;0=Off 1=On
	@@NoNote:
	;===UPDATE TREMOR===
	jmp     _MIefxU_Tremor
	ENDP
_MIefx_PatternLoop PROC NEAR
	mov     al,byte ptr [cs:TrackX.TRKeffectData][si] ;commands.
	or      al,al
	jz      short @@SetStart
	;===SET END ROW AND COUNTS....
	mov     MI.MIpatternLoopCount,al
	mov     ax,MI.MIcurrentRow
	mov     MI.MIpatternLoopEnd,ax
	mov     ax,MI.MIcurrentSequence     ;(If EFX was at row 63, nextSequence
	mov     MI.MIpatternLoopSequence,ax ;will already point to NEXT seq!)
	ret
      @@SetStart:
	;===SET START ROW...
	mov     ax,MI.MIcurrentRow
	mov     MI.MIpatternLoopStart,ax
	ret
	ENDP
_MIefx_PatternDelay PROC NEAR
	mov     al,byte ptr [cs:TrackX.TRKeffectData][si]
	or      al,al
	jz      short @@Blank
	inc     al                              ;Inc AL, coz we'll start dec right after track loop! .. So, inc by 1 (it's a tightly-structural thingy)
	mov     MI.MIpatternDelayCount,al
	mov     ax,MI.MIcurrentRow              ;Repeat *CURRENT* row.
	mov     MI.MInextRow,ax
	mov     ax,MI.MIcurrentSequence ;In case EFX was at row 63.
	mov     MI.MInextSequence,ax
       @@Blank:
	ret
	ENDP
_MIefx_SetVibratoWaveform PROC NEAR
	mov     al,byte ptr [cs:TrackX.TRKeffectData][si]
	mov     [cs:TrackX.TRKeffectVibratoWave][si],al
	ret
	ENDP
_MIefx_SetTremoloWaveform PROC NEAR
	mov     al,byte ptr [cs:TrackX.TRKeffectData][si]
	mov     [cs:TrackX.TRKeffectTremoloWave][si],al
	ret
	ENDP
_MIefx_SetGlissando PROC NEAR
	mov     al,byte ptr [cs:TrackX.TRKeffectData][si]
	mov     [cs:TrackX.TRKeffectGlissandoFlag][si],al
	ret
	ENDP
_MIefx_SetFineTune PROC NEAR
	push    bx
	mov     bl,byte ptr [cs:TrackX.TRKeffectData][si]
	xor     bh,bh
	shl     bx,1
	movzx   eax,MI_FineTuneFrequency[bx]
	mov     [cs:TrackX.TRKsampleMidC][si],eax
	pop     bx
	ret
	ENDP
_MIefx_Event PROC NEAR
	mov     al,byte ptr [cs:TrackX.TRKeffectData][si]
	mov     MI.MIeventData,al
	or      AM.AM_status,1 SHL 15
	ret
	ENDP
_MIefx_FineVibrato PROC NEAR
	;xy x=speed y=depth
	mov     ax,[cs:TrackX.TRKeffectData2][si]
	or      ax,ax
	jz      short @@UsePrevious
	mov     ah,al
	and     al,0Fh
	jz      short @@OldDepth
	mov     [cs:TrackX.TRKeffectVibratoDepth][si],al
	@@OldDepth:
	shr     ah,4
	jz      short @@OldSpeed
	mov     [cs:TrackX.TRKeffectVibratoSpeed][si],ah
	@@OldSpeed:
      @@UsePrevious:
	test    [cs:TrackX.TRKeffectVibratoWave][si],100b
	jnz     short @@NoNote  ;Bit 2. 1=No retrigger. 0=Retrigger
	mov     al,[es:NoteX.NOTEnote][di]              ;Reset count if
	cmp     al,255                                  ;new note present.
	je      short @@NoNote
	mov     [cs:TrackX.TRKeffectVibratoCount][si],0
	@@NoNote:

	;===PREPARE TO UPDATE PERIOD...
	call    _MIefxU_FineVibrato
	mov     al,[cs:TrackX.TRKeffectVibratoSpeed][si]
	sub     [cs:TrackX.TRKeffectVibratoCount][si],al
	and     [cs:TrackX.TRKeffectVibratoCount][si],111111b
	ret
	ENDP
;
;
;EFFECT UPDATE ROUTINES
;UPON CALL:
;CS:SI          = Track structure
;MI_TrackNumber = Track number (0-?)
;
;
_MIefxU_VolumeSlide PROC NEAR
	;===S3M BUG. IF IT IS 0, IT WILL CONTIUE THE PREVIOUS SLIDE...
	;===AND IT REALLY DEPENDS ON WHAT KIND OF SLIDES IT WAS!
	;===IF 0, WE WILL CONTINUE EITHER SLIDE/FINE SLIDE/EXTRA FINE SLIDE!
	mov     al,[cs:TrackX.TRKeffectSlideData][si]
	;test    al,11110000b
	;jz      short @@VSD
	;test    al,00001111b
	;jz      short @@VSU
	;ret     ;For fine slide - don't need update

	;SCREAM TRACKER BUG - SORT OF...
	test    al,11110000b
	jz      short @@VSD
	test    al,00001111b
	jz      short @@VSU

	;===Now, both parts are non-zero
	;===Check if either one nibble is F. If it is, it's fine slide...

	;eg, 8F = Fine slide up speed 8
	;    81 = Slide down speed 1
	;    18=Slide down speed 8 (slide down has more priority)
	;    81 = Fine slide down speed 1 (slide down has more priority)

	mov     ah,al           ;Fine slide up check
	and     ah,00Fh
	cmp     ah,00Fh
	je      short @@Fine
	mov     ah,al           ;Fine slide down check
	and     ah,0F0h
	cmp     ah,0F0h
	je      short @@Fine
	jmp     short @@VSD

	@@Fine:
	ret
	;SCREAM TRACKER BUG

comment ~
	;?x = x<>F, then it's slide down!, eg: 1F=Fine Slide down

	mov     ah,al           ;Fine slide up has more priority in S3M...
	and     ah,00Fh         ;Fine slide...
	cmp     ah,00Fh         ;?F = Fine slide up
	je      short @@Fine    ;?x = x<>F, then it's slide down!, eg: 81=Slide down



	jmp     short @@VSD


	and     ah,0F0h         ;Fine slide...
	cmp     ah,0F0h         ;F? = Fine slide down
	je      short @@Fine    ;x? = x<>F, then it's slide down!, eg: 81=Slide down
	jmp     short @@VSD

	mov     ah,al           ;Slide down has more priority in S3M...
	and     ah,0F0h         ;Fine slide...
	cmp     ah,0F0h
	je      short @@Fine
	ret

	and     al,00Fh

	;

	;test    al,00001111b
	;jnz     short @@VSD
	;test    al,11110000b
	;jnz     short @@VSU

	;test    al,11110000b
	;jz      short @@VSD
	;test    al,00001111b
	;jz      short @@VSU
	;;Not considered a fine slide yet!
	;;S3M uses previous value (irrespective of effect type)...
	;;and, say, if the previous value is 081h, which is SLIDE DOWN,
	;;(not fine slide), we should do it...
	;mov     ah,al           ;Slide down has more priority in S3M...
	;and     ah,0F0h
	;cmp     ah,0F0h         ;More priority slide down
	;jne     short @@VSD
	;mov     ah,al           ;Slide down has more priority in S3M...
	;and     ah,00Fh
	;cmp     ah,00Fh
	;jne     short @@VSU
	;;If either one if 0Fh, it's fine slide...
~


     @@VSD:
	mov     ah,al           ;Slide down has more priority in S3M...
	and     ah,0F0h         ;Fine slide...
	cmp     ah,0F0h
	je      short @@Fine
	and     al,00Fh
	xchg    [cs:TrackX.TRKvolume][si],al
	sub     al,[cs:TrackX.TRKvolume][si]
	jnc     short @@SetVol
	xor     al,al
	jmp     short @@SetVol
     @@VSU:
	mov     ah,al           ;Slide down has more priority in S3M...
	and     ah,00Fh         ;Fine slide...
	cmp     ah,00Fh
	je      short @@Fine
	;and     al,0F0h
	shr     al,4
	add     al,[cs:TrackX.TRKvolume][si]
	jnc     short @@VSUok1
	mov     al,64
	@@VSUok1:
	cmp     al,64
	jle     short @@NotBig
	mov     al,64
	@@NotBig:
	;jmp     short @@SetVol
     @@SetVol:
	mov     [cs:TrackX.TRKvolume][si],al
	xor     ah,ah
	push    MI_TrackNumber
	push    ax
	call    _AMsetVolume
	ret
	ENDP
_MIefxU_SlideUp PROC NEAR
	;OPTIMIZABLE
	mov     al,[cs:TrackX.TRKeffectSlideData][si]
	mov     ah,al
	shr     ah,4
	cmp     ah,0Eh
	jae     short @@NotSU
	;===ONLY UPDATE SLIDE UP===
	push    ebx
	xor     ah,ah
	shl     ax,2                            ;x4!
	neg     ax
	movsx   eax,ax
	movzx   ebx,[cs:TrackX.TRKperiod][si]
	add     eax,ebx
	call    _MIsetPeriod
	mov     [cs:TrackX.TRKperiod][si],ax
	pop     ebx
	@@NotSU:
	ret
	ENDP
_MIefxU_SlideDown PROC NEAR
	;OPTIMIZABLE
	mov     al,[cs:TrackX.TRKeffectSlideData][si]
	mov     ah,al
	shr     ah,4
	cmp     ah,0Eh
	jae     short @@NotSD
	;===ONLY UPDATE SLIDE DOWN===
	push    ebx
	xor     ah,ah
	shl     ax,2                            ;x4!
	movsx   eax,ax
	movzx   ebx,[cs:TrackX.TRKperiod][si]
	add     eax,ebx
	call    _MIsetPeriod
	mov     [cs:TrackX.TRKperiod][si],ax
	pop     ebx
	@@NotSD:
	ret
	ENDP
_MIefxU_SlideToNote PROC NEAR
	cmp     [cs:TrackX.TRKnote][si],255
	je      @@Cancel
	push    ebx
	movzx   eax,[cs:TrackX.TRKeffectSlideToNoteSpeed][si]
	movzx   ebx,[cs:TrackX.TRKperiod][si]
	cmp     [cs:TrackX.TRKeffectSlideToNoteDir][si],1 ;1=Inc
	je      @@IncrementPeriod
	;DECREMENT PERIOD
	sub     ebx,eax
	movzx   eax,[cs:TrackX.TRKeffectSlideToNoteTarget][si]
	cmp     ebx,eax
	jge     short @@Not2Low
	mov     ebx,eax
	@@Not2Low:
	mov     eax,ebx
	jmp     short @@SetPeriod
      @@IncrementPeriod:
	;INCREMENT PERIOD
	add     eax,ebx
	movzx   ebx,[cs:TrackX.TRKeffectSlideToNoteTarget][si]
	cmp     eax,ebx
	jle     short @@Not2High
	mov     eax,ebx
	@@Not2High:
      @@SetPeriod:
	CLIPPERIOD
	mov     [cs:TrackX.TRKperiod][si],ax    ;SET PERIOD
	;===PERFORM GLISSANDO BY ROUNDING PERIOD TO NEAREST NOTE===
	cmp     [cs:TrackX.TRKeffectGlissandoFlag][si],0
	je      @@NoGlissando
	push    bx cx dx
	xor     cl,cl           ;Start from Octave 0
	@@CheckOctave:
	xor     bx,bx
	mov     ch,12           ;12 notes per octave
	@@CheckNote:
	mov     dx,MI_PeriodTable[bx]
	shr     dx,cl
	cmp     ax,dx           ;IF period >= notePeriod, match found!
	jge     short @@FoundMatch
	inc     bx
	inc     bx
	dec     ch
	jnz     short @@CheckNote
	inc     cl
	cmp     cl,8
	jbe     short @@CheckOctave     ;Up to octave 8.
	@@FoundMatch:
	movzx   eax,dx
	pop     dx cx bx
	;SET TRACK'S NEW NOTE? PIG!
	@@NoGlissando:
	;*GLISSANDO *DOES NOT* SET PERIOD OR IT WILL STOP!*
	;===SET PERIOD===
	call    _MIsetPeriod
	;mov     [cs:TrackX.TRKperiod][si],ax
	;===SET CLIPPED PERIOD IF NO GLISSANDO===
	cmp     [cs:TrackX.TRKeffectGlissandoFlag][si],0
	jne     @@Glissando
	mov     [cs:TrackX.TRKperiod][si],ax    ;Set clipped period
	@@Glissando:
	pop     ebx
	@@Cancel:
	ret
	ENDP
_MIefxU_Vibrato PROC NEAR
	cmp     [cs:TrackX.TRKnote][si],255
	je      short @@Cancel
	push    ebx dx
	mov     bl,[cs:TrackX.TRKeffectVibratoWave][si]
	and     bl,11b
	xor     bh,bh
	shl     bx,7            ;Each waveform is 128 bytes long
	mov     al,[cs:TrackX.TRKeffectVibratoCount][si]
	xor     ah,ah
	shl     ax,1
	add     bx,ax
	mov     al,[cs:TrackX.TRKeffectVibratoDepth][si][0]
	xor     ah,ah
	imul    MI_WaveForms[bx]
	;===For MOD samples, RealDepth=(Depthx2)*(SineTableVal/256)
	;===But we use S3M periods, therefore, it'2 4x larger.
	;===(We should do shrd ax,dx,7 for MOD periods).
	shrd    ax,dx,5
	;Go down then up...
	;neg     ax      ;Go up then down...
	movsx   eax,ax
	movzx   ebx,[cs:TrackX.TRKperiod][si]
;neg     eax ;piggy
	add     eax,ebx
	;===SET PERIOD BUT DO *NOT* UPDATE STRUCTURE===
	call    _MIsetPeriod
	;===INCREMENT POSITION IN WAVE TABLE
	mov     al,[cs:TrackX.TRKeffectVibratoSpeed][si]
	add     [cs:TrackX.TRKeffectVibratoCount][si],al
	and     [cs:TrackX.TRKeffectVibratoCount][si],111111b
	pop     dx ebx
	@@Cancel:
	ret
	ENDP
_MIefxU_Tremolo PROC NEAR
	push    ebx dx
	mov     bl,[cs:TrackX.TRKeffectTremoloWave][si]
	and     bl,11b
	xor     bh,bh
	shl     bx,7            ;Each waveform is 128 bytes long
	mov     al,[cs:TrackX.TRKeffectTremoloCount][si]
	xor     ah,ah
	shl     ax,1
	add     bx,ax
	movzx   ax,[cs:TrackX.TRKeffectTremoloDepth][si][0]
	;SOME OLD STUFF...DELETED (DOESN'T SOUND RIGHT AS DOC SAYS)
	;;-=- SOME DOCS STATE THAT REAL DEPTH = (SPEED-1)xDepth=-
	;;===For MODs, the real depth = (Speed-1)*Depth
	;;===For S3Ms, the real depth = Depth
	;test    Music.MUSinfo,100b
	;jnz     short @@S3M
	;mov     ah,byte ptr MI.MIspeed      ;MODs
	;dec     ah
	;mul     ah
	;@@S3M:
	;;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
	imul    MI_WaveForms[bx]
	;===Unlike vibrato, tremolo uses the method for depth as...
	;===RealDepth=(Depth)*(SineTableVal/256)
	;===This is true for almost all formats (MOD,S3M,etc)
	shrd    ax,dx,7 ;8
	;Go down then up...
	movzx   bx,[cs:TrackX.TRKvolume][si]
	add     ax,bx
	cmp     ax,0
	jge     short @@NotNeg
	xor     ax,ax
	@@NotNeg:
	cmp     ax,64
	jle     short @@NotBig
	mov     ax,64
	@@NotBig:
	push    MI_TrackNumber
	push    ax
	call    _AMsetVolume
	;===INCREMENT POSITION IN WAVE TABLE
	mov     al,[cs:TrackX.TRKeffectTremoloSpeed][si]
	add     [cs:TrackX.TRKeffectTremoloCount][si],al
	and     [cs:TrackX.TRKeffectTremoloCount][si],111111b
	pop     dx ebx
	ret
	ENDP
_MIefxU_Arpeggio PROC NEAR
	cmp     [cs:TrackX.TRKnote][si],255
	je      short @@Cancel
	push    bx
	mov     bl,[cs:TrackX.TRKeffectArpeggioCount][si]
	xor     bh,bh
	mov     al,[cs:TrackX.TRKeffectArpeggioNotes][si][bx]
	;===UPDATE COUNTS===
	inc     bl
	cmp     bl,3    ;0,1,2...
	jb      short @@CountOK
	xor     bl,bl
	@@CountOK:
	mov     [cs:TrackX.TRKeffectArpeggioCount][si],bl
	call    _MIgetPeriod
	call    _MIsetPeriod
	;mov     [cs:TrackX.TRKperiod][si],ax
	pop     bx
	@@Cancel:
	ret
	ENDP
_MIefxU_Vibrato_VolumeSlide PROC NEAR
	call    _MIefxU_Vibrato
	jmp     _MIefxU_VolumeSlide
	ENDP
_MIefxU_SlideToNote_VolumeSlide PROC NEAR
	call    _MIefxU_SlideToNote
	jmp     _MIefxU_VolumeSlide
	ENDP
_MIefxU_Retrigger PROC NEAR
	cmp     [cs:TrackX.TRKeffectRetriggerTicks][si],0
	je      short @@NoRetrigger
	dec     [cs:TrackX.TRKeffectRetriggerCount][si]
	jnz     short @@NoRetrigger
	mov     al,[cs:TrackX.TRKeffectRetriggerTicks][si]
	mov     [cs:TrackX.TRKeffectRetriggerCount][si],al
       push    bx
	;===TIME FOR RETRIGGER===
	;===RESET OFFSET===
	push    MI_TrackNumber
	push    dword ptr 0
	call    _AMsetOffset
	;===VOLUME FADE===
	mov     bl,[cs:TrackX.TRKeffectRetriggerVolFade][si]
	xor     bh,bh
	mov     al,[cs:TrackX.TRKvolume][si]
	imul    MI_RetrigMul[bx]        ;BYTE!
	shr     ax,4
	movsx   bx,MI_RetrigDelta[bx]   ;BYTE!
	add     ax,bx
	cmp     ax,0
	jge     short @@NotTooLow
	xor     ax,ax
	@@NotTooLow:
	cmp     ax,64
	jle     short @@NotTooHigh
	mov     ax,64
	@@NotTooHigh:
	mov     [cs:TrackX.TRKvolume][si],al
	push    MI_TrackNumber
	push    ax
	call    _AMsetVolume
       pop     bx
	@@NoRetrigger:
	ret
	ENDP
_MIefxU_CutNote PROC NEAR
	cmp     [cs:TrackX.TRKeffectCutNoteCount][si],0
	je      short @@NoCut
	dec     [cs:TrackX.TRKeffectCutNoteCount][si]
	jnz     short @@NoCut
	push    MI_TrackNumber
	push    word ptr 0
	call    _AMsetVolume    ;NOT STOP SAMPLE! STILL CAN DO VOLUME SLIDE!
	mov     [cs:TrackX.TRKvolume][si],0
	@@NoCut:
	ret
	ENDP
_MIefxU_DelayNote PROC NEAR
	push    bx fs
	cmp     [cs:TrackX.TRKeffectDelayNoteCount][si],0
	je      @@NoPlay
	dec     [cs:TrackX.TRKeffectDelayNoteCount][si]
	jnz     @@NoPlay
	cmp     [cs:TrackX.TRKeffectDelayNoteNote][si],255      ;NO NOTE!
	je      @@NoPlay
	;SET SAMPLE NUMBER
	mov     bl,[cs:TrackX.TRKeffectDelayNoteSampleNumber][si]
	cmp     bl,255                                          ;NO SAMPLE!
	je      @@NoPlay
	mov     [cs:TrackX.TRKsampleNumber][si],bl
	;SET SAMPLE STRUCTURE ADDRESS
	xor     bh,bh
	shl     bx,1
	mov     ax,cs
	shl     eax,16
	mov     ax,MI_Samples[bx]
	mov     [cs:TrackX.TRKsampleStrucAddress][si],eax
	;STOP SOUND
	push    MI_TrackNumber
	call    _AMkeyOff
	cmp     [cs:TrackX.TRKeffectDelayNoteNote][si],254
	je      short @@NoPlay
	;SET OFFSET
	push    MI_TrackNumber
	push    dword ptr 0
	call    _AMsetOffset
	;GET NOTE PERIOD & SET NOTE FREQUENCY
	lfs     bx,[cs:TrackX.TRKsampleStrucAddress][si]
	mov     eax,[fs:SmpX.SMPmidC][bx]
	mov     [cs:TrackX.TRKsampleMidC][si],eax
	mov     al,[cs:TrackX.TRKeffectDelayNoteNote][si]
	mov     [cs:TrackX.TRKnote][si],al
	call    _MIgetPeriod
	movzx   eax,ax
	call    _MIsetPeriod
	mov     [cs:TrackX.TRKperiod][si],ax
	;SET VOLUME OVERRIDE AND SET VOLUME
	mov     al,[cs:TrackX.TRKeffectDelayNoteVolume][si]
	cmp     al,64                           ;Volume clip
	jbe     short @@ValidVolume
	mov     al,64
	@@ValidVolume:
	xor     ah,ah
	push    MI_TrackNumber
	push    ax
	call    _AMsetVolume
	mov     al,[cs:TrackX.TRKsampleVolume][si]      ;Store volume for
	mov     [cs:TrackX.TRKvolume][si],al            ;MUSIC INTERPRETER.
	@@NoVolume:
	;SET SAMPLE
	push    MI_TrackNumber
	push    [cs:TrackX.TRKsampleStrucAddress][si]
	call    _AMsetSample
	;TRIGGER SAMPLE
	push    MI_TrackNumber
	call    _AMkeyOn
      @@NoPlay:
	pop     fs bx
	ret
	ENDP
_MIefxU_Tremor PROC NEAR
	;We do not modify TRKvolume...just TRKsampleVolume (used by SDI)
	cmp     [cs:TrackX.TRKeffectTremorCount][si],0
	je      short @@NoTremor
	dec     [cs:TrackX.TRKeffectTremorCount][si]
	jnz     short @@NoTremor
	push    bx
	push    MI_TrackNumber
	movzx   ax,[cs:TrackX.TRKvolume][si]
	mov     bl,[cs:TrackX.TRKeffectTremorOnTicks][si]
	xor     [cs:TrackX.TRKeffectTremorFlag][si],1   ;Reverse next state
	jz      short @@On
	xor     ax,ax
	mov     bl,[cs:TrackX.TRKeffectTremorOffTicks][si]
	@@On:
	mov     [cs:TrackX.TRKeffectTremorCount][si],bl
	push    ax
	call    _AMsetVolume
	pop     bx
	@@NoTremor:
	ret
	ENDP
_MIefxU_FineVibrato PROC NEAR
	cmp     [cs:TrackX.TRKnote][si],255
	je      short @@Cancel
	push    ebx dx
	mov     bl,[cs:TrackX.TRKeffectVibratoWave][si]
	and     bl,11b
	xor     bh,bh
	shl     bx,7            ;Each waveform is 128 bytes long
	mov     al,[cs:TrackX.TRKeffectVibratoCount][si]
	xor     ah,ah
	shl     ax,1
	add     bx,ax
	mov     al,[cs:TrackX.TRKeffectVibratoDepth][si][0]
	xor     ah,ah
	imul    MI_WaveForms[bx]
	;;===For MOD samples, RealDepth=(Depthx2)*(SineTableVal/256)
	;;===But we use S3M periods, therefore, it'2 4x larger.
	;;===(We should do shrd ax,dx,7 for MOD periods).
	;But for fine vibrato, use raw value (div 256)
	shrd    ax,dx,8
	;Go down then up...
	;neg     ax      ;Go up then down...
	movsx   eax,ax
	movzx   ebx,[cs:TrackX.TRKperiod][si]
	add     eax,ebx
	;===SET PERIOD BUT DO *NOT* UPDATE STRUCTURE===
	call    _MIsetPeriod
	;===INCREMENT POSITION IN WAVE TABLE
	mov     al,[cs:TrackX.TRKeffectVibratoSpeed][si]
	add     [cs:TrackX.TRKeffectVibratoCount][si],al
	and     [cs:TrackX.TRKeffectVibratoCount][si],111111b
	pop     dx ebx
	@@Cancel:
	ret
	ENDP
.CSEG_ENDS AM


comment ~
;Commands that will use the actual value as it is
;(EffectData)
	MI@EFXsetMasterVolume           = 003h
	MI@EFXpatternJump               = 004h
	MI@EFXpatternBreak              = 005h


	MI@EFXsetSampleOffset           = 00Fh  ;OS

	MI@EFXsetPan                    = 011h  ;L
	MI@EFXcutNote                   = 012h  ;S
	MI@EFXdelayNote                 = 013h  ;*

	MI@EFXpatternLoop               = 015h
	MI@EFXpatternDelay              = 016h
	MI@EFXsetVibratoWaveform        = 017h
	MI@EFXsetTremoloWaveform        = 018h
	MI@EFXsetGlissando              = 019h
	MI@EFXsetFineTune               = 01Ah
	MI@EFXsetFilter                 = 01Bh  ;-- FROM HERE, NOT SUPPORTED
	MI@EFXstereoControl             = 01Ch
	MI@EFXinvertLoop                = 01Dh
	MI@EFXevent                     = 01Eh

;Commands that will use the general value/previous value
;(EffectData2)
	MI@EFXtremor                    = 014h  ;V
	MI@EFXnoEffect                  = 000h
	MI@EFXsetSpeed                  = 001h
	MI@EFXsetTempo                  = 002h
	MI@EFXvolumeSlide               = 006h  ;V
	MI@EFXslideUp                   = 007h  ;V
	MI@EFXslideDown                 = 008h  ;V
	MI@EFXslideToNote               = 009h
	MI@EFXvibrato                   = 00Ah  ;P
	MI@EFXtremolo                   = 00Bh
	MI@EFXarpeggio                  = 00Ch  ;P --- NEEDS TO BE MOVED...
	MI@EFXvibrato_VolumeSlide       = 00Dh
	MI@EFXslidetoNote_VolumeSlide   = 00Eh
	MI@EFXretrigger                 = 010h  ;OV


if efx val = 0
	No change

Else if efx val <> 0
	Set effectData2,EffectData      ;This value is used
					;by the second bunch of routines...

~
