;[]-----------------------------------------[]
;| GENERAL MANAGER LIBRARY ASSEMBLER-SPECIFIC|
;| by Kenneth Foo @ TechnoMaestro. 1994      |
;[]-----------------------------------------[]
;SETTING UP COMPILATION STUFFS
	.MODEL FARSTACK LARGE,PASCAL
	.386
	MASM51
	JUMPS
	LOCALS
;EQUATES
	_TP_            = 0
	_Portable_      = 0             ;High-level language compatible
	;true            = 1
	;false           = 0
	enable          = 1
	disable         = 0
	enabled         = 1
	disabled        = 0
	;on              = 1
	;off             = 0
	pushw equ <push word ptr>
	pushd equ <push dword ptr>
	;---GENERAL ERRORS
	ERR_NoError             = 0     ;No error
	ERR_NoHardware          = 1     ;Hardware not present (undetected)
	ERR_HardwareProblem     = 2     ;Hardware problem
	ERR_NotEnoughMemory     = 3     ;Insufficient memory
	ERR_CannotManageMemory  = 4     ;Can't manage mem/mem not there/can't dealloc
	ERR_CannotManageDisk    = 5     ;Can't manage disk/no file/disk error
	ERR_AlreadyDone         = 6     ;Process already done. Cannot redo
	ERR_NotPossible         = 7     ;Process not possible bcoz of certain factors
	ERR_UnknownError        = 8     ;Unkown/other error
	ERR_OutOfResource       = 9     ;Out of resource (no more handles/etc...)
	ERR_InternalError       = 10    ;Internal program error
	ERR_OutOfRange          = 11    ;Out of range value given
	ERR_BadData             = 12    ;Bad data/file format/etc.
;MACROS
	doerr MACRO ErrNm
	    mov ErrorCode,&ErrNm
	    jc  @@Error
	    ENDM
	quit MACRO
	    clc
	    jmp short @@Done
	    @@Error:mov ax,ErrorCode
	    @@Error2:stc
	    @@Done:ret
	    ENDM
	quitf MACRO
	    clc
	    jmp short @@Done
	    @@Error:
	    @@Error2:stc
	    @@Done:ret
	    ENDM
	setDS MACRO
	    mov ax,$$data
	    mov ds,ax
	    ENDM
	;include io_keys.inc
	;include esalg.mac
;GLOBAL DECLARATION
	IF _TP_ EQ 0
	global GM_ProgramSize:word
	global GM_Done:FAR
	global ProgramError:proc,InitError:proc,DeinitError:proc
	ENDIF
;SEMENTATION DECLARATION
	IF _Portable_ EQ 0 ;--------NON-PORTABLE--------------------
	DO_ALIGN      EQU <align 2>
	DW_ALIGN      EQU <align 2>
	DD_ALIGN      EQU <align 4>
	DQ_ALIGN      EQU <align 8>
	PARA_ALIGN    EQU <ALIGN 16>
	CODE_ALIGN    EQU <ALIGN 16>
	DO_CLEARCACHE EQU <dw 000ebh>

	.CSEG   MACRO   SegName
	    IFB <SegName>
	    CODE_ SEGMENT PARA USE16 PUBLIC 'CODE'
	    ASSUME  CS:CODE_
	    ELSE
	    CODE_&SegName SEGMENT PARA USE16 PUBLIC 'CODE'
	    ASSUME  CS:CODE_&SegName
	    ENDIF
	    ENDM
	.DSEG   MACRO   SegName
	    IFB <SegName>
	    DATA_ SEGMENT PARA USE16 PUBLIC 'DATA'
	    ASSUME  DS:DATA_
	    ELSE
	    DATA_&SegName SEGMENT PARA USE16 PUBLIC 'DATA'
	    ASSUME  DS:DATA_&SegName
	    ENDIF
	    ENDM
	.UDSEG  MACRO   SegName
	    IFB <SegName>
	    BSS_ SEGMENT PARA USE16 PUBLIC 'BSS'
	    ASSUME  DS:BSS_
	    ELSE
	    BSS_&SegName SEGMENT PARA USE16 PUBLIC 'BSS'
	    ASSUME  DS:BSS_&SegName
	    ENDIF
	    ENDM
	.CSEG_ENDS      MACRO   SegName
	    IFB <SegName>
	    CODE_ ENDS
	    ELSE
	    CODE_&SegName ENDS
	    ENDIF
	    ENDM
	.DSEG_ENDS      MACRO   SegName
	    IFB <SegName>
	    DATA_ ENDS
	    ELSE
	    DATA_&SegName ENDS
	    ENDIF
	    ENDM
	.UDSEG_ENDS     MACRO   SegName
	    IFB <SegName>
	    BSS_ ENDS
	    ELSE
	    BSS_&SegName ENDS
	    ENDIF
	    ENDM
	.STACKSEG       MACRO   StackSizet
	    STACKS SEGMENT PARA USE16 STACK 'STACK'
	    ASSUME SS:STACKS
	    IFB <StackSizet>
	    DB 4096 DUP(?)     ;;4k default stack
	    ELSE
	    DB StackSizet DUP(?)
	    ENDIF
	    STACKS ENDS
	    ENDM
	.CSEG
	.CSEG_ENDS
	.DSEG
	.DSEG_ENDS
	.UDSEG
	.UDSEG_ENDS
	;SEGMENT EQUATES
	$$DATA  EQU <SEG DATA_>
	$$CODE  EQU <SEG CODE_>
	$$STACK EQU <SEG STACKS>
	$$UDATA EQU <SEG BSS_>
	DGROUP  GROUP DATA_,BSS_

	ELSE    ;--------PORTABLE--------------------
	DO_ALIGN      EQU <align 2>
	DW_ALIGN      EQU <align 2>
	DD_ALIGN      EQU <align 2>
	DQ_ALIGN      EQU <align 2>
	PARA_ALIGN    EQU <ALIGN 2>
	CODE_ALIGN    EQU <ALIGN 2>
	DO_CLEARCACHE EQU <dw 000ebh>

	IF _TP_ EQ 0 ;---------------- TP = 0

	.CSEG   MACRO   SegName
	    IFB <SegName>
	    _TEXT SEGMENT WORD USE16 PUBLIC 'CODE'
	    ASSUME CS:_TEXT
	    ELSE
	    CODE_&SegName SEGMENT WORD USE16 PUBLIC 'CODE'
	    ASSUME  CS:CODE_&SegName
	    ENDIF
	    ENDM
	.DSEG   MACRO
	    _DATA SEGMENT WORD USE16 PUBLIC 'DATA'
	    ASSUME DS:_DATA
	    ENDM
	.UDSEG   MACRO
	    _BSS SEGMENT WORD USE16 PUBLIC 'BSS'
	    ASSUME DS:_BSS
	    ENDM
	.CSEG_ENDS      MACRO   SegName
	    IFB <SegName>
	    _TEXT ENDS
	    ELSE
	    CODE_&SegName ENDS
	    ENDIF
	    ENDM
	.DSEG_ENDS      MACRO
	    _DATA ENDS
	    ENDM
	.UDSEG_ENDS     MACRO
	    _BSS        ENDS
	    ENDM
	.STACKSEG       MACRO   StackSizet
	    IFB <StackSizet>
	    .STACK StackSizet
	    ELSE
	    .STACK 4096
	    ENDIF
	    ENDM
	.CSEG
	.CSEG_ENDS
	.DSEG
	.DSEG_ENDS
	.UDSEG
	.UDSEG_ENDS
	;SEGMENT EQUATES
	$$DATA  EQU <SEG _DATA>
	$$CODE  EQU <SEG _TEXT>
	$$STACK EQU <SEG STACK> ;;??
	$$UDATA EQU <SEG _BSS>
	;DGROUP  GROUP _DATA,_BSS

	ELSE    ;-------------------------TP = 1
	.CSEG   MACRO   SegName
	    .CODE   ;&SegName
	    ENDM
	.DSEG   MACRO   SegName
	    .DATA   ;&SegName
	    ENDM
	.UDSEG  MACRO   SegName
	    .DATA   ;&SegName
	    ENDM
	.CSEG_ENDS      MACRO   SegName
	    ENDS ;&SegName
	    ENDM
	.DSEG_ENDS      MACRO   SegName
	    ENDS ;&SegName
	    ENDM
	.UDSEG_ENDS     MACRO   SegName
	    ENDS ;&SegName
	    ENDM
	.STACKSEG       MACRO   StackSizet
	    ENDS
	    ENDM
	;.CSEG
	;.CSEG_ENDS
	;.DSEG
	;.DSEG_ENDS
	;SEGMENT EQUATES
	$$DATA  EQU <@DATA>
	$$CODE  EQU <@CODE>
	$$STACK EQU <SEG STACK>
	$$UDATA EQU <@DATA>
	;DGROUP  GROUP DATA,BSS

	.CODE
	InitError PROC
	ret
	ENDP
	DeinitError PROC
	ret
	ENDP
	ProgramError PROC
	ret
	ENDP
	ENDS

	ENDIF
	ENDIF

