;--5 INSTRUCTIONS PER SAMPLE - SEEMS FAST, AS IT TAKES ADVANTAGE OF AGIS!

;Search "Lossy" - Clips off to certain number of bits, currently 6.
;Don't use! PRoblems!
;TO ADD...
;NO STEREO PANNING ... - FIXED - (INCLUDING COPY ROUTINE)...
;FAST!!!!!!!!!!!!!!!!!!!!!!!!!!!
;

;DMA READING/SETTING OFFSET ....16-BITs!!!!!!!!!!!!!
;ALIGNMENTS FOR 16-BIT DMA?
;TO ADD...
;FASTER 16-BIT MIXING/COOPY/SILENCE!!!!!!!!!!!!!!!!!!!!!!
;DMA SIZE ACCORDING TO UPDATE SPEED... --- SAVES MEMORY!
;STEREO - SETS VOLUME TABLE TO SPECIAL MODE...HEHEHE.. :)
;[]------------------------------------------------------------------------[]
;| AUDIO MANAGER III by Kenneth Foo 1994.                                   |
;| DIGITAL SOUND MIXER                                                      |
;[]------------------------------------------------------------------------[]
;
;NOTES
; Volume0 optimization is performed, while keeping keeping track of the
; pointers to samples.
; Basically, this routine mixes samples and forms them into a stream of
; sound waves. It handles all (and only) DMA stuffs.
;
; No PC speaker or any other polling hardware is supported, due to it's
; structure and speed considerations.
;
;
;EQUATES

IF _MINIMAL_ EQ 1
	AM@MultiSamplingBits    = 3     ;Do 8 bytes in a row!! :-). (>= 4)
ELSE
	AM@MultiSamplingBits    = 4     ;Do 16 bytes in a row!! :-). (>= 4)
ENDIF

	AM@MultiSamplingBytes   = (1 SHL AM@MultiSamplingBits)
	;Keep multisampling bytes =< 32, since the offset displacement
	;values MOV AX,[DI][xx] is smaller if value is less than 128.
	;So, for stereo, we need 2...so, I'll keep it to 16...
;
;GLOBAL DATA IN DATA SEGMENT
;
.DSEG
.DSEG_ENDS
;
;DATA IN CODE SEGMENT
;
.CSEG   AM
DSM_INFO DB 'AUDIO MANAGER 3.0: DIGITAL SOUND MIXER 1.1 by Kenneth Foo. 1994'
	;STRUCTURE DECLARATION
	;POINTERS TO...
	DD_ALIGN
	DSM_DMAbufferHandle     dd 0
	DSM_MixingBufferHandle  dd 0
	DSM_UpdateRoutine       dd _DSMidle
	DSM_MixingRoutine       dw MixMono
	DSM_CopyRoutine         dw Copy8
	DSM_SilentDMAroutine    dw SilentDMA8
	DSM_SilenceRoutine      dw MonoSilence
	DSM_DMAbuffer           dw 0
	DSM_MixingBuffer        dw 0
	DSM_SilenceRoutine1     dw MonoSilenceA

	;STORAGE
	DW_ALIGN
	DSM_BytesPerElement     dw 0            ;Byte per element. 1=Mono 8 4=Stereo 16-bit
	DSM_Amplification       dw 65535        ;Will be overwritten by init.
	DSM_CurrentTrack        dw 0
	DSM_NumberMixedTracks   dw 0
	DSM_LoSkips             dw 0
	DSM_NumberMixes         dw 0
	DSM_TRACKMIXcount       dw 0
	DSM_MixingBufferOffset  dw 0
	DSM_CopyCount           dw 0
	TMPbp                   dw 0
	TMPsi                   dw 0
	TMPds                   dw 0
	TMPsp                   dw 0
	DSM_OrigqNumEMSblocks   dw 0
	DSM_RemainderDelta      dw 0
	DSM_MixRoutineOffset    dw 0
	DSM_Volume              db 0


	;SYSTEM
	;Minimum DMA counts for us to mix. If too little, don't mix.
	DW_ALIGN
	DSM_MixingSHR           db      2 dup(0)        ;0-1
				db      1               ;2
				db      2 dup(2)        ;3-4
				db      4 dup(3)        ;5-8
				db      8 dup(4)        ;9-16
				db      16 dup(5)       ;17-32
	DW_ALIGN ;16-bit mixing mode...SHL (not SHR)
	DSM_MixingSHL16         db      8,8             ;0-1
				db      7               ;2
				db      2 dup(6)        ;3-4
				db      4 dup(5)        ;5-8
				db      8 dup(4)        ;9-16
				db      16 dup(3)       ;17-32
	DW_ALIGN
	DSM_CountsPerTick       dw 64000 ;Ahh...make it large lah.. :)0
	DSM_TICKcount           dw 0
	DSM_DMAcount            dw 0    ;Number elements to mix in DMA
					;Mono:
					;8-bit  - 1 byte 1 element
					;16-bit - 2 bytes 1 element
					;Stereo:
					;8-bit  - 2 bytes 1 element
					;16-bit - 4 bytes 1 element
	DSM_MappingContext      db MEM@mapLength dup(0)

	;HARDWARE
	DSM_MixingRate          dw 0
	DSM_Flags               dw 0    ;Bit 0=Stereo flag 1=16-bit flag
	DSM_DMAchannel          dw 0
	DSM_DMAsize             dw (1024) ;(4096/1)
	DSM_DMAsizeMask         dw (1024)-1 ;(4096/1)-1
	DSM_MixPos              dw 0    ;Offset of last mixing pos
.CSEG_ENDS AM

;
;CODE
;
.CSEG   AM
;
;_DSMidle                                                                  
;_DSMinit                                                                  
;_DSMdeinit                                                                
;
_DSMidle PROC FAR       ;(DEFAULT UPDATE ROUTINE)
	ret
	ENDP
_DSMinit PROC NEAR
	clc
	ret
	ENDP
_DSMdeinit PROC NEAR
	clc
	ret
	ENDP
;
;_DSMstart                                                                
;I:  DMAchannel:W,MixingRate:W, SmpX.Flags                                
;O:  Carry1=Error & AX=Error.                                             
;
_DSMstart PROC NEAR USES EBX CX DX DI ES DS, DMAchn:WORD,MixRate:WORD, \
					    SmpFlags:WORD
	setDS
	;START PLAYING
	mov     DSM_BytesPerElement,1
	mov     ax,AM.DSM_MinDMAsize       ;Select a nice buffer size.
	test    SmpFlags,01b
	jz      @@MonoDMA
	shl     ax,1
	;shl     AM.DSM_MinDMAcounts,1
	shl     DSM_BytesPerElement,1
	@@MonoDMA:
	test    SmpFlags,10b
	jz      @@DMA8
	shl     ax,1
	;shl     AM.DSM_MinDMAcounts,1
	shl     DSM_BytesPerElement,1
	@@DMA8:
	mov     DSM_DMAsize,ax
	dec     ax
	mov     DSM_DMAsizeMask,ax
	;ALLOCATE VOLUMETABLE/MIXING BUFFER
	;xor     eax,eax
	;mov     ax,DSM_DMAsize                  ;Alloc mix buffer (DMAsize*2)
	;dec     ax
	;mov     DSM_DMAsizeMask,ax
	inc     ax
	shl     ax,1
	add     ax,8192+256                     ;8+k volume table
	movzx   eax,ax
	push    eax
	call    _MEMallocBase
	doerr   ERR_NotEnoughMemory
	shl     eax,16
	mov     ax,dx
	rol     eax,16
	mov     DSM_MixingBufferHandle,eax
	mov     DSM_MixingBuffer,dx
	;MAKE VOLUME TABLE AND CLEAR MIXING BUFFER
	mov     es,dx ;DSM_MixingBuffer
	xor     di,di           ;Start from first element of Volume table
	mov     bh,0            ;Volume start from 0
	@@DoVolume:
	mov     cx,256
	xor     bl,bl           ;Start from value 0
	@@DoValues:
	mov     al,bl
	xor     al,128          ;Signed value to...
	imul    bh
	sar     ax,6
	xor     al,128          ;Use unsigned values!
	mov     es:[di],al
	inc     bl
	inc     di
	loop    @@DoValues
	inc     bh              ;Next volume
	inc     bh
	cmp     bh,64           ;Max volume
	jbe     short @@DoVolume
	mov     cx,DSM_DMAsize  ;DSM_DMAsize x 2 - CLEAR MIX BUFFER
	xor     ax,ax
	cld
	rep     stosw
	;ALLOCATE DMA BUFFER
	;====================================;
	;1) Allocate double the DMA size     ;
	;2) Get the last offset in the buffer;
	;   that doesn't cross 64k boundary. ;
	;3) Shrink size of buffer.           ;
	;====================================;
	xor     eax,eax
	mov     ax,DSM_DMAsize                  ;Allocate
	shl     ax,1
	push    eax
	call    _MEMallocBase
	doerr   ERR_NotEnoughMemory
	shl     eax,16
	mov     ax,dx
	rol     eax,16
	mov     DSM_DMAbufferHandle,eax

;comment ~
	;[] are optional??

	;Get first starting address not crossing the 64k DMA boundary.
	;in EBX (linear address, though)
	movzx   ebx,ax                          ;Convert to linear
	shr     eax,16
	shl     eax,4
	add     ebx,eax
	push    ebx

;Shouldn't cross any addresses with value xxxx:x000 !
;in other words, in 20-bit address,
;x x000

	add     ebx,0FFFh
	and     ebx,NOT 0FFFh

	;add     ax,DSM_DMAsize                  ;Add DMA size. Carry means 64k
	;jnc     short @@NoCross                 ;overrun.
	;neg     ax
	;add     ax,DSM_DMAsize
	;movzx   eax,ax
	;add     ebx,eax
	;@@NoCross:
	;add     ebx,15                          ;[Rounding?]
	;and     bl,NOT 0Fh

	ror     ebx,4                           ;Set DMA buffer segment
	mov     DSM_DMAbuffer,bx
	rol     ebx,4

	movzx   eax,DSM_DMAsize                 ;Get last pos in buffer
	add     ebx,eax
	pop     eax
	sub     ebx,eax                         ;(High address-Lo address)+1
	inc     ebx                             ;= number bytes
	push    DSM_DMAbufferHandle
	push    ebx
	call    _MEMresizeBase
	doerr   ERR_CannotManageMemory
;~

comment ~
	;Now, adjust...
	rol     eax,16+4
	;movzx   eax,ax                          ;Convert to linear
	;shl     eax,4                           ;& +16-bit DMAsize. If carry
	mov     ebx,eax
       push    eax
	add     ax,DSM_DMAsize                  ;, it means offset crossed 64k!
	jnc     short @@NoCross                 ;IF cross, get remainder, which
	neg     ax                              ;is the number of bytes too
	add     ax,DSM_DMAsize                  ;much. DMAsize-Remainder=number
	movzx   eax,ax                          ;bytes to be padded.
	add     ebx,eax
	@@NoCross:                              ;OUTPUT: EBX=Linear address
	ror     ebx,4
	mov     DSM_DMAbuffer,bx
	rol     ebx,4
	xor     eax,eax
	mov     ax,DSM_DMAsize
	add     ebx,eax                         ;EBX=Past end linear address
       pop     eax
	sub     ebx,eax                         ;(High address-Lo address)+1
	inc     ebx                             ;= number bytes
	push    DSM_DMAbufferHandle
	push    ebx
	call    _MEMresizeBase
	doerr   ERR_CannotManageMemory
~
	;CLEAR MIXING AND DMA BUFFER
	mov     es,DSM_DMAbuffer
	xor     di,di
	mov     cx,DSM_DMAsize
	mov     ax,08080h
	cld
	shr     cx,1
	rep     stosw
	rcl     cx,1
	rep     stosb
	;START DMA
	mov     ax,MixRate
	mov     DSM_MixingRate,ax
	mov     ax,SmpFlags
	mov     DSM_Flags,ax
	mov     ax,DMAchn
	mov     DSM_DMAchannel,ax
	push    ax
	push    word ptr 058h           ;Auto-init DMA!
	xor     eax,eax
	mov     ax,DSM_DMAbuffer
	shl     eax,4
	push    ax
	shr     eax,16
	push    ax
	push    DSM_DMAsize             ;Should be Even size for 16-bit?
	call    setDMA
	;SET MIXING ROUTINE
	mov     ax,offset MonoMixer
	mov     bx,offset MonoSilence
	mov     cx,offset MonoSilenceA
	test    DSM_Flags,01b
	jz      short @@MonoMix
	mov     ax,offset StereoMixer
	mov     bx,offset StereoSilence
	mov     cx,offset StereoSilenceA
	@@MonoMix:
	mov     DSM_MixingRoutine,ax
	mov     DSM_SilenceRoutine,bx
	mov     DSM_SilenceRoutine1,cx
	;SET AMPLIFICATION (AND COPY/SILENCE ROUTINE)
	push    word ptr 65535          ;Default = Standard ...
	call    _AMamplification
	quit
	ENDP
;
;_DSMstop                                                                 
;O:  Carry1=Error & AX=Error.                                             
;
_DSMstop PROC NEAR USES DS
	setDS
	;DEALLOCATE BUFFERS
	mov     ErrorCode,ERR_CannotManageMemory
	push    DSM_DMAbufferHandle
	call    _MEMdeallocBase
	jc      short @@Error2
	push    DSM_MixingBufferHandle
	call    _MEMdeallocBase
	jc      short @@Error2
	quit
	ENDP
;
;_DSMsetUpdate                                                            
;I:  UpdateRateInHertz:W, UpdateRoutineAddress:D                          
;
_DSMsetUpdate PROC NEAR USES DX, UpdateRate:WORD,UpdateR:DWORD
	;SET COUNTS PER TICK (UPDATE)
	;===CntsPerTick=MixingRate/UpdateRate===
	mov     ax,DSM_MixingRate
	xor     dx,dx
	div     UpdateRate
	mov     DSM_CountsPerTick,ax
	mov     DSM_TICKcount,ax                ;Reset tick count!
	mov     eax,UpdateR                     ;Although it won't happen
	mov     DSM_UpdateRoutine,eax           ;immediately, it will happen
	clc                                     ;right on the NEXT music tick.
	ret
	ENDP
;
;_DSMinitTrack                                                            
;I:  TrackNumber:W                                                        
;
CODE_ALIGN
_DSMinitTrack PROC NEAR ;TrackNumber:WORD
	clc
	ret 2
	ENDP
;
;_DSMdeinitTrack                                                          
;I:  TrackNumber:W                                                        
;
CODE_ALIGN
_DSMdeinitTrack PROC NEAR ;TrackNumber:WORD
	clc
	ret 2
	ENDP
;
;_DSMsetSample                                                            
;I:  TrackNumber:W, SampleStrucAdd:DW                                     
;
CODE_ALIGN
_DSMsetSample PROC NEAR ;TrackNumber:WORD,StrucAdd:DWORD
	clc
	ret 6
	ENDP
;
;_DSMsetVolume                                                            
;I:  TrackNumber:W, Volume:W                                              
;
CODE_ALIGN
_DSMsetVolume PROC NEAR ;TrackNumber:WORD,Volume:WORD
	clc
	ret 4
	ENDP
;
;_DSMsetFrequency                                                         
;I:  TrackNumber:W, Frequency:D                                           
;
CODE_ALIGN
_DSMsetFrequency PROC NEAR USES EAX EBX EDX SI,TrackNumber:WORD,Freq:DWORD
	;StepRatex65536 = Frequency x 65536
	;                 ----------
	;                 MixingRate
	mov     si,TrackNumber
	shl     si,1
	mov     si,AM_TrackTable[si]
	mov     eax,Freq
	xor     dx,dx
	shld    edx,eax,16
	shl     eax,16
	movzx   ebx,DSM_MixingRate
	div     ebx
	mov     [cs:TrackX.TRKsampleSteps][si],eax
	clc
	ret
	ENDP
;
;_DSMsetPanPos                                                            
;I:  TrackNumber:W, PanPos:W                                              
;
CODE_ALIGN
_DSMsetPanPos PROC NEAR ;TrackNumber:WORD,PanPos:WORD
	clc
	ret 4
	ENDP
;
;_DSMsetOffset                                                            
;I:  TrackNumber:W, Offset:D                                              
;
CODE_ALIGN
_DSMsetOffset PROC NEAR ;TrackNumber:WORD,SOffset:DWORD
	clc
	ret 6
	ENDP
;
;_DSMkeyOn                                                                
;I:  TrackNumber:W                                                        
;
CODE_ALIGN
_DSMkeyOn PROC NEAR ;TrackNumber:WORD
	clc
	ret 2
	ENDP
;
;_DSMkeyOff                                                               
;I:  TrackNumber:W                                                        
;
CODE_ALIGN
_DSMkeyOff PROC NEAR ;TrackNumber:WORD
	clc
	ret 2
	ENDP
;
;_DSMallocMem                                                             
;I:  NumberBytes:D                                                        
;O:  Carry0=Success EAX=SDI memory handle                                 
;    Carry1=Error & AX=Error.                                             
;
_DSMallocMem PROC NEAR NumberBytes:DWORD
	push    NumberBytes
	call    _MEMqAlloc
	ret
	ENDP
;
;_DSMdeallocMem                                                           
;I:  SDImemoryHandle:D                                                    
;O:  Carry0=Success                                                       
;O:  Carry1=Error & AX=Error.                                             
;
_DSMdeallocMem PROC NEAR SDImemHandle:DWORD
	push    SDImemHandle
	call    _MEMqDealloc
	ret
	ENDP
;
;_DSMloadSample                                                           
;I:  SampleStrucAdd:D,FileHandle:W,PositionInFile:D                       
;O:  Carry0=Success, EAX=File pos past sample                             
;    Carry1=Error & AX=Error.                                             
;N:  Loads the SAMPLE only...without the header.                          
;    Automatically converts sample to signed format.                      
;
_DSMloadSample PROC NEAR uses EBX CX DX SI DI FS ES DS, StrucAdd:DWORD,\
						     Handle:WORD,FilePos:DWORD
	local   TMPlength:DWORD,TMPpos:DWORD,TMPhandle:DWORD,TMPprevValue:BYTE

	mov     ErrorCode,ERR_CannotManageDisk
	push    Handle                  ;Seek pos
	push    FilePos
	push    word ptr 0
	call    _DMseekFile
	jc      @@Error

	;LOAD SAMPLE
	les     si,StrucAdd
	mov     eax,es:[SmpX.SMPlength][si]
	mov     ebx,eax
	mov     TMPlength,eax
	mov     eax,es:[SmpX.SMPmemHandle][si]
	mov     TMPhandle,eax
	mov     eax,es:[SmpX.SMPmemPos][si]
	mov     TMPpos,eax
	mov     TMPprevValue,0          ;For delta-encoded samples
      @@ReadSample:
	or      ebx,ebx
	jz      @@DoneRead

	push    TMPhandle               ;Get address of buffer
	push    TMPpos
	call    _MEMqGetAddress
	doerr   ERR_NotEnoughMemory
	mov     fs,dx
	mov     di,ax

	mov     cx,bx                   ;Read in 32k chunks
	cmp     ebx,32768
	jbe     short @@BXlessThan32k
	mov     cx,32768
	@@BXlessThan32k:
	;push    eax
	movzx   eax,cx
	sub     ebx,eax
	add     TMPpos,eax
	;pop     eax

	push    Handle
	push    dx DI ;ax
	push    cx
	call    _DMreadFile
	doerr   ERR_CannotManageDisk

	;-----------------SAMPLE CONVERSION CODE---------------
	or      ax,ax
	jz      short @@NoSample                        ;0 bytes - no sample...
	;Decode delta-encoded values
	test    es:[SmpX.SMPinfo][si],100000b
	jz      short @@NotDeltaEncoded
	push    ax di
	mov     cx,ax
	@@DecodeDelta:
	mov     al,[fs:di]
	add     al,TMPprevValue
	mov     [fs:di],al
	mov     TMPprevValue,al
	inc     di
	dec     cx
	jnz     short @@DecodeDelta
	pop     di ax
	@@NotDeltaEncoded:
	;Convert to unsigned if sample is signed
	test    es:[SmpX.SMPinfo][si],10000b
	jz      short @@UnSigned
;push    di
	mov     cx,ax ;32768/2
	@@MakingSigned:
	xor     byte ptr fs:[di],080h
	inc     di
	dec     cx
	jnz     short @@MakingSigned
;pop     di
	@@UnSigned:

;;=Lossy encoding
;        ;Cut to 7-bit samples...for phun
;        mov     cx,ax ;32768/2
;        @@Making4bit:
;        and     byte ptr fs:[di],11111110b
;        inc     di
;        dec     cx
;        jnz     short @@Making4bit


	@@NoSample:
	;-----------------SAMPLE CONVERSION CODE---------------

	jmp     @@ReadSample
      @@DoneRead:
	and     es:[SmpX.SMPinfo][si],NOT 110000b       ;Set UNSIGNED flag
							;Set non-delta-encoded
	mov     eax,TMPlength
	add     eax,FilePos             ;EAX=File pos past this sample
	quit
	_DSMloadSample ENDP



mycurptr  dd 0            ;Virtual 'file' pointer (linear memory pointer)

;
;Seek a memory address - for use in _AMmusicMemloadMOD                    
;Assumes MoveCode always 0 (from start of mem)                            
;
__MMseekFile PROC FileHandle:WORD,NumBytes:DWORD,MoveCode:WORD
	mov     eax,NumBytes
	;add     eax,curptr
	mov     mycurptr,eax
	clc
	ret
	ENDP

;
;Reads from memory - for use in _AMmusicMemloadMOD                        
;
__MMreadFile PROC FileHandle:WORD,Buffer:DWORD,NumBytes:WORD
	push    es
	push    ds
	push    si
	push    di
	push    ebx
	push    cx
	cld
	les     di,Buffer
	mov     eax,mycurptr
	mov     esi,eax
	and     esi,0Fh
	shr     eax,4
	mov     ds,ax
	mov     cx,NumBytes
	shr     cx,1
	rep     movsw
	adc     cl,0
	rep     movsb
	pop     cx
	pop     ebx
	pop     di
	pop     si
	pop     ds
	pop     es
	movzx   eax,NumBytes
	add     mycurptr,eax
	clc
	ret
	ENDP

;
;_DSMmemloadSample                                                        
;I:  SampleStrucAdd:D,FileHandle:W,SEG:OFF of sample                      
;O:  Carry0=Success, EAX=File pos past sample                             
;    Carry1=Error & AX=Error.                                             
;N:  Loads the SAMPLE only...without the header.                          
;    Automatically converts sample to signed format.                      
;
_DSMmemloadSample PROC NEAR uses EBX CX DX SI DI FS ES DS, StrucAdd:DWORD,\
						     Handle:WORD,FilePos:DWORD
	local   TMPlength:DWORD,TMPpos:DWORD,TMPhandle:DWORD,TMPprevValue:BYTE

	mov     ErrorCode,ERR_CannotManageDisk
	push    Handle                  ;Seek pos
	push    FilePos
	push    word ptr 0
	call    __MMseekFile
	jc      @@Error

	;LOAD SAMPLE
	les     si,StrucAdd
	mov     eax,es:[SmpX.SMPlength][si]
	mov     ebx,eax
	mov     TMPlength,eax
	mov     eax,es:[SmpX.SMPmemHandle][si]
	mov     TMPhandle,eax
	mov     eax,es:[SmpX.SMPmemPos][si]
	mov     TMPpos,eax
	mov     TMPprevValue,0          ;For delta-encoded samples
      @@ReadSample:
	or      ebx,ebx
	jz      @@DoneRead

	push    TMPhandle               ;Get address of buffer
	push    TMPpos
	call    _MEMqGetAddress
	doerr   ERR_NotEnoughMemory
	mov     fs,dx
	mov     di,ax

	mov     cx,bx                   ;Read in 32k chunks
	cmp     ebx,32768
	jbe     short @@BXlessThan32k
	mov     cx,32768
	@@BXlessThan32k:
	;push    eax
	movzx   eax,cx
	sub     ebx,eax
	add     TMPpos,eax
	;pop     eax

	push    Handle
	push    dx DI ;ax
	push    cx
	call    __MMreadFile
	doerr   ERR_CannotManageDisk

	;-----------------SAMPLE CONVERSION CODE---------------
	or      ax,ax
	jz      short @@NoSample                        ;0 bytes - no sample...
	;Decode delta-encoded values
	test    es:[SmpX.SMPinfo][si],100000b
	jz      short @@NotDeltaEncoded
	push    ax di
	mov     cx,ax
	@@DecodeDelta:
	mov     al,[fs:di]
	add     al,TMPprevValue
	mov     [fs:di],al
	mov     TMPprevValue,al
	inc     di
	dec     cx
	jnz     short @@DecodeDelta
	pop     di ax
	@@NotDeltaEncoded:
	;Convert to unsigned if sample is signed
	test    es:[SmpX.SMPinfo][si],10000b
	jz      short @@UnSigned
;push    di
	mov     cx,ax ;32768/2
	@@MakingSigned:
	xor     byte ptr fs:[di],080h
	inc     di
	dec     cx
	jnz     short @@MakingSigned
;pop     di
	@@UnSigned:

;;=Lossy encoding
;        ;Cut to 7-bit samples...for phun
;        mov     cx,ax ;32768/2
;        @@Making4bit:
;        and     byte ptr fs:[di],11111110b
;        inc     di
;        dec     cx
;        jnz     short @@Making4bit


	@@NoSample:
	;-----------------SAMPLE CONVERSION CODE---------------

	jmp     @@ReadSample
      @@DoneRead:
	and     es:[SmpX.SMPinfo][si],NOT 110000b       ;Set UNSIGNED flag
							;Set non-delta-encoded
	mov     eax,TMPlength
	add     eax,FilePos             ;EAX=File pos past this sample
	quit
	_DSMmemloadSample ENDP



;
;_DSMunloadSample                                                         
;I:  SampleStrucAdd:D                                                     
;O:  Carry1=Error & AX=Error.                                             
;
_DSMunloadSample PROC NEAR ;StrucAdd:DWORD
	clc
	ret 4
	ENDP
;
;_DSMamplification                                                        
;I:  Amplification:W                                                      
;O:  Carry1=Error & AX=Error.                                             
;N:  Sets amplification and the appropriate mixing routine.               
;
_DSMamplification PROC NEAR USES BX DX DS, Amplification:WORD
	;setDS
	pushf
	cli
	mov     ax,Amplification
	;16-BITS?
	test    DSM_Flags,10b
	jnz     short @@Do16 ;Done
	;STANDARD MIXING?
	mov     dx,offset SilentDMA8
	mov     bx,offset Copy8
	cmp     ax,65535
	je      short @@Done
	;QUALITY MIXING?
	mov     bx,offset Copy8quality
	cmp     ax,32768
	jb      short @@Done
	;ELSE, IT'S QUICK QUALITY. GET NUMBER BITS TO SHIFT.
	mov     bx,offset Copy8quickQuality
      @@Done:
	mov     DSM_CopyRoutine,bx
	mov     DSM_SilentDMARoutine,dx
	mov     DSM_Amplification,ax
	popf
	clc
	ret

      @@Do16:
	;STANDARD MIXING?
	mov     dx,offset SilentDMA16
	mov     bx,offset Copy16
	cmp     ax,65535
	je      short @@Done
	;QUALITY MIXING?
	mov     bx,offset Copy16quality
	cmp     ax,32768
	jb      short @@Done
	;ELSE, IT'S QUICK QUALITY. GET NUMBER BITS TO SHIFT.
	mov     bx,offset Copy16quickQuality
	jmp     short @@Done
	_DSMamplification ENDP
;
;_DSMpoll                                                                 
;
CODE_ALIGN
_DSMpoll PROC NEAR USES ;EBX ECX EDX SI DI ES DS BP ;BP TOO? PIG!
	pushad
	push    es ds
	setDS

	;DETERMINE NUMBER OF BYTES TO FILL IN DMA BUFFER
	push    DSM_DMAchannel
	push    DSM_DMAsize
	call    GetDMApos
	mov     bx,DSM_MixPos
	cmp     ax,bx
	jae     short @@DMAmoreDSM
	;***DMA POS < DSM POS.     --DMA--MIX--
	;***NumMix=DMAsize-MIXpos+DMApos
	neg     bx
	add     bx,DSM_DMAsize
	add     ax,bx
	jmp     short @@A1
	@@DMAmoreDSM:
	;***DMA POS >= DSM POS.    --MIX--DMA--
	;***NumMix=DMApos-MIXpos
	sub     ax,bx
	@@A1:
	test    DSM_Flags,01b           ;Stereo! Half number counts!
	jz      short @@NotStereo
	shr     ax,1
	@@NotStereo:
	test    DSM_Flags,10b           ;16-bits! Half number counts!
	jz      short @@Not16
	shr     ax,1
	@@Not16:
	and     ax,NOT 1b               ;Mix EVEN number counts ALWAYS (speed!)
	;or      ax,ax
	jz      @@DonePoll
	cmp     ax,AM.DSM_MinDMAcounts
	jb      @@DonePoll
	mov     DSM_DMAcount,ax
	xor     ecx,ecx                 ;Clear top word of ECX

	;SAVE MAPPING CONTEXT
	cld
	call    _MEMgetInfo
	mov     es,dx
	mov     di,ax
	mov     ax,[es:di][MEMx.MEM_qNumEMSblocks]
	mov     DSM_OrigqNumEMSblocks,ax
	mov     [es:di][MEMx.MEM_qNumEMSblocks],2
	;Need at least 2, as the offset might
	;be VERY near 16384...near to next
	;block...

	push    seg DSM_MappingContext
	push    offset DSM_MappingContext
	call    _MEMsaveStatus
	or      AM.AM_Status,1000b         ;Set MEMORY MAP SAVED
CODE_ALIGN
@@DO_TICKS: ;
	;DETERMINE IF TIME TO STOP
	cmp     DSM_DMAcount,0
	je      @@DoneMix
	;DETERMINE IF TIME FOR TICK. DECREMENT COUNT.
	and     DSM_TICKcount,NOT 1b
	jne     short @@NoTick
	call    DSM_UpdateRoutine
	mov     ax,DSM_CountsPerTick
	and     ax,NOT 1b
	mov     DSM_TICKcount,ax
	@@NoTick:
	;SELECT THE SMALLER OF DMAcount AND TICKcount & DECREMENT THEM!
	mov     ax,DSM_DMAcount
	cmp     ax,DSM_TICKcount
	jbe     short @@A2
	mov     ax,DSM_TICKcount
	@@A2:
	mov     DSM_MIXcount,ax
	sub     DSM_DMAcount,ax
	sub     DSM_TICKcount,ax
    ;
	;DO FOR EACH ACTIVE TRACKS
	mov     DSM_CurrentTrack,0
	mov     DSM_NumberMixedTracks,0
    @@DO_TRACKS:
	mov     ax,DSM_MIXcount
	mov     DSM_TRACKMIXcount,ax
	mov     bx,DSM_CurrentTrack             ;Get track struc offset
	cmp     bx,AM.AM_NumberActiveTracks
	jae     @@NoMoreTracks
	mov     bl,AM.AM_TrackList[bx]             ;Get REAL track number in BX
	shl     bx,1
	mov     si,AM_TrackTable[bx]
	;DETERMINE IF TOO SOFT (NO SOUND FOR VOL 0-1) OR MUTED/STOPPED
	test    [cs:TrackX.TRKstatus][si],111b  ;Stop if either paused/muted/stopped?
	jnz     @@TrackDone
	cmp     [cs:TrackX.TRKsamplePanPos][si],255;Pan pos 255 = no sound!
	je      @@TrackDone
	cmp     [cs:TrackX.TRKfinalVolume][si],0       ;VOLUME OPTIMIZATION
	je      short @@VolumeNotAudible ;jbe     @@TrackDone
	inc     DSM_NumberMixedTracks           ;Nope. Increment mixed tracks!
	@@VolumeNotAudible:
	mov     DSM_MixingBufferOffset,8192+256

      ;
      @@DO_SMPcount:
	;WHILE THERE IS SOME MORE COUNTS TO MIX...
	cmp     DSM_TRACKMIXcount,0
	je      @@TrackDone
	;CALCULATE SMPcount
	mov     edx,[cs:TrackX.TRKsampleOffset][si]
	shl     edx,16
	mov     dx,[cs:TrackX.TRKsampleStepCount][si]
	mov     eax,[cs:TrackX.TRKsamplePast][si]
	shl     eax,16
	sub     eax,edx
	jc      short @@SampleEnd
	xor     edx,edx
	div     [cs:TrackX.TRKsampleSteps][si]
	or      edx,edx                 ;If modulus present, increment by 1
	jz      short @@NoRemainder1    ;so that the next time we come here,
	inc     eax                     ;SmpOffset > SmpPast! (More accurate)
	@@NoRemainder1:
	;================================================================;
	;Say, if in the last cycle, we have went near the past offset,   ;
	;The stopped/muted flag will not be set and thus, execution will ;
	;come here. If it is truly stopped/muted, the _DSMsampleEnd      ;
	;routine will set the flags!                                     ;
	;================================================================;
	;DETERMINE IF TIME FOR SAMPLE TO END/LOOP
	;and     eax,NOT (AM@MultiSamplingBytes-1);Too few counts?
	;jnz     short @@EnoughCounts
	or      eax,eax
	jnz     short @@EnoughCounts
	;
	;SAMPLE END. CHECK FOR LOOPING
	;
      @@SampleEnd:
	les     di,[cs:TrackX.TRKsampleStrucAddress][si]
	test    es:[SmpX.SMPinfo][di],1000b
	jnz     short @@Looped
	@@Stopped:
	;STOPPED!
	or      [cs:TrackX.TRKstatus][si],10b      ;Stop!
	jmp     short @@SampleStopped
	@@Looped:
	;====================================================================;
	;LOOPED! - Bypass _AMsetOffset for speed!                            ;
	;mov     [cs:TrackX.TRKsampleStepCount][si],0                        ;
	;Nope! We WANNA keep track of the lower 16-bit step count!           ;
	;You see...problem arises with looping..as follows..                 ;
	;Say the sample is as follows...                                     ;
	;1   2   3   4   5   6   7   8                                       ;
	;A B C D E F G H I J K L M N O P                                     ;
	;where each alphabet=1 sample byte                                   ;
	;                                                                    ;
	;The frist 8 samples play correctly...but when it comes to the       ;
	;9th one...we SHOULD PLAY 'B' ! Not 'A' again! This is the reason    ;
	;why my previous players played wrongly with the MOD from HexAppeal! ;
	;                                                                    ;
	;So, what we should do is DECREMENT offset by the LOOP length! :)    ;
	;====================================================================;
	mov     eax,[cs:TrackX.TRKsamplePast][si]
	sub     eax,[cs:TrackX.TRKsampleLoopOffset][si]
	sub     [cs:TrackX.TRKsampleOffset][si],eax ;SmpOffset&StepCount = Past sample past end!
	mov     edx,[cs:TrackX.TRKsampleOffset][si]
	shl     edx,16
	mov     dx,[cs:TrackX.TRKsampleStepCount][si]
	mov     eax,[cs:TrackX.TRKsamplePast][si]
	shl     eax,16
	sub     eax,edx
	jc      short @@SampleStopped
	xor     edx,edx
	div     [cs:TrackX.TRKsampleSteps][si]
	or      edx,edx                 ;If modulus present, increment by 1
	jz      short @@NoRemainder2    ;so that the next time we come here,
	inc     eax                     ;SmpOffset > SmpPast! (More accurate)
	@@NoRemainder2:
	or      eax,eax
	jnz     short @@EnoughCounts
	;===================================================================;
	;CANNOT SET FLAG, SINCE IF THE ROUTINE DECREASES THE RATE           ;
	;OR SOMETHING, THEN, IT MIGHT TURN OUT TO BE POSSIBLE FOR THE LOOP! ;
	;What we can do is make it silent for this tick...and until the next;
	;tick, we will check again.                                         ;
	;or      [cs:TrackX.TRKstatus][si],10b      ;Stop!
	;;jmp     short @@Stopped
	;===================================================================;
      @@SampleStopped:
	;
	;SAMPLE END - FILL IN GAPS WITH SILENCE!
	;
	cmp     [cs:TrackX.TRKfinalVolume][si],0       ;Vol optimization
	je      @@TrackDone
	mov     cx,DSM_TRACKMIXcount
	mov     ax,DSM_SilenceRoutine
	cmp     DSM_NumberMixedTracks,1
	jne     short @@SilenceNotFirst
	mov     ax,DSM_SilenceRoutine1
	@@SilenceNotFirst:
	call    ax
	jmp     @@TrackDone
      @@EnoughCounts:
	;SELECT THE SMALLER OF MIXcount and SMPcount
	;DON'T SUBTRACT/DECREMENT DMAcount OR TICKcount! ALREADY DONE!!
	cmp     eax,65536                       ;Too large. Clip to 16-bits.
	jb      short @@WithinRange
	mov     eax,65535
	@@WithinRange:
	cmp     ax,DSM_TRACKMIXcount
	jbe     short @@A3
	mov     ax,DSM_TRACKMIXcount
	@@A3:
	sub     DSM_TRACKMIXcount,ax
	;shr     ax,AM@MultiSamplingBits
	mov     DSM_NumberMixes,ax

	;
	;SET UP REGISTERS
	mov     TMPbp,bp
	mov     TMPsi,si
	mov     TMPds,ds
	;***CHECK FOR SURROUND SOUND, ETC..............................!!
	;======================================;
	;Vo = Original volume                  ;
	;PanPos = Panning position (0<-64->128);
	;Vr = [Vo x PanPos] / 128              ;
	;Vl = Vo-Vr                            ;
	;======================================;
	mov     al,[cs:TrackX.TRKfinalVolume][si]
	;mov     DSM_Volume,al                   ;(vol 1 is heard! :) 0-32
	xor     ah,ah                                   ;Master volume...
	inc     ax                              ;Inc AL so that we round it up...
	shr     ax,1
	;OPTIMIZABLE - CAN USE PAN TABLES...
	mov     ah,[cs:TrackX.TRKsamplePanPos][si]         ;Set l/r volume, BH:CH
	cmp     ah,0254                                 ;DMP SURROUND SOUND (ORIGINAL VALUE IS A4h)
	jne     short @@NotSurrorund                    ;((( SURROUND SOUND )))
	mov     ah,040h                                 ;not supported. Make it
	@@NotSurrorund:                                 ;middle.
	mov     ch,al
	mul     ah
	shr     ax,7    ;mov     bh,128         div     bh
	mov     bh,al
	sub     ch,al
	xchg    bh,ch   ;Bug found from PP3.1 -> PP3.2 !
	mov     ax,word ptr [cs:TrackX.TRKsampleSteps][si+0] ;Set steps
	mov     DSM_LoSkips,ax                            ;dx:DSM_LoSkips,bp
	;push    dx                                      ;Set pointers to
	les     di,[cs:TrackX.TRKsampleStrucAddress][si]   ;Sample, ES:DI
	push    es:[SmpX.SMPmemHandle][di]              ;MixBuff, DS:SI
	mov     eax,[cs:TrackX.TRKsampleOffset][si]
	add     eax,es:[SmpX.SMPmemPos][di]
	push    eax
	call    _MEMqGetAddress
	mov     es,dx
	mov     di,ax
	;pop     dx
	mov     dx,word ptr [cs:TrackX.TRKsampleSteps][si+2]
	mov     bp,word ptr [cs:TrackX.TRKsampleStepCount][si]
	;doerr   ERR_CannotManageMemory ;IGNORE ERROR FOR SPEED!
	mov     si,DSM_MixingBufferOffset
	mov     ds,DSM_MixingBuffer
	;MIX!
	push    di
	call    DSM_MixingRoutine
	pop     ax
	;RESTORE REGISTERS
	sub     di,ax                                   ;Move by relative
	xor     eax,eax                                 ;offset from real sample
	mov     ax,di                                   ;offset..sort like that,
	mov     ds,TMPds                                ;since the sample might be larger than 64k and DI may not point to the real smaple offset, but offset in buffer
	mov     DSM_MixingBufferOffset,si
	mov     si,TMPsi
	add     [cs:TrackX.TRKsampleOffset][si],eax
	mov     [cs:TrackX.TRKsampleStepCount][si],bp
	mov     bp,TMPbp

	;
      ;
      jmp     @@DO_SMPcount
      @@TrackDone:
	inc     DSM_CurrentTrack
	jmp     @@DO_TRACKS
      @@NoMoreTracks:
	;COPY MIXING BUFFER TO DMA BUFFER
	;Check how many channels active...
	;If NONE active, the mixing buffer has values of 0!
	;Must make it 128 for 8-bit ones! But that'll be handled by their
	;respective routines.
	;mov     cx,DSM_MIXcount
	cmp     DSM_NumberMixedTracks,0
	ja      short @@SoundMixed
	call    DSM_SilentDMAroutine
	jmp     short @@SoundMixed2
	@@SoundMixed:
	call    DSM_CopyRoutine
	@@SoundMixed2:
    ;
jmp     @@DO_TICKS
@@DoneMix:
	;BEFORE EXIT, RESTORE MAPPING CONTEXT
	call    _MEMgetInfo
	mov     es,dx
	mov     di,ax
	mov     ax,DSM_OrigqNumEMSblocks        ;Restore num EMS blocks
	mov     [es:di][MEMx.MEM_qNumEMSblocks],ax
	push    seg DSM_MappingContext
	push    offset DSM_MappingContext
	call    _MEMrestoreStatus
	and     AM.AM_Status,NOT 1000b     ;Set MEMORY MAP NOT SAVED
@@DonePoll:
	clc
	pop     ds es
	popad
	ret
	_DSMpoll ENDP

;
; MIXER--------                                                    
; INPUT:                                                           
;             BH      Left channel volume                          
;             CH      Right channel volume                         
;             [E]DI   Sample offset                                
;             [E]SI   Mixer buffer offset                          
;             ES      Sample segment/selector                      
;             DS      VolumeTable & Mixer bufer segment/selector   
;             LoSkips Low skips                                    
;             DX      High skips                                   
;             BP      Low skip count (low 16-bit fixed point)      
;             DSM_NumberMixes Number elements to mix               
;             HighCX (top word) = 0                                
; OUTPUT:     [E]DI   Sample offset                                
;             [E]SI   Mixer buffer offset                          
;             BP      Low skip count (low 16-bit fixed point)      
;             DSM_NumberMixes 0                                    
;             CX      Possibly modified                            
;             BH      Possibly modified                            
;             others  Not modified.                                
; NOTE:       BH+CH=LeftVol+RightVol=64                            
;
	;============================================
	;NumLabel
	; CREATE NUMBERED LABEL.
	;I lname = label name
	;  lnum  = label number
	;O L_(labelname)(labelnumber)
	;============================================
      NumLabel MACRO lname,lnum
	L_&lname&lnum:
	ENDM
	;============================================
	;JmpTable
	; CREATE A JUMP OFFSET TABLE
	;I lname = label name
	;  lcount= number of labels
	;N Label numbering starts from 0.
	;N Label name created with NumLabel macro.
	;============================================
      dwptr MACRO lname,lnum
	dw offset L_&lname&lnum
	ENDM
      JmpTable MACRO lname,lcount
	lcountX=0
	rept lcount
	dwptr lname,%lcountX
	lcountX=lcountX+1
	ENDM
	ENDM
	;============================================
	;MixLoop
	; CREATE A SHORT CHUNK OF REPEATED MIXING CODE
	;I mname = Mixer label name
	;  mmacro= Mixer macro name
	;  esize = Element size. Mono=1 Stereo=2
	;  countv= Count value (number elements)
	;  retLbl= Return address label. After mix, JMPs to this label.
	;============================================
      MixLoop MACRO mname,mmacro,esize,countv,retLbl
	LOCAL MixLabel
	DW_ALIGN
	&mname LABEL WORD
	JmpTable &mname,%(AM@MultiSamplingBytes+1)
	MCNT=0
	CODE_ALIGN
	MixLabel:
	REPT AM@MultiSamplingBytes
	NumLabel &mname,%MCNT
	&mmacro %MCNT
	MCNT=MCNT+1
	ENDM
	NumLabel &mname,%MCNT           ;Xtra 1 coz of mixer structure.
	add     si,2*AM@MultiSamplingBytes*esize
	dec     countv
	jnz     MixLabel
	jmp     retLbl
	ENDM
	;==============================MONO MIXER===
	__MixMonoA MACRO cntx           ;MONO MIXER - FIRST MIX
	mov     bl,es:[di]      ;[bp] ;
	add     bp,sp           ;di,sp ;
	adc     di,dx           ;bp,dx ;
	mov     al,[bx]
	IF cntx EQ 0
	mov     [si],ax
	ELSE
	mov     [si+(cntx*2)],ax
	ENDIF
	ENDM
	__MixMono MACRO cntx            ;MONO MIXER
	mov     bl,es:[di]      ;[bp] ;
	add     bp,sp           ;di,sp ;
	adc     di,dx           ;bp,dx ;
	mov     al,[bx]
	IF cntx EQ 0
	add     [si],ax
	ELSE
	add     [si+(cntx*2)],ax
	ENDIF
	ENDM
	;==============================FULL-VOLUME MONO MIXER===
	;FULL VOLUME MIXER
	__MixFullMonoA MACRO cntx           ;MONO MIXER - FIRST MIX
	mov     al,es:[di]
	add     bp,sp
	adc     di,dx
	IF cntx EQ 0
	mov     [si],ax
	ELSE
	mov     [si+(cntx*2)],ax
	ENDIF
	ENDM
	__MixFullMono MACRO cntx            ;MONO MIXER
	mov     al,es:[di]
	add     bp,sp
	adc     di,dx
	IF cntx EQ 0
	add     [si],ax
	ELSE
	add     [si+(cntx*2)],ax
	ENDIF
	ENDM
	;==============================NORMAL STEREO MIXER===
	__MixStereoA MACRO cntx         ;STEREO MIXER - FIRST MIX
	mov     cl,es:[di]      ;Right channel
	add     bp,sp
	adc     di,dx
	mov     al,[ecx]
	shl     eax,16
	mov     bl,cl           ;Left channel
	mov     al,[bx]
	IF cntx EQ 0
	mov     [si],eax
	ELSE
	mov     [si+(cntx*4)],eax
	ENDIF
	ENDM
	__MixStereo MACRO cntx          ;STEREO MIXER
	mov     cl,es:[di]      ;Right channel
	add     bp,sp
	adc     di,dx
	mov     al,[ecx]
	shl     eax,16
	mov     bl,cl           ;Left channel
	mov     al,[bx]
	IF cntx EQ 0
	add     [si],eax
	ELSE
	add     [si+(cntx*4)],eax
	ENDIF
	ENDM
	;==============================LEFT STEREO MIXER===
	;==============================RIGHT STEREO MIXER===
	;==============================MIDDLE STEREO MIXER===
	;==============================SURROUND STEREO MIXER===

	;======AN EXAMPLE OF TRAN'S MTM MIXER FOR PROTECTED MODE...
	comment ~
		irp a,<32,31,30,29,28,27,26,25,24,23,22,21,20,19,18,17,16,15,14,13,12,11,10,9,8,7,6,5,4,3,2,1>
		M16&a:  mov  bl, [b esi]          ;Signed sample
		mov  al, [b ebx]
		add  [w edi+(32-a)*2], ax ;Add to unsigned buffer
		add  ecx, edx
		adc  esi, ebp
		EndM
		add  edi, 32*2
		dec  cl
		jnz  M16_loop
		pop  eax
		shr  ecx, 16
		mov  [w (eax*4)+Ch_LowPos+2], cx  ;Don't affect flags, write upper 12 bits
		mov  [(eax*4)+Ch_HighPos], esi
		mov  esi, eax
		ret

	What I would probably have in my Protected Mode mixer...
	(All's in one 4-gig segment! :)

	mov     bl,[edi]
	mov     al,[ebx]
	add     ebp,ecx ;Change here..
	adc     edi,edx
	add     [esi+(cntx*2)],ax

	mov     bl,[edi]
	mov     al,[ebx]
	sub     ebp,ecx ;Change here..
	sbc     edi,edx
	add     [esi+(cntx*2)],ax

	of course, this isn't exactly the optimal code.


;
;EXTENDED STEREO MIXERS FOR SURROUND AND SPEED.
;NOT SUPPORTED YET.
;
	;===SURROUND SOUND MIXER===
	__MixSurroundA MACRO cntx
	mov     bl,es:[di]      ;Left channel
	add     bp,sp
	adc     di,dx
	mov     al,[bx]
	IF cntx EQ 0
	mov     [si],eax
	ELSE
	mov     [si+(cntx*4)],ax
	ENDIF
	mov     cl,bl           ;Right channel
	mov     al,[ecx]
	mov     [si+(cntx*4)+2],ax
	ENDM
	__MixSurround MACRO cntx
	mov     bl,es:[di]      ;Left channel
	add     bp,sp
	adc     di,dx
	mov     al,[bx]
	IF cntx EQ 0
	add     [si],eax
	ELSE
	sub     [si+(cntx*4)],ax
	ENDIF
	mov     cl,bl           ;Right channel
	mov     al,[ecx]
	mov     [si+(cntx*4)+2],ax
	ENDM
	~

	 ;===LEFT-ONLY SOUND MIXER===
	;*** TOP WORD OF EAX MUST BE 128! ***
	__MixLeftA MACRO cntx
	mov     bl,es:[di]
	add     bp,sp
	adc     di,dx
	mov     al,[bx]
	IF cntx EQ 0
	mov     [si],eax
	ELSE
	mov     [si+(cntx*4)],eax
	ENDIF
	ENDM
	__MixLeft MACRO cntx
	mov     bl,es:[di]
	add     bp,sp
	adc     di,dx
	mov     al,[bx]
	IF cntx EQ 0
	add     [si],eax
	ELSE
	add     [si+(cntx*4)],eax
	ENDIF
	ENDM

	;===RIGHT-ONLY SOUND MIXER===
	;*** AX MUST BE 128! ***
	;*** BH MUST BE RIGHT CHANNEL VOLUME! ***
	__MixRightA MACRO cntx
	mov     bl,es:[di]
	add     bp,sp
	adc     di,dx
	mov     al,[bx]
	shl     eax,16
	mov     al,128
	IF cntx EQ 0
	mov     [si],eax
	ELSE
	mov     [si+(cntx*4)],eax
	ENDIF
	ENDM
	__MixRight MACRO cntx
	mov     bl,es:[di]
	add     bp,sp
	adc     di,dx
	mov     al,[bx]
	shl     eax,16
	mov     al,128
	IF cntx EQ 0
	add     [si],eax
	ELSE
	add     [si+(cntx*4)],eax
	ENDIF
	ENDM

	;===MIDDLE-ONLY SOUND MIXER===
	__MixMiddleA MACRO cntx
	mov     bl,es:[di]
	add     bp,sp
	adc     di,dx
	mov     al,[bx]
	IF cntx EQ 0
	mov     [si],ax
	ELSE
	mov     [si+(cntx*4)],ax
	ENDIF
	mov     [si+(cntx*4)+2],ax
	ENDM
	__MixMiddle MACRO cntx
	mov     bl,es:[di]
	add     bp,sp
	adc     di,dx
	mov     al,[bx]
	IF cntx EQ 0
	add     [si],ax
	ELSE
	add     [si+(cntx*4)],ax
	ENDIF
	add     [si+(cntx*4)+2],ax
	ENDM


;
;
;MIX8-BITSAMPLESINMONO
;
;
	MixLoop MixMonoA   ,__MixMonoA   ,1  ,cx        ,MixMonoDone
	MixLoop MixMono    ,__MixMono    ,1  ,cx        ,MixMonoDone

	MixLoop MixFullMonoA ,__MixFullMonoA ,1  ,cx    ,MixMonoDone
	MixLoop MixFullMono  ,__MixFullMono  ,1  ,cx    ,MixMonoDone

	TMPvol          db 0
CODE_ALIGN
MonoMixer PROC NEAR
	;===IF NO SOUND. JUST UPDATE POINTER...
	add     bh,ch                   ;Get total of left-right volume (0-32)
	mov     TMPvol,bh
	jnz     short @@VolumeAudible
	;cmp     DSM_Volume,0
	;ja      short @@VolumeAudible
	movzx   eax,DSM_NumberMixes             ;NewSteps = OldStep + (StepxCnt)
	shl     edx,16
	mov     dx,DSM_LoSkips
	mul     edx ;[cs:TrackX.TRKsampleSteps][si]
	mov     dx,ax
	shr     eax,16
	add     bp,dx
	adc     di,ax
	mov     ax,DSM_NumberMixes
	shl     ax,1
	add     si,ax
	jmp     short @@NoMix
	@@VolumeAudible:

	;DETERMINE NUMBER ELEMENTS REMAINDER AND ADJUST SI!
	mov     ax,DSM_NumberMixes
	and     ax,(AM@MultiSamplingBytes-1)
	shl     ax,1
	neg     ax
	add     ax,(AM@MultiSamplingBytes*2)
	mov     DSM_RemainderDelta,ax
	sub     si,ax                           ;Adjust SI!
	push    bx
	;add     bh,ch                   ;Get total of left-right volume (0-32)
	;mov     TMPvol,bh
	mov     bx,offset MixMono
	;cmp     TMPvol,32
	;jne     short @@NormalVol
	test    TMPvol,32
	jz      short @@NormalVol
	mov     bx,offset MixFullMono
	@@NormalVol:
	cmp     DSM_NumberMixedTracks,1
	jne     short @@NotFirst

	mov     bx,offset MixMonoA
	;cmp     TMPvol,32
	;jne     short @@NormalVolA
	test    TMPvol,32
	jz      short @@NormalVolA
	mov     bx,offset MixFullMonoA
	@@NormalVolA:
	@@NotFirst:
	add     bx,ax

	mov     ax,[cs:bx]
	mov     DSM_MixRoutineOffset,ax
	pop     bx
	;'CALL' THE MIXER (ACTUALLY, DO A SHORT JUMP)
	pushf
	cli
	;mov     TMPsp,sp
	;mov     sp,DSM_LoSkips
	xchg    sp,DSM_LoSkips
;        add     bh,ch
	xor     ah,ah
	;GET NUMBER CYCLES TO DO
	mov     cx,DSM_NumberMixes
	shr     cx,AM@MultiSamplingBits
	inc     cx
	jmp     DSM_MixRoutineOffset
	CODE_ALIGN
	MixMonoDone:
	mov     sp,DSM_LoSkips ;TMPsp ;
	popf
	@@NoMix:
	ret
	ENDP
CODE_ALIGN                      ;*** FIRST MIX! ***
MonoSilenceA PROC NEAR
	mov     es,DSM_MixingBuffer
	mov     di,DSM_MixingBufferOffset
	mov     eax,000800080h
	shr     cx,1
	CODE_ALIGN
	rep     stosd
	rcl     cx,1
	rep     stosw
	ret
	ENDP
CODE_ALIGN
MonoSilence PROC NEAR
	push    ds
	mov     ds,DSM_MixingBuffer
	mov     di,DSM_MixingBufferOffset
	mov     eax,000800080h
	push    cx
	shr     cx,1
	jz      short @@NoChunks
	CODE_ALIGN
	@@DoSilence:
	add     [di],eax
	add     di,4
	dec     cx
	jnz     short @@DoSilence
	@@NoChunks:
	pop     cx
	test    cl,1
	jz      short @@Even
	add     [di],ax
	@@Even:
	pop     ds
	ret
	ENDP
;
;
;MIX8-BITSAMPLESINSTEREO
;
;

;There are offsets of jump tables (jump tables have offset to mixer)
StereoMixerAOffset LABEL WORD
	dw      MixStereoA
	dw      MixLeftA
	dw      MixRightA
	dw      MixMiddleA
StereoMixerOffset LABEL WORD
	dw      MixStereo
	dw      MixLeft
	dw      MixRight
	dw      MixMiddle




	MixLoop MixStereoA ,__MixStereoA ,2  ,DSM_NumberMixes  ,MixStereoDone
;Put here for speed purposes?
	DD_ALIGN
	DSM_MIXcount            dw 0
	MixLoop MixStereo  ,__MixStereo  ,2  ,DSM_NumberMixes  ,MixStereoDone


	MixLoop MixLeftA ,__MixLeftA ,2  ,cx  ,MixStereoDone
	MixLoop MixLeft  ,__MixLeft  ,2  ,cx  ,MixStereoDone
	MixLoop MixRightA ,__MixRightA ,2  ,cx  ,MixStereoDone
	MixLoop MixRight  ,__MixRight  ,2  ,cx  ,MixStereoDone
	MixLoop MixMiddleA ,__MixMiddleA ,2  ,cx  ,MixStereoDone
	MixLoop MixMiddle  ,__MixMiddle  ,2  ,cx  ,MixStereoDone
;        MixLoop SurroundMixStereoA ,__SurroundMixStereoA ,2  ,DSM_NumberMixes  ,MixStereoDone
;        MixLoop SurroundMixStereo  ,__SurroundMixStereo  ,2  ,DSM_NumberMixes  ,MixStereoDone

	DD_ALIGN
	TMPeaxValue dd 0
	TMPcxValue  dw 0
CODE_ALIGN
StereoMixer PROC NEAR
	;===IF NO SOUND. JUST UPDATE POINTER...
	mov     al,bh
	or      al,ch
	;or      bh,ch
	jnz     short @@VolumeAudible
	;cmp     DSM_Volume,0
	;ja      short @@VolumeAudible
	movzx   eax,DSM_NumberMixes             ;NewSteps = OldStep + (StepxCnt)
	shl     edx,16
	mov     dx,DSM_LoSkips
	mul     edx ;[cs:TrackX.TRKsampleSteps][si]
	mov     dx,ax
	shr     eax,16
	add     bp,dx
	adc     di,ax
	mov     ax,DSM_NumberMixes
	shl     ax,1
	add     si,ax
	jmp     @@NoMix
	@@VolumeAudible:

	;DETERMINE NUMBER ELEMENTS REMAINDER AND ADJUST SI!
	;===OPTIMIZE TO USE LEFT/MIDDLE/RIGHT/SMOOTH PANNING MIXERS...
push    DSM_NumberMixes
	shr     DSM_NumberMixes,AM@MultiSamplingBits
	inc     DSM_NumberMixes
	;mov     TMPcxValue,cx
	mov     TMPeaxValue,0
  xor     bl,bl   ;Default to panning mixer
	or      ch,ch
	jz      short @@LeftMix
	or      bh,bh
	jz      short @@RightMix
;pignerd
  cmp     ch,16
  jne     short @@NormalMix
  mov     bl,6    ;Ptr to Middle mixing routine
  mov     cx,DSM_NumberMixes
  ;mov     TMPcxValue,ax
	jmp     short @@NormalMix
	@@RightMix:
  mov     bl,4    ;Right
	mov     bh,ch
	mov     TMPeaxValue,128
	mov     cx,DSM_NumberMixes
	;mov     TMPcxValue,ax
	jmp     short @@NormalMix
	@@LeftMix:
	mov     bl,2    ;Left
	mov     cx,DSM_NumberMixes
	;mov     TMPcxValue,ax
	mov     TMPeaxValue,128 SHL 16
	@@NormalMix:
pop     ax
	push    bx
	xor     bh,bh
	;===FIRST MIX OR NORMAL MIX...
	add     bx,offset StereoMixerOffset ;MixStereo
	cmp     DSM_NumberMixedTracks,1
	jne     short @@NotFirst
	add     bx,(offset StereoMixerAOffset)-(offset StereoMixerOffset) ;MixStereoA
	@@NotFirst:
	mov     bx,[cs:bx]                      ;Get jump table offset...
	;===FRACTION MANAGEMENT
	;mov     ax,DSM_NumberMixes
	and     ax,(AM@MultiSamplingBytes-1)
	shl     ax,1
	neg     ax
	add     ax,(AM@MultiSamplingBytes*2)
	mov     DSM_RemainderDelta,ax
	shl     ax,1                            ;Stereo - doubleword counts!
	sub     si,ax                           ;Adjust SI!
	shr     ax,1
	add     bx,ax
	mov     ax,[cs:bx]
	mov     DSM_MixRoutineOffset,ax
	pop     bx

	;'CALL' THE MIXER (ACTUALLY, DO A SHORT JUMP)
	pushf
	cli
	;mov     TMPsp,sp
	;mov     sp,DSM_LoSkips
	xchg    sp,DSM_LoSkips
	;xor     ah,ah
	mov     eax,TMPeaxValue
	;GET NUMBER CYCLES TO DO
	;mov     cx,TMPcxValue
	jmp     DSM_MixRoutineOffset
	CODE_ALIGN
	MixStereoDone:
	mov     sp,DSM_LoSkips ;TMPsp
	popf
	@@NoMix:
	ret
	ENDP
CODE_ALIGN                      ;*** FIRST MIX! ***
StereoSilenceA PROC NEAR
	mov     es,DSM_MixingBuffer
	mov     di,DSM_MixingBufferOffset
	mov     eax,000800080h
	CODE_ALIGN
	rep     stosd
	ret
	ENDP
CODE_ALIGN
StereoSilence PROC NEAR
	push    ds
	mov     ds,DSM_MixingBuffer
	mov     di,DSM_MixingBufferOffset
	mov     eax,000800080h
	CODE_ALIGN
	@@DoSilence:
	add     [di],eax
	add     di,4
	dec     cx
	jnz     short @@DoSilence
	pop     ds
	ret
	ENDP

;
;Now, to convert the 16-bit unsigned mixing to centre, we do...
;Since it has been converted to unsigned samples (through volume table),
;the middle pos (where speaker is neutral) is NumberActiveTracks x 128.
;
;NOTE! I have not optimized the code below much yet...performance can be
;      further boosted by using the _MultiCopying_ method. But come to
;      think of it...maybe I won't support it anyway...
;
;CAN BE MADE FASTER FOR STEREO - BUT NOT DONE (LAZY)
;

CLIPSAMPLE MACRO
	local SampleOK1,SampleOK2
	cmp     ax,127
	jle     short SampleOK1
	mov     ax,127  ;BYTE IS SLOWER THAN WORD?
	jmp     short SampleOK2
	CODE_ALIGN
	SampleOK1:
	cmp     ax,-128
	jge     short SampleOK2
	mov     ax,-128 ;BYTE IS SLOWER THAN WORD?
	SampleOK2:
	endm
CLIPSAMPLE16 MACRO
	local SampleOK1,SampleOK2
	cmp     eax,32767 ;127
	jle     short SampleOK1
	mov     eax,32767 ;127  ;BYTE IS SLOWER THAN WORD?
	jmp     short SampleOK2
	CODE_ALIGN
	SampleOK1:
	cmp     eax,-32768 ;-128
	jge     short SampleOK2
	mov     eax,-32768 ;-128 ;BYTE IS SLOWER THAN WORD?
	SampleOK2:
	endm
CODE_ALIGN
Copy8 PROC NEAR
	push    bp ds
	mov     bx,AM.AM_NumberActiveTracks
	mov     cl,DSM_MixingSHR[bx]
	mov     ax,DSM_NumberMixedTracks
	mov     ah,080h
	mul     ah
	mov     bx,ax
	mov     dx,DSM_MIXcount
	test    DSM_Flags,01b
	jnz     short @@Stereo
	shr     dx,1
	@@Stereo:
	mov     bp,DSM_DMAsizeMask
	mov     di,DSM_MixPos
	mov     es,DSM_MixingBuffer
	mov     si,8192+256
	mov     ds,DSM_DMAbuffer
	CODE_ALIGN
      @@Copy:
	mov     eax,es:[si]             ;1ST
	sub     ax,bx                   ;Move back to neutral pos = 0
	sar     ax,cl                   ;Decrease quality
	xor     al,128
	mov     [di],al
	inc     di
	shr     eax,16                  ;2ND
	sub     ax,bx                   ;Move back to neutral pos = 0
	sar     ax,cl                   ;Decrease quality
	xor     al,128
	mov     [di],al
	inc     di
	add     si,4
	and     di,bp                   ;**WRAPAROUND DI**
	dec     dx
	jnz     short @@Copy
	pop     ds bp
	mov     DSM_MixPos,di
	ret
	Copy8 ENDP
CODE_ALIGN
Copy8QuickQuality PROC NEAR
	push    bp ds
	mov     ax,DSM_NumberMixedTracks
	mov     ah,080h
	mul     ah
	mov     bx,ax
	mov     cx,DSM_Amplification    ;Amplification-32768 = Number shifts
	sub     cx,32768
	mov     dx,DSM_MIXcount
	test    DSM_Flags,01b
	jnz     short @@Stereo
	shr     dx,1
	@@Stereo:
	mov     bp,DSM_DMAsizeMask
	mov     di,DSM_MixPos
	mov     es,DSM_MixingBuffer
	mov     si,8192+256
	mov     ds,DSM_DMAbuffer
      CODE_ALIGN
      @@Copy:
	mov     eax,es:[si]             ;1ST
	sub     ax,bx                   ;Move back to neutral pos = 0
	sar     ax,cl                   ;Decrease quality
	CLIPSAMPLE
	xor     al,128
	mov     [di],al
	inc     di
	shr     eax,16                  ;2ND
	sub     ax,bx                   ;Move back to neutral pos = 0
	sar     ax,cl                   ;Decrease quality
	CLIPSAMPLE
	xor     al,128
	mov     [di],al
	inc     di
	add     si,4
	and     di,bp                   ;**WRAPAROUND DI**
	dec     dx
	jnz     short @@Copy
	pop     ds bp
	mov     DSM_MixPos,di
	ret
	Copy8QuickQuality ENDP
CODE_ALIGN
Copy8Quality PROC NEAR
	push    bp ds
	mov     cx,DSM_Amplification
	mov     ax,DSM_NumberMixedTracks
	mov     ah,080h
	mul     ah
	mov     bx,ax
	mov     ax,DSM_MIXcount
	test    DSM_Flags,01b
	jnz     short @@Stereo
	shr     ax,1
	@@Stereo:
	mov     DSM_CopyCount,ax
	mov     bp,DSM_DMAsizeMask
	mov     di,DSM_MixPos
	mov     es,DSM_MixingBuffer
	mov     si,8192+256
	mov     ds,DSM_DMAbuffer
	;============================
	;Amplification
	;------------- x SignedSample
	;    256
	;============================
      CODE_ALIGN
      @@Copy:
	mov     eax,es:[si]             ;1ST
	sub     ax,bx                   ;Move back to neutral pos = 0
	imul    cx
	shrd    ax,dx,8
	CLIPSAMPLE
	xor     al,128
	mov     [di],al
	inc     di
	shr     eax,16                  ;2ND
	sub     ax,bx                   ;Move back to neutral pos = 0
	imul    cx
	shrd    ax,dx,8
	CLIPSAMPLE
	xor     al,128
	mov     [di],al
	inc     di
	add     si,4
	and     di,bp                   ;**WRAPAROUND DI**
	dec     DSM_CopyCount
	jnz     short @@Copy
	pop     ds bp
	mov     DSM_MixPos,di
	ret
	Copy8Quality ENDP
CODE_ALIGN
SilentDMA8 PROC NEAR
	push    ds
	mov     cx,DSM_MIXcount
	test    DSM_Flags,01b
	jnz     short @@Stereo
	shr     cx,1
	@@Stereo:
	mov     di,DSM_MixPos
	mov     bx,DSM_DMAsizeMask
	mov     ds,DSM_DMAbuffer
	mov     ax,08080h
	CODE_ALIGN
      @@Silent:
	mov     [di],ax
	inc     di
	inc     di
	and     di,bx                   ;**WRAPAROUND DI**
	dec     cx
	jnz     short @@Silent
	pop     ds
	mov     DSM_MixPos,di
	ret
	SilentDMA8 ENDP
CODE_ALIGN
Copy16 PROC NEAR ;HIGHEST QUALITY - NO AMPLIFICATION/ETC...
	push    bp ds
	mov     bx,AM.AM_NumberActiveTracks
	mov     cl,DSM_MixingSHL16[bx]
	mov     ax,DSM_NumberMixedTracks
	mov     ah,080h
	mul     ah
	mov     bx,ax
	mov     dx,DSM_MIXcount
	test    DSM_Flags,01b
	jz      short @@Mono
	shl     dx,1
	@@Mono:
	mov     bp,DSM_DMAsizeMask
	mov     di,DSM_MixPos
	mov     es,DSM_DMAbuffer
	mov     si,8192+256
	mov     ds,DSM_MixingBuffer
	CODE_ALIGN
      @@Copy:
	mov     ax,[si]
	sub     ax,bx                   ;Move back to neutral pos = 0
	sal     ax,cl                   ;AMPLIFY!!
	mov     es:[di],ax              ;16-BIT USES SIGNED ALUES!
	inc     si
	inc     si
	inc     di
	inc     di
	and     di,bp                   ;**WRAPAROUND DI**
	dec     dx
	jnz     short @@Copy
	pop     ds bp
	mov     DSM_MixPos,di
	ret
	Copy16 ENDP
CODE_ALIGN
Copy16QuickQuality PROC NEAR
	push    bp ds
	mov     bx,AM.AM_NumberActiveTracks
	mov     cx,DSM_Amplification    ;Amplification-32768 = Number shifts
	sub     cx,32768
	mov     ax,DSM_NumberMixedTracks
	mov     ah,080h
	mul     ah
	mov     bx,ax
	mov     dx,DSM_MIXcount
	test    DSM_Flags,01b
	jz      short @@Mono
	shl     dx,1
	@@Mono:
	mov     bp,DSM_DMAsizeMask
	mov     di,DSM_MixPos
	mov     es,DSM_DMAbuffer
	mov     si,8192+256
	mov     ds,DSM_MixingBuffer
	CODE_ALIGN
      @@Copy:
	mov     ax,word ptr [si]
	sub     ax,bx                   ;Move back to neutral pos = 0
	movsx   eax,ax
	sal     eax,cl
	CLIPSAMPLE16
	mov     es:[di],ax              ;16-BIT USES SIGNED ALUES!
	inc     si
	inc     si
	inc     di
	inc     di
	and     di,bp                   ;**WRAPAROUND DI**
	dec     dx
	jnz     short @@Copy
	pop     ds bp
	mov     DSM_MixPos,di
	ret
	ENDP
CODE_ALIGN
Copy16Quality PROC NEAR
	push    bp ds
	mov     bx,AM.AM_NumberActiveTracks
	movzx   ecx,DSM_Amplification    ;Amplification-32768 = Number shifts
	mov     ax,DSM_NumberMixedTracks
	mov     ah,080h
	mul     ah
	mov     bx,ax
	mov     dx,DSM_MIXcount
	test    DSM_Flags,01b
	jz      short @@Mono
	shl     dx,1
	@@Mono:
	mov     DSM_CopyCount,dx
	mov     bp,DSM_DMAsizeMask
	mov     di,DSM_MixPos
	mov     es,DSM_DMAbuffer
	mov     si,8192+256
	mov     ds,DSM_MixingBuffer
	CODE_ALIGN
	;============================
	;Amplification
	;------------- x SignedSample x 256 (256=amplification to 16-bits)
	;    256
	;==> Nett result = same val!
	;============================
      @@Copy:
	mov     ax,word ptr [si]
	sub     ax,bx                   ;Move back to neutral pos = 0
	movsx   eax,ax
	imul    ecx
	;shrd    eax,edx,1
	CLIPSAMPLE16
	mov     es:[di],ax              ;16-BIT USES SIGNED ALUES!
	inc     si
	inc     si
	inc     di
	inc     di
	and     di,bp                   ;**WRAPAROUND DI**
	dec     DSM_CopyCount
	jnz     short @@Copy
	pop     ds bp
	mov     DSM_MixPos,di
	ret
	ENDP
CODE_ALIGN
SilentDMA16 PROC NEAR
	push    ds
	mov     cx,DSM_MIXcount
	test    DSM_Flags,01b
	jz      short @@Mono
	shl     cx,1
	@@Mono:
	mov     di,DSM_MixPos
	mov     bx,DSM_DMAsizeMask
	mov     ds,DSM_DMAbuffer
	xor     ax,ax
	CODE_ALIGN
      @@Silent:
	mov     [di],ax
	inc     di
	inc     di
	and     di,bx                   ;**WRAPAROUND DI**
	dec     cx
	jnz     short @@Silent
	pop     ds
	mov     DSM_MixPos,di
	ret
	SilentDMA16 ENDP
.CSEG_ENDS AM





