// c_module.h: interface for the c_module class.
//
//////////////////////////////////////////////////////////////////////
/*
PLAY_ITW.EXE v0.03a : Player for Impulse Tracker modules files
Copyright (C) 1998  Olivier AUMAGE
E-mail : Olivier.Aumage@ens-lyon.fr
Web : http://www.ens-lyon.fr/~oaumage/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  any later version.
  
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	  You should have received a copy of the GNU General Public License
	  along with this program; if not, write to the Free Software
	  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#if !defined(AFX_C_MODULE_H__2691C106_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_)
#define AFX_C_MODULE_H__2691C106_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class c_module  
{
public:
	c_module(FILE *module_file);
	c_module(istream &is, int format, bool linear_interpolation);
	virtual ~c_module();
	const char *get_name();
	signed long get_number_of_orders();
	signed long get_number_of_instruments();
	signed long get_number_of_samples();
	signed long get_number_of_patterns();
	bool is_stereo();
	bool use_instruments();
	bool use_linear_slides();
	bool use_old_effects();
	bool use_compatible_g();
	bool has_a_message();
	const char *get_message();
	signed long get_global_volume();
	signed long get_mixing_volume();
	signed long get_initial_speed();
	signed long get_initial_tempo();
	signed long get_panning_separation();
	signed long get_channel_volume(signed long channel);
	signed long get_channel_panning(signed long channel);
	signed long get_order (signed long order);
	p_instrument get_instrument (signed long instrument);
	p_sample get_sample (signed long sample);
	p_pattern get_pattern (signed long pattern);
	p_pattern get_order_pattern (signed long order);

private:
	void RTM_istream_loader(istream &is);
	void IT_istream_loader(istream &is, bool linear_interpolation);
	char m_name[256] ; 
	signed long m_number_of_orders ;
	signed long m_number_of_instruments ;
	signed long m_number_of_samples ;
	signed long m_number_of_patterns ;
	bool m_is_stereo ;
	bool m_use_instruments ;
	bool m_type_of_slides ;
	bool m_old_effects ;
	bool m_g_effect ;
	bool m_has_a_message ;
	char *m_message ;
	signed long m_global_volume ;
	signed long m_mixing_volume ;
	signed long m_initial_speed ;
	signed long m_initial_tempo ;
	signed long m_panning_separation ;
	signed long m_channels_volumes [64] ;
	signed long m_channels_pannings [64] ;
	signed long *m_orders ;
	signed long m_cwt ;
	signed long m_cmwt ;
	p_instrument m_instruments[256] ;
	p_sample m_samples[256] ;
	p_pattern m_patterns[256] ;
};

#endif // !defined(AFX_C_MODULE_H__2691C106_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_)
