// c_driver.h: interface for the c_driver class.
//
//////////////////////////////////////////////////////////////////////
/*
PLAY_ITW.EXE v0.03a : Player for Impulse Tracker modules files
Copyright (C) 1998  Olivier AUMAGE
E-mail : Olivier.Aumage@ens-lyon.fr
Web : http://www.ens-lyon.fr/~oaumage/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  any later version.
  
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	  You should have received a copy of the GNU General Public License
	  along with this program; if not, write to the Free Software
	  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#if !defined(AFX_C_DRIVER_H__F7DA69C1_206F_11D1_B35E_DCE971BF2962__INCLUDED_)
#define AFX_C_DRIVER_H__F7DA69C1_206F_11D1_B35E_DCE971BF2962__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class c_driver  
{
public:
	void config(bool linear_interpolation, 
					  signed long sampling_rate, 
					  signed long latency,
					  bool loop_allowed,
					  bool nnas,
					  signed long ramp_length,
					  signed long priority_scheme,
					  unsigned long feedback_delay,
					  double feedback_volume, 
					  bool use_reset);
	void set_latency(signed long latency);
	char* get_module_title(signed long mixer);
	void set_mixing_volume(signed long mixer, double mixing_volume_left, double mixing_volume_right, double panning);
	void rewind();
	void rewind(signed long mixer);
	void stop(signed long mixer);
	void play(signed long mixer);
	void set_feedback_volume(double feedback_volume);
	void set_feedback_delay(unsigned long feedback_delay);
	void set_loop_allowed(bool loop_allowed);
	void set_nnas(bool nnas);
	void set_ramp_length(signed long ramp_length);
	void set_sampling_rate(signed long sampling_rate);
	void set_priority_scheme(signed long priority_scheme);
	void unload(signed long mixer);
	void stop();
	void play();
	signed long load(char *module);
	c_driver();
	virtual ~c_driver();
private:
	static signed long m_latency;
	bool m_use_reset;
	static volatile bool m_closed;
	static volatile signed long m_buffer_to_fill;
	static volatile signed long m_current_buffer;
	static signed long m_ramp_length;
	static bool m_nnas;
	static bool m_loop_allowed;

	void clear_feedback_buffer();
	void delete_output_buffers();
	void delete_input_buffer();
	void terminate_mixing_thread();
	static void input_to_output();
	static void prepare_input_buffer();
	void clear_input_buffer();
	void reset();

	static signed long m_sampling_rate;

	void close_device();
	void open_device();

	static bool m_mixing_thread_is_running;

	void stop_mixing_thread();
	static void set_calculation_priority();
	static void set_normal_priority();
	static void set_idle_priority();
	void start_mixing_thread();
	void init_mixing_thread();
	void allocate_output_buffers();
	void allocate_input_buffer();

	// members
	static bool m_is_first_instance ;
	static bool m_is_configured ;

	// buffers
	static double *m_input_buffer ;
	static WAVEHDR *m_output_buffers; 
	static signed long m_buffer_length ; // in pair of samples
	static signed long m_number_of_buffers ;

	static unsigned long m_feedback_delay ;
	static double m_feedback_volume ;
	static unsigned long m_max_feedback_delay ;

	// mixing thread
	static DWORD m_mixing_thread_id ;
	static HANDLE m_mixing_thread_handle ;
	static SECURITY_ATTRIBUTES m_mixing_thread_security_struct ;

	// device
	static HWAVEOUT m_output_device_handler ;

	// static control functions
	static void CALLBACK WaveProc (HWAVE hWave,
		UINT uMsg,
		DWORD dwInstance,
		DWORD dwParam1,
		DWORD dwParam2
		) ;
	
	static DWORD WINAPI mixing_thread_routine (LPVOID) ;

	static c_driver *m_the_driver ; // contain the 'this' pointer for static routines

	// mutual threads exclusion

	static CRITICAL_SECTION m_mixing_critical_section ;
	static CRITICAL_SECTION m_config_critical_section ;

	// data structures

	static signed long m_formats[NB_MIXERS] ;
	static void *m_mixers[NB_MIXERS] ;
/*	static double m_mixing_volume_left[NB_MIXERS];
	static double m_mixing_volume_right[NB_MIXERS]; */
	static signed long *(m_orders[NB_MIXERS]) ;
	static signed long *(m_lines[NB_MIXERS]) ;
	static bool *(m_playings[NB_MIXERS]) ;
	static bool m_playing[NB_MIXERS] ;
	static bool m_linear_interpolation ;

#ifdef _DEBUG
	// debug
	static FILE *f ;
#endif
};

//extern c_driver CLASS_DECLSPEC driver ;

#endif // !defined(AFX_C_DRIVER_H__F7DA69C1_206F_11D1_B35E_DCE971BF2962__INCLUDED_)
