// Play_ITwDlg.cpp : implementation file
//
/*
PLAY_ITW.EXE v0.03a : Player for Impulse Tracker modules files
Copyright (C) 1998  Olivier AUMAGE
E-mail : Olivier.Aumage@ens-lyon.fr
Web : http://www.ens-lyon.fr/~oaumage/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  any later version.
  
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	  You should have received a copy of the GNU General Public License
	  along with this program; if not, write to the Free Software
	  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

////////////////////////////////////////////////////////////////////////////////////////////////
//
//  Standard C++ lib

// The debugger can't handle symbols more than 255 characters long.
// STL often creates symbols longer than that.
// When symbols are longer than 255 characters, the warning is disabled.
#pragma warning(disable:4786)
#include <string>
#include <vector>
#include <cstring>

using namespace std ;

#include "stdafx.h"
#include "Play_ITw.h"
#include "Play_ITwDlg.h"
#include "DlgProxy.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Misc. routines


typedef vector<string> t_string_vector ;

t_string_vector split_cmdline(char *cmdline)
{
	char *_cmdline = cmdline;
	t_string_vector arg_vector ;
	bool in_string = false ;
	bool in_space = false ;

	while (true)
	{
		if (in_space && !((*_cmdline == ' ') || (*_cmdline == '\t')))
		{
			in_space = false ;

			cmdline = _cmdline + 1 ;
		}

		if (*_cmdline == '\0')
		{
			if (*cmdline == ' ')
			{
				cmdline ++ ;
			}

			if ((!in_space) && (_cmdline > cmdline))
			{
				arg_vector.push_back((string)cmdline) ;
			}
			
			break ;
		}

		if ((!in_string) && (!in_space))
		{
			if ((*_cmdline == ' ') || (*_cmdline == '\t'))
			{
				in_space = true ;

				if (*cmdline == ' ')
				{
					cmdline ++ ;
				}

				if (_cmdline > cmdline)
				{
					*_cmdline = '\0' ;
					arg_vector.push_back((string)cmdline) ;
				}
			}
			else if (*_cmdline == '\"')
			{
				*_cmdline = ' ' ;
				in_string = true ;
			}
		}
		else
		{
			if (*_cmdline == '\"')
			{
				*_cmdline = ' ' ;
				in_string = false ;
			}
		}

		_cmdline++ ;
	}

	return arg_vector ;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CEdit	m_copyright;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_ABOUT_COPYRIGHT, m_copyright);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	ON_WM_CREATE()
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPlay_ITwDlg dialog

IMPLEMENT_DYNAMIC(CPlay_ITwDlg, CDialog);

CPlay_ITwDlg::CPlay_ITwDlg(char *cmd_line, CWnd* pParent /*=NULL*/)
	: CDialog(CPlay_ITwDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPlay_ITwDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_hSmallIcon = (HICON)::LoadImage(AfxGetInstanceHandle(), 
		MAKEINTRESOURCE(IDR_MAINFRAME), 
		IMAGE_ICON,
		16,
		16,
		LR_DEFAULTCOLOR) ;
	m_pAutoProxy = NULL;

	for (int i = 0 ; i < 4 ; i++)
	{
		m_module_handles[i] = -1 ;
	}

	char *module = NULL ;

	{

		m_play_at_startup = false ;
		bool linear = true ; /* linear interpolation by default */

		if (cmd_line != (char *)NULL)
		{
			t_string_vector arg_vector = split_cmdline(cmd_line) ;
			
			for (t_string_vector::iterator arg_vector_iterator = arg_vector.begin() ; 
			arg_vector_iterator != arg_vector.end() ; arg_vector_iterator ++)
			{
				string s = *arg_vector_iterator ;
				const char *arg = s.data() ;
				
				if (strncmp(arg, "-linear", 7) == 0)
				{
					linear = true ;
				}
				else if (strncmp(arg, "-cubic", 6) == 0)
				{
					linear = false ;
				}
				else 
				{
					m_play_at_startup = true ;
					module = new char[s.length() + 1] ;
					strcpy(module, arg) ;
				}
			}
		}

		pi_config(linear, 44100, 8, true, true, 64, 1, 0, 0.0, false);

		if (m_play_at_startup)
		{
			m_module_handles[0] = pi_load((char*)(LPCSTR)module) ;
			
			if (m_module_handles[0] == -1)
			{
				m_play_at_startup = false ;
			}
		}
	}

	if (m_play_at_startup && module)
	{
		char buffer [MAX_PATH + 1] ;
		char dir[_MAX_DIR];

		_splitpath(module, buffer, dir, NULL, NULL) ;
		strcat(buffer, dir) ;

		AfxGetApp()->WriteProfileString("Config", "defpath", buffer) ;

		CString def_path = AfxGetApp()->GetProfileString("Config", "defpath", buffer) ;
		::SetCurrentDirectory((char *)(LPCSTR)def_path) ;
	}
	else
	{
		char buffer [MAX_PATH + 1] ;
		::GetCurrentDirectory(MAX_PATH + 1, buffer) ;
		CString def_path = AfxGetApp()->GetProfileString("Config", "defpath", buffer) ;
		::SetCurrentDirectory((char *)(LPCSTR)def_path) ;
	}


}

CPlay_ITwDlg::~CPlay_ITwDlg()
{
	// If there is an automation proxy for this dialog, set
	//  its back pointer to this dialog to NULL, so it knows
	//  the dialog has been deleted.
	if (m_pAutoProxy != NULL)
		m_pAutoProxy->m_pDialog = NULL;
}

void CPlay_ITwDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPlay_ITwDlg)
	DDX_Control(pDX, IDC_SLIDER_LATENCY, m_latency);
	DDX_Control(pDX, IDC_SLIDER_BAL_4, m_slider_balance_4);
	DDX_Control(pDX, IDC_SLIDER_BAL_3, m_slider_balance_3);
	DDX_Control(pDX, IDC_SLIDER_BAL_2, m_slider_balance_2);
	DDX_Control(pDX, IDC_SLIDER_BAL_1, m_slider_balance_1);
	DDX_Control(pDX, IDC_SLIDER_PAN_4, m_slider_panning_4);
	DDX_Control(pDX, IDC_SLIDER_PAN_3, m_slider_panning_3);
	DDX_Control(pDX, IDC_SLIDER_PAN_2, m_slider_panning_2);
	DDX_Control(pDX, IDC_SLIDER_PAN_1, m_slider_panning_1);
	DDX_Control(pDX, IDC_SLIDER_MAIN_VOL, m_slider_main_volume);
	DDX_Control(pDX, IDC_SLIDER_FB_VOLUME, m_slider_fb_volume);
	DDX_Control(pDX, IDC_SLIDER_FB_DELAY, m_slider_fb_delay);
	DDX_Control(pDX, IDC_EDIT4, m_edit_4);
	DDX_Control(pDX, IDC_EDIT3, m_edit_3);
	DDX_Control(pDX, IDC_EDIT2, m_edit_2);
	DDX_Control(pDX, IDC_EDIT1, m_edit_1);
	DDX_Control(pDX, IDC_SLIDER4, m_slider_4);
	DDX_Control(pDX, IDC_SLIDER3, m_slider_3);
	DDX_Control(pDX, IDC_SLIDER2, m_slider_2);
	DDX_Control(pDX, IDC_SLIDER1, m_slider_1);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPlay_ITwDlg, CDialog)
	//{{AFX_MSG_MAP(CPlay_ITwDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_MAIN_ABOUT, OnButtonAbout)
	ON_BN_CLICKED(IDC_MAIN_PLAY, OnButtonPlay)
	ON_BN_CLICKED(IDC_MAIN_STOP, OnButtonStop)
	ON_BN_CLICKED(IDC_MAIN_LOAD1, OnMainLoad1)
	ON_BN_CLICKED(IDC_MAIN_LOAD2, OnMainLoad2)
	ON_BN_CLICKED(IDC_MAIN_LOAD3, OnMainLoad3)
	ON_BN_CLICKED(IDC_MAIN_LOAD4, OnMainLoad4)
	ON_BN_CLICKED(IDC_MAIN_PLAY1, OnMainPlay1)
	ON_BN_CLICKED(IDC_MAIN_PLAY2, OnMainPlay2)
	ON_BN_CLICKED(IDC_MAIN_PLAY3, OnMainPlay3)
	ON_BN_CLICKED(IDC_MAIN_PLAY4, OnMainPlay4)
	ON_BN_CLICKED(IDC_MAIN_REWIND1, OnMainRewind1)
	ON_BN_CLICKED(IDC_MAIN_REWIND2, OnMainRewind2)
	ON_BN_CLICKED(IDC_MAIN_REWIND3, OnMainRewind3)
	ON_BN_CLICKED(IDC_MAIN_REWIND4, OnMainRewind4)
	ON_BN_CLICKED(IDC_MAIN_STOP1, OnMainStop1)
	ON_BN_CLICKED(IDC_MAIN_STOP2, OnMainStop2)
	ON_BN_CLICKED(IDC_MAIN_STOP3, OnMainStop3)
	ON_BN_CLICKED(IDC_MAIN_STOP4, OnMainStop4)
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_BN_CLICKED(IDC_MAIN_REWIND, OnMainRewind)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPlay_ITwDlg message handlers

BOOL CPlay_ITwDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hSmallIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	if (m_module_handles[0] != -1)
	{
		char buffer[256] ;
		pi_get_module_title(m_module_handles[0], buffer, 256) ;
		m_edit_1.SetWindowText(buffer) ;
	}

	m_latency.SetRange(4, 60, true) ;
	m_slider_1.SetRange(0, 100, true) ;
	m_slider_2.SetRange(0, 100, true) ;
	m_slider_3.SetRange(0, 100, true) ;
	m_slider_4.SetRange(0, 100, true) ;
	m_slider_balance_1.SetRange(-100, 100, true) ;
	m_slider_balance_2.SetRange(-100, 100, true) ;
	m_slider_balance_3.SetRange(-100, 100, true) ;
	m_slider_balance_4.SetRange(-100, 100, true) ;
	m_slider_panning_1.SetRange(-100, 100, true) ;
	m_slider_panning_2.SetRange(-100, 100, true) ;
	m_slider_panning_3.SetRange(-100, 100, true) ;
	m_slider_panning_4.SetRange(-100, 100, true) ;
	m_slider_fb_delay.SetRange(0, 4096, true) ;
	m_slider_fb_volume.SetRange(0, 100, true) ;
	m_slider_main_volume.SetRange(0, 400, true) ;

	m_latency.SetPos(16) ;
	m_slider_1.SetPos(0) ;
	m_slider_2.SetPos(0) ;
	m_slider_3.SetPos(0) ;
	m_slider_4.SetPos(0) ;
	m_slider_fb_delay.SetPos(4096) ;
	m_slider_fb_volume.SetPos(100);
	m_slider_balance_1.SetPos(0) ;
	m_slider_balance_2.SetPos(0) ;
	m_slider_balance_3.SetPos(0) ;
	m_slider_balance_4.SetPos(0) ;
	m_slider_panning_1.SetPos(0) ;
	m_slider_panning_2.SetPos(0) ;
	m_slider_panning_3.SetPos(0) ;
	m_slider_panning_4.SetPos(0) ;
	m_slider_main_volume.SetPos(300) ;

	m_latency.SetTicFreq(8) ;
	m_slider_1.SetTicFreq(10) ;
	m_slider_2.SetTicFreq(10) ;
	m_slider_3.SetTicFreq(10) ;
	m_slider_4.SetTicFreq(10) ;
	m_slider_fb_delay.SetTicFreq(512) ;
	m_slider_fb_volume.SetTicFreq(10) ;
	m_slider_balance_1.SetTicFreq(25) ;
	m_slider_balance_2.SetTicFreq(25) ;
	m_slider_balance_3.SetTicFreq(25) ;
	m_slider_balance_4.SetTicFreq(25) ;
	m_slider_panning_1.SetTicFreq(25) ;
	m_slider_panning_2.SetTicFreq(25) ;
	m_slider_panning_3.SetTicFreq(25) ;
	m_slider_panning_4.SetTicFreq(25) ;
	m_slider_main_volume.SetTicFreq(10) ;

	// CG: The following block was added by the ToolTips component.
	{
		// Create the ToolTip control.
		m_tooltip.Create(this);
		m_tooltip.Activate(TRUE);

		// TODO: Use one of the following forms to add controls:
		// m_tooltip.AddTool(GetDlgItem(IDC_<name>), <string-table-id>);
		// m_tooltip.AddTool(GetDlgItem(IDC_<name>), "<text>");
		m_tooltip.AddTool(GetDlgItem(IDC_MAIN_REWIND), IDS_MAIN_REWIND);
		m_tooltip.AddTool(GetDlgItem(IDC_MAIN_PLAY), IDS_MAIN_PLAY);
		m_tooltip.AddTool(GetDlgItem(IDC_MAIN_STOP), IDS_MAIN_STOP);
		m_tooltip.AddTool(GetDlgItem(IDC_MAIN_ABOUT), IDS_MAIN_ABOUT);
		m_tooltip.AddTool(GetDlgItem(ID_HELP), IDS_MAIN_HELP);
		m_tooltip.AddTool(GetDlgItem(IDC_MAIN_PLAY1), IDS_PLAY);
		m_tooltip.AddTool(GetDlgItem(IDC_MAIN_PLAY2), IDS_PLAY);
		m_tooltip.AddTool(GetDlgItem(IDC_MAIN_PLAY3), IDS_PLAY);
		m_tooltip.AddTool(GetDlgItem(IDC_MAIN_PLAY4), IDS_PLAY);
		m_tooltip.AddTool(GetDlgItem(IDC_MAIN_STOP1), IDS_STOP);
		m_tooltip.AddTool(GetDlgItem(IDC_MAIN_STOP2), IDS_STOP);
		m_tooltip.AddTool(GetDlgItem(IDC_MAIN_STOP3), IDS_STOP);
		m_tooltip.AddTool(GetDlgItem(IDC_MAIN_STOP4), IDS_STOP);
		m_tooltip.AddTool(GetDlgItem(IDC_MAIN_REWIND1), IDS_REWIND);
		m_tooltip.AddTool(GetDlgItem(IDC_MAIN_REWIND2), IDS_REWIND);
		m_tooltip.AddTool(GetDlgItem(IDC_MAIN_REWIND3), IDS_REWIND);
		m_tooltip.AddTool(GetDlgItem(IDC_MAIN_REWIND4), IDS_REWIND);
		m_tooltip.AddTool(GetDlgItem(IDC_MAIN_LOAD1), IDS_MAIN_LOAD);
		m_tooltip.AddTool(GetDlgItem(IDC_MAIN_LOAD2), IDS_MAIN_LOAD);
		m_tooltip.AddTool(GetDlgItem(IDC_MAIN_LOAD3), IDS_MAIN_LOAD);
		m_tooltip.AddTool(GetDlgItem(IDC_MAIN_LOAD4), IDS_MAIN_LOAD);
		m_tooltip.AddTool(GetDlgItem(IDC_SLIDER_FB_VOLUME), IDS_FB_VOLUME);
		m_tooltip.AddTool(GetDlgItem(IDC_SLIDER_FB_DELAY), IDS_FB_DELAY);
		m_tooltip.AddTool(GetDlgItem(IDC_SLIDER_MAIN_VOL), IDS_MAIN_VOLUME);
		m_tooltip.AddTool(GetDlgItem(IDC_SLIDER1), IDS_VOLUME);
		m_tooltip.AddTool(GetDlgItem(IDC_SLIDER2), IDS_VOLUME);
		m_tooltip.AddTool(GetDlgItem(IDC_SLIDER3), IDS_VOLUME);
		m_tooltip.AddTool(GetDlgItem(IDC_SLIDER4), IDS_VOLUME);
		m_tooltip.AddTool(GetDlgItem(IDC_SLIDER_PAN_1), IDS_PANNING);
		m_tooltip.AddTool(GetDlgItem(IDC_SLIDER_PAN_2), IDS_PANNING);
		m_tooltip.AddTool(GetDlgItem(IDC_SLIDER_PAN_3), IDS_PANNING);
		m_tooltip.AddTool(GetDlgItem(IDC_SLIDER_PAN_4), IDS_PANNING);
		m_tooltip.AddTool(GetDlgItem(IDC_SLIDER_BAL_1), IDS_BALANCE);
		m_tooltip.AddTool(GetDlgItem(IDC_SLIDER_BAL_2), IDS_BALANCE);
		m_tooltip.AddTool(GetDlgItem(IDC_SLIDER_BAL_3), IDS_BALANCE);
		m_tooltip.AddTool(GetDlgItem(IDC_SLIDER_BAL_4), IDS_BALANCE);
		m_tooltip.AddTool(GetDlgItem(IDC_SLIDER_LATENCY), IDS_LATENCY);
/*		m_tooltip.AddTool(GetDlgItem(IDC_EDIT1), LPSTR_TEXTCALLBACK, NULL, IDC_EDIT1);
		m_tooltip.AddTool(GetDlgItem(IDC_EDIT2), LPSTR_TEXTCALLBACK, NULL, IDC_EDIT2);
		m_tooltip.AddTool(GetDlgItem(IDC_EDIT3), LPSTR_TEXTCALLBACK, NULL, IDC_EDIT3);
		m_tooltip.AddTool(GetDlgItem(IDC_EDIT4), LPSTR_TEXTCALLBACK, NULL, IDC_EDIT4);*/

		if (m_play_at_startup)
		{
			pi_play(0) ;
			m_play_at_startup = false ;
		}
	
	}
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPlay_ITwDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CPlay_ITwDlg::OnDestroy()
{
	WinHelp(0L, HELP_QUIT);
	CDialog::OnDestroy();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPlay_ITwDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CRect rect;
		GetClientRect(&rect);
		CPaintDC dc(this); // device context for painting
		
		CBitmap bitmap ;
		bitmap.LoadBitmap(IDB_ABOUT_BACKGROUND) ;
		
		BITMAP bm ;
		bitmap.GetObject(sizeof(BITMAP), &bm) ;
		CPoint size(bm.bmWidth, bm.bmHeight) ;
		dc.DPtoLP(&size) ;
		
		CPoint org(0, 0) ;
		dc.DPtoLP(&org) ;
		
		CDC dcMem ;
		dcMem.CreateCompatibleDC(&dc) ;
		CBitmap* pOldBitmap = dcMem.SelectObject(&bitmap) ;
		dcMem.SetMapMode(dc.GetMapMode()) ;
		
		for (int dy = 0 ; dy < rect.Height() ; dy += size.y)
		{
			for (int dx = 0 ; dx < rect.Width() ; dx += size.x)
			{
				dc.BitBlt(dx, dy, size.x, size.y, &dcMem, org.x, org.y, SRCCOPY) ;
			}
		}

		dcMem.SelectObject(pOldBitmap) ;
		
		/*int old_map_mode = dc.SetMapMode(MM_TEXT) ;
		
		RECT rc;
		GetClientRect(&rc);
		
		CBitmap bitmap ;
		bitmap.CreateCompatibleBitmap(&dc, (rc.right - rc.left) + 1, (rc.bottom - rc.top) + 1);
		
		CDC dcMem ;
		dcMem.CreateCompatibleDC(&dc) ;
		
		CBitmap* pOldBitmap = dcMem.SelectObject(&bitmap) ;
		dcMem.SetMapMode(MM_TEXT) ;
		
		CBrush brush(RGB(0, 0, 0));
		dcMem.FillRect(&rc, &brush) ;
		
		int width ;
		if ((rc.bottom - rc.top) > (rc.right - rc.left))
		{
			width = (rc.right - rc.left) / 2 ;
		}
		else
		{
			width = (rc.bottom - rc.top) / 2	;
		}
		
		for (int y = rc.top ; y <= rc.top + width ; y++)
		{
			CPen cp(PS_SOLID, 0, RGB(((y << 2) & 0xFF), 0, (y << 3) & 0xFF));
			CPen *previous ;
			
			previous = dcMem.SelectObject(&cp) ;
			
			dcMem.MoveTo(rc.left+y, y);
			dcMem.LineTo(rc.right-y, y);
			dcMem.MoveTo(rc.left+y, rc.bottom - (1 + y - rc.top));
			dcMem.LineTo(rc.right-y, rc.bottom - (1 + y - rc.top));					  
			
			dcMem.SelectObject(previous) ;
		}
		
		for (int x = rc.left ; x <= rc.left + width ; x++)
		{
			CPen cp(PS_SOLID, 0, RGB(0, ((x << 2) & 0xFF), (x << 3) & 0xFF));
			CPen *previous ;
			
			previous = dcMem.SelectObject(&cp) ;
			
			dcMem.MoveTo(x, rc.top + x);
			dcMem.LineTo(x, rc.bottom - x);
			dcMem.MoveTo(rc.right - (1 + x - rc.left), rc.top + x);
			dcMem.LineTo(rc.right - (1 + x - rc.left), rc.bottom - x);
			
			dcMem.SelectObject(previous) ;
		}
		
		dc.BitBlt(0, 0, (rc.right - rc.left) + 1, (rc.bottom - rc.top) + 1, &dcMem, 0, 0, SRCCOPY) ;
		dcMem.SelectObject(pOldBitmap) ;
		
		dc.SetMapMode(old_map_mode) ;
		CDialog::OnPaint() ;*/
	}
}


// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPlay_ITwDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

// Automation servers should not exit when a user closes the UI
//  if a controller still holds on to one of its objects.  These
//  message handlers make sure that if the proxy is still in use,
//  then the UI is hidden but the dialog remains around if it
//  is dismissed.

void CPlay_ITwDlg::OnClose() 
{
	if (CanExit())
		CDialog::OnClose();

	DestroyWindow();
}

void CPlay_ITwDlg::OnOK() 
{
}

void CPlay_ITwDlg::OnCancel() 
{
}

BOOL CPlay_ITwDlg::CanExit()
{
	// If the proxy object is still around, then the automation
	//  controller is still holding on to this application.  Leave
	//  the dialog around, but hide its UI.
	if (m_pAutoProxy != NULL)
	{
		ShowWindow(SW_HIDE);
		return FALSE;
	}

	return TRUE;
}

int CAboutDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	return 0;
}

void CPlay_ITwDlg::OnButtonAbout() 
{
	CAboutDlg AboutDlg ;
	AboutDlg.DoModal() ;
	
}

BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_copyright.SetWindowText(
"Player for Impulse Tracker modules files\r\n\
Copyright (C) 1998  Olivier AUMAGE\r\n\
E-mail : Olivier.Aumage@ens-lyon.fr\r\n\
Web : http://www.ens-lyon.fr/~oaumage/\r\n\
\r\n\
This program is free software; you can redistribute it and/or modify \
it under the terms of the GNU General Public License as published by \
the Free Software Foundation; either version 2 of the License, or \
any later version.\r\n\
This program is distributed in the hope that it will be useful, \
but WITHOUT ANY WARRANTY; without even the implied warranty of \
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the \
GNU General Public License for more details.\r\n\
You should have received a copy of the GNU General Public License \
along with this program; if not, write to the Free Software \
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.");
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPlay_ITwDlg::PostNcDestroy() 
{
	// TODO: Add your specialized code here and/or call the base class
	
//	CDialog::PostNcDestroy();
	delete this ;
}

BOOL CPlay_ITwDlg::Create() 
{
	return CDialog::Create(IDD);
}

signed long CPlay_ITwDlg::load(signed long previous) 
{
	char mask[] = "Music files (*.it;*.wav)|*.it;*.wav|Impulse Tracker modules (*.it)|*.it|Wav files (*.wav)|*.wav|All Files (*.*)|*.*||";
	CFileDialog file_dialog (TRUE, 
		NULL,
		NULL, 
		OFN_HIDEREADONLY 
		| OFN_EXPLORER
		| OFN_FILEMUSTEXIST
		| OFN_LONGNAMES, mask);

	if(file_dialog.DoModal() == IDOK)
	{
		if (previous != -1)
		{
			pi_unload(previous) ;
		}

		signed long value = pi_load((char*)(LPCSTR)file_dialog.GetPathName()) ;

		char buffer [MAX_PATH + 1] ;
		::GetCurrentDirectory(MAX_PATH + 1, buffer) ;
		AfxGetApp()->WriteProfileString("Config", "defpath", buffer) ;
		
		return value ;
	}

	return previous ;
}

void CPlay_ITwDlg::OnButtonPlay() 
{
	pi_play_all() ;
}

void CPlay_ITwDlg::OnButtonStop() 
{
	pi_stop_all();
}

BOOL CPlay_ITwDlg::PreTranslateMessage(MSG* pMsg)
{
	// CG: The following block was added by the ToolTips component.
	{
		// Let the ToolTip process this message.
		m_tooltip.RelayEvent(pMsg);
	}
	return CDialog::PreTranslateMessage(pMsg);	// CG: This was added by the ToolTips component.
}

void CAboutDlg::OnPaint() 
{
		CRect rect;
		GetClientRect(&rect);
		CPaintDC dc(this); // device context for painting
		
		CBitmap bitmap ;
		bitmap.LoadBitmap(IDB_ABOUT_BACKGROUND) ;
		
		BITMAP bm ;
		bitmap.GetObject(sizeof(BITMAP), &bm) ;
		CPoint size(bm.bmWidth, bm.bmHeight) ;
		dc.DPtoLP(&size) ;
		
		CPoint org(0, 0) ;
		dc.DPtoLP(&org) ;
		
		CDC dcMem ;
		dcMem.CreateCompatibleDC(&dc) ;
		CBitmap* pOldBitmap = dcMem.SelectObject(&bitmap) ;
		dcMem.SetMapMode(dc.GetMapMode()) ;
		
		for (int dy = 0 ; dy < rect.Height() ; dy += size.y)
		{
			for (int dx = 0 ; dx < rect.Width() ; dx += size.x)
			{
				dc.BitBlt(dx, dy, size.x, size.y, &dcMem, org.x, org.y, SRCCOPY) ;
			}
		}

		dcMem.SelectObject(pOldBitmap) ;
	// Do not call CDialog::OnPaint() for painting messages
}

void CPlay_ITwDlg::OnMainLoad1() 
{
	m_module_handles[0] = load (m_module_handles[0]) ;	
	if (m_module_handles[0] != -1)
	{
		update_volume(1) ;
		pi_rewind(m_module_handles[0]) ;

		char buffer[256] ;
		pi_get_module_title(m_module_handles[0], buffer, 256) ;
		m_edit_1.SetWindowText(buffer) ;
	}
	else
	{
		m_edit_1.SetWindowText("") ;
	}
}

void CPlay_ITwDlg::OnMainLoad2() 
{
	m_module_handles[1] = load (m_module_handles[1]) ;	
	if (m_module_handles[1] != -1)
	{
		update_volume(2) ;
		pi_rewind(m_module_handles[1]) ;
		char buffer[256] ;
		pi_get_module_title(m_module_handles[1], buffer, 256) ;
		m_edit_2.SetWindowText(buffer) ;
	}
	else
	{
		m_edit_2.SetWindowText("") ;
	}
}

void CPlay_ITwDlg::OnMainLoad3() 
{
	m_module_handles[2] = load (m_module_handles[2]) ;	
	if (m_module_handles[2] != -1)
	{
		update_volume(3) ;
		pi_rewind(m_module_handles[2]) ;
		char buffer[256] ;
		pi_get_module_title(m_module_handles[2], buffer, 256) ;
		m_edit_3.SetWindowText(buffer) ;
	}
	else
	{
		m_edit_3.SetWindowText("") ;
	}
}

void CPlay_ITwDlg::OnMainLoad4() 
{
	m_module_handles[3] = load (m_module_handles[3]) ;	
	if (m_module_handles[3] != -1)
	{
		update_volume(4) ;
		pi_rewind(m_module_handles[3]) ;
		char buffer[256] ;
		pi_get_module_title(m_module_handles[3], buffer, 256) ;
		m_edit_4.SetWindowText(buffer) ;
	}
	else
	{
		m_edit_4.SetWindowText("") ;
	}
}

void CPlay_ITwDlg::OnMainPlay1() 
{
	if (m_module_handles[0] != -1)
	{
		pi_play(m_module_handles[0]) ;
	}	
}

void CPlay_ITwDlg::OnMainPlay2() 
{
	if (m_module_handles[1] != -1)
	{
		pi_play(m_module_handles[1]) ;
	}		
}

void CPlay_ITwDlg::OnMainPlay3() 
{
	if (m_module_handles[2] != -1)
	{
		pi_play(m_module_handles[2]) ;
	}	
}

void CPlay_ITwDlg::OnMainPlay4() 
{
	if (m_module_handles[3] != -1)
	{
		pi_play(m_module_handles[3]) ;
	}	
}

void CPlay_ITwDlg::OnMainRewind1() 
{
	if (m_module_handles[0] != -1)
	{
		pi_rewind(m_module_handles[0]) ;
	}		
}

void CPlay_ITwDlg::OnMainRewind2() 
{
	if (m_module_handles[1] != -1)
	{
		pi_rewind(m_module_handles[1]) ;
	}			
}

void CPlay_ITwDlg::OnMainRewind3() 
{
	if (m_module_handles[2] != -1)
	{
		pi_rewind(m_module_handles[2]) ;
	}			
}

void CPlay_ITwDlg::OnMainRewind4() 
{
	if (m_module_handles[3] != -1)
	{
		pi_rewind(m_module_handles[3]) ;
	}			
}

void CPlay_ITwDlg::OnMainStop1() 
{
	if (m_module_handles[0] != -1)
	{
		pi_stop(m_module_handles[0]) ;
	}			
}

void CPlay_ITwDlg::OnMainStop2() 
{
	if (m_module_handles[1] != -1)
	{
		pi_stop(m_module_handles[1]) ;
	}			
}

void CPlay_ITwDlg::OnMainStop3() 
{
	if (m_module_handles[2] != -1)
	{
		pi_stop(m_module_handles[2]) ;
	}			
}

void CPlay_ITwDlg::OnMainStop4() 
{
	if (m_module_handles[3] != -1)
	{
		pi_stop(m_module_handles[3]) ;
	}			
}

void CPlay_ITwDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CSliderCtrl *pointer = (CSliderCtrl *)pScrollBar ;

	if (pointer == &m_latency)
	{
		pi_set_latency(m_latency.GetPos()) ;
	}
	else if (pointer == &m_slider_panning_1)
	{
		update_volume(1);
	}
	else if (pointer == &m_slider_panning_2)
	{
		update_volume(2) ;
	}
	else if (pointer == &m_slider_panning_3)
	{
		update_volume(3) ;
	}
	else if (pointer == &m_slider_panning_4)
	{
		update_volume(4) ;
	}
	else if (pointer == &m_slider_balance_1)
	{
		update_volume(1) ;
	}
	else if (pointer == &m_slider_balance_2)
	{
		update_volume(2) ;
	}
	else if (pointer == &m_slider_balance_3)
	{
		update_volume(3) ;
	}
	else if (pointer == &m_slider_balance_4)
	{
		update_volume(4) ;
	}
	
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CPlay_ITwDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CSliderCtrl *pointer = (CSliderCtrl *)pScrollBar ;
	if (pointer == &m_slider_1)
	{
		update_volume(1) ;
	}
	else if (pointer == &m_slider_2)
	{
		update_volume(2) ;
	}
	else if (pointer == &m_slider_3)
	{
		update_volume(3) ;
	}
	else if (pointer == &m_slider_4)
	{
		update_volume(4) ;
	}
	else if (pointer == &m_slider_main_volume)
	{
		update_volume(1) ;
		update_volume(2) ;
		update_volume(3) ;
		update_volume(4) ;
	}
	else if (pointer == &m_slider_fb_delay)
	{
		unsigned long delay = (unsigned long)(4096 - pointer->GetPos()) ;
		pi_set_feedback_delay (delay) ;
	}
	else if (pointer == &m_slider_fb_volume)
	{
		double volume = (100 - pointer->GetPos()) / 100.0 ;
		pi_set_feedback_volume (volume) ;
	}
	
	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CPlay_ITwDlg::OnMainRewind() 
{
	pi_rewind_all() ;
}

void CPlay_ITwDlg::update_volume(signed long num)
{
	double main_volume = (400 - m_slider_main_volume.GetPos()) / 100.0 ;

	if (num == 1)
	{
		if (m_module_handles[0] != -1)
		{
			double volume = main_volume * (100 - m_slider_1.GetPos()) / 100.0 ;
			double panning = m_slider_panning_1.GetPos() / 100.0 ;
			double balance = m_slider_balance_1.GetPos() / 100.0 ;

			double volume_left = volume * ((balance <= 0)?1:1-balance) ;
			double volume_right = volume * ((balance >= 0)?1:1+balance) ;

			pi_set_mixing_volume (m_module_handles[0], volume_left, volume_right, panning) ;
		}
	}
	else if (num == 2)
	{
		if (m_module_handles[1] != -1)
		{
			double volume = main_volume * (100 - m_slider_2.GetPos()) / 100.0 ;
			double panning = m_slider_panning_2.GetPos() / 100.0 ;
			double balance = m_slider_balance_2.GetPos() / 100.0 ;

			double volume_left = volume * ((balance <= 0)?1:1-balance) ;
			double volume_right = volume * ((balance >= 0)?1:1+balance) ;

			pi_set_mixing_volume (m_module_handles[1], volume_left, volume_right, panning) ;
		}
	}
	else if (num == 3)
	{
		if (m_module_handles[2] != -1)
		{
			double volume = main_volume * (100 - m_slider_3.GetPos()) / 100.0 ;
			double panning = m_slider_panning_3.GetPos() / 100.0 ;
			double balance = m_slider_balance_3.GetPos() / 100.0 ;

			double volume_left = volume * ((balance <= 0)?1:1-balance) ;
			double volume_right = volume * ((balance >= 0)?1:1+balance) ;

			pi_set_mixing_volume (m_module_handles[2], volume_left, volume_right, panning) ;
		}
	}
	else if (num == 4)
	{
		if (m_module_handles[3] != -1)
		{
			double volume = main_volume * (100 - m_slider_4.GetPos()) / 100.0 ;
			double panning = m_slider_panning_4.GetPos() / 100.0 ;
			double balance = m_slider_balance_4.GetPos() / 100.0 ;

			double volume_left = volume * ((balance <= 0)?1:1-balance) ;
			double volume_right = volume * ((balance >= 0)?1:1+balance) ;

			pi_set_mixing_volume (m_module_handles[3], volume_left, volume_right, panning) ;
		}
	}
}

BOOL CPlay_ITwDlg::OnToolTipNotify( UINT id, NMHDR * pNMHDR, LRESULT * pResult)
{
	// Doesn't work yet :-(

    TOOLTIPTEXT *pTTT = (TOOLTIPTEXT *)pNMHDR;
    UINT nID =pNMHDR->idFrom;
    if (pTTT->uFlags & TTF_IDISHWND)
    {
        // idFrom is actually the HWND of the tool
        nID = ::GetDlgCtrlID((HWND)nID);
        if(nID == IDC_EDIT1)
        {
			if (m_module_handles[0] != -1)
			{
				char buffer[256] ;
				pi_get_module_title(m_module_handles[0], buffer, 256) ;
				pTTT->lpszText = buffer ;
				return(TRUE);
			}
        }
		else if(nID == IDC_EDIT2)
        {
			if (m_module_handles[1] != -1)
			{
				char buffer[256] ;
				pi_get_module_title(m_module_handles[1], buffer, 256) ;
				pTTT->lpszText = buffer ;
				return(TRUE);
			}
        }
		else if(nID == IDC_EDIT3)
        {
			if (m_module_handles[2] != -1)
			{
				char buffer[256] ;
				pi_get_module_title(m_module_handles[2], buffer, 256) ;
				pTTT->lpszText = buffer ;
				return(TRUE);
			}
        }
		else if(nID == IDC_EDIT4)
        {
			if (m_module_handles[3] != -1)
			{
				char buffer[256] ;
				pi_get_module_title(m_module_handles[3], buffer, 256) ;
				pTTT->lpszText = buffer ;
				return(TRUE);
			}
        }

    }
    return(FALSE);
}

/*BOOL CPlay_ITwDlg::OnEraseBkgnd(CDC* pdc)
{
	int old_map_mode = pdc->SetMapMode(MM_TEXT) ;
	
	RECT rc;
	GetClientRect(&rc);

	CBitmap bitmap ;
	bitmap.CreateCompatibleBitmap(pdc, (rc.right - rc.left) + 1, (rc.bottom - rc.top) + 1);

	CDC dcMem ;
	dcMem.CreateCompatibleDC(pdc) ;

	CBitmap* pOldBitmap = dcMem.SelectObject(&bitmap) ;
	dcMem.SetMapMode(MM_TEXT) ;

	CBrush brush(RGB(0, 0, 0));
	dcMem.FillRect(&rc, &brush) ;

	int width ;
	if ((rc.bottom - rc.top) > (rc.right - rc.left))
	{
		width = (rc.right - rc.left) / 2 ;
	}
	else
	{
		width = (rc.bottom - rc.top) / 2	;
	}

	for (int y = rc.top ; y <= rc.top + width ; y++)
	{
		CPen cp(PS_SOLID, 0, RGB(((y << 2) & 0xFF), 0, (y << 3) & 0xFF));
		CPen *previous ;
		
		previous = dcMem.SelectObject(&cp) ;
		
		dcMem.MoveTo(rc.left+y, y);
		dcMem.LineTo(rc.right-y, y);
		dcMem.MoveTo(rc.left+y, rc.bottom - (1 + y - rc.top));
		dcMem.LineTo(rc.right-y, rc.bottom - (1 + y - rc.top));					  
		
		dcMem.SelectObject(previous) ;
	}

	for (int x = rc.left ; x <= rc.left + width ; x++)
	{
		CPen cp(PS_SOLID, 0, RGB(0, ((x << 2) & 0xFF), (x << 3) & 0xFF));
		CPen *previous ;
		
		previous = dcMem.SelectObject(&cp) ;
		
		dcMem.MoveTo(x, rc.top + x);
		dcMem.LineTo(x, rc.bottom - x);
		dcMem.MoveTo(rc.right - (1 + x - rc.left), rc.top + x);
		dcMem.LineTo(rc.right - (1 + x - rc.left), rc.bottom - x);
		
		dcMem.SelectObject(previous) ;
	}

	pdc->BitBlt(0, 0, (rc.right - rc.left) + 1, (rc.bottom - rc.top) + 1, &dcMem, 0, 0, SRCCOPY) ;
	dcMem.SelectObject(pOldBitmap) ;
			
	pdc->SetMapMode(old_map_mode) ;

	return TRUE ;
}
*/
