//****************************************************************************
//*                                                                          *
//*                PDSoft Wav Normalizer and Cutter ver. 1.1                 *
//*                         (shareware)                                      *
//*       Please report modifications to padara@hotmail.com                  *
//*                                                                          *
//* usage: PDSWAVNR infile.wav outfile.wav -nr -ncl 100  (best normalize)    *
//*        PDSWAVNR infile.wav outfile.wav -nr           (norm. to 0 dB)     *
//*        PDSWAVNR infile.wav outfile.wav -ndb 65       (norm. with 6.5dB)  *
//*        PDSWAVNR infile.wav outfile.wav -ctl 5        (cut at sign 5)     *
//*        PDSWAVNR infile.wav outfile.wav -sw           (swap channels)     *
//*                                                                          *
//****************************************************************************


#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <io.h>
#include <i86.h>
#include <dos.h>
#include <mem.h>
#include <math.h>
#include <string.h>

#define MEMBUFSIZE 2096640

#define GLO_ARG  2
#define GLO_ARG2 4
#define GLO_CHAR 1
#define GLO_NUM  0

static long getfreemem(void);
static float get20log(int);

static unsigned long clipcounts[33000];
static unsigned int SIGN_LIMIT=29000,CUT_LIMIT,CLIPS_LIMIT,NORM_DB,normalize,swapping;
static char *worktypes[8]={"           ","Swapping   ","Normalize  ","Swap & norm",
			   "Cuting     ","Cut & Swap ","Cut & Norm ","Do All     "};
typedef struct {
 char *sname;
 int flags;
 void *var;
 int value;
 void *var2;
}topt;

static topt opts[]={
  {"sw" ,0,                 &swapping   ,1,0},
  {"nr" ,0,                 &normalize  ,1,0},
  {"na" ,0,                 &normalize  ,2,0},
  {"ctl",GLO_ARG | GLO_NUM, &CUT_LIMIT  ,0,0},
  {"ncl",GLO_ARG | GLO_NUM, &CLIPS_LIMIT,0,0},
  {"ndb",GLO_ARG | GLO_NUM, &NORM_DB    ,0,0},
  {"nsl",GLO_ARG | GLO_NUM, &SIGN_LIMIT ,0,0}
 };

void main(int argc,char *argv[])
{
 FILE *fin=NULL,*fout=NULL;
 char *buffer=NULL;
 short *ptr,*cutptr;
 long bufsize,filesize,currpos;
 int i,k,parts,endpart,bytestoread,bytestowrite;
 int maxsign,maxsignc,worktype=0,begin=0,end=0,clips=0;
 float multipli;

 if(argc<3){
  fprintf(stderr,"SWAPCHAN 1.1 by PDSoft\n");
  fprintf(stderr,"Usage:SWAPCHAN infile.wav outfile.wav options\n");
  fprintf(stderr,"   -sw       swap channels (L->R, R->L)\n");
  // bal es jobb csatorna megcserelese
  fprintf(stderr,"   -nr       normalize sound\n");
  // hang normalizalasa, felhangositasa
  fprintf(stderr,"   -na       analize sound only \n");
  fprintf(stderr,"   -ncl NUM  maximum clips in 12 seconds (def. 0)\n");
  // normalizalasnal NUM darab torz jel lehet 12 masodpercben
  fprintf(stderr,"   -ndb NUM  normailze with NUM/10 db\n");
  fprintf(stderr,"   -nsl NUM  sign limit for normalize (don't normalize over it, def. 29000\n");
  fprintf(stderr,"   -ctl NUM  cut files with NUM sound limit (def. 0 : no cut)\n");
  // fileok megvagasa, NUM hangero alatt vag (1-100)

  exit(0);
 }
 get_options(argc,argv);
 if(!(fin=fopen(argv[1],"rb"))){
  fprintf(stderr,"Can't open input file (%s)!\n",argv[1]);
  exit(1);
 }
 if(!(fout=fopen(argv[2],"wb"))){
  fprintf(stderr,"Can't open output file (%s)!\n",argv[2]);
  exit(2);
 }
 if(swapping)
  worktype|=1;
 if(normalize)
  worktype|=2;
 if(CUT_LIMIT){
  begin=1;
  worktype|=4;
 }
 bufsize=getfreemem();
 if(bufsize>MEMBUFSIZE)
  bufsize=MEMBUFSIZE;
 buffer=malloc(bufsize);
 if(buffer==NULL){
  fprintf(stderr,"Can't alloc buffer (%d bytes)!\n",bufsize);
  exit(3);
 }
 filesize=filelength(fin->_handle);
 if(filesize<50){
  fprintf(stderr,"File too short! (%d bytes)\n",filesize);
  exit(4);
 }
 fread(buffer,1,44,fin);
 fwrite(buffer,1,44,fout);
 filesize-=44;
 if(filesize>bufsize){
  parts=filesize/bufsize;
  endpart=filesize-parts*bufsize;
  if(endpart)
   parts++;
 }else{
  parts=1;
  endpart=0;
 }
 if(normalize){
  if(NORM_DB){
   multipli=pow(10.0,(float)NORM_DB/200.0);
  }else{
   maxsign=maxsignc=0;
   for(i=0;i<parts;i++){
    memset(&clipcounts[0],32900,4);
    if(i==(parts-1) && endpart){
     bytestoread=endpart;
     currpos=(i*bufsize+endpart)>>10;
    }else{
     bytestoread=bufsize;
     currpos=((i+1)*bufsize)>>10;
    }
    fprintf(stderr,"\rAnalize file ... part %2d/%d (%5d/%d kbytes)  (peek/clips: %+1.1fdB/%2d) ",i+1,parts,currpos,filesize>>10,get20log(maxsign),clips);
    fread(buffer,1,bytestoread,fin);
    ptr=(short *)(buffer);
    for(k=bytestoread>>1;k;k--){
     register int ch=(int)ptr[0];
     if(ch<0)
      ch=-ch;
     if(maxsign<ch && !CLIPS_LIMIT){
      maxsign=ch;
      fprintf(stderr,"\rAnalize file ... part %2d/%d (%5d/%d kbytes)  (peek/clips: %+1.1fdB/%2d) ",i+1,parts,currpos,filesize>>10,get20log(maxsign),clips);
     }
     clipcounts[ch]++;
     ptr++;
    }
    if(CLIPS_LIMIT){
     int maxc=32768;
     clips=0;
     for(k=32768;k;k--){
      clips+=clipcounts[k];
      if(clips>CLIPS_LIMIT)
       break;
      maxc=k;
     }
     maxsignc=max(maxc,maxsignc);
     fprintf(stderr,"\rAnalize file ... part %2d/%d (%5d/%d kbytes)  (peek/clips: %+1.1fdB/%2d) ",i+1,parts,currpos,filesize>>10,get20log(maxsignc),clips);
     maxsign=maxsignc;
    }
    if(maxsign>=SIGN_LIMIT)
      break;
   }
   if(CLIPS_LIMIT)
    maxsign=maxsignc;
   if(maxsign>=SIGN_LIMIT)
    normalize=0;
   else
    multipli=32768.0/(float)(maxsign);
  }
 }
 if(!swapping && !normalize && !CUT_LIMIT || normalize==2){
  fprintf(stderr,"\nSign over limit. Nothing to do. Exiting.");
  fclose(fin);
  fclose(fout);
  unlink(argv[2]);
  exit(1);
 }
 fseek(fin,44,SEEK_SET);
 for(i=0;i<parts;i++){
  if(kbhit()){
   fprintf(stderr,"\rBreak!!!    ");
   getch();
   break;
  }
  if(i==(parts-1) && endpart){
   bytestoread=endpart;
   currpos=(i*bufsize+endpart)>>10;
   if(CUT_LIMIT)
    end=1;
  }else{
   if(!endpart && CUT_LIMIT)
    if(i==(parts-1))
     end=1;
   bytestoread=bufsize;
   currpos=((i+1)*bufsize)>>10;
  }
  /*fprintf(stderr,"\rRead file    ... part %2d/%d (%5d/%d kbytes)  ",i+1,parts,currpos,filesize>>10);*/
  fprintf(stderr,"\rRead file    ... part %2d/%d (%5d/%d kbytes)  (gain/clips: %+1.1fdB/%2d) ",i+1,parts,currpos,filesize>>10,get20log(multipli*32768),clips);
  fread(buffer,1,bytestoread,fin);
  fprintf(stderr,"\r%s",worktypes[worktype]);
  cutptr=ptr=(short *)buffer;
  bytestowrite=bytestoread;
  for(k=bytestoread>>1;k;k-=2){
   int ch1=ptr[k-2],ch2=ptr[k-1];
   if(normalize){
    ch1=(float)(ch1)*multipli;
    if(ch1>32767)
     ch1=32767;
    if(ch1<-32768)
     ch1=-32768;
    ch2=(float)(ch2)*multipli;
    if(ch2>32767)
     ch2=32767;
    if(ch2<-32768)
     ch2=-32768;
   }
   if(begin){
    if(ch1>CUT_LIMIT || ch1<-CUT_LIMIT || ch2>CUT_LIMIT || ch2<-CUT_LIMIT){
     cutptr=&ptr[k-2];
     bytestowrite=bytestoread-((k-2)<<1);
    }
   }
   if(end){
    if(ch1<=CUT_LIMIT && ch1>=-CUT_LIMIT && ch2<=CUT_LIMIT && ch2>=-CUT_LIMIT){
     bytestowrite=(k<<1);
    }else
     end=0;
   }
   if(swapping){
    ptr[k-2]=ch2;
    ptr[k-1]=ch1;
   }else{
    ptr[k-2]=ch1;
    ptr[k-1]=ch2;
   }
  }
  fprintf(stderr,"\rWrite file   ...");
  fwrite(cutptr,1,bytestowrite,fout);
  begin=0;
 }
 fprintf(stderr,"\n");
 fclose(fin);
 fclose(fout);
 free(buffer);
}

static void get_options(int argc,char *argv[])
{
 topt *optpointer;
 unsigned int i;
 for(i=3;i<argc;i++){
  optpointer=&opts;
  if(argv[i][0]=='-' || argv[i][0]=='/'){
   while(optpointer->sname!=NULL){
    if(strcmp(&argv[i][1],optpointer->sname)==0){
     if(((optpointer->flags & GLO_ARG)==0) || ((optpointer->flags & GLO_ARG2)==GLO_ARG2))
      *((int *) optpointer->var)=optpointer->value;
     if((optpointer->flags & GLO_ARG)==GLO_ARG){
       i++;
       if(i<argc && argv[i][0]!='-' && argv[i][0]!='/' && argv[i]!=NULL){
	if((optpointer->flags & GLO_CHAR)>0)
	 if((optpointer->flags & GLO_ARG2)==GLO_ARG2)
	  *((int *)optpointer->var2)=&argv[i][0];
	 else
	  *((int *)optpointer->var)=&argv[i][0];
	else
	 if((optpointer->flags & GLO_ARG2)==GLO_ARG2)
	  *((int *)optpointer->var2)=atol(&argv[i][0]);
	 else
	  *((int *)optpointer->var)=atol(&argv[i][0]);
       }else
	i--;
     }else
      break;
    }
    optpointer++;
   }
  }
 }
}

struct meminfo{
    unsigned LargestBlockAvail;
    unsigned MaxUnlockedPage;
    unsigned LargestLockablePage;
    unsigned LinAddrSpace;
    unsigned NumFreePagesAvail;
    unsigned NumPhysicalPagesFree;
    unsigned TotalPhysicalPages;
    unsigned FreeLinAddrSpace;
    unsigned SizeOfPageFile;
    unsigned Reserved[3];
} MemInfo;

static long getfreemem(void)
{

 union REGS regs;
 struct SREGS sregs;

 regs.x.eax = 0x00000500;
 memset( &sregs, 0, sizeof(sregs) );
 sregs.es = FP_SEG( &MemInfo );
 regs.x.edi = FP_OFF( &MemInfo );

 int386x( 0x31, &regs, &regs, &sregs );
 return MemInfo.LargestBlockAvail;
}

static float get20log(int value)
{
 return log10((float)value/32768.0)*20;
}

